/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.reader;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Field;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import com.apollographql.apollo.internal.reader.ResponseReaderShadow;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RealResponseReader<R>
implements ResponseReader {
    private final Operation.Variables operationVariables;
    private final R recordSet;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final FieldValueResolver<R> fieldValueResolver;
    private final ResponseReaderShadow<R> readerShadow;

    public RealResponseReader(Operation.Variables operationVariables, R recordSet, FieldValueResolver<R> fieldValueResolver, Map<ScalarType, CustomTypeAdapter> customTypeAdapters, ResponseReaderShadow<R> readerShadow) {
        this.operationVariables = operationVariables;
        this.recordSet = recordSet;
        this.fieldValueResolver = fieldValueResolver;
        this.customTypeAdapters = customTypeAdapters;
        this.readerShadow = readerShadow;
    }

    public <T> T read(Field field) throws IOException {
        List<T> value;
        this.willResolve(field);
        switch (field.type()) {
            case STRING: {
                value = this.readString(field);
                break;
            }
            case INT: {
                value = this.readInt(field);
                break;
            }
            case LONG: {
                value = this.readLong(field);
                break;
            }
            case DOUBLE: {
                value = this.readDouble(field);
                break;
            }
            case BOOLEAN: {
                value = this.readBoolean(field);
                break;
            }
            case OBJECT: {
                value = this.readObject((Field.ObjectField)field);
                break;
            }
            case SCALAR_LIST: {
                value = this.readScalarList((Field.ScalarListField)field);
                break;
            }
            case OBJECT_LIST: {
                value = this.readObjectList((Field.ObjectListField)field);
                break;
            }
            case CUSTOM: {
                value = this.readCustomType((Field.CustomTypeField)field);
                break;
            }
            case CONDITIONAL: {
                value = this.readConditional((Field.ConditionalTypeField)field, this.operationVariables);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type");
            }
        }
        this.didResolve(field);
        return (T)value;
    }

    private void willResolve(Field field) {
        if (field.type() != Field.Type.CONDITIONAL) {
            this.readerShadow.willResolve(field, this.operationVariables);
        }
    }

    private void didResolve(Field field) {
        if (field.type() != Field.Type.CONDITIONAL) {
            this.readerShadow.didResolve(field, this.operationVariables);
        }
    }

    String readString(Field field) throws IOException {
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        this.readerShadow.didParseScalar(value);
        return value;
    }

    Integer readInt(Field field) throws IOException {
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        this.readerShadow.didParseScalar(value);
        return value.intValue();
    }

    Long readLong(Field field) throws IOException {
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        this.readerShadow.didParseScalar(value);
        return value.longValue();
    }

    Double readDouble(Field field) throws IOException {
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        this.readerShadow.didParseScalar(value);
        return value.doubleValue();
    }

    Boolean readBoolean(Field field) throws IOException {
        Boolean value = (Boolean)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        this.readerShadow.didParseScalar(value);
        return value;
    }

    <T> T readObject(Field.ObjectField field) throws IOException {
        Object value = this.fieldValueResolver.valueFor(this.recordSet, (Field)field);
        this.checkValue(value, field.optional());
        this.readerShadow.willParseObject((Field)field, Optional.fromNullable(value));
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        Object parsedValue = field.objectReader().read(new RealResponseReader(this.operationVariables, value, this.fieldValueResolver, this.customTypeAdapters, this.readerShadow));
        this.readerShadow.didParseObject((Field)field, Optional.fromNullable(value));
        return (T)parsedValue;
    }

    <T> List<T> readScalarList(Field.ScalarListField field) throws IOException {
        List values = (List)this.fieldValueResolver.valueFor(this.recordSet, (Field)field);
        this.checkValue(values, field.optional());
        if (values == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < values.size(); ++i) {
            this.readerShadow.willParseElement(i);
            Object value = values.get(i);
            Object item = field.listReader().read((Field.ListItemReader)new ListItemReader(value, this.customTypeAdapters));
            this.readerShadow.didParseScalar(value);
            this.readerShadow.didParseElement(i);
            result.add(item);
        }
        this.readerShadow.didParseList(values);
        return Collections.unmodifiableList(result);
    }

    <T> List<T> readObjectList(Field.ObjectListField field) throws IOException {
        List values = (List)this.fieldValueResolver.valueFor(this.recordSet, (Field)field);
        this.checkValue(values, field.optional());
        if (values == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < values.size(); ++i) {
            this.readerShadow.willParseElement(i);
            Object value = values.get(i);
            this.readerShadow.willParseObject((Field)field, Optional.fromNullable(value));
            Object item = field.objectReader().read(new RealResponseReader(this.operationVariables, value, this.fieldValueResolver, this.customTypeAdapters, this.readerShadow));
            this.readerShadow.didParseObject((Field)field, Optional.fromNullable(value));
            this.readerShadow.didParseElement(i);
            result.add(item);
        }
        this.readerShadow.didParseList(values);
        return Collections.unmodifiableList(result);
    }

    private <T> T readCustomType(Field.CustomTypeField field) throws IOException {
        Object value = this.fieldValueResolver.valueFor(this.recordSet, (Field)field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            return null;
        }
        CustomTypeAdapter typeAdapter = this.customTypeAdapters.get(field.scalarType());
        if (typeAdapter == null) {
            this.readerShadow.didParseScalar(value);
            return value;
        }
        this.readerShadow.didParseScalar(value);
        return typeAdapter.decode(value.toString());
    }

    private <T> T readConditional(Field.ConditionalTypeField field, Operation.Variables variables) throws IOException {
        this.readerShadow.willResolve((Field)field, variables);
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, (Field)field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didParseNull();
            this.readerShadow.didResolve((Field)field, variables);
            return null;
        }
        this.readerShadow.didParseScalar(value);
        this.readerShadow.didResolve((Field)field, variables);
        return (T)field.conditionalTypeReader().read(value, (ResponseReader)this);
    }

    private void checkValue(Object value, boolean optional) {
        if (!optional && value == null) {
            throw new NullPointerException("corrupted response reader, expected non null value");
        }
    }

    private static class ListItemReader
    implements Field.ListItemReader {
        private final Object value;
        private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;

        ListItemReader(Object value, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
            this.value = value;
            this.customTypeAdapters = customTypeAdapters;
        }

        public String readString() throws IOException {
            return (String)this.value;
        }

        public Integer readInt() throws IOException {
            return ((BigDecimal)this.value).intValue();
        }

        public Long readLong() throws IOException {
            return ((BigDecimal)this.value).longValue();
        }

        public Double readDouble() throws IOException {
            return ((BigDecimal)this.value).doubleValue();
        }

        public Boolean readBoolean() throws IOException {
            return (Boolean)this.value;
        }

        public <T> T readCustomType(ScalarType scalarType) throws IOException {
            CustomTypeAdapter typeAdapter = this.customTypeAdapters.get(scalarType);
            if (typeAdapter == null) {
                throw new RuntimeException("Can't resolve custom type adapter for " + scalarType.typeName());
            }
            return typeAdapter.decode(this.value.toString());
        }
    }
}

