/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.field;

import com.apollographql.apollo.api.Field;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ReadableStore;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CacheFieldValueResolver
implements FieldValueResolver<Record> {
    private final ReadableStore readableCache;
    private final Operation.Variables variables;
    private final CacheKeyResolver cacheKeyResolver;
    private final CacheHeaders cacheHeaders;

    public CacheFieldValueResolver(ReadableStore readableCache, Operation.Variables variables, CacheKeyResolver cacheKeyResolver, CacheHeaders cacheHeaders) {
        this.readableCache = readableCache;
        this.variables = variables;
        this.cacheKeyResolver = cacheKeyResolver;
        this.cacheHeaders = cacheHeaders;
    }

    @Override
    public <T> T valueFor(Record record, Field field) throws IOException {
        if (field instanceof Field.ObjectField) {
            return (T)this.valueFor(record, (Field.ObjectField)field);
        }
        if (field instanceof Field.ScalarListField) {
            return this.fieldValue(record, field);
        }
        if (field instanceof Field.ObjectListField) {
            return (T)this.valueFor(record, (Field.ObjectListField)field);
        }
        return this.fieldValue(record, field);
    }

    private Record valueFor(Record record, Field.ObjectField field) throws IOException {
        CacheKey fieldCacheKey = this.cacheKeyResolver.fromFieldArguments((Field)field, this.variables);
        CacheReference cacheReference = fieldCacheKey != CacheKey.NO_KEY ? new CacheReference(fieldCacheKey.key()) : (CacheReference)this.fieldValue(record, (Field)field);
        return cacheReference != null ? this.readableCache.read(cacheReference.key(), this.cacheHeaders) : null;
    }

    private List<Record> valueFor(Record record, Field.ObjectListField field) throws IOException {
        List values = (List)this.fieldValue(record, (Field)field);
        ArrayList<Record> result = new ArrayList<Record>();
        for (CacheReference reference : values) {
            result.add(this.readableCache.read(reference.key(), this.cacheHeaders));
        }
        return result;
    }

    private <T> T fieldValue(Record record, Field field) throws IOException {
        String fieldKey = field.cacheKey(this.variables);
        if (!record.hasField(fieldKey)) {
            throw new IOException("Missing value: " + field.fieldName());
        }
        return (T)record.field(fieldKey);
    }
}

