/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.http;

import com.apollographql.apollo.cache.http.HttpCacheRecord;
import com.apollographql.apollo.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo.cache.http.HttpCacheStore;
import com.apollographql.apollo.internal.cache.http.CacheResponseBody;
import com.apollographql.apollo.internal.cache.http.HttpCacheInterceptor;
import com.apollographql.apollo.internal.cache.http.ResponseBodyProxy;
import com.apollographql.apollo.internal.cache.http.ResponseHeaderRecord;
import com.apollographql.apollo.internal.cache.http.Utils;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ForwardingSource;
import okio.Sink;
import okio.Source;

public final class HttpCache {
    public static final String CACHE_KEY_HEADER = "X-APOLLO-CACHE-KEY";
    public static final String CACHE_FETCH_STRATEGY_HEADER = "X-APOLLO-CACHE-FETCH-STRATEGY";
    public static final String CACHE_SERVED_DATE_HEADER = "X-APOLLO-SERVED-DATE";
    public static final String CACHE_PREFETCH_HEADER = "X-APOLLO-PREFETCH";
    public static final String CACHE_EXPIRE_TIMEOUT_HEADER = "X-APOLLO-EXPIRE-TIMEOUT";
    public static final String CACHE_EXPIRE_AFTER_READ_HEADER = "X-APOLLO-EXPIRE-AFTER-READ";
    private final HttpCacheStore cacheStore;
    private final ApolloLogger logger;

    public HttpCache(@Nonnull HttpCacheStore cacheStore, @Nonnull ApolloLogger logger) {
        this.cacheStore = (HttpCacheStore)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)cacheStore, (Object)"cacheStore can't be null");
        this.logger = (ApolloLogger)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger can't be null");
    }

    public void clear() {
        try {
            this.cacheStore.delete();
        }
        catch (IOException e) {
            this.logger.e(e, "Failed to clear http cache", new Object[0]);
        }
    }

    public void remove(@Nonnull String cacheKey) throws IOException {
        this.cacheStore.remove(cacheKey);
    }

    public void removeQuietly(@Nonnull String cacheKey) {
        try {
            this.remove(cacheKey);
        }
        catch (Exception ignore) {
            this.logger.w(ignore, "Failed to remove cached record for key: %s", cacheKey);
        }
    }

    public Response read(@Nonnull String cacheKey) {
        return this.read(cacheKey, false);
    }

    public Response read(final @Nonnull String cacheKey, final boolean expireAfterRead) {
        HttpCacheRecord responseCacheRecord = null;
        try {
            responseCacheRecord = this.cacheStore.cacheRecord(cacheKey);
            if (responseCacheRecord == null) {
                return null;
            }
            final HttpCacheRecord cacheRecord = responseCacheRecord;
            ForwardingSource cacheResponseSource = new ForwardingSource(responseCacheRecord.bodySource()){

                public void close() throws IOException {
                    super.close();
                    HttpCache.this.closeQuietly(cacheRecord);
                    if (expireAfterRead) {
                        HttpCache.this.removeQuietly(cacheKey);
                    }
                }
            };
            Response response = new ResponseHeaderRecord(responseCacheRecord.headerSource()).response();
            String contentType = response.header("Content-Type");
            String contentLength = response.header("Content-Length");
            return response.newBuilder().body((ResponseBody)new CacheResponseBody((Source)cacheResponseSource, contentType, contentLength)).build();
        }
        catch (Exception e) {
            this.closeQuietly(responseCacheRecord);
            this.logger.e(e, "Failed to read http cache entry for key: %s", cacheKey);
            return null;
        }
    }

    public Interceptor interceptor() {
        return new HttpCacheInterceptor(this, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response cacheProxy(@Nonnull Response response, @Nonnull String cacheKey) {
        block5: {
            HttpCacheRecordEditor cacheRecordEditor = null;
            try {
                cacheRecordEditor = this.cacheStore.cacheRecordEditor(cacheKey);
                if (cacheRecordEditor == null) break block5;
                Sink headerSink = cacheRecordEditor.headerSink();
                try {
                    new ResponseHeaderRecord(response).writeTo(headerSink);
                }
                finally {
                    this.closeQuietly(headerSink);
                }
                return response.newBuilder().body((ResponseBody)new ResponseBodyProxy(cacheRecordEditor, response, this.logger)).build();
            }
            catch (Exception e) {
                this.abortQuietly(cacheRecordEditor);
                this.logger.e(e, "Failed to proxy http response for key: %s", cacheKey);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(@Nonnull Response response, @Nonnull String cacheKey) {
        block8: {
            HttpCacheRecordEditor cacheRecordEditor = null;
            try {
                cacheRecordEditor = this.cacheStore.cacheRecordEditor(cacheKey);
                if (cacheRecordEditor == null) break block8;
                Sink headerSink = cacheRecordEditor.headerSink();
                try {
                    new ResponseHeaderRecord(response).writeTo(headerSink);
                }
                finally {
                    this.closeQuietly(headerSink);
                }
                Sink bodySink = cacheRecordEditor.bodySink();
                try {
                    Utils.copyResponseBody(response, bodySink);
                }
                finally {
                    this.closeQuietly(bodySink);
                }
                cacheRecordEditor.commit();
            }
            catch (Exception e) {
                this.abortQuietly(cacheRecordEditor);
                this.logger.e(e, "Failed to cache http response for key: %s", cacheKey);
            }
        }
    }

    private void closeQuietly(HttpCacheRecord cacheRecord) {
        try {
            if (cacheRecord != null) {
                cacheRecord.close();
            }
        }
        catch (Exception ignore) {
            this.logger.w(ignore, "Failed to close cache record", new Object[0]);
        }
    }

    private void abortQuietly(HttpCacheRecordEditor cacheRecordEditor) {
        try {
            if (cacheRecordEditor != null) {
                cacheRecordEditor.abort();
            }
        }
        catch (Exception ignore) {
            this.logger.w(ignore, "Failed to abort cache record edit", new Object[0]);
        }
    }

    private void closeQuietly(Sink sink) {
        try {
            sink.close();
        }
        catch (Exception ignore) {
            this.logger.w(ignore, "Failed to close sink", new Object[0]);
        }
    }
}

