/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.ws;

import com.apollographql.apollo.network.ws.WebSocketConnection;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.ObsoleteCoroutinesApi;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.channels.ValueOrClosed;
import kotlinx.coroutines.selects.SelectClause1;
import okhttp3.WebSocket;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0016\u001a\u00020\u0017H\u0097\u0001J\u0015\u0010\u0016\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0097\u0001J\u001b\u0010\u0016\u001a\u00020\u00172\u0010\b\u0002\u0010\u0018\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001bH\u0096\u0001J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0096\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0096\u0001J\u0011\u0010 \u001a\u00020\u0003H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0097A\u00f8\u0001\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0013\u0010#\u001a\u0004\u0018\u00010\u0003H\u0097A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\u00020\n8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u000e8\u0016X\u0097\u0005\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo/network/ws/WebSocketConnectionImpl;", "Lcom/apollographql/apollo/network/ws/WebSocketConnection;", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lokio/ByteString;", "webSocket", "Lokhttp3/WebSocket;", "messageChannel", "Lkotlinx/coroutines/channels/Channel;", "(Lokhttp3/WebSocket;Lkotlinx/coroutines/channels/Channel;)V", "isClosedForReceive", "", "()Z", "isEmpty", "onReceive", "Lkotlinx/coroutines/selects/SelectClause1;", "getOnReceive", "()Lkotlinx/coroutines/selects/SelectClause1;", "onReceiveOrClosed", "Lkotlinx/coroutines/channels/ValueOrClosed;", "getOnReceiveOrClosed", "onReceiveOrNull", "getOnReceiveOrNull", "cancel", "", "cause", "", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "close", "iterator", "Lkotlinx/coroutines/channels/ChannelIterator;", "poll", "receive", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "receiveOrClosed", "receiveOrNull", "send", "data", "apollo-runtime-kotlin"})
@ExperimentalCoroutinesApi
final class WebSocketConnectionImpl
implements WebSocketConnection,
ReceiveChannel<ByteString> {
    private final WebSocket webSocket;
    private final Channel<ByteString> messageChannel;

    @Override
    public void send(@NotNull ByteString data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (!this.messageChannel.isClosedForReceive()) {
            this.webSocket.send(data);
        }
    }

    @Override
    public void close() {
        SendChannel.DefaultImpls.close$default(this.messageChannel, null, (int)1, null);
    }

    public WebSocketConnectionImpl(@NotNull WebSocket webSocket2, @NotNull Channel<ByteString> messageChannel) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull(messageChannel, (String)"messageChannel");
        this.webSocket = webSocket2;
        this.messageChannel = messageChannel;
        this.messageChannel.invokeOnClose((Function1)new Function1<Throwable, Unit>(){

            public final void invoke(@Nullable Throwable it) {
                webSocket.close(1000, null);
            }
        });
    }

    public /* synthetic */ WebSocketConnectionImpl(WebSocket webSocket2, Channel channel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            channel = ChannelKt.Channel$default((int)0, (int)1, null);
        }
        this(webSocket2, (Channel<ByteString>)channel);
    }

    public boolean isClosedForReceive() {
        return this.messageChannel.isClosedForReceive();
    }

    public boolean isEmpty() {
        return this.messageChannel.isEmpty();
    }

    @NotNull
    public SelectClause1<ByteString> getOnReceive() {
        return this.messageChannel.getOnReceive();
    }

    @NotNull
    public SelectClause1<ValueOrClosed<ByteString>> getOnReceiveOrClosed() {
        return this.messageChannel.getOnReceiveOrClosed();
    }

    @NotNull
    public SelectClause1<ByteString> getOnReceiveOrNull() {
        return this.messageChannel.getOnReceiveOrNull();
    }

    @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ void cancel() {
        this.messageChannel.cancel();
    }

    @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ boolean cancel(@Nullable Throwable cause) {
        return this.messageChannel.cancel(cause);
    }

    public void cancel(@Nullable CancellationException cause) {
        this.messageChannel.cancel(cause);
    }

    @NotNull
    public ChannelIterator<ByteString> iterator() {
        return this.messageChannel.iterator();
    }

    @Nullable
    public ByteString poll() {
        return (ByteString)this.messageChannel.poll();
    }

    @Nullable
    public Object receive(@NotNull Continuation<? super ByteString> continuation) {
        Object object = this.messageChannel.receive(continuation);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"receive(...)");
        return object;
    }

    @InternalCoroutinesApi
    @Nullable
    public Object receiveOrClosed(@NotNull Continuation<? super ValueOrClosed<? extends ByteString>> continuation) {
        return this.messageChannel.receiveOrClosed(continuation);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={"kotlinx.coroutines.channels.receiveOrNull"}, expression="receiveOrNull"), message="Deprecated in favor of receiveOrClosed and receiveOrNull extension", level=DeprecationLevel.WARNING)
    @ObsoleteCoroutinesApi
    @LowPriorityInOverloadResolution
    @Nullable
    public Object receiveOrNull(@NotNull Continuation<? super ByteString> continuation) {
        return this.messageChannel.receiveOrNull(continuation);
    }
}

