/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket.internal;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.network.websocket.WebSocketEngine;
import com.apollographql.apollo.network.websocket.WsProtocol;
import com.apollographql.apollo.network.websocket.internal.SubscribableWebSocket;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import okio.BufferedSink;
import okio.ByteString;
import okio.HashingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0012\u0010\"\u001a\u00020\u00152\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/apollographql/apollo/network/websocket/internal/WebSocketPool;", "", "webSocketEngine", "Lcom/apollographql/apollo/network/websocket/WebSocketEngine;", "serverUrl", "", "wsProtocol", "Lcom/apollographql/apollo/network/websocket/WsProtocol;", "connectionAcknowledgeTimeout", "Lkotlin/time/Duration;", "pingInterval", "idleTimeout", "<init>", "(Lcom/apollographql/apollo/network/websocket/WebSocketEngine;Ljava/lang/String;Lcom/apollographql/apollo/network/websocket/WsProtocol;JLkotlin/time/Duration;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/atomicfu/locks/ReentrantLock;", "subscribableWebSockets", "", "Lokio/ByteString;", "Lcom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket;", "cleanupLocked", "", "key", "closeAllConnections", "cause", "Lcom/apollographql/apollo/exception/ApolloException;", "close", "closeAllConnectionsLocked", "url", "httpHeaders", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "acquire", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "apollo-runtime"})
@SourceDebugExtension(value={"SMAP\nWebSocketPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketPool.kt\ncom/apollographql/apollo/network/websocket/internal/WebSocketPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 WebSocketPool.kt\ncom/apollographql/apollo/network/websocket/internal/WebSocketPool\n*L\n71#1:106,2\n*E\n"})
public final class WebSocketPool {
    @NotNull
    private final WebSocketEngine webSocketEngine;
    @Nullable
    private final String serverUrl;
    @NotNull
    private final WsProtocol wsProtocol;
    private final long connectionAcknowledgeTimeout;
    @Nullable
    private final Duration pingInterval;
    private final long idleTimeout;
    @NotNull
    private ReentrantLock lock;
    @NotNull
    private final Map<ByteString, SubscribableWebSocket> subscribableWebSockets;

    private WebSocketPool(WebSocketEngine webSocketEngine, String serverUrl2, WsProtocol wsProtocol, long connectionAcknowledgeTimeout, Duration pingInterval, long idleTimeout) {
        Intrinsics.checkNotNullParameter((Object)webSocketEngine, (String)"webSocketEngine");
        Intrinsics.checkNotNullParameter((Object)wsProtocol, (String)"wsProtocol");
        this.webSocketEngine = webSocketEngine;
        this.serverUrl = serverUrl2;
        this.wsProtocol = wsProtocol;
        this.connectionAcknowledgeTimeout = connectionAcknowledgeTimeout;
        this.pingInterval = pingInterval;
        this.idleTimeout = idleTimeout;
        this.lock = new ReentrantLock();
        this.subscribableWebSockets = new LinkedHashMap();
    }

    private final void cleanupLocked(ByteString key) {
        Iterator<Map.Entry<ByteString, SubscribableWebSocket>> iterator = this.subscribableWebSockets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ByteString, SubscribableWebSocket> entry = iterator.next();
            if (!entry.getValue().isShutdown(Intrinsics.areEqual((Object)entry.getKey(), (Object)key))) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeAllConnections(@NotNull ApolloException cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.closeAllConnectionsLocked(cause);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.closeAllConnectionsLocked((ApolloException)new ApolloNetworkException("WebSocketNetworkTransport was closed", null, 2, null));
            this.webSocketEngine.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private final void closeAllConnectionsLocked(ApolloException cause) {
        Iterator<Map.Entry<ByteString, SubscribableWebSocket>> iterator = this.subscribableWebSockets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ByteString, SubscribableWebSocket> entry = iterator.next();
            entry.getValue().shutdown(cause, 1001, "Client requested closing the connection");
            iterator.remove();
        }
    }

    private final ByteString key(String url, List<HttpHeader> httpHeaders) {
        BufferedSink bufferedSink;
        HashingSink hashingSink = HashingSink.Companion.sha256(Okio.blackhole());
        BufferedSink $this$key_u24lambda_u240 = bufferedSink = Okio.buffer((Sink)((Sink)hashingSink));
        boolean bl = false;
        $this$key_u24lambda_u240.writeUtf8(url);
        $this$key_u24lambda_u240.writeByte(0);
        Iterable $this$forEach$iv = httpHeaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpHeader it = (HttpHeader)element$iv;
            boolean bl2 = false;
            $this$key_u24lambda_u240.writeUtf8(it.getName() + ": " + it.getValue());
            $this$key_u24lambda_u240.writeByte(0);
        }
        $this$key_u24lambda_u240.flush();
        return hashingSink.hash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SubscribableWebSocket acquire(@NotNull ApolloRequest<?> apolloRequest) {
        SubscribableWebSocket subscribableWebSocket;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            String string = apolloRequest.getUrl();
            if (string == null && (string = this.serverUrl) == null) {
                throw new IllegalStateException(("ApolloRequest.url is missing for request '" + apolloRequest.getOperation().name() + "', did you call ApolloClient.Builder.webSocketServerUrl(url)?").toString());
            }
            String url = string;
            List list = apolloRequest.getHttpHeaders();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List httpHeaders = list;
            ByteString key = this.key(url, httpHeaders);
            this.cleanupLocked(key);
            SubscribableWebSocket webSocket2 = this.subscribableWebSockets.get(key);
            if (webSocket2 == null) {
                webSocket2 = new SubscribableWebSocket(this.webSocketEngine, url, httpHeaders, this.wsProtocol, this.pingInterval, this.connectionAcknowledgeTimeout, this.idleTimeout, null);
                this.subscribableWebSockets.put(key, webSocket2);
            }
            subscribableWebSocket = webSocket2;
        }
        finally {
            reentrantLock.unlock();
        }
        return subscribableWebSocket;
    }

    public /* synthetic */ WebSocketPool(WebSocketEngine webSocketEngine, String serverUrl2, WsProtocol wsProtocol, long connectionAcknowledgeTimeout, Duration pingInterval, long idleTimeout, DefaultConstructorMarker $constructor_marker) {
        this(webSocketEngine, serverUrl2, wsProtocol, connectionAcknowledgeTimeout, pingInterval, idleTimeout);
    }
}

