/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.RequestParameters;
import com.apollographql.apollo.api.RequestParametersKt;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.network.websocket.ClientMessage;
import com.apollographql.apollo.network.websocket.ClientMessageKt;
import com.apollographql.apollo.network.websocket.CompleteServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionAckServerMessage;
import com.apollographql.apollo.network.websocket.GraphQLWsProtocol;
import com.apollographql.apollo.network.websocket.OperationErrorServerMessage;
import com.apollographql.apollo.network.websocket.ParseErrorServerMessage;
import com.apollographql.apollo.network.websocket.PingServerMessage;
import com.apollographql.apollo.network.websocket.PongServerMessage;
import com.apollographql.apollo.network.websocket.ResponseServerMessage;
import com.apollographql.apollo.network.websocket.ServerMessage;
import com.apollographql.apollo.network.websocket.WsProtocol;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012 \b\u0002\u0010\u0002\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J&\u0010\u0012\u001a\u00020\u0010\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u0010\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0016R+\u0010\u0002\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo/network/websocket/GraphQLWsProtocol;", "Lcom/apollographql/apollo/network/websocket/WsProtocol;", "connectionPayload", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getConnectionPayload", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "name", "", "getName", "()Ljava/lang/String;", "connectionInit", "Lcom/apollographql/apollo/network/websocket/ClientMessage;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "operationStart", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "Lcom/apollographql/apollo/api/ApolloRequest;", "(Lcom/apollographql/apollo/api/ApolloRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "operationStop", "ping", "pong", "parseServerMessage", "Lcom/apollographql/apollo/network/websocket/ServerMessage;", "text", "apollo-runtime"})
public final class GraphQLWsProtocol
implements WsProtocol {
    @NotNull
    private final Function1<Continuation<Object>, Object> connectionPayload;

    public GraphQLWsProtocol(@NotNull Function1<? super Continuation<Object>, ? extends Object> connectionPayload2) {
        Intrinsics.checkNotNullParameter(connectionPayload2, (String)"connectionPayload");
        this.connectionPayload = connectionPayload2;
    }

    public /* synthetic */ GraphQLWsProtocol(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = (Function1)new Function1<Continuation, Object>(null){
                int label;

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return null;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            };
        }
        this((Function1<? super Continuation<Object>, ? extends Object>)function1);
    }

    @NotNull
    public final Function1<Continuation<Object>, Object> getConnectionPayload() {
        return this.connectionPayload;
    }

    @Override
    @NotNull
    public String getName() {
        return "graphql-transport-ws";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object connectionInit(@NotNull Continuation<? super ClientMessage> $completion) {
        if (!($completion instanceof connectionInit.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GraphQLWsProtocol this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connectionInit((Continuation<? super ClientMessage>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                map = new LinkedHashMap<K, V>();
                map.put("type", "connection_init");
                $continuation.L$0 = map;
                $continuation.label = 1;
                v0 = this.connectionPayload.invoke((Object)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                map = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((payload = v0) != null) {
                    map.put("payload", payload);
                }
                return ClientMessageKt.toClientMessage(map);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public <D extends Operation.Data> Object operationStart(@NotNull ApolloRequest<D> request, @NotNull Continuation<? super ClientMessage> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"subscribe"), TuplesKt.to((Object)"id", (Object)request.getRequestUuid().toString()), TuplesKt.to((Object)"payload", (Object)RequestParametersKt.toMap((RequestParameters)RequestParametersKt.toRequestParameters(request)))};
        return ClientMessageKt.toClientMessage(MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public <D extends Operation.Data> ClientMessage operationStop(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"complete"), TuplesKt.to((Object)"id", (Object)request.getRequestUuid().toString())};
        return ClientMessageKt.toClientMessage(MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public ClientMessage ping() {
        return ClientMessageKt.toClientMessage(MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"ping")));
    }

    @Override
    @NotNull
    public ClientMessage pong() {
        return ClientMessageKt.toClientMessage(MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"pong")));
    }

    @Override
    @NotNull
    public ServerMessage parseServerMessage(@NotNull String text) {
        ServerMessage serverMessage;
        String type;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            Object object = -JsonReaders.readAny((JsonReader)-JsonReaders.jsonReader((BufferedSource)((BufferedSource)new Buffer().writeUtf8(text))));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            map2 = (Map)object;
        }
        catch (Exception exception) {
            return new ParseErrorServerMessage("Invalid JSON: '" + text + '\'');
        }
        Map map3 = map2;
        Object object = map3.get("type");
        String string = type = object instanceof String ? (String)object : null;
        if (type == null) {
            return new ParseErrorServerMessage("No 'type' found in server message: '" + text + '\'');
        }
        switch (type) {
            case "connection_ack": {
                serverMessage = ConnectionAckServerMessage.INSTANCE;
                break;
            }
            case "ping": {
                serverMessage = PingServerMessage.INSTANCE;
                break;
            }
            case "pong": {
                serverMessage = PongServerMessage.INSTANCE;
                break;
            }
            case "next": 
            case "complete": 
            case "error": {
                String id;
                Object v = map3.get("id");
                String string2 = id = v instanceof String ? (String)v : null;
                if (Intrinsics.areEqual((Object)type, (Object)"next")) {
                    return new ResponseServerMessage(String.valueOf(id), map3.get("payload"));
                }
                if (id == null) {
                    serverMessage = new ParseErrorServerMessage("No 'id' found in message: '" + text + '\'');
                    break;
                }
                if (Intrinsics.areEqual((Object)type, (Object)"next")) {
                    serverMessage = new ResponseServerMessage(id, map3.get("payload"));
                    break;
                }
                if (Intrinsics.areEqual((Object)type, (Object)"complete")) {
                    serverMessage = new CompleteServerMessage(id);
                    break;
                }
                if (Intrinsics.areEqual((Object)type, (Object)"error")) {
                    serverMessage = new OperationErrorServerMessage(id, map3.get("payload"));
                    break;
                }
                throw new IllegalStateException("".toString());
            }
            default: {
                serverMessage = new ParseErrorServerMessage("Unknown type: '" + type + "' found in server message: '" + text + '\'');
            }
        }
        return serverMessage;
    }

    public GraphQLWsProtocol() {
        this(null, 1, null);
    }
}

