/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket;

import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.network.websocket.WebSocket;
import com.apollographql.apollo.network.websocket.WebSocketListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\"\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016J \u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0012\u0010$\u001a\u00020%*\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010)\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/apollographql/apollo/network/websocket/JvmWebSocket;", "Lcom/apollographql/apollo/network/websocket/WebSocket;", "Lokhttp3/WebSocketListener;", "webSocketFactory", "Lokhttp3/WebSocket$Factory;", "url", "", "headers", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "listener", "Lcom/apollographql/apollo/network/websocket/WebSocketListener;", "<init>", "(Lokhttp3/WebSocket$Factory;Ljava/lang/String;Ljava/util/List;Lcom/apollographql/apollo/network/websocket/WebSocketListener;)V", "platformWebSocket", "Ljava/util/concurrent/atomic/AtomicReference;", "Lokhttp3/WebSocket;", "disposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onOpen", "", "webSocket", "response", "Lokhttp3/Response;", "onMessage", "bytes", "Lokio/ByteString;", "text", "onFailure", "t", "", "onClosing", "code", "", "reason", "onClosed", "toOkHttpHeaders", "Lokhttp3/Headers;", "send", "data", "", "close", "apollo-runtime"})
@SourceDebugExtension(value={"SMAP\nWebSocketEngine.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketEngine.jvm.kt\ncom/apollographql/apollo/network/websocket/JvmWebSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1869#2,2:139\n*S KotlinDebug\n*F\n+ 1 WebSocketEngine.jvm.kt\ncom/apollographql/apollo/network/websocket/JvmWebSocket\n*L\n95#1:139,2\n*E\n"})
public final class JvmWebSocket
extends okhttp3.WebSocketListener
implements WebSocket {
    @NotNull
    private final WebSocketListener listener;
    @NotNull
    private final AtomicReference<okhttp3.WebSocket> platformWebSocket;
    @NotNull
    private final AtomicBoolean disposed;

    public JvmWebSocket(@NotNull WebSocket.Factory webSocketFactory, @NotNull String url, @NotNull List<HttpHeader> headers, @NotNull WebSocketListener listener2) {
        Intrinsics.checkNotNullParameter((Object)webSocketFactory, (String)"webSocketFactory");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listener = listener2;
        this.platformWebSocket = new AtomicReference();
        this.disposed = new AtomicBoolean(false);
        Request request = new Request.Builder().url(url).headers(this.toOkHttpHeaders(headers)).build();
        this.platformWebSocket.set(webSocketFactory.newWebSocket(request, (okhttp3.WebSocketListener)this));
    }

    public void onOpen(@NotNull okhttp3.WebSocket webSocket2, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.listener.onOpen();
    }

    public void onMessage(@NotNull okhttp3.WebSocket webSocket2, @NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listener.onMessage(bytes.toByteArray());
    }

    public void onMessage(@NotNull okhttp3.WebSocket webSocket2, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.listener.onMessage(text);
    }

    public void onFailure(@NotNull okhttp3.WebSocket webSocket2, @NotNull Throwable t, @Nullable Response response) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!this.disposed.compareAndSet(false, true)) break block1;
            this.listener.onError((ApolloException)new ApolloNetworkException(t.getMessage(), (Object)t));
            okhttp3.WebSocket webSocket3 = this.platformWebSocket.get();
            if (webSocket3 != null) {
                webSocket3.cancel();
            }
        }
    }

    public void onClosing(@NotNull okhttp3.WebSocket webSocket2, int code, @NotNull String reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            if (!this.disposed.compareAndSet(false, true)) break block1;
            this.listener.onClosed(code, reason);
            okhttp3.WebSocket webSocket3 = this.platformWebSocket.get();
            if (webSocket3 != null) {
                webSocket3.close(code, reason);
            }
        }
    }

    public void onClosed(@NotNull okhttp3.WebSocket webSocket2, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    private final Headers toOkHttpHeaders(List<HttpHeader> $this$toOkHttpHeaders) {
        Headers.Builder builder;
        Headers.Builder headers = builder = new Headers.Builder();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$toOkHttpHeaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpHeader it = (HttpHeader)element$iv;
            boolean bl2 = false;
            headers.add(it.getName(), it.getValue());
        }
        return builder.build();
    }

    @Override
    public void send(@NotNull byte[] data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            okhttp3.WebSocket webSocket2 = this.platformWebSocket.get();
            if (webSocket2 == null) break block0;
            webSocket2.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])data, (int)0, (int)0, (int)3, null));
        }
    }

    @Override
    public void send(@NotNull String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            okhttp3.WebSocket webSocket2 = this.platformWebSocket.get();
            if (webSocket2 == null) break block0;
            webSocket2.send(text);
        }
    }

    @Override
    public void close(int code, @NotNull String reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            if (!this.disposed.compareAndSet(false, true)) break block1;
            okhttp3.WebSocket webSocket2 = this.platformWebSocket.get();
            if (webSocket2 != null) {
                webSocket2.close(code, reason);
            }
        }
    }
}

