/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Operations;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.DefaultApolloException;
import com.apollographql.apollo.internal.incremental.IncrementalDeliveryProtocolImpl;
import com.apollographql.apollo.internal.incremental.IncrementalResultsMerger;
import com.apollographql.apollo.network.websocket.SubscriptionParser;
import com.apollographql.apollo.network.websocket.WebSocketNetworkTransportKt;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011j\u0002`\u0012H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo/network/websocket/DefaultSubscriptionParser;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "Lcom/apollographql/apollo/network/websocket/SubscriptionParser;", "incrementalDeliveryProtocolImpl", "Lcom/apollographql/apollo/internal/incremental/IncrementalDeliveryProtocolImpl;", "request", "Lcom/apollographql/apollo/api/ApolloRequest;", "<init>", "(Lcom/apollographql/apollo/internal/incremental/IncrementalDeliveryProtocolImpl;Lcom/apollographql/apollo/api/ApolloRequest;)V", "incrementalResultsMerger", "Lcom/apollographql/apollo/internal/incremental/IncrementalResultsMerger;", "requestCustomScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "parse", "Lcom/apollographql/apollo/api/ApolloResponse;", "response", "", "Lcom/apollographql/apollo/api/json/ApolloJsonElement;", "apollo-runtime"})
final class DefaultSubscriptionParser<D extends Operation.Data>
implements SubscriptionParser<D> {
    @NotNull
    private final ApolloRequest<D> request;
    @NotNull
    private final IncrementalResultsMerger incrementalResultsMerger;
    @NotNull
    private final CustomScalarAdapters requestCustomScalarAdapters;

    public DefaultSubscriptionParser(@NotNull IncrementalDeliveryProtocolImpl incrementalDeliveryProtocolImpl, @NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter((Object)incrementalDeliveryProtocolImpl, (String)"incrementalDeliveryProtocolImpl");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        this.request = request;
        this.incrementalResultsMerger = incrementalDeliveryProtocolImpl.newIncrementalResultsMerger();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)this.request.getExecutionContext().get((ExecutionContext.Key)CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        this.requestCustomScalarAdapters = customScalarAdapters;
    }

    @Override
    @Nullable
    public ApolloResponse<D> parse(@Nullable Object response) {
        Map responseMap;
        Map map2 = responseMap = response instanceof Map ? (Map)response : null;
        if (responseMap == null) {
            return new ApolloResponse.Builder(this.request.getOperation(), this.request.getRequestUuid()).exception((ApolloException)new DefaultApolloException("Invalid payload", null, 2, null)).build();
        }
        Pair pair = WebSocketNetworkTransportKt.access$isDeferred(responseMap) ? TuplesKt.to(this.incrementalResultsMerger.merge(responseMap), this.incrementalResultsMerger.getDeferredFragmentIdentifiers()) : TuplesKt.to((Object)responseMap, null);
        Map payload = (Map)pair.component1();
        Set deferredFragmentIdentifiers = (Set)pair.component2();
        ApolloResponse apolloResponse = Operations.toApolloResponse((JsonReader)-JsonReaders.jsonReader((Map)payload), (Operation)this.request.getOperation(), (UUID)this.request.getRequestUuid(), (CustomScalarAdapters)this.requestCustomScalarAdapters, (Set)deferredFragmentIdentifiers);
        if (!this.incrementalResultsMerger.getHasNext()) {
            this.incrementalResultsMerger.reset();
        }
        return this.incrementalResultsMerger.isEmptyResponse() ? null : apolloResponse;
    }
}

