/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.http;

import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Operations;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.HttpResponse;
import com.apollographql.apollo.api.internal.ResponseParserKt;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.RouterError;
import com.apollographql.apollo.internal.MultipartKt;
import com.apollographql.apollo.internal.incremental.IncrementalDeliveryProtocolImpl;
import com.apollographql.apollo.internal.incremental.IncrementalDeliveryProtocolImplKt;
import com.apollographql.apollo.internal.incremental.IncrementalResultsMerger;
import com.apollographql.apollo.mpp.UtilsKt;
import com.apollographql.apollo.network.IncrementalDeliveryProtocol;
import com.apollographql.apollo.network.NetworkTransport;
import com.apollographql.apollo.network.http.DefaultHttpEngine;
import com.apollographql.apollo.network.http.DefaultHttpInterceptorChain;
import com.apollographql.apollo.network.http.HttpEngine;
import com.apollographql.apollo.network.http.HttpInfo;
import com.apollographql.apollo.network.http.HttpInterceptor;
import com.apollographql.apollo.network.http.HttpInterceptorChain;
import com.apollographql.apollo.network.http.HttpNetworkTransport$execute$1$invokeSuspend$;
import com.apollographql.apollo.network.http.HttpNetworkTransport$multipleResponses$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003678B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ,\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00170\u0016\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001bH\u0016JA\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00170\u0016\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J.\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00180#2\u0006\u0010$\u001a\u00020%H\u0002J4\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00170\u0016\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00180#2\u0006\u0010&\u001a\u00020'H\u0002J<\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00170\u0016\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J<\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u00170\u0016\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010*\u001a\u00020+*\u00020%H\u0002J@\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\b\b\u0000\u0010\u0018*\u00020\u0019*\b\u0012\u0004\u0012\u0002H\u00180\u00172\n\u0010-\u001a\u00060.j\u0002`/2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000203H\u0016J\u0006\u00104\u001a\u000205R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/apollographql/apollo/network/http/HttpNetworkTransport;", "Lcom/apollographql/apollo/network/NetworkTransport;", "httpRequestComposer", "Lcom/apollographql/apollo/api/http/HttpRequestComposer;", "engine", "Lcom/apollographql/apollo/network/http/HttpEngine;", "interceptors", "", "Lcom/apollographql/apollo/network/http/HttpInterceptor;", "exposeErrorBody", "", "incrementalDeliveryProtocol", "Lcom/apollographql/apollo/network/IncrementalDeliveryProtocol;", "<init>", "(Lcom/apollographql/apollo/api/http/HttpRequestComposer;Lcom/apollographql/apollo/network/http/HttpEngine;Ljava/util/List;ZLcom/apollographql/apollo/network/IncrementalDeliveryProtocol;)V", "getInterceptors", "()Ljava/util/List;", "engineInterceptor", "Lcom/apollographql/apollo/network/http/HttpNetworkTransport$EngineInterceptor;", "incrementalDeliveryProtocolImpl", "Lcom/apollographql/apollo/internal/incremental/IncrementalDeliveryProtocolImpl;", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo/api/ApolloResponse;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "Lcom/apollographql/apollo/api/ApolloRequest;", "httpRequest", "Lcom/apollographql/apollo/api/http/HttpRequest;", "customScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "execute$apollo_runtime", "errorResponse", "operation", "Lcom/apollographql/apollo/api/Operation;", "throwable", "", "httpResponse", "Lcom/apollographql/apollo/api/http/HttpResponse;", "singleResponse", "multipleResponses", "wrapIfNeeded", "Lcom/apollographql/apollo/exception/ApolloException;", "withHttpInfo", "requestUuid", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "millisStart", "", "dispose", "", "newBuilder", "Lcom/apollographql/apollo/network/http/HttpNetworkTransport$Builder;", "EngineInterceptor", "Builder", "TransportHeadersInterceptor", "apollo-runtime"})
@SourceDebugExtension(value={"SMAP\nHttpNetworkTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpNetworkTransport.kt\ncom/apollographql/apollo/network/http/HttpNetworkTransport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 uuid.kt\ncom/benasher44/uuid/UuidKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 6 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 7 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,424:1\n2746#2,3:425\n1869#2,2:435\n100#3:428\n1#4:429\n56#5:430\n59#5:434\n46#6:431\n51#6:433\n105#7:432\n*S KotlinDebug\n*F\n+ 1 HttpNetworkTransport.kt\ncom/apollographql/apollo/network/http/HttpNetworkTransport\n*L\n61#1:425,3\n303#1:435,2\n142#1:428\n194#1:430\n194#1:434\n194#1:431\n194#1:433\n194#1:432\n*E\n"})
public final class HttpNetworkTransport
implements NetworkTransport {
    @NotNull
    private final HttpRequestComposer httpRequestComposer;
    @NotNull
    private final HttpEngine engine;
    @NotNull
    private final List<HttpInterceptor> interceptors;
    private final boolean exposeErrorBody;
    @NotNull
    private final IncrementalDeliveryProtocol incrementalDeliveryProtocol;
    @NotNull
    private final EngineInterceptor engineInterceptor;
    @NotNull
    private final IncrementalDeliveryProtocolImpl incrementalDeliveryProtocolImpl;

    private HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine engine, List<? extends HttpInterceptor> interceptors, boolean exposeErrorBody, IncrementalDeliveryProtocol incrementalDeliveryProtocol) {
        this.httpRequestComposer = httpRequestComposer;
        this.engine = engine;
        this.interceptors = interceptors;
        this.exposeErrorBody = exposeErrorBody;
        this.incrementalDeliveryProtocol = incrementalDeliveryProtocol;
        this.engineInterceptor = new EngineInterceptor();
        this.incrementalDeliveryProtocolImpl = IncrementalDeliveryProtocolImplKt.getImpl(this.incrementalDeliveryProtocol);
    }

    @NotNull
    public final List<HttpInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> execute(@NotNull ApolloRequest<D> request) {
        ApolloRequest apolloRequest;
        boolean bl;
        CustomScalarAdapters customScalarAdapters;
        block6: {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            ExecutionContext.Element element = request.getExecutionContext().get((ExecutionContext.Key)CustomScalarAdapters.Key);
            Intrinsics.checkNotNull((Object)element);
            customScalarAdapters = (CustomScalarAdapters)element;
            List list = request.getHttpHeaders();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    HttpHeader it = (HttpHeader)element$iv;
                    boolean bl2 = false;
                    String string = it.getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string, (Object)"accept")) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            String accept = request.getOperation() instanceof Subscription ? "multipart/mixed;subscriptionSpec=1.0, application/graphql-response+json, application/json" : this.incrementalDeliveryProtocolImpl.getAcceptHeader();
            apolloRequest = request.newBuilder().addHttpHeader("accept", accept).build();
        } else {
            apolloRequest = request;
        }
        ApolloRequest request2 = apolloRequest;
        HttpRequest httpRequest = this.httpRequestComposer.compose(request2);
        return this.execute$apollo_runtime(request2, httpRequest, customScalarAdapters);
    }

    @NotNull
    public final <D extends Operation.Data> Flow<ApolloResponse<D>> execute$apollo_runtime(@NotNull ApolloRequest<D> request, @NotNull HttpRequest httpRequest, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super ApolloResponse<D>>, Continuation<? super Unit>, Object>(this, httpRequest, request, customScalarAdapters, null){
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HttpNetworkTransport this$0;
            final /* synthetic */ HttpRequest $httpRequest;
            final /* synthetic */ ApolloRequest<D> $request;
            final /* synthetic */ CustomScalarAdapters $customScalarAdapters;
            {
                this.this$0 = $receiver;
                this.$httpRequest = $httpRequest;
                this.$request = $request;
                this.$customScalarAdapters = $customScalarAdapters;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        millisStart = UtilsKt.currentTimeMillis();
                        throwable = null;
                        this.L$0 = $this$flow;
                        this.J$0 = millisStart;
                        this.label = 1;
                        v0 = new DefaultHttpInterceptorChain(CollectionsKt.plus((Collection)this.this$0.getInterceptors(), (Object)HttpNetworkTransport.access$getEngineInterceptor$p(this.this$0)), 0).proceed(this.$httpRequest, (Continuation<? super HttpResponse>)((Continuation)this));
                        ** if (v0 != var15_2) goto lbl16
lbl15:
                        // 1 sources

                        return var15_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        millisStart = this.J$0;
                        throwable = null;
                        $this$flow = (FlowCollector)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var7_6 = (HttpResponse)v0;
                        }
                        catch (Throwable t) {
                            if (t instanceof CancellationException) {
                                throw t;
                            }
                            throwable = t;
                            var7_6 = null;
                        }
                        httpResponse = var7_6;
                        if (httpResponse == null) {
                            v1 = this.$request.getOperation();
                            v2 = throwable;
                            Intrinsics.checkNotNull((Object)v2);
                            v3 = FlowKt.flowOf((Object)HttpNetworkTransport.access$errorResponse(this.this$0, v1, v2));
                        } else {
                            t = httpResponse.getStatusCode();
                            v3 = (200 <= t ? t < 300 : false) == false && MultipartKt.isGraphQLResponse(httpResponse) == false ? HttpNetworkTransport.access$errorResponse(this.this$0, this.$request.getOperation(), httpResponse) : (MultipartKt.isMultipart(httpResponse) != false ? HttpNetworkTransport.access$multipleResponses(this.this$0, this.$request, this.$customScalarAdapters, httpResponse) : HttpNetworkTransport.access$singleResponse(this.this$0, this.$request, this.$customScalarAdapters, httpResponse));
                        }
                        t = responses = v3;
                        var9_11 = this.this$0;
                        var10_12 = this.$request;
                        $i$f$map = false;
                        $this$unsafeTransform$iv$iv = $this$map$iv;
                        $i$f$unsafeTransform = false;
                        $i$f$unsafeFlow = false;
                        this.L$0 = null;
                        this.label = 2;
                        v4 = FlowKt.emitAll((FlowCollector)$this$flow, (Flow)((Flow)new Flow<ApolloResponse<D>>((Flow)$this$unsafeTransform$iv$iv, var9_11, var10_12, httpResponse, millisStart){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            final /* synthetic */ HttpNetworkTransport this$0;
                            final /* synthetic */ ApolloRequest $request$inlined;
                            final /* synthetic */ HttpResponse $httpResponse$inlined;
                            final /* synthetic */ long $millisStart$inlined;
                            {
                                this.$this_unsafeTransform$inlined = flow2;
                                this.this$0 = httpNetworkTransport;
                                this.$request$inlined = apolloRequest;
                                this.$httpResponse$inlined = httpResponse;
                                this.$millisStart$inlined = l;
                            }

                            public Object collect(FlowCollector collector2, Continuation $completion) {
                                Continuation continuation = $completion;
                                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector2;
                                boolean bl = false;
                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0, this.$request$inlined, this.$httpResponse$inlined, this.$millisStart$inlined){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                    final /* synthetic */ HttpNetworkTransport this$0;
                                    final /* synthetic */ ApolloRequest $request$inlined;
                                    final /* synthetic */ HttpResponse $httpResponse$inlined;
                                    final /* synthetic */ long $millisStart$inlined;
                                    {
                                        this.$this_unsafeFlow = $receiver;
                                        this.this$0 = httpNetworkTransport;
                                        this.$request$inlined = apolloRequest;
                                        this.$httpResponse$inlined = httpResponse;
                                        this.$millisStart$inlined = l;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object emit(Object var1_1, Continuation $completion) {
                                        if (!($completion instanceof execute$1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                        var3_3 = $completion;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                int label;
                                                Object L$0;
                                                final /* synthetic */ execute$1$invokeSuspend$$inlined$map$1$2 this$0;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit(null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var6_6 = value;
                                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                var9_10 = $this$map_u24lambda_u245;
                                                (Continuation)$continuation;
                                                it = (ApolloResponse)value;
                                                $i$a$-map-HttpNetworkTransport$execute$1$1 = false;
                                                $continuation.label = 1;
                                                v0 = var9_10.emit((Object)HttpNetworkTransport.access$withHttpInfo(this.this$0, it, this.$request$inlined.getRequestUuid(), this.$httpResponse$inlined, this.$millisStart$inlined), (Continuation)$continuation);
                                                if (v0 == var5_5) {
                                                    return var5_5;
                                                }
                                                ** GOTO lbl29
                                            }
                                            case 1: {
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl29:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this));
                        if (v4 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl60
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl60:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<FlowCollector<? super ApolloResponse<D>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(FlowCollector<? super ApolloResponse<D>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final <D extends Operation.Data> ApolloResponse<D> errorResponse(Operation<D> operation, Throwable throwable) {
        ApolloException apolloException = throwable instanceof ApolloException ? (ApolloException)throwable : (ApolloException)new ApolloNetworkException("Error while reading JSON response", (Object)throwable);
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        UUID uUID2 = uUID;
        return new ApolloResponse.Builder(operation, uUID2).exception(apolloException).isLast(true).build();
    }

    private final <D extends Operation.Data> Flow<ApolloResponse<D>> errorResponse(Operation<D> operation, HttpResponse httpResponse) {
        BufferedSource bufferedSource;
        if (this.exposeErrorBody) {
            bufferedSource = httpResponse.getBody();
        } else {
            BufferedSource bufferedSource2 = httpResponse.getBody();
            if (bufferedSource2 != null) {
                bufferedSource2.close();
            }
            bufferedSource = null;
        }
        BufferedSource maybeBody = bufferedSource;
        ApolloHttpException apolloException = new ApolloHttpException(httpResponse.getStatusCode(), httpResponse.getHeaders(), maybeBody, "Http request failed with status code `" + httpResponse.getStatusCode() + '`', null, 16, null);
        return FlowKt.flowOf(this.errorResponse(operation, (Throwable)apolloException));
    }

    private final <D extends Operation.Data> Flow<ApolloResponse<D>> singleResponse(ApolloRequest<D> request, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        JsonReader jsonReader;
        Operation operation = request.getOperation();
        BufferedSource bufferedSource = httpResponse.getBody();
        Intrinsics.checkNotNull((Object)bufferedSource);
        JsonReader $this$singleResponse_u24lambda_u240 = jsonReader = -JsonReaders.jsonReader((BufferedSource)bufferedSource);
        boolean bl = false;
        Boolean bl2 = request.getIgnoreUnknownKeys();
        $this$singleResponse_u24lambda_u240.ignoreUnknownKeys(bl2 != null ? bl2 : true);
        ApolloResponse response = Operations.toApolloResponse$default((JsonReader)jsonReader, (Operation)operation, null, (CustomScalarAdapters)customScalarAdapters, null, (int)2, null).newBuilder().addExecutionContext(httpResponse.getExecutionContext()).build();
        return FlowKt.flowOf((Object)response.newBuilder().isLast(true).build());
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends Operation.Data> Flow<ApolloResponse<D>> multipleResponses(ApolloRequest<D> request, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        void $this$mapNotNull$iv;
        Ref.ObjectRef incrementalResultsMerger = new Ref.ObjectRef();
        Operation operation = request.getOperation();
        Flow<BufferedSource> flow2 = MultipartKt.multipartBodyFlow(httpResponse);
        boolean $i$f$mapNotNull = false;
        void $this$unsafeTransform$iv$iv = $this$mapNotNull$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.catch((Flow)new Flow<ApolloResponse<D>>((Flow)$this$unsafeTransform$iv$iv, operation, customScalarAdapters, this, incrementalResultsMerger, request){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ Operation $operation$inlined;
            final /* synthetic */ CustomScalarAdapters $customScalarAdapters$inlined;
            final /* synthetic */ HttpNetworkTransport this$0;
            final /* synthetic */ Ref.ObjectRef $incrementalResultsMerger$inlined;
            final /* synthetic */ ApolloRequest $request$inlined;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.$operation$inlined = operation;
                this.$customScalarAdapters$inlined = customScalarAdapters;
                this.this$0 = httpNetworkTransport;
                this.$incrementalResultsMerger$inlined = objectRef;
                this.$request$inlined = apolloRequest;
            }

            public Object collect(FlowCollector collector2, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector2;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$operation$inlined, this.$customScalarAdapters$inlined, this.this$0, this.$incrementalResultsMerger$inlined, this.$request$inlined){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ Operation $operation$inlined;
                    final /* synthetic */ CustomScalarAdapters $customScalarAdapters$inlined;
                    final /* synthetic */ HttpNetworkTransport this$0;
                    final /* synthetic */ Ref.ObjectRef $incrementalResultsMerger$inlined;
                    final /* synthetic */ ApolloRequest $request$inlined;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.$operation$inlined = operation;
                        this.$customScalarAdapters$inlined = customScalarAdapters;
                        this.this$0 = httpNetworkTransport;
                        this.$incrementalResultsMerger$inlined = objectRef;
                        this.$request$inlined = apolloRequest;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object var1_1, Continuation $completion) {
                        if (!($completion instanceof multipleResponses$$inlined$mapNotNull$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ multipleResponses$$inlined$mapNotNull$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = value;
                                $this$mapNotNull_u24lambda_u246 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                (Continuation)$continuation;
                                part = (BufferedSource)value;
                                $i$a$-mapNotNull-HttpNetworkTransport$multipleResponses$1 = false;
                                if (this.$operation$inlined instanceof Subscription) {
                                    $this$multipleResponses_u24lambda_u240_u240 = var11_12 = -JsonReaders.jsonReader((BufferedSource)part);
                                    $i$a$-apply-HttpNetworkTransport$multipleResponses$1$reader$1 = false;
                                    v0 = this.$request$inlined.getIgnoreUnknownKeys();
                                    $this$multipleResponses_u24lambda_u240_u240.ignoreUnknownKeys(v0 != null ? v0 : true);
                                    reader = var11_12;
                                    payloadResponse = null;
                                    errors = null;
                                    reader.beginObject();
                                    while (reader.hasNext()) {
                                        var13_17 = reader.nextName();
                                        if (Intrinsics.areEqual((Object)var13_17, (Object)"payload")) {
                                            if (reader.peek() == JsonReader.Token.NULL) {
                                                reader.skipValue();
                                                continue;
                                            }
                                            payloadResponse = Operations.parseResponse$default((JsonReader)reader, (Operation)this.$operation$inlined, null, (CustomScalarAdapters)this.$customScalarAdapters$inlined, null, (int)2, null);
                                            continue;
                                        }
                                        if (Intrinsics.areEqual((Object)var13_17, (Object)"errors")) {
                                            if (reader.peek() == JsonReader.Token.NULL) {
                                                reader.skipValue();
                                                continue;
                                            }
                                            errors = ResponseParserKt.readErrors((JsonReader)reader);
                                            continue;
                                        }
                                        reader.skipValue();
                                    }
                                    reader.endObject();
                                    if (errors != null) {
                                        v1 = HttpNetworkTransport.access$errorResponse(this.this$0, this.$operation$inlined, (Throwable)new RouterError(errors));
                                    } else {
                                        v1 = payloadResponse;
                                        if (v1 == null) {
                                            v1 = null;
                                        }
                                    }
                                } else {
                                    if (this.$incrementalResultsMerger$inlined.element == null) {
                                        this.$incrementalResultsMerger$inlined.element = HttpNetworkTransport.access$getIncrementalDeliveryProtocolImpl$p(this.this$0).newIncrementalResultsMerger();
                                    }
                                    merged = ((IncrementalResultsMerger)this.$incrementalResultsMerger$inlined.element).merge(part);
                                    deferredFragmentIdentifiers = ((IncrementalResultsMerger)this.$incrementalResultsMerger$inlined.element).getDeferredFragmentIdentifiers();
                                    v2 = isLast = ((IncrementalResultsMerger)this.$incrementalResultsMerger$inlined.element).getHasNext() == false;
                                    v1 = ((IncrementalResultsMerger)this.$incrementalResultsMerger$inlined.element).isEmptyResponse() ? null : Operations.toApolloResponse$default((JsonReader)-JsonReaders.jsonReader(merged), (Operation)this.$operation$inlined, null, (CustomScalarAdapters)this.$customScalarAdapters$inlined, deferredFragmentIdentifiers, (int)2, null).newBuilder().isLast(isLast != false).build();
                                }
                                if ((var15_20 = v1) != null) {
                                    transformed = var15_20;
                                    $continuation.label = 1;
                                    v3 = $this$mapNotNull_u24lambda_u246.emit((Object)transformed, (Continuation)$continuation);
                                    if (v3 == var5_5) {
                                        return var5_5;
                                    }
                                }
                                ** GOTO lbl72
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$mapNotNull$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl72:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }, (Function3)new Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object>(operation, this, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ Operation<D> $operation;
            final /* synthetic */ HttpNetworkTransport this$0;
            {
                this.$operation = $operation;
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        FlowCollector $this$catch = (FlowCollector)this.L$0;
                        Throwable throwable = (Throwable)this.L$1;
                        boolean $i$f$uuid4 = false;
                        UUID uUID = UUID.randomUUID();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
                        this.L$0 = null;
                        this.label = 1;
                        Object object3 = var2_3.emit((Object)new ApolloResponse.Builder(this.$operation, uUID).exception(HttpNetworkTransport.access$wrapIfNeeded(this.this$0, throwable)).build(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super ApolloResponse<D>> p1, Throwable p2, Continuation<? super Unit> p3) {
                Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    private final ApolloException wrapIfNeeded(Throwable $this$wrapIfNeeded) {
        return $this$wrapIfNeeded instanceof ApolloException ? (ApolloException)$this$wrapIfNeeded : (ApolloException)new ApolloNetworkException("Error while reading response", (Object)$this$wrapIfNeeded);
    }

    private final <D extends Operation.Data> ApolloResponse<D> withHttpInfo(ApolloResponse<D> $this$withHttpInfo, UUID requestUuid, HttpResponse httpResponse, long millisStart) {
        ApolloResponse.Builder builder;
        ApolloResponse.Builder $this$withHttpInfo_u24lambda_u240 = builder = $this$withHttpInfo.newBuilder().requestUuid(requestUuid);
        boolean bl = false;
        if (httpResponse != null) {
            $this$withHttpInfo_u24lambda_u240.addExecutionContext((ExecutionContext)new HttpInfo(millisStart, UtilsKt.currentTimeMillis(), httpResponse.getStatusCode(), httpResponse.getHeaders()));
        }
        return builder.build();
    }

    @Override
    public void dispose() {
        Iterable $this$forEach$iv = this.interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpInterceptor it = (HttpInterceptor)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.engine.close();
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder().httpEngine(this.engine).interceptors(this.interceptors).httpRequestComposer(this.httpRequestComposer).exposeErrorBody(this.exposeErrorBody).incrementalDeliveryProtocol(this.incrementalDeliveryProtocol);
    }

    public static final /* synthetic */ EngineInterceptor access$getEngineInterceptor$p(HttpNetworkTransport $this) {
        return $this.engineInterceptor;
    }

    public static final /* synthetic */ ApolloResponse access$errorResponse(HttpNetworkTransport $this, Operation operation, Throwable throwable) {
        return $this.errorResponse(operation, throwable);
    }

    public static final /* synthetic */ Flow access$errorResponse(HttpNetworkTransport $this, Operation operation, HttpResponse httpResponse) {
        return $this.errorResponse(operation, httpResponse);
    }

    public static final /* synthetic */ Flow access$multipleResponses(HttpNetworkTransport $this, ApolloRequest request, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        return $this.multipleResponses(request, customScalarAdapters, httpResponse);
    }

    public static final /* synthetic */ Flow access$singleResponse(HttpNetworkTransport $this, ApolloRequest request, CustomScalarAdapters customScalarAdapters, HttpResponse httpResponse) {
        return $this.singleResponse(request, customScalarAdapters, httpResponse);
    }

    public static final /* synthetic */ ApolloResponse access$withHttpInfo(HttpNetworkTransport $this, ApolloResponse $receiver, UUID requestUuid, HttpResponse httpResponse, long millisStart) {
        return $this.withHttpInfo($receiver, requestUuid, httpResponse, millisStart);
    }

    public static final /* synthetic */ ApolloException access$wrapIfNeeded(HttpNetworkTransport $this, Throwable $receiver) {
        return $this.wrapIfNeeded($receiver);
    }

    public /* synthetic */ HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine engine, List interceptors, boolean exposeErrorBody, IncrementalDeliveryProtocol incrementalDeliveryProtocol, DefaultConstructorMarker $constructor_marker) {
        this(httpRequestComposer, engine, interceptors, exposeErrorBody, incrementalDeliveryProtocol);
    }

    public static final /* synthetic */ IncrementalDeliveryProtocolImpl access$getIncrementalDeliveryProtocolImpl$p(HttpNetworkTransport $this) {
        return $this.incrementalDeliveryProtocolImpl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0007J\u0016\u0010\u0016\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0017J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u001cR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/apollographql/apollo/network/http/HttpNetworkTransport$Builder;", "", "<init>", "()V", "httpRequestComposer", "Lcom/apollographql/apollo/api/http/HttpRequestComposer;", "serverUrl", "", "engine", "Lcom/apollographql/apollo/network/http/HttpEngine;", "interceptors", "", "Lcom/apollographql/apollo/network/http/HttpInterceptor;", "exposeErrorBody", "", "incrementalDeliveryProtocol", "Lcom/apollographql/apollo/network/IncrementalDeliveryProtocol;", "headers", "Lcom/apollographql/apollo/api/http/HttpHeader;", "addHttpHeader", "name", "value", "httpHeaders", "", "httpEngine", "addInterceptor", "interceptor", "build", "Lcom/apollographql/apollo/network/http/HttpNetworkTransport;", "apollo-runtime"})
    public static final class Builder {
        @Nullable
        private HttpRequestComposer httpRequestComposer;
        @Nullable
        private String serverUrl;
        @Nullable
        private HttpEngine engine;
        @NotNull
        private final List<HttpInterceptor> interceptors = new ArrayList();
        private boolean exposeErrorBody;
        @NotNull
        private IncrementalDeliveryProtocol incrementalDeliveryProtocol = IncrementalDeliveryProtocol.V0_1;
        @NotNull
        private final List<HttpHeader> headers = new ArrayList();

        @NotNull
        public final Builder httpRequestComposer(@NotNull HttpRequestComposer httpRequestComposer) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpRequestComposer, (String)"httpRequestComposer");
            Builder $this$httpRequestComposer_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpRequestComposer_u24lambda_u240.httpRequestComposer = httpRequestComposer;
            return builder;
        }

        @NotNull
        public final Builder serverUrl(@Nullable String serverUrl2) {
            Builder builder;
            Builder $this$serverUrl_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$serverUrl_u24lambda_u240.serverUrl = serverUrl2;
            return builder;
        }

        @NotNull
        public final Builder exposeErrorBody(boolean exposeErrorBody) {
            Builder builder;
            Builder $this$exposeErrorBody_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$exposeErrorBody_u24lambda_u240.exposeErrorBody = exposeErrorBody;
            return builder;
        }

        @Deprecated(message="Use ApolloClient.Builder.addHttpHeader() instead", level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder addHttpHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addHttpHeader_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addHttpHeader_u24lambda_u240.headers.add(new HttpHeader(name, value));
            return builder;
        }

        @Deprecated(message="Use ApolloClient.Builder.httpHeader() instead", level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder httpHeaders(@NotNull List<HttpHeader> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$httpHeaders_u24lambda_u240 = builder = this;
            boolean bl = false;
            CollectionsKt.removeAll($this$httpHeaders_u24lambda_u240.interceptors, Builder::httpHeaders$lambda$0$0);
            $this$httpHeaders_u24lambda_u240.headers.clear();
            $this$httpHeaders_u24lambda_u240.headers.addAll((Collection<HttpHeader>)headers);
            return builder;
        }

        @NotNull
        public final Builder httpEngine(@NotNull HttpEngine httpEngine) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpEngine, (String)"httpEngine");
            Builder $this$httpEngine_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpEngine_u24lambda_u240.engine = httpEngine;
            return builder;
        }

        @ApolloExperimental
        @NotNull
        public final Builder incrementalDeliveryProtocol(@NotNull IncrementalDeliveryProtocol incrementalDeliveryProtocol) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)incrementalDeliveryProtocol), (String)"incrementalDeliveryProtocol");
            Builder $this$incrementalDeliveryProtocol_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$incrementalDeliveryProtocol_u24lambda_u240.incrementalDeliveryProtocol = incrementalDeliveryProtocol;
            return builder;
        }

        @NotNull
        public final Builder interceptors(@NotNull List<? extends HttpInterceptor> interceptors) {
            Builder builder;
            Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
            Builder $this$interceptors_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$interceptors_u24lambda_u240.interceptors.clear();
            $this$interceptors_u24lambda_u240.interceptors.addAll((Collection<HttpInterceptor>)interceptors);
            return builder;
        }

        @NotNull
        public final Builder addInterceptor(@NotNull HttpInterceptor interceptor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            Builder $this$addInterceptor_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addInterceptor_u24lambda_u240.interceptors.add(interceptor);
            return builder;
        }

        @NotNull
        public final HttpNetworkTransport build() {
            HttpEngine httpEngine;
            HttpRequestComposer composer;
            if (!(this.httpRequestComposer == null || this.serverUrl == null)) {
                boolean bl = false;
                String string = "It is an error to set both 'httpRequestComposer' and 'serverUrl'";
                throw new IllegalStateException(string.toString());
            }
            HttpRequestComposer httpRequestComposer = this.httpRequestComposer;
            if (httpRequestComposer == null) {
                httpRequestComposer = composer = (HttpRequestComposer)new DefaultHttpRequestComposer(this.serverUrl);
            }
            if (!((Collection)this.headers).isEmpty()) {
                this.interceptors.add(new TransportHeadersInterceptor(this.headers));
            }
            if ((httpEngine = this.engine) == null) {
                httpEngine = DefaultHttpEngine.DefaultHttpEngine$default(0L, 1, null);
            }
            return new HttpNetworkTransport(composer, httpEngine, this.interceptors, this.exposeErrorBody, this.incrementalDeliveryProtocol, null);
        }

        private static final boolean httpHeaders$lambda$0$0(HttpInterceptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof TransportHeadersInterceptor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo/network/http/HttpNetworkTransport$EngineInterceptor;", "Lcom/apollographql/apollo/network/http/HttpInterceptor;", "<init>", "(Lcom/apollographql/apollo/network/http/HttpNetworkTransport;)V", "intercept", "Lcom/apollographql/apollo/api/http/HttpResponse;", "request", "Lcom/apollographql/apollo/api/http/HttpRequest;", "chain", "Lcom/apollographql/apollo/network/http/HttpInterceptorChain;", "(Lcom/apollographql/apollo/api/http/HttpRequest;Lcom/apollographql/apollo/network/http/HttpInterceptorChain;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "apollo-runtime"})
    public final class EngineInterceptor
    implements HttpInterceptor {
        @Override
        @Nullable
        public Object intercept(@NotNull HttpRequest request, @NotNull HttpInterceptorChain chain, @NotNull Continuation<? super HttpResponse> $completion) {
            return HttpNetworkTransport.this.engine.execute(request, $completion);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo/network/http/HttpNetworkTransport$TransportHeadersInterceptor;", "Lcom/apollographql/apollo/network/http/HttpInterceptor;", "headers", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "<init>", "(Ljava/util/List;)V", "intercept", "Lcom/apollographql/apollo/api/http/HttpResponse;", "request", "Lcom/apollographql/apollo/api/http/HttpRequest;", "chain", "Lcom/apollographql/apollo/network/http/HttpInterceptorChain;", "(Lcom/apollographql/apollo/api/http/HttpRequest;Lcom/apollographql/apollo/network/http/HttpInterceptorChain;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "apollo-runtime"})
    private static final class TransportHeadersInterceptor
    implements HttpInterceptor {
        @NotNull
        private final List<HttpHeader> headers;

        public TransportHeadersInterceptor(@NotNull List<HttpHeader> headers) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            this.headers = headers;
        }

        @Override
        @Nullable
        public Object intercept(@NotNull HttpRequest request, @NotNull HttpInterceptorChain chain, @NotNull Continuation<? super HttpResponse> $completion) {
            return chain.proceed(HttpRequest.newBuilder$default((HttpRequest)request, null, null, (int)3, null).addHeaders(this.headers).build(), $completion);
        }
    }
}

