/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.runtime.java.network.ws.protocol;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ImmutableMapBuilder;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo.runtime.java.network.ws.WebSocketConnection;
import com.apollographql.apollo.runtime.java.network.ws.protocol.WsProtocol;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppSyncWsProtocol
extends WsProtocol {
    private Map<String, Object> authorization;
    private long connectionAcknowledgeTimeoutMs;

    public AppSyncWsProtocol(WebSocketConnection webSocketConnection, WsProtocol.Listener listener, Map<String, Object> authorization, long connectionAcknowledgeTimeoutMs) {
        super(webSocketConnection, listener);
        this.authorization = authorization;
        this.connectionAcknowledgeTimeoutMs = connectionAcknowledgeTimeoutMs;
    }

    @Override
    public void connectionInit() {
        Map message = new ImmutableMapBuilder().put((Object)"type", (Object)"connection_init").build();
        this.sendMessageMapText(message);
        Map<String, Object> map = this.receiveMessageMap(this.connectionAcknowledgeTimeoutMs);
        if (map == null) {
            this.listener.networkError(new IOException("Connection closed or timeout while waiting for connection_ack"));
        } else {
            Object type = map.get("type");
            if ("connection_error".equals(type)) {
                this.listener.networkError(new IOException("connection_error received " + map));
            } else if (!"connection_ack".equals(type)) {
                System.out.println("unknown graphql-transport-ws message while waiting for connection_ack: " + type);
            }
        }
    }

    @Override
    public void handleServerMessage(Map<String, Object> messageMap) {
        String type;
        switch (type = (String)messageMap.get("type")) {
            case "data": {
                this.listener.operationResponse((String)messageMap.get("id"), (Map)messageMap.get("payload"));
                break;
            }
            case "error": {
                String id = (String)messageMap.get("id");
                if (id != null) {
                    this.listener.operationError(id, (Map)messageMap.get("payload"));
                    break;
                }
                this.listener.generalError((Map)messageMap.get("payload"));
                break;
            }
            case "complete": {
                this.listener.operationComplete((String)messageMap.get("id"));
                break;
            }
        }
    }

    @Override
    public <D extends Operation.Data> void startOperation(ApolloRequest<D> request) {
        String data = AppSyncWsProtocol.toJsonString(DefaultHttpRequestComposer.Companion.composePayload(request));
        this.sendMessageMapText(new ImmutableMapBuilder().put((Object)"type", (Object)"start").put((Object)"id", (Object)request.getRequestUuid().toString()).put((Object)"payload", (Object)new ImmutableMapBuilder().put((Object)"data", (Object)data).put((Object)"extensions", (Object)new ImmutableMapBuilder().put((Object)"authorization", this.authorization).build()).build()).build());
    }

    @Override
    public <D extends Operation.Data> void stopOperation(ApolloRequest<D> request) {
        this.sendMessageMapText(new ImmutableMapBuilder().put((Object)"type", (Object)"stop").put((Object)"id", (Object)request.getRequestUuid().toString()).build());
    }

    @NotNull
    public static String buildUrl(@NotNull String baseUrl, @NotNull Map<String, Object> authorization, @NotNull Map<String, Object> payload) {
        return DefaultHttpRequestComposer.Companion.appendQueryParameters(baseUrl, new ImmutableMapBuilder().put((Object)"header", (Object)AppSyncWsProtocol.toJsonByteString(authorization).base64()).put((Object)"payload", (Object)AppSyncWsProtocol.toJsonByteString(payload).base64()).build());
    }

    public static class Factory
    implements WsProtocol.Factory {
        private Map<String, Object> authorization;
        private long connectionAcknowledgeTimeoutMs;

        public Factory(Map<String, Object> authorization) {
            this(authorization, 10000L);
        }

        public Factory(Map<String, Object> authorization, long connectionAcknowledgeTimeoutMs) {
            this.authorization = authorization;
            this.connectionAcknowledgeTimeoutMs = connectionAcknowledgeTimeoutMs;
        }

        @Override
        public String getName() {
            return "graphql-ws";
        }

        @Override
        public WsProtocol create(WebSocketConnection webSocketConnection, WsProtocol.Listener listener) {
            return new AppSyncWsProtocol(webSocketConnection, listener, this.authorization, this.connectionAcknowledgeTimeoutMs);
        }
    }
}

