/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.reactor;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryWatcher;
import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionTerminatedException;
import com.apollographql.apollo.internal.util.Cancelable;
import org.jetbrains.annotations.NotNull;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class ReactorApollo {
    private ReactorApollo() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    @NotNull
    public static <T> Mono<Response<T>> from(@NotNull ApolloQueryWatcher<T> watcher) {
        Utils.checkNotNull(watcher, (Object)"watcher == null");
        return Mono.create(sink -> {
            ApolloQueryWatcher clone = watcher.clone();
            ReactorApollo.cancelOnMonoDisposed(sink, (Cancelable)clone);
            clone.enqueueAndWatch(new ApolloCall.Callback<T>((MonoSink)sink){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                public void onResponse(@NotNull Response<T> response) {
                    this.val$sink.success(response);
                }

                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.val$sink.error((Throwable)e);
                }
            });
        });
    }

    @NotNull
    public static <T> Mono<Response<T>> from(@NotNull ApolloCall<T> call) {
        Utils.checkNotNull(call, (Object)"call == null");
        return Mono.create(sink -> {
            ApolloCall clone = call.toBuilder().build();
            ReactorApollo.cancelOnMonoDisposed(sink, (Cancelable)clone);
            clone.enqueue(new ApolloCall.Callback<T>((MonoSink)sink){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                public void onResponse(@NotNull Response<T> response) {
                    this.val$sink.success(response);
                }

                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.val$sink.error((Throwable)e);
                }

                public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                    if (event == ApolloCall.StatusEvent.COMPLETED) {
                        this.val$sink.success();
                    }
                }
            });
        });
    }

    @NotNull
    public static Mono<Void> from(@NotNull ApolloPrefetch prefetch) {
        Utils.checkNotNull((Object)prefetch, (Object)"prefetch == null");
        return Mono.create(sink -> {
            ApolloPrefetch clone = prefetch.clone();
            ReactorApollo.cancelOnMonoDisposed(sink, (Cancelable)clone);
            clone.enqueue(new ApolloPrefetch.Callback((MonoSink)sink){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                public void onSuccess() {
                    this.val$sink.success();
                }

                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.val$sink.error((Throwable)e);
                }
            });
        });
    }

    @NotNull
    public static <T> Flux<Response<T>> from(@NotNull ApolloSubscriptionCall<T> call) {
        return ReactorApollo.from(call, FluxSink.OverflowStrategy.LATEST);
    }

    @NotNull
    public static <T> Flux<Response<T>> from(@NotNull ApolloSubscriptionCall<T> call, @NotNull FluxSink.OverflowStrategy backpressureStrategy) {
        Utils.checkNotNull(call, (Object)"originalCall == null");
        Utils.checkNotNull((Object)backpressureStrategy, (Object)"backpressureStrategy == null");
        return Flux.create(sink -> {
            ApolloSubscriptionCall clone = call.clone();
            ReactorApollo.cancelOnFluxDisposed(sink, (Cancelable)clone);
            clone.execute(new ApolloSubscriptionCall.Callback<T>((FluxSink)sink){
                final /* synthetic */ FluxSink val$sink;
                {
                    this.val$sink = fluxSink;
                }

                public void onResponse(@NotNull Response<T> response) {
                    if (!this.val$sink.isCancelled()) {
                        this.val$sink.next(response);
                    }
                }

                public void onFailure(@NotNull ApolloException e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    if (!this.val$sink.isCancelled()) {
                        this.val$sink.error((Throwable)e);
                    }
                }

                public void onCompleted() {
                    if (!this.val$sink.isCancelled()) {
                        this.val$sink.complete();
                    }
                }

                public void onTerminated() {
                    this.onFailure((ApolloException)new ApolloSubscriptionTerminatedException("Subscription server unexpectedly terminated connection"));
                }

                public void onConnected() {
                }
            });
        }, (FluxSink.OverflowStrategy)backpressureStrategy);
    }

    @NotNull
    public static <T> Mono<T> from(@NotNull ApolloStoreOperation<T> operation) {
        Utils.checkNotNull(operation, (Object)"operation == null");
        return Mono.create(sink -> operation.enqueue(new ApolloStoreOperation.Callback<T>((MonoSink)sink){
            final /* synthetic */ MonoSink val$sink;
            {
                this.val$sink = monoSink;
            }

            public void onSuccess(T result) {
                this.val$sink.success(result);
            }

            public void onFailure(@NotNull Throwable t) {
                this.val$sink.error(t);
            }
        }));
    }

    private static <T> void cancelOnMonoDisposed(MonoSink<T> sink, Cancelable cancelable) {
        sink.onCancel(ReactorApollo.getReactorDisposable(cancelable));
        sink.onDispose(ReactorApollo.getReactorDisposable(cancelable));
    }

    private static <T> void cancelOnFluxDisposed(FluxSink<T> sink, Cancelable cancelable) {
        sink.onCancel(ReactorApollo.getReactorDisposable(cancelable));
        sink.onDispose(ReactorApollo.getReactorDisposable(cancelable));
    }

    private static Disposable getReactorDisposable(final Cancelable cancelable) {
        return new Disposable(){

            public void dispose() {
                cancelable.cancel();
            }

            public boolean isDisposed() {
                return cancelable.isCanceled();
            }
        };
    }
}

