/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.internal.ResolveDelegate;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.RecordSet;
import com.apollographql.apollo.cache.normalized.internal.CacheKeyBuilder;
import com.apollographql.apollo.cache.normalized.internal.SimpleStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResponseNormalizer<R>
implements ResolveDelegate<R> {
    private SimpleStack<List<String>> pathStack;
    private SimpleStack<Record> recordStack;
    private SimpleStack<Object> valueStack;
    private List<String> path;
    private Record.Builder currentRecordBuilder;
    private RecordSet recordSet = new RecordSet();
    private Set<String> dependentKeys = Collections.emptySet();
    public static final ResponseNormalizer NO_OP_NORMALIZER = new ResponseNormalizer(){

        @Override
        public void willResolveRootQuery(Operation operation) {
        }

        @Override
        public void willResolve(ResponseField field, Operation.Variables variables, @Nullable Object value) {
        }

        @Override
        public void didResolve(ResponseField field, Operation.Variables variables) {
        }

        @Override
        public void didResolveScalar(Object value) {
        }

        public void willResolveObject(ResponseField field, @Nullable Object objectSource) {
        }

        public void didResolveObject(ResponseField field, @Nullable Object objectSource) {
        }

        @Override
        public void didResolveList(List array) {
        }

        @Override
        public void willResolveElement(int atIndex) {
        }

        @Override
        public void didResolveElement(int atIndex) {
        }

        @Override
        public void didResolveNull() {
        }

        @Override
        public Collection<Record> records() {
            return Collections.emptyList();
        }

        @Override
        public Set<String> dependentKeys() {
            return Collections.emptySet();
        }

        @NotNull
        public CacheKey resolveCacheKey(@NotNull ResponseField field, @NotNull Object record) {
            return CacheKey.NO_KEY;
        }

        @Override
        @NotNull
        public CacheKeyBuilder cacheKeyBuilder() {
            return new CacheKeyBuilder(){

                @NotNull
                public String build(@NotNull ResponseField field, @NotNull Operation.Variables variables) {
                    return CacheKey.NO_KEY.key();
                }
            };
        }
    };

    public Collection<Record> records() {
        return this.recordSet.allRecords();
    }

    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }

    public void willResolveRootQuery(Operation operation) {
        this.willResolveRecord(CacheKeyResolver.rootKeyForOperation((Operation)operation));
    }

    public void willResolve(ResponseField field, Operation.Variables variables, @Nullable Object value) {
        String key = this.cacheKeyBuilder().build(field, variables);
        this.path.add(key);
    }

    public void didResolve(ResponseField field, Operation.Variables variables) {
        this.path.remove(this.path.size() - 1);
        Object value = this.valueStack.pop();
        String cacheKey = this.cacheKeyBuilder().build(field, variables);
        String dependentKey = this.currentRecordBuilder.key() + "." + cacheKey;
        this.dependentKeys.add(dependentKey);
        this.currentRecordBuilder.addField(cacheKey, value);
        if (this.recordStack.isEmpty()) {
            this.recordSet.merge(this.currentRecordBuilder.build());
        }
    }

    public void didResolveScalar(@Nullable Object value) {
        this.valueStack.push(value);
    }

    public void willResolveObject(ResponseField field, @Nullable R objectSource) {
        this.pathStack.push(this.path);
        CacheKey cacheKey = objectSource != null ? this.resolveCacheKey(field, objectSource) : CacheKey.NO_KEY;
        String cacheKeyValue = cacheKey.key();
        if (cacheKey.equals((Object)CacheKey.NO_KEY)) {
            cacheKeyValue = this.pathToString();
        } else {
            this.path = new ArrayList<String>();
            this.path.add(cacheKeyValue);
        }
        this.recordStack.push(this.currentRecordBuilder.build());
        this.currentRecordBuilder = Record.builder((String)cacheKeyValue);
    }

    public void didResolveObject(ResponseField field, @Nullable R objectSource) {
        this.path = this.pathStack.pop();
        if (objectSource != null) {
            Record completedRecord = this.currentRecordBuilder.build();
            this.valueStack.push(new CacheReference(completedRecord.key()));
            this.dependentKeys.add(completedRecord.key());
            this.recordSet.merge(completedRecord);
        }
        this.currentRecordBuilder = this.recordStack.pop().toBuilder();
    }

    public void didResolveList(List array) {
        ArrayList<Object> parsedArray = new ArrayList<Object>(array.size());
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            parsedArray.add(0, this.valueStack.pop());
        }
        this.valueStack.push(parsedArray);
    }

    public void willResolveElement(int atIndex) {
        this.path.add(Integer.toString(atIndex));
    }

    public void didResolveElement(int atIndex) {
        this.path.remove(this.path.size() - 1);
    }

    public void didResolveNull() {
        this.valueStack.push(null);
    }

    @NotNull
    public abstract CacheKey resolveCacheKey(@NotNull ResponseField var1, @NotNull R var2);

    @NotNull
    public abstract CacheKeyBuilder cacheKeyBuilder();

    public void willResolveRecord(CacheKey cacheKey) {
        this.pathStack = new SimpleStack();
        this.recordStack = new SimpleStack();
        this.valueStack = new SimpleStack();
        this.dependentKeys = new HashSet<String>();
        this.path = new ArrayList<String>();
        this.currentRecordBuilder = Record.builder((String)cacheKey.key());
        this.recordSet = new RecordSet();
    }

    private String pathToString() {
        StringBuilder stringBuilder = new StringBuilder();
        int size = this.path.size();
        for (int i = 0; i < size; ++i) {
            String pathPiece = this.path.get(i);
            stringBuilder.append(pathPiece);
            if (i >= size - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }
}

