/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.internal.json.JsonReader;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.internal.CacheJsonStreamReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public final class RecordFieldJsonAdapter {
    public static RecordFieldJsonAdapter create() {
        return new RecordFieldJsonAdapter();
    }

    private RecordFieldJsonAdapter() {
    }

    public String toJson(@NotNull Map<String, Object> fields) {
        Utils.checkNotNull(fields, (Object)"fields == null");
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.setSerializeNulls(true);
        try {
            jsonWriter.beginObject();
            for (Map.Entry<String, Object> fieldEntry : fields.entrySet()) {
                String key = fieldEntry.getKey();
                Object value = fieldEntry.getValue();
                jsonWriter.name(key);
                RecordFieldJsonAdapter.writeJsonValue(value, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            return buffer.readUtf8();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> fromBufferSource(BufferedSource bufferedFieldSource) throws IOException {
        CacheJsonStreamReader cacheJsonStreamReader = new CacheJsonStreamReader((JsonReader)new BufferedSourceJsonReader(bufferedFieldSource));
        return cacheJsonStreamReader.toMap();
    }

    public Map<String, Object> from(String jsonFieldSource) throws IOException {
        BufferedSource bufferSource = Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(jsonFieldSource.getBytes(Charset.defaultCharset()))));
        return this.fromBufferSource(bufferSource);
    }

    private static void writeJsonValue(Object value, JsonWriter jsonWriter) throws IOException {
        if (value == null) {
            jsonWriter.nullValue();
        } else if (value instanceof String) {
            jsonWriter.value((String)value);
        } else if (value instanceof Boolean) {
            jsonWriter.value(Boolean.valueOf((Boolean)value));
        } else if (value instanceof Number) {
            jsonWriter.value((Number)value);
        } else if (value instanceof CacheReference) {
            jsonWriter.value(((CacheReference)value).serialize());
        } else if (value instanceof List) {
            jsonWriter.beginArray();
            for (Object item : (List)value) {
                RecordFieldJsonAdapter.writeJsonValue(item, jsonWriter);
            }
            jsonWriter.endArray();
        } else if (value instanceof Map) {
            Map fields = (Map)value;
            jsonWriter.beginObject();
            for (Map.Entry fieldEntry : fields.entrySet()) {
                jsonWriter.name((String)fieldEntry.getKey());
                RecordFieldJsonAdapter.writeJsonValue(fieldEntry.getValue(), jsonWriter);
            }
            jsonWriter.endObject();
        } else {
            throw new RuntimeException("Unsupported record value type: " + value.getClass());
        }
    }
}

