/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.MutableExecutionOptions;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.cache.http.ApolloHttpCache;
import com.apollographql.apollo.cache.http.CachingHttpInterceptor;
import com.apollographql.apollo.cache.http.DiskLruHttpCache;
import com.apollographql.apollo.cache.http.HttpFetchPolicy;
import com.apollographql.apollo.cache.http.HttpFetchPolicyContext;
import com.apollographql.apollo.cache.http.internal.CacheHeadersHttpInterceptor;
import com.apollographql.apollo.cache.http.internal.HttpCacheApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.network.NetworkTransport;
import com.apollographql.apollo.network.http.HttpInfo;
import com.apollographql.apollo.network.http.HttpInterceptor;
import com.apollographql.apollo.network.http.HttpNetworkTransport;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0006\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b\u0006\u001a%\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0011\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015\u001a%\u0010\u0016\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a%\u0010\u0018\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0018\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0019\u001a%\u0010\u001a\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u001a\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0019\".\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\t\u0010\u0010\"\u001e\u0010\u0000\u001a\u00020\b*\u00020\u001b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"httpCache", "Lcom/apollographql/apollo/ApolloClient$Builder;", "directory", "Ljava/io/File;", "maxSize", "", "configureApolloClientBuilder", "apolloHttpCache", "Lcom/apollographql/apollo/cache/http/ApolloHttpCache;", "isFromHttpCache", "", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "Lcom/apollographql/apollo/api/ApolloResponse;", "isFromHttpCache$annotations", "(Lcom/apollographql/apollo/api/ApolloResponse;)V", "(Lcom/apollographql/apollo/api/ApolloResponse;)Z", "httpFetchPolicy", "T", "Lcom/apollographql/apollo/api/MutableExecutionOptions;", "Lcom/apollographql/apollo/cache/http/HttpFetchPolicy;", "(Lcom/apollographql/apollo/api/MutableExecutionOptions;Lcom/apollographql/apollo/cache/http/HttpFetchPolicy;)Ljava/lang/Object;", "httpExpireTimeout", "(Lcom/apollographql/apollo/api/MutableExecutionOptions;J)Ljava/lang/Object;", "httpExpireAfterRead", "(Lcom/apollographql/apollo/api/MutableExecutionOptions;Z)Ljava/lang/Object;", "httpDoNotStore", "Lcom/apollographql/apollo/ApolloClient;", "getHttpCache$annotations", "(Lcom/apollographql/apollo/ApolloClient;)V", "getHttpCache", "(Lcom/apollographql/apollo/ApolloClient;)Lcom/apollographql/apollo/cache/http/ApolloHttpCache;", "apollo-http-cache"})
@JvmName(name="HttpCache")
@SourceDebugExtension(value={"SMAP\nHttpCacheExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCacheExtensions.kt\ncom/apollographql/apollo/cache/http/HttpCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n295#2,2:155\n295#2,2:157\n295#2,2:159\n1761#2,3:161\n295#2,2:164\n*S KotlinDebug\n*F\n+ 1 HttpCacheExtensions.kt\ncom/apollographql/apollo/cache/http/HttpCache\n*L\n80#1:155,2\n83#1:157,2\n90#1:159,2\n101#1:161,3\n148#1:164,2\n*E\n"})
public final class HttpCache {
    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    @JvmName(name="configureApolloClientBuilder")
    @NotNull
    public static final ApolloClient.Builder configureApolloClientBuilder(@NotNull ApolloClient.Builder $this$httpCache, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return HttpCache.configureApolloClientBuilder($this$httpCache, new DiskLruHttpCache(FileSystem.SYSTEM, directory, maxSize));
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    @JvmName(name="configureApolloClientBuilder")
    @NotNull
    public static final ApolloClient.Builder configureApolloClientBuilder(@NotNull ApolloClient.Builder $this$httpCache, @NotNull ApolloHttpCache apolloHttpCache) {
        ApolloClient.Builder builder;
        Map apolloRequestToCacheKey;
        CachingHttpInterceptor cachingHttpInterceptor;
        block8: {
            Object v4;
            ApolloClient.Builder $this$httpCache_u24lambda_u241;
            block7: {
                Object v2;
                HttpInterceptor it;
                Iterable $this$firstOrNull$iv;
                ApolloClient.Builder $this$httpCache_u24lambda_u240;
                block6: {
                    Object v0;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)apolloHttpCache, (String)"apolloHttpCache");
                        cachingHttpInterceptor = new CachingHttpInterceptor(apolloHttpCache);
                        apolloRequestToCacheKey = new LinkedHashMap();
                        $this$httpCache_u24lambda_u240 = builder = $this$httpCache;
                        boolean bl = false;
                        $this$firstOrNull$iv = $this$httpCache_u24lambda_u240.getHttpInterceptors();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (HttpInterceptor)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof CacheHeadersHttpInterceptor)) continue;
                            v0 = element$iv;
                            break block5;
                        }
                        v0 = null;
                    }
                    HttpInterceptor httpInterceptor = v0;
                    if (httpInterceptor != null) {
                        HttpInterceptor it2 = httpInterceptor;
                        boolean bl = false;
                        $this$httpCache_u24lambda_u240.removeHttpInterceptor(it2);
                    }
                    $this$firstOrNull$iv = $this$httpCache_u24lambda_u240.getHttpInterceptors();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (HttpInterceptor)element$iv;
                        boolean bl = false;
                        if (!(it instanceof CachingHttpInterceptor)) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                HttpInterceptor httpInterceptor = v2;
                if (httpInterceptor != null) {
                    HttpInterceptor it3 = httpInterceptor;
                    boolean bl = false;
                    $this$httpCache_u24lambda_u240.removeHttpInterceptor(it3);
                }
                $this$httpCache_u24lambda_u241 = builder = builder.addHttpInterceptor((HttpInterceptor)new CacheHeadersHttpInterceptor(apolloRequestToCacheKey)).addHttpInterceptor((HttpInterceptor)cachingHttpInterceptor);
                boolean bl = false;
                $this$firstOrNull$iv = $this$httpCache_u24lambda_u241.getInterceptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ApolloInterceptor)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof HttpCacheApolloInterceptor)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            ApolloInterceptor apolloInterceptor = v4;
            if (apolloInterceptor == null) break block8;
            ApolloInterceptor it = apolloInterceptor;
            boolean bl = false;
            $this$httpCache_u24lambda_u241.removeInterceptor(it);
        }
        return ApolloClient.Builder.addInterceptor$default((ApolloClient.Builder)builder, (ApolloInterceptor)new HttpCacheApolloInterceptor(apolloRequestToCacheKey, cachingHttpInterceptor), null, (int)2, null);
    }

    public static final <D extends Operation.Data> boolean isFromHttpCache(@NotNull ApolloResponse<D> $this$isFromHttpCache) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$isFromHttpCache, (String)"<this>");
            Object object = (HttpInfo)$this$isFromHttpCache.executionContext.get((ExecutionContext.Key)HttpInfo.Key);
            if (object != null && (object = object.getHeaders()) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        HttpHeader it = (HttpHeader)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"X-APOLLO-FROM-CACHE")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    public static /* synthetic */ void isFromHttpCache$annotations(ApolloResponse apolloResponse) {
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    public static final <T> T httpFetchPolicy(@NotNull MutableExecutionOptions<T> $this$httpFetchPolicy, @NotNull HttpFetchPolicy httpFetchPolicy) {
        Intrinsics.checkNotNullParameter($this$httpFetchPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)httpFetchPolicy), (String)"httpFetchPolicy");
        return (T)$this$httpFetchPolicy.addExecutionContext((ExecutionContext)new HttpFetchPolicyContext(httpFetchPolicy));
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    public static final <T> T httpExpireTimeout(@NotNull MutableExecutionOptions<T> $this$httpExpireTimeout, long httpExpireTimeout) {
        Intrinsics.checkNotNullParameter($this$httpExpireTimeout, (String)"<this>");
        return (T)$this$httpExpireTimeout.addHttpHeader("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(httpExpireTimeout));
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    public static final <T> T httpExpireAfterRead(@NotNull MutableExecutionOptions<T> $this$httpExpireAfterRead, boolean httpExpireAfterRead) {
        Intrinsics.checkNotNullParameter($this$httpExpireAfterRead, (String)"<this>");
        return (T)$this$httpExpireAfterRead.addHttpHeader("X-APOLLO-EXPIRE-AFTER-READ", String.valueOf(httpExpireAfterRead));
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    public static final <T> T httpDoNotStore(@NotNull MutableExecutionOptions<T> $this$httpDoNotStore, boolean httpDoNotStore) {
        Intrinsics.checkNotNullParameter($this$httpDoNotStore, (String)"<this>");
        return (T)$this$httpDoNotStore.addHttpHeader("X-APOLLO-CACHE-DO-NOT-STORE", String.valueOf(httpDoNotStore));
    }

    @NotNull
    public static final ApolloHttpCache getHttpCache(@NotNull ApolloClient $this$httpCache) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
            NetworkTransport networkTransport = $this$httpCache.getNetworkTransport();
            HttpNetworkTransport httpNetworkTransport = networkTransport instanceof HttpNetworkTransport ? (HttpNetworkTransport)networkTransport : null;
            if (httpNetworkTransport == null) {
                throw new IllegalStateException("cannot get the HttpCache, networkTransport is not a HttpNetworkTransport".toString());
            }
            HttpNetworkTransport httpNetworkTransport2 = httpNetworkTransport;
            Iterable $this$firstOrNull$iv = httpNetworkTransport2.getInterceptors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpInterceptor it = (HttpInterceptor)element$iv;
                boolean bl = false;
                if (!(it instanceof CachingHttpInterceptor)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        HttpInterceptor httpInterceptor = v1;
        if (httpInterceptor == null) {
            throw new IllegalStateException("no http cache configured".toString());
        }
        HttpInterceptor cachingHttpInterceptor = httpInterceptor;
        return ((CachingHttpInterceptor)cachingHttpInterceptor).getCache();
    }

    @Deprecated(message="Use `DefaultHttpRequestComposer(enablePostCaching = true)` instead. See https://go.apollo.dev/ak-http-cache")
    public static /* synthetic */ void getHttpCache$annotations(ApolloClient apolloClient) {
    }
}

