/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.okhttp3.Headers;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream$FramingSink;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream$FramingSource;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream$StreamTimeout;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.StreamResetException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;

public final class Http2Stream {
    public final int id;
    public final Http2Connection connection;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    public long writeBytesMaximum;
    public final ArrayDeque headersQueue;
    public boolean hasResponseHeaders;
    public final Http2Stream$FramingSource source;
    public final Http2Stream$FramingSink sink;
    public final Http2Stream$StreamTimeout readTimeout;
    public final Http2Stream$StreamTimeout writeTimeout;
    public int errorCode;
    public IOException errorException;

    public Http2Stream(int n, Http2Connection http2Connection, boolean bl, boolean bl2, Headers headers) {
        ArrayDeque<Headers> arrayDeque;
        Http2Stream http2Stream = this;
        http2Connection.getClass();
        this.id = n;
        this.connection = http2Connection;
        http2Stream.writeBytesMaximum = http2Connection.peerSettings.getInitialWindowSize();
        ArrayDeque<Headers> arrayDeque2 = arrayDeque;
        http2Stream.headersQueue = new ArrayDeque<Headers>();
        http2Stream.source = new Http2Stream$FramingSource(this, http2Connection.okHttpSettings.getInitialWindowSize(), bl2);
        http2Stream.sink = new Http2Stream$FramingSink(this, bl);
        http2Stream.readTimeout = new Http2Stream$StreamTimeout(this);
        http2Stream.writeTimeout = new Http2Stream$StreamTimeout(this);
        if (headers != null) {
            if (!this.isLocallyInitiated()) {
                arrayDeque2.add(headers);
                return;
            }
            throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
        }
        if (this.isLocallyInitiated()) {
            return;
        }
        throw new IllegalStateException("remotely-initiated streams should have headers");
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != 0) {
            return false;
        }
        Closeable closeable = this.source;
        if (closeable.finished || closeable.closed) {
            closeable = this.sink;
            if ((((Http2Stream$FramingSink)closeable).finished || ((Http2Stream$FramingSink)closeable).closed) && this.hasResponseHeaders) {
                return false;
            }
        }
        return true;
    }

    public final boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        this.connection.getClass();
        return true == bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized Headers takeHeaders() {
        Throwable throwable2;
        block6: {
            this.readTimeout.enter();
            try {
                while (this.headersQueue.isEmpty() && this.errorCode == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
            catch (Throwable throwable2) {
                break block6;
            }
            Http2Stream http2Stream = this;
            http2Stream.readTimeout.exitAndThrowIfTimedOut();
            if (!http2Stream.headersQueue.isEmpty()) {
                Object e = this.headersQueue.removeFirst();
                e.getClass();
                return (Headers)e;
            }
            IOException iOException = this.errorException;
            if (iOException != null) throw iOException;
            int n = this.errorCode;
            if (n == 0) throw null;
            iOException = new StreamResetException(n);
            throw iOException;
        }
        this.readTimeout.exitAndThrowIfTimedOut();
        throw throwable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void receiveHeaders(Headers headers, boolean bl) {
        headers.getClass();
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                if (!http2Stream.hasResponseHeaders || !bl) break block7;
                                this.source.getClass();
                            }
                            catch (Throwable throwable2) {}
                            break block8;
                        }
                        this.hasResponseHeaders = true;
                        this.headersQueue.add(headers);
                    }
                    if (!bl) break block9;
                    this.source.finished = true;
                    break block10;
                }
                boolean bl2 = this.isOpen();
                Http2Stream http2Stream2 = this;
                http2Stream2.notifyAll();
                // ** MonitorExit[v3] (shouldn't be in output)
                if (!bl2) {
                    this.connection.removeStream$okhttp(this.id);
                    return;
                }
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelStreamIfNecessary$okhttp() {
        if (Util.assertionsEnabled) {
            if (Thread.holdsLock(this)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block9: {
                boolean bl;
                block10: {
                    block8: {
                        try {
                            Closeable closeable = http2Stream.source;
                            if (closeable.finished || !closeable.closed) break block8;
                            closeable = this.sink;
                            if (!((Http2Stream$FramingSink)closeable).finished && !((Http2Stream$FramingSink)closeable).closed) break block8;
                        }
                        catch (Throwable throwable2) {
                            break block9;
                        }
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                Http2Stream http2Stream2 = this;
                int n = http2Stream2.isOpen();
                // ** MonitorExit[v3] (shouldn't be in output)
                if (!bl) {
                    if (n != 0) return;
                    this.connection.removeStream$okhttp(this.id);
                    return;
                }
                n = 9;
                if (!this.closeInternal(9, null)) {
                    return;
                }
                Http2Connection http2Connection = this.connection;
                int n2 = this.id;
                http2Connection.getClass();
                http2Connection.writer.rstStream(n2, n);
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Http2Stream$FramingSink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block4: {
                try {
                    if (!http2Stream.hasResponseHeaders && !this.isLocallyInitiated()) {
                        String string = "reply before requesting the sink";
                        throw new IllegalStateException(string);
                    }
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                Http2Stream http2Stream2 = this;
                // ** MonitorExit[v2] (shouldn't be in output)
                return http2Stream2.sink;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final synchronized void receiveRstStream() {
        int n = 8;
        if (this.errorCode == 0) {
            this.errorCode = n;
            this.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean closeInternal(int n, IOException iOException) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (http2Stream.errorCode == 0) break block6;
                        }
                        catch (Throwable throwable2) {}
                        return false;
                    }
                    Http2Stream http2Stream2 = this;
                    this.errorCode = n;
                    http2Stream2.errorException = iOException;
                    http2Stream2.notifyAll();
                    if (!http2Stream2.source.finished || !this.sink.finished) break block7;
                    // ** MonitorExit[this] (shouldn't be in output)
                    return false;
                }
                Http2Stream http2Stream3 = this;
                Http2Stream http2Stream4 = http2Stream3;
                Http2Stream http2Stream5 = http2Stream3;
                break block8;
                // ** MonitorExit[v4] (shouldn't be in output)
                http2Stream5.connection.removeStream$okhttp(this.id);
                return true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final synchronized int getErrorCode$okhttp() {
        return this.errorCode;
    }
}

