/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.internal.ExecutableValidationScope$0;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskQueue;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskRunner;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection$Builder;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection$Listener;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection$ReaderRunnable;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection$writeSynResetLater$$inlined$execute$default$1;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection$writeWindowUpdateLater$$inlined$execute$default$1;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Reader;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Writer;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.PushObserver;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.PushObserver$Companion$PushObserverCancel;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Settings;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.RealBufferedSink;
import com.apollographql.apollo.relocated.okio.RealBufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.channels.Channel;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public final class Http2Connection
implements Closeable {
    public static final Settings DEFAULT_SETTINGS;
    public final Http2Connection$Listener listener;
    public final LinkedHashMap streams;
    public final String connectionName;
    public int lastGoodStreamId;
    public int nextStreamId;
    public boolean isShutdown;
    public final TaskRunner taskRunner;
    public final TaskQueue writerQueue;
    public final TaskQueue pushQueue;
    public final TaskQueue settingsListenerQueue;
    public final PushObserver$Companion$PushObserverCancel pushObserver;
    public long intervalPongsReceived;
    public long degradedPingsSent;
    public long degradedPongsReceived;
    public long degradedPongDeadlineNs;
    public final Settings okHttpSettings;
    public Settings peerSettings;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    public long writeBytesMaximum;
    public final Socket socket;
    public final Http2Writer writer;
    public final Http2Connection$ReaderRunnable readerRunnable;
    public final LinkedHashSet currentPushRequests;

    public Http2Connection(Http2Connection$Builder object) {
        Http2Connection http2Connection = linkedHashSet2;
        http2Connection.listener = ((Http2Connection$Builder)object).listener;
        http2Connection.streams = new LinkedHashMap();
        Object object2 = ((Http2Connection$Builder)object).connectionName;
        if (object2 != null) {
            Http2Connection http2Connection2 = linkedHashSet2;
            Http2Connection http2Connection3 = linkedHashSet2;
            http2Connection3.connectionName = object2;
            http2Connection3.nextStreamId = 3;
            object2 = ((Http2Connection$Builder)object).taskRunner;
            http2Connection2.taskRunner = object2;
            http2Connection2.writerQueue = ((TaskRunner)object2).newQueue();
            http2Connection2.pushQueue = ((TaskRunner)object2).newQueue();
            http2Connection2.settingsListenerQueue = ((TaskRunner)object2).newQueue();
            http2Connection2.pushObserver = PushObserver.CANCEL;
            Settings settings = new Settings();
            settings.set(7, 0x1000000);
            http2Connection2.okHttpSettings = settings;
            object2 = DEFAULT_SETTINGS;
            http2Connection2.peerSettings = object2;
            http2Connection2.writeBytesMaximum = ((Settings)object2).getInitialWindowSize();
            object2 = ((Http2Connection$Builder)object).socket;
            if (object2 != null) {
                ((Http2Connection)((Object)linkedHashSet2)).socket = object2;
                Channel channel = ((Http2Connection$Builder)object).sink;
                if (channel != null) {
                    Http2Connection$Builder http2Connection$Builder = object;
                    ((Http2Connection)((Object)linkedHashSet2)).writer = object2 = new Http2Writer((RealBufferedSink)channel);
                    channel = http2Connection$Builder.source;
                    if (channel != null) {
                        LinkedHashSet linkedHashSet;
                        Http2Connection http2Connection4 = linkedHashSet2;
                        object2 = new Http2Reader((RealBufferedSource)channel);
                        http2Connection4.readerRunnable = object = new Http2Connection$ReaderRunnable((Http2Connection)((Object)linkedHashSet2), (Http2Reader)object2);
                        LinkedHashSet linkedHashSet2 = linkedHashSet;
                        linkedHashSet = new LinkedHashSet();
                        http2Connection4.currentPushRequests = linkedHashSet2;
                        return;
                    }
                    Intrinsics.throwUninitializedPropertyAccessException("source");
                    throw null;
                }
                Intrinsics.throwUninitializedPropertyAccessException("sink");
                throw null;
            }
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            throw null;
        }
        Intrinsics.throwUninitializedPropertyAccessException("connectionName");
        throw null;
    }

    static {
        Settings settings = new Settings();
        settings.set(7, 65535);
        settings.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    public final synchronized Http2Stream getStream(int n) {
        return (Http2Stream)this.streams.get(n);
    }

    public final synchronized Http2Stream removeStream$okhttp(int n) {
        Http2Stream http2Stream = (Http2Stream)this.streams.remove(n);
        this.notifyAll();
        return http2Stream;
    }

    public final synchronized void updateConnectionFlowControl$okhttp(long l) {
        this.readBytesTotal = l = this.readBytesTotal + l;
        if ((l -= this.readBytesAcknowledged) >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            Http2Connection http2Connection = this;
            String string = ExecutableValidationScope$0.m(new StringBuilder(), this.connectionName, "[0] windowUpdate");
            http2Connection.writerQueue.schedule(new Http2Connection$writeWindowUpdateLater$$inlined$execute$default$1(string, this, 0, l), 0L);
            http2Connection.readBytesAcknowledged += l;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void writeData(int n, boolean bl, Buffer buffer, long l) {
        if (l == 0L) {
            this.writer.data(bl, n, buffer, 0);
            return;
        }
        while (l > 0L) {
            long l2;
            long l3;
            // MONITORENTER : this
            while ((l3 = this.writeBytesTotal) >= (l2 = this.writeBytesMaximum)) {
                block14: {
                    if (!this.streams.containsKey(n)) break block14;
                    this.wait();
                    continue;
                }
                throw new IOException("stream closed");
            }
            Http2Connection http2Connection = this;
            int n2 = Math.min((int)Math.min(l, l2 - l3), this.writer.maxFrameSize);
            long l4 = http2Connection.writeBytesTotal;
            l3 = n2;
            http2Connection.writeBytesTotal = l4 + l3;
            l3 = l - l3;
            Http2Writer http2Writer = this.writer;
            boolean bl2 = bl && l3 == 0L;
            http2Writer.data(bl2, n, buffer, n2);
            l = l3;
        }
        return;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {}
        {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(1, 9, null);
    }

    public final synchronized boolean isHealthy(long l) {
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l < this.degradedPongDeadlineNs;
    }

    public final void writeSynResetLater$okhttp(int n, int n2) {
        if (n2 != 0) {
            String string = this.connectionName + '[' + n + "] writeSynReset";
            this.writerQueue.schedule(new Http2Connection$writeSynResetLater$$inlined$execute$default$1(string, this, n, n2), 0L);
            return;
        }
        throw null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown(int n) {
        if (n == 0) {
            throw null;
        }
        Http2Connection http2Connection = this;
        Http2Writer http2Writer = http2Connection.writer;
        synchronized (http2Writer) {
            Throwable throwable2;
            block12: {
                synchronized (http2Connection) {
                }
                {
                    catch (Throwable throwable2) {
                        break block12;
                    }
                    {
                        int n2;
                        Http2Connection http2Connection2;
                        block11: {
                            if (!http2Connection.isShutdown) break block11;
                            {
                                // ** MonitorExit[this] (shouldn't be in output)
                                return;
                            }
                        }
                        try {
                            Http2Writer http2Writer2 = http2Writer;
                            Http2Connection http2Connection3 = this;
                            Http2Connection http2Connection4 = http2Connection3;
                            http2Connection2 = http2Connection3;
                            http2Connection3.isShutdown = true;
                            n2 = http2Connection3.lastGoodStreamId;
                        }
                        catch (Throwable throwable3) {}
                        {
                            // ** MonitorExit[v4] (shouldn't be in output)
                            http2Connection2.writer.goAway(n2, n, Util.EMPTY_BYTE_ARRAY);
                        }
                        // ** MonitorExit[v2] (shouldn't be in output)
                        return;
                        {
                            // ** MonitorExit[this] (shouldn't be in output)
                            throw throwable3;
                        }
                    }
                }
            }
            throw throwable2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close$okhttp(int var1_1, int var2_3, IOException var3_4) {
        if (var1_1 == 0) {
            throw null;
        }
        if (var2_3 == 0) {
            throw null;
        }
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        try {
            this.shutdown(var1_1);
        }
        catch (IOException v0) {}
        v1 = this;
        var1_2 = null;
        synchronized (v1) {
            block19: {
                block20: {
                    block18: {
                        block17: {
                            try {
                                if (v1.streams.isEmpty()) break block17;
                                v2 = this;
                                var1_2 = v2.streams.values().toArray(new Http2Stream[0]);
                                v2.streams.clear();
                            }
                            catch (Throwable v3) {
                                break block18;
                            }
                        }
                        // ** MonitorExit[this] (shouldn't be in output)
                        var1_2 = var1_2;
                        if (var1_2 == null) break block19;
                        var5_6 = var1_2.length;
                        break block20;
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                    throw v3;
                }
                for (var4_5 = 0; var4_5 < var5_6; ++var4_5) {
                    var6_7 = var1_2[var4_5];
                    if (var2_3 == 0) ** GOTO lbl46
                    try {
                        if (!var6_7.closeInternal(var2_3, var3_4)) continue;
                        v4 = var6_7.connection;
                        v5 = v4;
                        var6_8 = var6_7.id;
                        v4.getClass();
                    }
                    catch (IOException v6) {}
                    v5.writer.rstStream(var6_8, var2_3);
                    continue;
lbl46:
                    // 1 sources

                    var6_7.getClass();
                    throw null;
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException v7) {}
            try {
                this.socket.close();
            }
            catch (IOException v8) {}
            v9 = this;
            v9.writerQueue.shutdown();
            v9.pushQueue.shutdown();
            v9.settingsListenerQueue.shutdown();
            return;
        }
    }
}

