/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.connection;

import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.internal.ExecutableValidationScope$0;
import com.apollographql.apollo.relocated.okhttp3.Address;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskQueue;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskRunner;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall$CallReference;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnectionPool$cleanupTask$1;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public final class RealConnectionPool {
    public final long keepAliveDurationNs;
    public final TaskQueue cleanupQueue;
    public final RealConnectionPool$cleanupTask$1 cleanupTask;
    public final ConcurrentLinkedQueue connections;

    public RealConnectionPool(TaskRunner object, TimeUnit timeUnit) {
        RealConnectionPool realConnectionPool = this;
        object.getClass();
        this.keepAliveDurationNs = timeUnit.toNanos(5L);
        realConnectionPool.cleanupQueue = ((TaskRunner)object).newQueue();
        object = ExecutableValidationScope$0.m(new StringBuilder(), Util.okHttpName, " ConnectionPool");
        realConnectionPool.cleanupTask = new RealConnectionPool$cleanupTask$1(this, (String)object);
        realConnectionPool.connections = new ConcurrentLinkedQueue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean callAcquirePooledConnection(Address address, RealCall realCall, List list, boolean bl) {
        Throwable throwable2;
        Iterator iterator2 = ((RealConnectionPool)((Object)iterator2)).connections.iterator();
        while (true) {
            block8: {
                if (!iterator2.hasNext()) {
                    return false;
                }
                RealConnection realConnection = (RealConnection)iterator2.next();
                realConnection.getClass();
                synchronized (realConnection) {
                    if (bl) {
                        try {
                            if (!(realConnection.http2Connection != null)) break block8;
                        }
                        catch (Throwable throwable2) {
                            break;
                        }
                    }
                    if (realConnection.isEligible$okhttp(address, list)) {
                        realCall.acquireConnectionNoEvents(realConnection);
                        return true;
                    }
                }
            }
        }
        {
            throw throwable2;
        }
    }

    public final void put(RealConnection realConnection) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        RealConnectionPool realConnectionPool = this;
        realConnectionPool.connections.add(realConnection);
        realConnectionPool.cleanupQueue.schedule(this.cleanupTask, 0L);
    }

    public final int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        ArrayList arrayList = realConnection.calls;
        int n = 0;
        while (n < arrayList.size()) {
            Reference reference = (Reference)arrayList.get(n);
            if (reference.get() != null) {
                ++n;
                continue;
            }
            reference = (RealCall$CallReference)reference;
            Platform.platform.logCloseableLeak("A connection to " + realConnection.route.address.url + " was leaked. Did you forget to close a response body?", ((RealCall$CallReference)reference).callStackTrace);
            arrayList.remove(n);
            realConnection.noNewExchanges = true;
            if (!arrayList.isEmpty()) continue;
            realConnection.idleAtNs = l - this.keepAliveDurationNs;
            return 0;
        }
        return arrayList.size();
    }
}

