/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.AnnotationSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ClassName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeWriter$Multiset;
import com.apollographql.apollo.relocated.com.squareup.javapoet.LineWrapper;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeVariableName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class CodeWriter {
    public static final String NO_PACKAGE = new String();
    public final String indent;
    public final LineWrapper out;
    public int indentLevel;
    public boolean javadoc;
    public boolean comment;
    public String packageName;
    public final ArrayList typeSpecStack;
    public final LinkedHashSet staticImportClassNames;
    public final Set staticImports;
    public final Set alwaysQualify;
    public final Map importedTypes;
    public final LinkedHashMap importableTypes;
    public final LinkedHashSet referencedNames;
    public final CodeWriter$Multiset currentTypeVariables;
    public boolean trailingNewline;
    public int statementLine;

    public CodeWriter(Appendable object, String string, Map map2, Set set, Set set2) {
        CodeWriter codeWriter = this;
        this.javadoc = false;
        this.comment = false;
        this.packageName = NO_PACKAGE;
        this.typeSpecStack = new ArrayList();
        this.importableTypes = new LinkedHashMap();
        this.referencedNames = new LinkedHashSet();
        this.currentTypeVariables = new CodeWriter$Multiset();
        this.statementLine = -1;
        this.out = new LineWrapper((Appendable)object, string);
        this.indent = (String)Util.checkNotNull(string, "indent == null", new Object[0]);
        this.importedTypes = (Map)Util.checkNotNull(map2, "importedTypes == null", new Object[0]);
        this.staticImports = (Set)Util.checkNotNull(set, "staticImports == null", new Object[0]);
        codeWriter.alwaysQualify = (Set)Util.checkNotNull(set2, "alwaysQualify == null", new Object[0]);
        codeWriter.staticImportClassNames = new LinkedHashSet();
        object = set.iterator();
        while (object.hasNext()) {
            String string2 = string = (String)object.next();
            this.staticImportClassNames.add(string2.substring(0, string2.lastIndexOf(46)));
        }
    }

    public final CodeWriter unindent(int n) {
        boolean bl = ((CodeWriter)((Object)n2)).indentLevel - n >= 0;
        CodeWriter codeWriter = n2;
        CodeWriter codeWriter2 = n2;
        Integer n2 = n;
        Integer n3 = codeWriter2.indentLevel;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = n3;
        Util.checkArgument(bl, "cannot unindent %s from %s", objectArray2);
        codeWriter.indentLevel -= n;
        return codeWriter;
    }

    public final void emitJavadoc(CodeBlock codeBlock) {
        if (codeBlock.formatParts.isEmpty()) {
            return;
        }
        CodeWriter codeWriter = this;
        codeWriter.emitAndIndent("/**\n");
        codeWriter.javadoc = true;
        try {
            codeWriter.emit(codeBlock, true);
        }
        catch (Throwable throwable) {
            this.javadoc = false;
            throw throwable;
        }
        codeWriter.javadoc = false;
        codeWriter.emitAndIndent(" */\n");
    }

    public final void emitAnnotations(List object, boolean bl) {
        object = object.iterator();
        while (object.hasNext()) {
            ((AnnotationSpec)object.next()).emit(this, bl);
            String string = bl ? " " : "\n";
            this.emitAndIndent(string);
        }
    }

    public final void emitModifiers(Set object, Set set) {
        if (!object.isEmpty()) {
            for (Modifier modifier : EnumSet.copyOf(object)) {
                if (set.contains((Object)modifier)) continue;
                CodeWriter codeWriter = this;
                codeWriter.emitAndIndent(modifier.name().toLowerCase(Locale.US));
                codeWriter.emitAndIndent(" ");
            }
        }
    }

    public final void emitTypeVariables(List list) {
        if (list.isEmpty()) {
            return;
        }
        list.forEach(typeVariableName -> this.currentTypeVariables.add(typeVariableName.name));
        this.emitAndIndent("<");
        boolean bl = true;
        for (Object object : list) {
            if (!bl) {
                this.emitAndIndent(", ");
            }
            TypeVariableName typeVariableName2 = object;
            this.emitAnnotations(((TypeName)object).annotations, true);
            object = ((TypeVariableName)object).name;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            this.emit(CodeBlock.of("$L", objectArray2), false);
            bl = true;
            for (TypeName typeName : typeVariableName2.bounds) {
                String string = bl ? " extends $T" : " & $T";
                this.emit(CodeBlock.of(string, typeName), false);
                bl = false;
            }
            bl = false;
        }
        this.emitAndIndent(">");
    }

    public final void popTypeVariables(List list) {
        list.forEach(typeVariableName -> this.currentTypeVariables.remove(typeVariableName.name));
    }

    /*
     * Unable to fully structure code
     */
    public final CodeWriter emit(CodeBlock var1_1, boolean var2_2) {
        var3_3 = 0;
        var4_4 = null;
        var5_5 = var1_1.formatParts.listIterator();
        block36: while (var5_5.hasNext()) {
            var6_6 = (String)var5_5.next();
            var6_6.getClass();
            var7_7 = -1;
            switch (var6_6.hashCode()) {
                default: {
                    break;
                }
                case 1209: {
                    if (!var6_6.equals("$]")) break;
                    var7_7 = 10;
                    break;
                }
                case 1207: {
                    if (!var6_6.equals("$[")) break;
                    var7_7 = 9;
                    break;
                }
                case 1206: {
                    if (!var6_6.equals("$Z")) break;
                    var7_7 = 8;
                    break;
                }
                case 1203: {
                    if (!var6_6.equals("$W")) break;
                    var7_7 = 7;
                    break;
                }
                case 1200: {
                    if (!var6_6.equals("$T")) break;
                    var7_7 = 6;
                    break;
                }
                case 1199: {
                    if (!var6_6.equals("$S")) break;
                    var7_7 = 5;
                    break;
                }
                case 1194: {
                    if (!var6_6.equals("$N")) break;
                    var7_7 = 4;
                    break;
                }
                case 1192: {
                    if (!var6_6.equals("$L")) break;
                    var7_7 = 3;
                    break;
                }
                case 1178: {
                    if (!var6_6.equals("$>")) break;
                    var7_7 = 2;
                    break;
                }
                case 1176: {
                    if (!var6_6.equals("$<")) break;
                    var7_7 = 1;
                    break;
                }
                case 1152: {
                    if (!var6_6.equals("$$")) break;
                    var7_7 = 0;
                }
            }
            switch (var7_7) {
                default: {
                    if (var4_4 == null) ** GOTO lbl81
                    if (!var6_6.startsWith(".")) ** GOTO lbl78
                    var7_8 = var4_4.canonicalName;
                    var8_11 = var6_6.substring(1);
                    if (var8_11.isEmpty() || !Character.isJavaIdentifierStart(var8_11.charAt(0))) ** GOTO lbl78
                    var9_14 = new StringBuilder().append(var7_8).append(".");
                    v0 = new Object[1];
                    var10_16 = v0;
                    v0[0] = var8_11;
                    Util.checkArgument(Character.isJavaIdentifierStart(var8_11.charAt(0)), "not an identifier: %s", var10_16);
                    for (var10_17 = 1; var10_17 <= var8_11.length(); ++var10_17) {
                        if (SourceVersion.isIdentifier(var8_11.substring(0, var10_17))) continue;
                        var10_18 = var8_11.substring(0, var10_17 - 1);
                        ** GOTO lbl72
                    }
                    var10_18 = var8_11;
lbl72:
                    // 2 sources

                    var7_8 = var7_8 + ".*";
                    if (this.staticImports.contains(var9_14.append((String)var10_18).toString()) || this.staticImports.contains(var7_8)) {
                        this.emitAndIndent((String)var8_11);
                        var4_4 = null;
                        continue block36;
                    }
lbl78:
                    // 4 sources

                    var4_4.emit(this);
                    var4_4 = null;
lbl81:
                    // 2 sources

                    this.emitAndIndent((String)var6_6);
                    continue block36;
                }
                case 10: {
                    Util.checkState(this.statementLine != -1, "statement exit $] has no matching statement enter $[", new Object[0]);
                    if (this.statementLine > 0) {
                        this.unindent(2);
                    }
                    this.statementLine = -1;
                    continue block36;
                }
                case 9: {
                    Util.checkState(this.statementLine == -1, "statement enter $[ followed by statement enter $[", new Object[0]);
                    this.statementLine = 0;
                    continue block36;
                }
                case 8: {
                    var6_6 = this.out;
                    var7_7 = this.indentLevel + 2;
                    if (var6_6.column == 0) continue block36;
                    var8_12 = var6_6.nextFlush;
                    if (var8_12 != 0) {
                        var6_6.flush(var8_12);
                    }
                    v1 = var6_6;
                    v1.nextFlush = 3;
                    v1.indentLevel = var7_7;
                    continue block36;
                }
                case 7: {
                    var6_6 = this.out;
                    var7_7 = this.indentLevel + 2;
                    var8_13 = var6_6.nextFlush;
                    if (var8_13 != 0) {
                        var6_6.flush(var8_13);
                    }
                    ++var6_6.column;
                    var6_6.nextFlush = 2;
                    var6_6.indentLevel = var7_7;
                    continue block36;
                }
                case 6: {
                    var6_6 = (TypeName)var1_1.args.get(var3_3++);
                    if (var6_6 instanceof ClassName && var5_5.hasNext() && !((String)var1_1.formatParts.get(var5_5.nextIndex())).startsWith("$")) {
                        var7_9 = (ClassName)var6_6;
                        if (this.staticImportClassNames.contains(var7_9.canonicalName)) {
                            Util.checkState(var4_4 == null, "pending type for static import?!", new Object[0]);
                            var4_4 = var7_9;
                            continue block36;
                        }
                    }
                    var6_6.emit(this);
                    continue block36;
                }
                case 5: {
                    var6_6 = (String)var1_1.args.get(var3_3++);
                    if (var6_6 != null) {
                        var7_10 = this.indent;
                        var8_11 = v2;
                        new StringBuilder(var6_6.length() + 2).append('\"');
                        for (var9_15 = 0; var9_15 < var6_6.length(); ++var9_15) {
                            var10_19 = var6_6.charAt(var9_15);
                            if (var10_19 == '\'') {
                                var8_11.append("'");
                                continue;
                            }
                            if (var10_19 == '\"') {
                                var8_11.append("\\\"");
                                continue;
                            }
                            switch (var10_19) {
                                default: {
                                    if (Character.isISOControl(var10_19)) {
                                        var11_20 = (int)var10_19;
                                        v3 = new Object[1];
                                        var12_21 = v3;
                                        v3[0] = var11_20;
                                        var11_20 = String.format("\\u%04x", var12_21);
                                        break;
                                    }
                                    var11_20 = Character.toString(var10_19);
                                    break;
                                }
                                case '\\': {
                                    var11_20 = "\\\\";
                                    break;
                                }
                                case '\'': {
                                    var11_20 = "\\'";
                                    break;
                                }
                                case '\"': {
                                    var11_20 = "\"";
                                    break;
                                }
                                case '\r': {
                                    var11_20 = "\\r";
                                    break;
                                }
                                case '\f': {
                                    var11_20 = "\\f";
                                    break;
                                }
                                case '\n': {
                                    var11_20 = "\\n";
                                    break;
                                }
                                case '\t': {
                                    var11_20 = "\\t";
                                    break;
                                }
                                case '\b': {
                                    var11_20 = "\\b";
                                }
                            }
                            var8_11.append((String)var11_20);
                            if (var10_19 != '\n' || var9_15 + 1 >= var6_6.length()) continue;
                            var8_11.append("\"\n").append(var7_10).append(var7_10).append("+ \"");
                        }
                        v4 = var8_11;
                        v4.append('\"');
                        var6_6 = v4.toString();
                    } else {
                        var6_6 = "null";
                    }
                    this.emitAndIndent((String)var6_6);
                    continue block36;
                }
                case 4: {
                    this.emitAndIndent((String)var1_1.args.get(var3_3++));
                    continue block36;
                }
                case 3: {
                    var6_6 = var1_1.args.get(var3_3++);
                    if (var6_6 instanceof TypeSpec) {
                        v5 = (TypeSpec)var6_6;
                        var6_6 = Collections.EMPTY_SET;
                        v5.emit(this, null, (Set)var6_6);
                        continue block36;
                    }
                    if (var6_6 instanceof AnnotationSpec) {
                        ((AnnotationSpec)var6_6).emit(this, true);
                        continue block36;
                    }
                    if (var6_6 instanceof CodeBlock) {
                        this.emit((CodeBlock)var6_6, false);
                        continue block36;
                    }
                    this.emitAndIndent(String.valueOf(var6_6));
                    continue block36;
                }
                case 2: {
                    ++this.indentLevel;
                    continue block36;
                }
                case 1: {
                    this.unindent(1);
                    continue block36;
                }
                case 0: 
            }
            this.emitAndIndent("$");
        }
        if (var2_2 && this.out.out.lastChar != '\n') {
            this.emitAndIndent("\n");
            return this;
        }
        return this;
    }

    public final String lookupName(ClassName className) {
        Object object = className.enclosingClassName;
        if (object != null) {
            ClassName className2 = ((ClassName)object).enclosingClassName;
            if (className2 != null) {
                object = className2.topLevelClassName();
            }
        } else {
            object = className;
        }
        if (this.currentTypeVariables.map.getOrDefault(object = ((ClassName)object).simpleName, 0) > 0) {
            return className.canonicalName;
        }
        boolean bl = false;
        ClassName className3 = className;
        while (className3 != null) {
            ClassName className4;
            block19: {
                Object object2;
                String string = className3.simpleName;
                int n = this.typeSpecStack.size() - 1;
                while (true) {
                    object2 = this.typeSpecStack;
                    if (n < 0) break;
                    if (((TypeSpec)((ArrayList)object2).get((int)n)).nestedTypesSimpleNames.contains(string)) {
                        ClassName className5;
                        Object object3;
                        object2 = ClassName.get(this.packageName, ((TypeSpec)this.typeSpecStack.get((int)0)).name, new String[0]);
                        for (int i = 1; i <= n; ++i) {
                            ClassName className6;
                            object3 = ((TypeSpec)this.typeSpecStack.get((int)i)).name;
                            ClassName className7 = className6;
                            className6 = new ClassName(((ClassName)object2).packageName, (ClassName)object2, (String)object3, Collections.EMPTY_LIST);
                            object2 = className7;
                        }
                        className4 = className5;
                        String string2 = ((ClassName)object2).packageName;
                        object3 = Collections.EMPTY_LIST;
                        className5 = new ClassName(string2, (ClassName)object2, string, (List)object3);
                        break block19;
                    }
                    --n;
                }
                if (((ArrayList)object2).size() > 0 && Objects.equals(((TypeSpec)this.typeSpecStack.get((int)0)).name, string)) {
                    className4 = ClassName.get(this.packageName, string, new String[0]);
                } else {
                    className4 = (ClassName)this.importedTypes.get(string);
                    if (className4 == null) {
                        className4 = null;
                    }
                }
            }
            bl = className4 != null;
            if (className4 != null && Objects.equals(className4.canonicalName, className3.canonicalName)) {
                int n = className3.simpleNames().size() - 1;
                return String.join((CharSequence)".", className.simpleNames().subList(n, className.simpleNames().size()));
            }
            className3 = className3.enclosingClassName;
        }
        if (bl) {
            return className.canonicalName;
        }
        if (Objects.equals(this.packageName, className.packageName)) {
            this.referencedNames.add(object);
            return String.join((CharSequence)".", className.simpleNames());
        }
        if (!(this.javadoc || className.packageName.isEmpty() || this.alwaysQualify.contains(className.simpleName))) {
            String string;
            object = className.enclosingClassName;
            if (object != null) {
                ClassName className8 = ((ClassName)object).enclosingClassName;
                if (className8 != null) {
                    object = className8.topLevelClassName();
                }
            } else {
                object = className;
            }
            if ((object = (ClassName)this.importableTypes.put(string = ((ClassName)object).simpleName, object)) != null) {
                this.importableTypes.put(string, object);
            }
        }
        return className.canonicalName;
    }

    public final CodeWriter emitAndIndent(String string) {
        int n = 1;
        for (String string2 : string.split("\\R", -1)) {
            int n2;
            int n3;
            if (n == 0) {
                if ((this.javadoc || this.comment) && this.trailingNewline) {
                    LineWrapper lineWrapper;
                    n3 = 0;
                    while (true) {
                        n2 = this.indentLevel;
                        lineWrapper = this.out;
                        if (n3 >= n2) break;
                        lineWrapper.append(this.indent);
                        ++n3;
                    }
                    String string3 = this.javadoc ? " *" : "//";
                    lineWrapper.append(string3);
                }
                this.out.append("\n");
                this.trailingNewline = true;
                n3 = this.statementLine;
                if (n3 != -1) {
                    if (n3 == 0) {
                        this.indentLevel += 2;
                    }
                    this.statementLine = n3 + 1;
                }
            }
            n3 = 0;
            if (!string2.isEmpty()) {
                if (this.trailingNewline) {
                    for (n2 = 0; n2 < this.indentLevel; ++n2) {
                        this.out.append(this.indent);
                    }
                    if (this.javadoc) {
                        this.out.append(" * ");
                    } else if (this.comment) {
                        this.out.append("// ");
                    }
                }
                this.out.append(string2);
                this.trailingNewline = false;
            }
            n = n3;
        }
        return this;
    }
}

