/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.tls;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    public final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        Intrinsics.checkNotNullParameter(trustRootIndex, "trustRootIndex");
        this.trustRootIndex = trustRootIndex;
    }

    @Override
    public final List clean(List arrayList, String object) {
        ArrayList arrayList2;
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter(arrayList, "chain");
        Intrinsics.checkNotNullParameter(object, "hostname");
        object = arrayDeque;
        arrayDeque = new ArrayDeque(arrayList);
        arrayList = arrayList2;
        arrayList();
        Object e = ((ArrayDeque)object).removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, "queue.removeFirst()");
        arrayList2.add(e);
        boolean bl = false;
        block4: for (int i = 0; i < 9; ++i) {
            ArrayList<Object> arrayList3 = arrayList;
            Object e2 = arrayList3.get(arrayList3.size() - 1);
            Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate x509Certificate = (X509Certificate)e2;
            Object object2 = this.trustRootIndex.findByIssuerAndSignature(x509Certificate);
            if (object2 != null) {
                if (arrayList.size() > 1 || !((Object)x509Certificate).equals(object2)) {
                    arrayList.add(object2);
                }
                if (Intrinsics.areEqual(((X509Certificate)object2).getIssuerDN(), ((X509Certificate)object2).getSubjectDN())) {
                    try {
                        Object object3 = object2;
                        ((Certificate)object3).verify(((Certificate)object3).getPublicKey());
                        return arrayList;
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
                bl = true;
                continue;
            }
            object2 = ((ArrayDeque)object).iterator();
            Intrinsics.checkNotNullExpressionValue(object2, "queue.iterator()");
            while (object2.hasNext()) {
                Object e3 = object2.next();
                Intrinsics.checkNotNull(e3, "null cannot be cast to non-null type java.security.cert.X509Certificate");
                X509Certificate x509Certificate2 = (X509Certificate)e3;
                if (!Intrinsics.areEqual(x509Certificate.getIssuerDN(), x509Certificate2.getSubjectDN())) continue;
                try {
                    x509Certificate.verify(x509Certificate2.getPublicKey());
                    object2.remove();
                    arrayList.add(x509Certificate2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    continue;
                }
                continue block4;
            }
            if (bl) {
                return arrayList;
            }
            throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + x509Certificate);
        }
        throw new SSLPeerUnverifiedException("Certificate chain too long: " + arrayList);
    }

    public final int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof BasicCertificateChainCleaner && Intrinsics.areEqual(((BasicCertificateChainCleaner)object).trustRootIndex, this.trustRootIndex);
    }
}

