/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.connection;

import com.apollographql.apollo.relocated.kotlin.collections.ArraysKt___ArraysKt;
import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.Regex;
import com.apollographql.apollo.relocated.okhttp3.Address;
import com.apollographql.apollo.relocated.okhttp3.Call;
import com.apollographql.apollo.relocated.okhttp3.EventListener;
import com.apollographql.apollo.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo.relocated.okhttp3.Route;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RouteDatabase;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RouteSelector$Selection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public final class RouteSelector {
    public final Address address;
    public final RouteDatabase routeDatabase;
    public final Call call;
    public final EventListener eventListener;
    public final List proxies;
    public int nextProxyIndex;
    public Object inetSocketAddresses;
    public final ArrayList postponedRoutes;

    public RouteSelector(Address list, RouteDatabase object, Call call, EventListener eventListener) {
        RouteSelector routeSelector = this;
        Intrinsics.checkNotNullParameter(object, "routeDatabase");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.address = list;
        this.routeDatabase = object;
        this.call = call;
        routeSelector.eventListener = eventListener;
        object = EmptyList.INSTANCE;
        routeSelector.proxies = object;
        routeSelector.inetSocketAddresses = object;
        routeSelector.postponedRoutes = new ArrayList();
        HttpUrl httpUrl = ((Address)((Object)list)).url;
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        object = httpUrl.uri();
        if (((URI)object).getHost() == null) {
            list = Util.immutableListOf(Proxy.NO_PROXY);
        } else {
            list = ((Address)((Object)list)).proxySelector.select((URI)object);
            if (list != null && !list.isEmpty()) {
                list = Collections.unmodifiableList(new ArrayList(list));
                Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(toMutableList())");
            } else {
                list = Util.immutableListOf(Proxy.NO_PROXY);
            }
        }
        RouteSelector routeSelector2 = this;
        routeSelector2.proxies = list;
        routeSelector2.nextProxyIndex = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RouteSelector$Selection next() {
        ArrayList arrayList;
        if (((RouteSelector)((Object)string)).nextProxyIndex >= ((RouteSelector)((Object)string)).proxies.size() && ((RouteSelector)((Object)string)).postponedRoutes.isEmpty()) {
            throw new NoSuchElementException();
        }
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (((RouteSelector)((Object)string)).nextProxyIndex < ((RouteSelector)((Object)string)).proxies.size()) {
            int n;
            Object object;
            ArrayList<InetSocketAddress> arrayList3;
            if (((RouteSelector)((Object)string)).nextProxyIndex >= ((RouteSelector)((Object)string)).proxies.size()) {
                throw new SocketException("No route to " + ((RouteSelector)((Object)string)).address.url.host + "; exhausted proxy configurations: " + ((RouteSelector)((Object)string)).proxies);
            }
            Proxy proxy = (Proxy)((RouteSelector)((Object)string)).proxies.get(((RouteSelector)((Object)string)).nextProxyIndex++);
            Object object2 = arrayList3;
            arrayList3 = new ArrayList<InetSocketAddress>();
            ((RouteSelector)((Object)string)).inetSocketAddresses = object2;
            if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
                SocketAddress socketAddress = proxy.address();
                if (!(socketAddress instanceof InetSocketAddress)) {
                    String string = "Proxy.address() is not an InetSocketAddress: " + socketAddress.getClass();
                    throw new IllegalArgumentException(string.toString());
                }
                SocketAddress socketAddress2 = socketAddress;
                Intrinsics.checkNotNullExpressionValue(socketAddress2, "proxyAddress");
                socketAddress = (InetSocketAddress)socketAddress2;
                Intrinsics.checkNotNullParameter(socketAddress, "<this>");
                object = ((InetSocketAddress)socketAddress).getAddress();
                if (object == null) {
                    object = ((InetSocketAddress)socketAddress).getHostName();
                    Intrinsics.checkNotNullExpressionValue(object, "hostName");
                } else {
                    object = ((InetAddress)object).getHostAddress();
                    Intrinsics.checkNotNullExpressionValue(object, "address.hostAddress");
                }
                n = ((InetSocketAddress)socketAddress).getPort();
            } else {
                HttpUrl httpUrl = ((RouteSelector)((Object)string)).address.url;
                object = httpUrl.host;
                n = httpUrl.port;
            }
            if (1 <= n && n < 65536) {
                if (proxy.type() == Proxy.Type.SOCKS) {
                    ((ArrayList)object2).add(InetSocketAddress.createUnresolved((String)object, n));
                } else {
                    Object object3;
                    Intrinsics.checkNotNullParameter(object, "<this>");
                    Regex regex = Util.VERIFY_AS_IP_ADDRESS;
                    regex.getClass();
                    if (regex.nativePattern.matcher((CharSequence)object).matches()) {
                        object = Collections.singletonList(InetAddress.getByName((String)object));
                        Intrinsics.checkNotNullExpressionValue(object, "singletonList(...)");
                    } else {
                        ((RouteSelector)((Object)string)).eventListener.getClass();
                        Intrinsics.checkNotNullParameter(((RouteSelector)((Object)string)).call, "call");
                        ((RouteSelector)((Object)string)).address.dns.getClass();
                        try {
                            Object[] objectArray = InetAddress.getAllByName(object);
                            Intrinsics.checkNotNullExpressionValue(objectArray, "getAllByName(hostname)");
                            object3 = ArraysKt___ArraysKt.toList(objectArray);
                        }
                        catch (NullPointerException nullPointerException) {
                            UnknownHostException unknownHostException = new UnknownHostException("Broken system behaviour for dns lookup of ".concat((String)object));
                            unknownHostException.initCause(nullPointerException);
                            throw unknownHostException;
                        }
                        if (object3.isEmpty()) {
                            throw new UnknownHostException(((RouteSelector)((Object)string)).address.dns + " returned no addresses for " + (String)object);
                        }
                        ((RouteSelector)((Object)string)).eventListener.getClass();
                        Intrinsics.checkNotNullParameter(((RouteSelector)((Object)string)).call, "call");
                        object = object3;
                    }
                    object = object.iterator();
                    while (object.hasNext()) {
                        object3 = (InetAddress)object.next();
                        ((ArrayList)object2).add(new InetSocketAddress((InetAddress)object3, n));
                    }
                }
                object2 = ((RouteSelector)((Object)string)).inetSocketAddresses.iterator();
                while (object2.hasNext()) {
                    Route route;
                    Object object4 = (InetSocketAddress)object2.next();
                    object = route;
                    route = new Route(((RouteSelector)((Object)string)).address, proxy, (InetSocketAddress)object4);
                    object4 = ((RouteSelector)((Object)string)).routeDatabase;
                    synchronized (object4) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 5, 22, 7] lbl81 : MonitorExitStatement: MONITOREXIT : var4_8
                        if (((RouteDatabase)object4).failedRoutes.contains(object)) {
                            ((RouteSelector)((Object)string)).postponedRoutes.add(object);
                            continue;
                        }
                    }
                    arrayList2.add(object);
                }
                if (arrayList2.isEmpty()) continue;
                break;
            }
            throw new SocketException("No route to " + (String)object + ':' + n + "; port is out of range");
        }
        if (arrayList2.isEmpty()) {
            CollectionsKt__MutableCollectionsKt.addAll(arrayList2, ((RouteSelector)((Object)string)).postponedRoutes);
            ((RouteSelector)((Object)string)).postponedRoutes.clear();
        }
        return new RouteSelector$Selection(arrayList2);
    }
}

