/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.json.internal;

import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.ApolloParser$$ExternalSyntheticOutline0;
import com.apollographql.apollo.relocated.kotlin.UInt;
import com.apollographql.apollo.relocated.kotlin.ULong;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.UStringsKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.AbstractDecoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.Json;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.AbstractJsonLexer;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.StringJsonLexer;
import com.apollographql.apollo.relocated.kotlinx.serialization.modules.SerialModuleImpl;
import com.apollographql.apollo.relocated.kotlinx.serialization.modules.SerializersModule;

public final class JsonDecoderForUnsignedTypes
extends AbstractDecoder {
    public final StringJsonLexer lexer;
    public final SerialModuleImpl serializersModule;

    public JsonDecoderForUnsignedTypes(StringJsonLexer stringJsonLexer, Json json2) {
        Intrinsics.checkNotNullParameter(json2, "json");
        this.lexer = stringJsonLexer;
        this.serializersModule = json2.serializersModule;
    }

    @Override
    public final SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public final int decodeElementIndex(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        throw new IllegalStateException("unsupported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int decodeInt() {
        StringJsonLexer stringJsonLexer = ((JsonDecoderForUnsignedTypes)((Object)stringJsonLexer)).lexer;
        String string = stringJsonLexer.consumeStringLenient();
        try {
            NumberFormatException numberFormatException;
            Intrinsics.checkNotNullParameter(string, "<this>");
            UInt uInt = UStringsKt.toUIntOrNull(string);
            if (uInt != null) {
                return uInt.data;
            }
            numberFormatException("Invalid number format: '" + string + '\'');
            throw numberFormatException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(stringJsonLexer, ApolloParser$$ExternalSyntheticOutline0.m("Failed to parse type 'UInt' for input '", string, '\''), 0, null, 6);
            throw null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long decodeLong() {
        StringJsonLexer stringJsonLexer = ((JsonDecoderForUnsignedTypes)((Object)stringJsonLexer)).lexer;
        String string = stringJsonLexer.consumeStringLenient();
        try {
            NumberFormatException numberFormatException;
            Intrinsics.checkNotNullParameter(string, "<this>");
            ULong uLong = UStringsKt.toULongOrNull(string);
            if (uLong != null) {
                return uLong.data;
            }
            numberFormatException("Invalid number format: '" + string + '\'');
            throw numberFormatException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(stringJsonLexer, ApolloParser$$ExternalSyntheticOutline0.m("Failed to parse type 'ULong' for input '", string, '\''), 0, null, 6);
            throw null;
        }
    }

    @Override
    public final byte decodeByte() {
        StringJsonLexer stringJsonLexer = ((JsonDecoderForUnsignedTypes)((Object)stringJsonLexer)).lexer;
        String string = stringJsonLexer.consumeStringLenient();
        try {
            return UStringsKt.toUByte(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(stringJsonLexer, ApolloParser$$ExternalSyntheticOutline0.m("Failed to parse type 'UByte' for input '", string, '\''), 0, null, 6);
            throw null;
        }
    }

    @Override
    public final short decodeShort() {
        StringJsonLexer stringJsonLexer = ((JsonDecoderForUnsignedTypes)((Object)stringJsonLexer)).lexer;
        String string = stringJsonLexer.consumeStringLenient();
        try {
            return UStringsKt.toUShort(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(stringJsonLexer, ApolloParser$$ExternalSyntheticOutline0.m("Failed to parse type 'UShort' for input '", string, '\''), 0, null, 6);
            throw null;
        }
    }
}

