/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Hpack;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Reader$ContinuationSource;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Huffman;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Huffman$Node;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.ByteString;
import com.apollographql.apollo.relocated.okio.RealBufferedSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public final class Hpack$Reader {
    public int maxDynamicTableByteCount = 4096;
    public final ArrayList headerList = new ArrayList();
    public final RealBufferedSource source;
    public Header[] dynamicTable;
    public int nextHeaderIndex;
    public int headerCount;
    public int dynamicTableByteCount;

    public Hpack$Reader(Http2Reader$ContinuationSource http2Reader$ContinuationSource) {
        this.source = new RealBufferedSource(http2Reader$ContinuationSource);
        this.dynamicTable = new Header[8];
        this.nextHeaderIndex = 7;
    }

    public final int readInt(int n, int n2) {
        int n3;
        if ((n &= n2) < n2) {
            return n;
        }
        n = 0;
        while (true) {
            RealBufferedSource realBufferedSource = this.source;
            realBufferedSource.require(1L);
            byte by = realBufferedSource.bufferField.readByte();
            n3 = by & 0xFF;
            if ((by & 0x80) == 0) break;
            n2 += (by & 0x7F) << n;
            n += 7;
        }
        return n2 + (n3 << n);
    }

    public final ByteString readByteString() {
        RealBufferedSource realBufferedSource = ((Hpack$Reader)((Object)buffer2)).source;
        realBufferedSource.require(1L);
        byte by = realBufferedSource.bufferField.readByte();
        int n = by & 0xFF;
        long l = ((Hpack$Reader)((Object)buffer2)).readInt(n, 127);
        if ((by & 0x80) == 128) {
            Buffer buffer;
            Hpack$Reader hpack$Reader = buffer2;
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            RealBufferedSource realBufferedSource2 = hpack$Reader.source;
            Intrinsics.checkNotNullParameter(realBufferedSource2, "source");
            Huffman$Node huffman$Node = Huffman.root;
            int n2 = 0;
            int n3 = 0;
            for (long i = 0L; i < l; ++i) {
                int n4 = n2;
                RealBufferedSource realBufferedSource3 = realBufferedSource2;
                realBufferedSource3.require(1L);
                n2 = realBufferedSource3.bufferField.readByte() & 0xFF;
                n2 = n4 << 8 | n2;
                n3 += 8;
                while (n3 >= 8) {
                    int n5 = n2 >>> n3 - 8 & 0xFF;
                    Intrinsics.checkNotNull(huffman$Node.children);
                    huffman$Node = huffman$Node.children[n5];
                    Intrinsics.checkNotNull(huffman$Node);
                    if (huffman$Node.children == null) {
                        Huffman$Node huffman$Node2;
                        buffer2.writeByte(huffman$Node.symbol);
                        int n6 = n3 - huffman$Node.terminalBitCount;
                        huffman$Node = huffman$Node2 = Huffman.root;
                        n3 = n6;
                        continue;
                    }
                    n3 -= 8;
                }
            }
            while (n3 > 0) {
                int n7 = n2 << 8 - n3 & 0xFF;
                Intrinsics.checkNotNull(huffman$Node.children);
                Huffman$Node huffman$Node3 = huffman$Node.children[n7];
                Intrinsics.checkNotNull(huffman$Node3);
                if (huffman$Node3.children != null || huffman$Node3.terminalBitCount > n3) break;
                buffer2.writeByte(huffman$Node3.symbol);
                n3 -= huffman$Node3.terminalBitCount;
                huffman$Node = Huffman.root;
            }
            Buffer buffer3 = buffer2;
            return buffer3.readByteString(buffer3.size);
        }
        RealBufferedSource realBufferedSource4 = ((Hpack$Reader)((Object)buffer2)).source;
        realBufferedSource4.require(l);
        return realBufferedSource4.bufferField.readByteString(l);
    }

    public final int evictToRecoverBytes(int n) {
        int n2 = 0;
        if (n > 0) {
            int n3;
            int n4;
            for (n4 = this.dynamicTable.length - 1; n4 >= (n3 = this.nextHeaderIndex) && n > 0; --n4) {
                Hpack$Reader hpack$Reader = this;
                int n5 = n;
                Header header = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header);
                n = header.hpackSize;
                n3 = n5 - n;
                hpack$Reader.dynamicTableByteCount -= n;
                hpack$Reader.headerCount += -1;
                ++n2;
                n = n3;
            }
            Hpack$Reader hpack$Reader = this;
            int n6 = n3;
            int n7 = n6 + 1;
            n = n6 + 1 + n2;
            n4 = this.headerCount;
            System.arraycopy(hpack$Reader.dynamicTable, n7, hpack$Reader.dynamicTable, n, n4);
            hpack$Reader.nextHeaderIndex += n2;
            return n2;
        }
        return n2;
    }

    public final ByteString getName(int n) {
        if (n >= 0) {
            Header[] headerArray = Hpack.STATIC_HEADER_TABLE;
            if (n <= Hpack.STATIC_HEADER_TABLE.length - 1) {
                return headerArray[n].name;
            }
        }
        int n2 = n - Hpack.STATIC_HEADER_TABLE.length;
        if ((n2 = headerArray.nextHeaderIndex + 1 + n2) >= 0) {
            Header[] headerArray = headerArray.dynamicTable;
            if (n2 < headerArray.dynamicTable.length) {
                Header header = headerArray[n2];
                Intrinsics.checkNotNull(header);
                return header.name;
            }
        }
        throw new IOException("Header index too large " + (n + 1));
    }

    public final void insertIntoDynamicTable(Header header) {
        this.headerList.add(header);
        int n = header.hpackSize;
        int n2 = this.maxDynamicTableByteCount;
        if (n > n2) {
            header = null;
            n = 0;
            Arrays.fill(this.dynamicTable, n, this.dynamicTable.length, header);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
            return;
        }
        this.evictToRecoverBytes(this.dynamicTableByteCount + n - n2);
        Header[] headerArray = this.dynamicTable;
        if (this.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray2 = headerArray;
            headerArray = new Header[headerArray.length * 2];
            int n3 = headerArray2.length;
            int n4 = headerArray.length;
            System.arraycopy(headerArray2, 0, headerArray, n3, n4);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        int n5 = this.nextHeaderIndex;
        this.nextHeaderIndex = n5 + -1;
        this.dynamicTable[n5] = header;
        ++this.headerCount;
        this.dynamicTableByteCount += n;
    }
}

