/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.AnnotationSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ArrayTypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ClassName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeWriter;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ParameterizedTypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName$1;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeVariableName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import com.apollographql.apollo.relocated.com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public class TypeName {
    public static final TypeName VOID = new TypeName("void", new ArrayList());
    public static final TypeName BOOLEAN = new TypeName("boolean", new ArrayList());
    public static final TypeName BYTE = new TypeName("byte", new ArrayList());
    public static final TypeName SHORT = new TypeName("short", new ArrayList());
    public static final TypeName INT = new TypeName("int", new ArrayList());
    public static final TypeName LONG = new TypeName("long", new ArrayList());
    public static final TypeName CHAR = new TypeName("char", new ArrayList());
    public static final TypeName FLOAT = new TypeName("float", new ArrayList());
    public static final TypeName DOUBLE = new TypeName("double", new ArrayList());
    public static final ClassName OBJECT;
    public static final ClassName BOXED_VOID;
    public static final ClassName BOXED_BOOLEAN;
    public static final ClassName BOXED_BYTE;
    public static final ClassName BOXED_SHORT;
    public static final ClassName BOXED_INT;
    public static final ClassName BOXED_LONG;
    public static final ClassName BOXED_CHAR;
    public static final ClassName BOXED_FLOAT;
    public static final ClassName BOXED_DOUBLE;
    public final String keyword;
    public final List annotations;
    public String cachedString;

    public TypeName(String string, List list) {
        TypeName typeName = this;
        typeName.keyword = string;
        typeName.annotations = Collections.unmodifiableList(new ArrayList(list));
    }

    public static TypeName get(TypeMirror typeMirror) {
        return TypeName.get(typeMirror, new LinkedHashMap());
    }

    public static TypeName get(TypeMirror typeMirror, LinkedHashMap linkedHashMap) {
        return (TypeName)typeMirror.accept(new TypeName$1(linkedHashMap), null);
    }

    public static TypeName get(Type type) {
        return TypeName.get(type, new LinkedHashMap());
    }

    public static TypeName get(Type object, LinkedHashMap linkedHashMap) {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            if (object == Void.TYPE) {
                return VOID;
            }
            if (object == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (object == Byte.TYPE) {
                return BYTE;
            }
            if (object == Short.TYPE) {
                return SHORT;
            }
            if (object == Integer.TYPE) {
                return INT;
            }
            if (object == Long.TYPE) {
                return LONG;
            }
            if (object == Character.TYPE) {
                return CHAR;
            }
            if (object == Float.TYPE) {
                return FLOAT;
            }
            if (object == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz.isArray()) {
                return ArrayTypeName.of(TypeName.get(clazz.getComponentType(), linkedHashMap));
            }
            return ClassName.get(clazz);
        }
        if (object instanceof ParameterizedType) {
            return ParameterizedTypeName.get((ParameterizedType)object, linkedHashMap);
        }
        if (object instanceof WildcardType) {
            ArrayList arrayList;
            WildcardTypeName wildcardTypeName;
            ArrayList arrayList2;
            int n;
            ArrayList<TypeName> arrayList3;
            object = (WildcardType)object;
            Object object2 = object.getUpperBounds();
            ArrayList<TypeName> arrayList4 = arrayList3;
            arrayList3 = new ArrayList<TypeName>(((Type[])object2).length);
            int n2 = ((Type[])object2).length;
            for (n = 0; n < n2; ++n) {
                arrayList4.add(TypeName.get(object2[n], linkedHashMap));
            }
            object = object.getLowerBounds();
            object2 = arrayList2;
            arrayList2 = new ArrayList(((Type[])object).length);
            n2 = ((Type[])object).length;
            for (n = 0; n < n2; ++n) {
                ((ArrayList)object2).add(TypeName.get(object[n], linkedHashMap));
            }
            WildcardTypeName wildcardTypeName2 = wildcardTypeName;
            object = arrayList;
            arrayList = new ArrayList();
            wildcardTypeName2(arrayList4, (List)object2, (ArrayList)object);
            return wildcardTypeName2;
        }
        if (object instanceof TypeVariable) {
            Object object3 = (TypeVariableName)linkedHashMap.get(object = (TypeVariable)object);
            if (object3 == null) {
                ArrayList arrayList;
                TypeVariableName typeVariableName;
                ArrayList arrayList5;
                object3 = arrayList5;
                List list = Collections.unmodifiableList(new ArrayList());
                TypeVariableName typeVariableName2 = typeVariableName;
                String string = object.getName();
                ArrayList arrayList6 = arrayList;
                arrayList = new ArrayList();
                typeVariableName = new TypeVariableName(string, list, arrayList6);
                linkedHashMap.put(object, typeVariableName2);
                object = object.getBounds();
                int n = ((Type[])object).length;
                for (int i = 0; i < n; ++i) {
                    ((ArrayList)object3).add(TypeName.get(object[i], linkedHashMap));
                }
                ((ArrayList)object3).remove(OBJECT);
                return typeVariableName2;
            }
            return object3;
        }
        if (object instanceof GenericArrayType) {
            return ArrayTypeName.of(TypeName.get(((GenericArrayType)object).getGenericComponentType(), linkedHashMap));
        }
        throw new IllegalArgumentException("unexpected type: " + object);
    }

    public static ArrayTypeName asArray(TypeName typeName) {
        if (typeName instanceof ArrayTypeName) {
            return (ArrayTypeName)typeName;
        }
        return null;
    }

    static {
        String[] stringArray = new String[]{};
        OBJECT = ClassName.get("java.lang", "Object", stringArray);
        stringArray = new String[]{};
        BOXED_VOID = ClassName.get("java.lang", "Void", stringArray);
        stringArray = new String[]{};
        BOXED_BOOLEAN = ClassName.get("java.lang", "Boolean", stringArray);
        stringArray = new String[]{};
        BOXED_BYTE = ClassName.get("java.lang", "Byte", stringArray);
        stringArray = new String[]{};
        BOXED_SHORT = ClassName.get("java.lang", "Short", stringArray);
        stringArray = new String[]{};
        BOXED_INT = ClassName.get("java.lang", "Integer", stringArray);
        stringArray = new String[]{};
        BOXED_LONG = ClassName.get("java.lang", "Long", stringArray);
        stringArray = new String[]{};
        BOXED_CHAR = ClassName.get("java.lang", "Character", stringArray);
        stringArray = new String[]{};
        BOXED_FLOAT = ClassName.get("java.lang", "Float", stringArray);
        stringArray = new String[]{};
        BOXED_DOUBLE = ClassName.get("java.lang", "Double", stringArray);
    }

    public TypeName annotated(List list) {
        Util.checkNotNull(list, "annotations == null", new Object[0]);
        ArrayList arrayList = new ArrayList(this.annotations);
        arrayList.addAll(list);
        return new TypeName(this.keyword, arrayList);
    }

    public TypeName withoutAnnotations() {
        ArrayList arrayList;
        String string = ((TypeName)((Object)string)).keyword;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        return new TypeName(string, arrayList2);
    }

    public boolean isAnnotated() {
        return this.annotations.isEmpty() ^ true;
    }

    public final boolean isPrimitive() {
        return this.keyword != null && this != VOID;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        CharSequence charSequence = this.cachedString;
        if (charSequence == null) {
            CodeWriter codeWriter;
            TypeName typeName;
            StringBuilder stringBuilder;
            charSequence = stringBuilder;
            try {
                typeName = this;
                ((StringBuilder)charSequence)();
            }
            catch (IOException iOException) {
                throw new AssertionError();
            }
            CodeWriter codeWriter2 = codeWriter;
            codeWriter = new CodeWriter((StringBuilder)charSequence);
            typeName.emit(codeWriter2);
            String string = stringBuilder.toString();
            this.cachedString = string;
            return string;
        }
        return charSequence;
    }

    public CodeWriter emit(CodeWriter codeWriter) {
        if (this.keyword != null) {
            if (this.isAnnotated()) {
                CodeWriter codeWriter2 = codeWriter;
                codeWriter2.emitAndIndent("");
                this.emitAnnotations(codeWriter2);
            }
            return codeWriter.emitAndIndent(this.keyword);
        }
        throw new AssertionError();
    }

    public final void emitAnnotations(CodeWriter codeWriter) {
        Iterator iterator2 = ((TypeName)((Object)iterator2)).annotations.iterator();
        while (iterator2.hasNext()) {
            ((AnnotationSpec)iterator2.next()).emit(codeWriter, true);
            codeWriter.emitAndIndent(" ");
        }
    }
}

