/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Reader;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.RealBufferedSource;
import com.apollographql.apollo.relocated.okio.Source;
import com.apollographql.apollo.relocated.okio.Timeout;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Http2Reader$ContinuationSource
implements Source {
    public final RealBufferedSource source;
    public int length;
    public int flags;
    public int streamId;
    public int left;
    public int padding;

    public Http2Reader$ContinuationSource(RealBufferedSource realBufferedSource) {
        Intrinsics.checkNotNullParameter(realBufferedSource, "source");
        this.source = realBufferedSource;
    }

    @Override
    public final long read(Buffer buffer, long l) {
        int n;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        while ((n = this.left) == 0) {
            int n2;
            int n3;
            Http2Reader$ContinuationSource http2Reader$ContinuationSource = this;
            http2Reader$ContinuationSource.source.skip(this.padding);
            http2Reader$ContinuationSource.padding = 0;
            if ((http2Reader$ContinuationSource.flags & 4) != 0) {
                return -1L;
            }
            Http2Reader$ContinuationSource http2Reader$ContinuationSource2 = this;
            n = http2Reader$ContinuationSource2.streamId;
            RealBufferedSource realBufferedSource = http2Reader$ContinuationSource2.source;
            Intrinsics.checkNotNullParameter(realBufferedSource, "<this>");
            realBufferedSource.require(1L);
            int n4 = (realBufferedSource.bufferField.readByte() & 0xFF) << 16;
            RealBufferedSource realBufferedSource2 = realBufferedSource;
            realBufferedSource2.require(1L);
            int n5 = n4 | (realBufferedSource2.bufferField.readByte() & 0xFF) << 8;
            RealBufferedSource realBufferedSource3 = realBufferedSource;
            realBufferedSource3.require(1L);
            http2Reader$ContinuationSource2.left = n3 = n5 | realBufferedSource3.bufferField.readByte() & 0xFF;
            http2Reader$ContinuationSource2.length = n3;
            RealBufferedSource realBufferedSource4 = http2Reader$ContinuationSource2.source;
            realBufferedSource4.require(1L);
            n3 = realBufferedSource4.bufferField.readByte() & 0xFF;
            RealBufferedSource realBufferedSource5 = http2Reader$ContinuationSource2.source;
            realBufferedSource5.require(1L);
            http2Reader$ContinuationSource2.flags = realBufferedSource5.bufferField.readByte() & 0xFF;
            Logger logger2 = Http2Reader.logger;
            if (logger2.isLoggable(Level.FINE)) {
                Http2Reader$ContinuationSource http2Reader$ContinuationSource3 = this;
                int n6 = http2Reader$ContinuationSource3.streamId;
                int n7 = http2Reader$ContinuationSource3.length;
                int n8 = http2Reader$ContinuationSource3.flags;
                logger2.fine(Http2.frameLog(true, n6, n7, n3, n8));
            }
            RealBufferedSource realBufferedSource6 = this.source;
            realBufferedSource6.require(4L);
            this.streamId = n2 = realBufferedSource6.bufferField.readInt() & Integer.MAX_VALUE;
            if (n3 == 9) {
                if (n2 == n) continue;
                throw new IOException("TYPE_CONTINUATION streamId changed");
            }
            throw new IOException(n3 + " != TYPE_CONTINUATION");
        }
        long l2 = this.source.read(buffer, Math.min(l, (long)n));
        if (l2 == -1L) {
            return -1L;
        }
        this.left -= (int)l2;
        return l2;
    }

    @Override
    public final Timeout timeout() {
        return this.source.source.timeout();
    }

    @Override
    public final void close() {
    }
}

