/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okio;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.BufferedSink;
import com.apollographql.apollo.relocated.okio.ByteString;
import com.apollographql.apollo.relocated.okio.Segment;
import com.apollographql.apollo.relocated.okio.Sink;
import com.apollographql.apollo.relocated.okio.Timeout;
import java.nio.ByteBuffer;

public final class RealBufferedSink
implements BufferedSink {
    public final Sink sink;
    public final Buffer bufferField;
    public boolean closed;

    public RealBufferedSink(Sink sink2) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        bufferedSink.sink = sink2;
        BufferedSink bufferedSink = buffer;
        buffer = new Buffer();
        v1.bufferField = bufferedSink;
    }

    @Override
    public final void write(Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "source");
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.bufferField.write(buffer, l);
            realBufferedSink.emitCompleteSegments();
            return;
        }
        throw new IllegalStateException("closed");
    }

    public final BufferedSink write(ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        if (!bufferedSink.closed) {
            RealBufferedSink realBufferedSink = bufferedSink;
            ByteString byteString2 = byteString;
            BufferedSink bufferedSink = bufferedSink.bufferField;
            byteString2.write$okio((Buffer)bufferedSink, byteString2.getSize$okio());
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public final BufferedSink writeUtf8(String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            String string2 = string;
            realBufferedSink.bufferField.writeUtf8(string2, 0, string2.length());
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public final BufferedSink writeUtf8CodePoint(int n) {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.bufferField.writeUtf8CodePoint(n);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public final int write(ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter(byteBuffer, "source");
        if (!this.closed) {
            int n = this.bufferField.write(byteBuffer);
            this.emitCompleteSegments();
            return n;
        }
        throw new IllegalStateException("closed");
    }

    public final BufferedSink writeByte(int n) {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.bufferField.writeByte(n);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    public final BufferedSink writeInt(int n) {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.bufferField.writeInt(n);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    public final BufferedSink emitCompleteSegments() {
        if (!this.closed) {
            Object object = this.bufferField;
            long l = ((Buffer)object).size;
            if (l == 0L) {
                l = 0L;
            } else {
                Segment segment = ((Buffer)object).head;
                Intrinsics.checkNotNull(segment);
                object = segment.prev;
                Intrinsics.checkNotNull(object);
                int n = ((Segment)object).limit;
                if (n < 8192 && ((Segment)object).owner) {
                    l -= (long)(n - ((Segment)object).pos);
                }
            }
            if (l > 0L) {
                RealBufferedSink realBufferedSink = this;
                realBufferedSink.sink.write(this.bufferField, l);
                return realBufferedSink;
            }
            return this;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public final void flush() {
        if (!this.closed) {
            Buffer buffer = this.bufferField;
            long l = buffer.size;
            if (l > 0L) {
                this.sink.write(buffer, l);
            }
            this.sink.flush();
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public final boolean isOpen() {
        return this.closed ^ true;
    }

    @Override
    public final void close() {
        if (!this.closed) {
            Throwable throwable;
            block9: {
                block8: {
                    throwable = null;
                    Buffer buffer = this.bufferField;
                    long l = buffer.size;
                    if (l <= 0L) break block8;
                    try {
                        this.sink.write(buffer, l);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                try {
                    this.sink.close();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block9;
                    throwable = throwable3;
                }
            }
            this.closed = true;
            if (throwable == null) {
                return;
            }
            throw throwable;
        }
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    public final String toString() {
        return "buffer(" + this.sink + ')';
    }
}

