/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.json.internal;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.ClassReference;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Reflection;
import com.apollographql.apollo.relocated.kotlin.reflect.KClass;
import com.apollographql.apollo.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.SealedClassSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.SerializationStrategy;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.PolymorphicKind;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.PrimitiveKind;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialKind$ENUM;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.StructureKind$CLASS;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.AbstractEncoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.CompositeEncoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.Encoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.AbstractPolymorphicSerializerKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.Platform_commonKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.Json;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonConfiguration;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonElementKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonEncoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.Composer;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonEncodingException;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonExceptionsKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonToStringWriter;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.PolymorphicKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.WriteMode;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.WriteModeKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.modules.SerialModuleImpl;
import com.apollographql.apollo.relocated.kotlinx.serialization.modules.SerializersModule;

public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    public final Composer composer;
    public final Json json;
    public final WriteMode mode;
    public final JsonEncoder[] modeReuseCache;
    public final SerialModuleImpl serializersModule;
    public boolean forceQuoting;
    public String polymorphicDiscriminator;

    public StreamingJsonEncoder(Composer composer, Json object, WriteMode writeMode, JsonEncoder[] jsonEncoderArray) {
        Intrinsics.checkNotNullParameter(composer, "composer");
        Intrinsics.checkNotNullParameter(object, "json");
        this.composer = composer;
        this.json = object;
        this.mode = writeMode;
        this.modeReuseCache = jsonEncoderArray;
        this.serializersModule = ((Json)object).serializersModule;
        int n = writeMode.ordinal();
        if (jsonEncoderArray != null) {
            object = jsonEncoderArray[n];
            if (object == null && object == this) {
                return;
            }
            jsonEncoderArray[n] = this;
            return;
        }
    }

    @Override
    public final SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public final boolean shouldEncodeElementDefault(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        return false;
    }

    @Override
    public final void encodeSerializableValue(SerializationStrategy object, Object object2) {
        block8: {
            Object object3;
            SerializationStrategy serializationStrategy;
            Object object4;
            block10: {
                block9: {
                    SerializationStrategy serializationStrategy2 = object;
                    Intrinsics.checkNotNullParameter(serializationStrategy2, "serializer");
                    if (!(serializationStrategy2 instanceof AbstractPolymorphicSerializer)) break block8;
                    JsonConfiguration cfr_ignored_0 = ((StreamingJsonEncoder)object3).json.configuration;
                    object4 = (AbstractPolymorphicSerializer)object;
                    object = PolymorphicKt.classDiscriminator(object.getDescriptor(), ((StreamingJsonEncoder)object3).json);
                    Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Any");
                    serializationStrategy = ((AbstractPolymorphicSerializer)object4).findPolymorphicSerializerOrNull((AbstractEncoder)object3, object2);
                    if (serializationStrategy == null) {
                        object3 = Reflection.getOrCreateKotlinClass(object2.getClass());
                        object = ((AbstractPolymorphicSerializer)object4).getBaseClass();
                        Intrinsics.checkNotNullParameter(object, "baseClass");
                        object2 = ((ClassReference)object3).getSimpleName();
                        if (object2 == null) {
                            object2 = String.valueOf(object3);
                        }
                        AbstractPolymorphicSerializerKt.throwSubtypeNotRegistered((String)object2, (KClass)object);
                        throw null;
                    }
                    if (!(object4 instanceof SealedClassSerializer)) break block9;
                    SerialDescriptor serialDescriptor = serializationStrategy.getDescriptor();
                    Intrinsics.checkNotNullParameter(serialDescriptor, "<this>");
                    if (Platform_commonKt.cachedSerialNames(serialDescriptor).contains(object)) break block10;
                }
                object4 = serializationStrategy.getDescriptor().getKind();
                Intrinsics.checkNotNullParameter(object4, "kind");
                if (!(object4 instanceof SerialKind$ENUM)) {
                    if (!(object4 instanceof PrimitiveKind)) {
                        if (!(object4 instanceof PolymorphicKind)) {
                            ((StreamingJsonEncoder)object3).polymorphicDiscriminator = object;
                            serializationStrategy.serialize((Encoder)object3, object2);
                            return;
                        }
                        throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself");
                    }
                    throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead");
                }
                throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead");
            }
            object3 = ((SerialDescriptor)((SealedClassSerializer)object4).descriptor$delegate.getValue()).getSerialName();
            object2 = serializationStrategy.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + (String)object2 + "' cannot be serialized as base class '" + (String)object3 + "' because it has property name that conflicts with JSON class discriminator '" + (String)object + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
        object.serialize((Encoder)object3, object2);
    }

    @Override
    public final CompositeEncoder beginStructure(SerialDescriptor object) {
        StreamingJsonEncoder streamingJsonEncoder = composer;
        Intrinsics.checkNotNullParameter(object, "descriptor");
        WriteMode writeMode = WriteModeKt.switchMode(streamingJsonEncoder.json, (SerialDescriptor)object);
        char c = writeMode.begin;
        streamingJsonEncoder.composer.print(c);
        streamingJsonEncoder.composer.indent();
        if (streamingJsonEncoder.polymorphicDiscriminator != null) {
            JsonEncoder[] jsonEncoderArray = object;
            StreamingJsonEncoder streamingJsonEncoder2 = composer;
            streamingJsonEncoder2.composer.nextItem();
            object = streamingJsonEncoder2.polymorphicDiscriminator;
            Intrinsics.checkNotNull(object);
            streamingJsonEncoder2.composer.printQuoted((String)object);
            streamingJsonEncoder2.composer.print(':');
            streamingJsonEncoder2.composer.space();
            object = jsonEncoderArray.getSerialName();
            Intrinsics.checkNotNullParameter(object, "value");
            ((StreamingJsonEncoder)((Object)composer)).composer.printQuoted((String)object);
            ((StreamingJsonEncoder)((Object)composer)).polymorphicDiscriminator = null;
        }
        if (((StreamingJsonEncoder)((Object)composer)).mode == writeMode) {
            return composer;
        }
        object = ((StreamingJsonEncoder)((Object)composer)).modeReuseCache;
        if (((StreamingJsonEncoder)((Object)composer)).modeReuseCache != null && (object = object[writeMode.ordinal()]) != null) {
            return object;
        }
        StreamingJsonEncoder streamingJsonEncoder3 = composer;
        Composer composer = streamingJsonEncoder3.composer;
        object = streamingJsonEncoder3.json;
        JsonEncoder[] jsonEncoderArray = streamingJsonEncoder3.modeReuseCache;
        return new StreamingJsonEncoder(composer, (Json)object, writeMode, jsonEncoderArray);
    }

    @Override
    public final void endStructure(SerialDescriptor serialDescriptor) {
        StreamingJsonEncoder streamingJsonEncoder = this;
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        streamingJsonEncoder.composer.unIndent();
        streamingJsonEncoder.composer.nextItem();
        streamingJsonEncoder.composer.print(this.mode.end);
    }

    @Override
    public final void encodeElement(SerialDescriptor object, int n) {
        Intrinsics.checkNotNullParameter(object, "descriptor");
        int n2 = ((StreamingJsonEncoder)((Object)string)).mode.ordinal();
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    Composer composer = ((StreamingJsonEncoder)((Object)string)).composer;
                    if (!composer.writingFirst) {
                        composer.print(',');
                    }
                    StreamingJsonEncoder streamingJsonEncoder = string;
                    StreamingJsonEncoder streamingJsonEncoder2 = string;
                    streamingJsonEncoder2.composer.nextItem();
                    Intrinsics.checkNotNullParameter(streamingJsonEncoder2.json, "json");
                    Intrinsics.areEqual(object.getKind(), StructureKind$CLASS.INSTANCE);
                    String string = object.getElementName(n);
                    Intrinsics.checkNotNullParameter(string, "value");
                    streamingJsonEncoder.composer.printQuoted(string);
                    streamingJsonEncoder.composer.print(':');
                    streamingJsonEncoder.composer.space();
                } else {
                    if (n == 0) {
                        ((StreamingJsonEncoder)((Object)string)).forceQuoting = true;
                    }
                    if (n == 1) {
                        StreamingJsonEncoder streamingJsonEncoder = string;
                        streamingJsonEncoder.composer.print(',');
                        streamingJsonEncoder.composer.space();
                        streamingJsonEncoder.forceQuoting = false;
                    }
                }
            } else {
                object = ((StreamingJsonEncoder)((Object)string)).composer;
                if (!((Composer)object).writingFirst) {
                    boolean bl;
                    if (n % 2 == 0) {
                        ((Composer)object).print(',');
                        ((StreamingJsonEncoder)((Object)string)).composer.nextItem();
                        bl = true;
                    } else {
                        ((Composer)object).print(':');
                        ((StreamingJsonEncoder)((Object)string)).composer.space();
                        bl = false;
                    }
                    ((StreamingJsonEncoder)((Object)string)).forceQuoting = bl;
                } else {
                    ((StreamingJsonEncoder)((Object)string)).forceQuoting = true;
                    ((Composer)object).nextItem();
                }
            }
        } else {
            object = ((StreamingJsonEncoder)((Object)string)).composer;
            if (!((Composer)object).writingFirst) {
                ((Composer)object).print(',');
            }
            ((StreamingJsonEncoder)((Object)string)).composer.nextItem();
        }
    }

    @Override
    public final void encodeNullableSerializableElement(SerialDescriptor serialDescriptor, int n, KSerializer kSerializer, Object object) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        Intrinsics.checkNotNullParameter(kSerializer, "serializer");
        super.encodeNullableSerializableElement(serialDescriptor, n, kSerializer, object);
    }

    @Override
    public final Encoder encodeInline(SerialDescriptor object) {
        Object object2;
        SerialDescriptor serialDescriptor = object;
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        if (serialDescriptor.isInline() && StreamingJsonEncoderKt.unsignedNumberDescriptors.contains(object)) {
            object = ((StreamingJsonEncoder)object2).composer;
            if (!(object instanceof ComposerForUnsignedNumbers)) {
                ComposerForUnsignedNumbers composerForUnsignedNumbers;
                object = ((Composer)object).writer;
                boolean bl = ((StreamingJsonEncoder)object2).forceQuoting;
                ComposerForUnsignedNumbers composerForUnsignedNumbers2 = composerForUnsignedNumbers;
                composerForUnsignedNumbers = new ComposerForUnsignedNumbers((JsonToStringWriter)object, bl);
                object = composerForUnsignedNumbers2;
            }
            StreamingJsonEncoder streamingJsonEncoder = object2;
            object2 = streamingJsonEncoder.json;
            WriteMode writeMode = streamingJsonEncoder.mode;
            return new StreamingJsonEncoder((Composer)object, (Json)object2, writeMode, null);
        }
        if (object.isInline()) {
            if (object.equals(JsonElementKt.jsonUnquotedLiteralDescriptor)) {
                object = ((StreamingJsonEncoder)object2).composer;
                if (!(object instanceof ComposerForUnquotedLiterals)) {
                    ComposerForUnquotedLiterals composerForUnquotedLiterals;
                    object = ((Composer)object).writer;
                    boolean bl = ((StreamingJsonEncoder)object2).forceQuoting;
                    ComposerForUnquotedLiterals composerForUnquotedLiterals2 = composerForUnquotedLiterals;
                    composerForUnquotedLiterals = new ComposerForUnquotedLiterals((JsonToStringWriter)object, bl);
                    object = composerForUnquotedLiterals2;
                }
                Object object3 = object2;
                object2 = ((StreamingJsonEncoder)object3).json;
                WriteMode writeMode = ((StreamingJsonEncoder)object3).mode;
                return new StreamingJsonEncoder((Composer)object, (Json)object2, writeMode, null);
            }
            return object2;
        }
        return object2;
    }

    @Override
    public final void encodeNull() {
        Composer composer = ((StreamingJsonEncoder)((Object)string)).composer;
        String string = "null";
        composer.getClass();
        composer.writer.write(string);
    }

    @Override
    public final void encodeBoolean(boolean bl) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            StreamingJsonEncoder streamingJsonEncoder = string;
            String string = String.valueOf(bl);
            Intrinsics.checkNotNullParameter(string, "value");
            streamingJsonEncoder.composer.printQuoted(string);
            return;
        }
        ((StreamingJsonEncoder)((Object)string)).composer.writer.write(String.valueOf(bl));
    }

    @Override
    public final void encodeByte(byte by) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            StreamingJsonEncoder streamingJsonEncoder = string;
            String string = String.valueOf(by);
            Intrinsics.checkNotNullParameter(string, "value");
            streamingJsonEncoder.composer.printQuoted(string);
            return;
        }
        ((StreamingJsonEncoder)((Object)string)).composer.print(by);
    }

    @Override
    public final void encodeShort(short s) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            StreamingJsonEncoder streamingJsonEncoder = string;
            String string = String.valueOf(s);
            Intrinsics.checkNotNullParameter(string, "value");
            streamingJsonEncoder.composer.printQuoted(string);
            return;
        }
        ((StreamingJsonEncoder)((Object)string)).composer.print(s);
    }

    @Override
    public final void encodeInt(int n) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            StreamingJsonEncoder streamingJsonEncoder = string;
            String string = String.valueOf(n);
            Intrinsics.checkNotNullParameter(string, "value");
            streamingJsonEncoder.composer.printQuoted(string);
            return;
        }
        ((StreamingJsonEncoder)((Object)string)).composer.print(n);
    }

    @Override
    public final void encodeLong(long l) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            StreamingJsonEncoder streamingJsonEncoder = string;
            String string = String.valueOf(l);
            Intrinsics.checkNotNullParameter(string, "value");
            streamingJsonEncoder.composer.printQuoted(string);
            return;
        }
        ((StreamingJsonEncoder)((Object)string)).composer.print(l);
    }

    @Override
    public final void encodeFloat(float f) {
        if (((StreamingJsonEncoder)((Object)f2)).forceQuoting) {
            String string = String.valueOf(f);
            Intrinsics.checkNotNullParameter(string, "value");
            ((StreamingJsonEncoder)((Object)f2)).composer.printQuoted(string);
        } else {
            ((StreamingJsonEncoder)((Object)f2)).composer.writer.write(String.valueOf(f));
        }
        if (!Float.isInfinite(f) && !Float.isNaN(f)) {
            return;
        }
        StreamingJsonEncoder streamingJsonEncoder = f2;
        Float f2 = Float.valueOf(f);
        String string = streamingJsonEncoder.composer.writer.toString();
        throw new JsonEncodingException("Unexpected special floating-point value " + f2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify(string, -1));
    }

    @Override
    public final void encodeDouble(double d) {
        if (((StreamingJsonEncoder)((Object)d2)).forceQuoting) {
            String string = String.valueOf(d);
            Intrinsics.checkNotNullParameter(string, "value");
            ((StreamingJsonEncoder)((Object)d2)).composer.printQuoted(string);
        } else {
            ((StreamingJsonEncoder)((Object)d2)).composer.writer.write(String.valueOf(d));
        }
        if (!Double.isInfinite(d) && !Double.isNaN(d)) {
            return;
        }
        StreamingJsonEncoder streamingJsonEncoder = d2;
        Double d2 = d;
        String string = streamingJsonEncoder.composer.writer.toString();
        throw new JsonEncodingException("Unexpected special floating-point value " + d2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify(string, -1));
    }

    @Override
    public final void encodeChar(char c) {
        StreamingJsonEncoder streamingJsonEncoder = string;
        String string = String.valueOf(c);
        Intrinsics.checkNotNullParameter(string, "value");
        streamingJsonEncoder.composer.printQuoted(string);
    }

    @Override
    public final void encodeString(String string) {
        Intrinsics.checkNotNullParameter(string, "value");
        this.composer.printQuoted(string);
    }

    @Override
    public final void encodeEnum(SerialDescriptor serialDescriptor, int n) {
        StreamingJsonEncoder streamingJsonEncoder = string;
        Intrinsics.checkNotNullParameter(serialDescriptor, "enumDescriptor");
        String string = serialDescriptor.getElementName(n);
        Intrinsics.checkNotNullParameter(string, "value");
        streamingJsonEncoder.composer.printQuoted(string);
    }
}

