/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.internal;

import com.apollographql.apollo.relocated.kotlin.SynchronizedLazyImpl;
import com.apollographql.apollo.relocated.kotlin.collections.ArraysKt___ArraysKt;
import com.apollographql.apollo.relocated.kotlin.jvm.functions.Function0;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.SerializationException;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.Decoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.Encoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.EnumSerializer$descriptor$2;
import java.util.Arrays;

public final class EnumSerializer
implements KSerializer {
    public final Enum[] values;
    public final SynchronizedLazyImpl descriptor$delegate;

    public EnumSerializer(String string, Enum[] object) {
        SynchronizedLazyImpl synchronizedLazyImpl;
        EnumSerializer$descriptor$2 enumSerializer$descriptor$2;
        ((EnumSerializer)((Object)synchronizedLazyImpl2)).values = object;
        object = enumSerializer$descriptor$2;
        enumSerializer$descriptor$2 = new EnumSerializer$descriptor$2((EnumSerializer)((Object)synchronizedLazyImpl2), string);
        SynchronizedLazyImpl synchronizedLazyImpl2 = synchronizedLazyImpl;
        synchronizedLazyImpl = new SynchronizedLazyImpl((Function0)object);
        v2.descriptor$delegate = synchronizedLazyImpl2;
    }

    @Override
    public final SerialDescriptor getDescriptor() {
        return (SerialDescriptor)this.descriptor$delegate.getValue();
    }

    public final String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + ((SerialDescriptor)this.descriptor$delegate.getValue()).getSerialName() + '>';
    }

    @Override
    public final void serialize(Encoder encoder, Object object) {
        object = (Enum)object;
        Intrinsics.checkNotNullParameter(object, "value");
        int n = ArraysKt___ArraysKt.indexOf(this.values, object);
        if (n != -1) {
            encoder.encodeEnum((SerialDescriptor)this.descriptor$delegate.getValue(), n);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(object).append(" is not a valid enum ").append(((SerialDescriptor)this.descriptor$delegate.getValue()).getSerialName()).append(", must be one of ");
        String string = Arrays.toString(this.values);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        throw new SerializationException(stringBuilder.append(string).toString());
    }

    @Override
    public final Object deserialize(Decoder decoder) {
        int n = decoder.decodeEnum((SerialDescriptor)this.descriptor$delegate.getValue());
        if (n >= 0) {
            Enum[] enumArray = this.values;
            if (n < this.values.length) {
                return enumArray[n];
            }
        }
        throw new SerializationException(n + " is not among valid " + ((SerialDescriptor)this.descriptor$delegate.getValue()).getSerialName() + " enum values, values size is " + this.values.length);
    }
}

