/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.json.internal;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.ClassReference;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Reflection;
import com.apollographql.apollo.relocated.kotlin.reflect.KClass;
import com.apollographql.apollo.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.SealedClassSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.PolymorphicKind;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.PrimitiveKind;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialKind$ENUM;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.AbstractEncoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.CompositeEncoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.Encoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.AbstractPolymorphicSerializerKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.Platform_commonKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.Json;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonConfiguration;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonElementKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.Composer;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.InternalJsonWriter;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonEncodingException;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonExceptionsKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonNamesMapKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonToStringWriter;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.PolymorphicKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.WriteMode;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.WriteModeKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.modules.SerialModuleImpl;

public final class StreamingJsonEncoder
extends AbstractEncoder {
    public final Composer composer;
    public final Json json;
    public final WriteMode mode;
    public final StreamingJsonEncoder[] modeReuseCache;
    public final SerialModuleImpl serializersModule;
    public final JsonConfiguration configuration;
    public boolean forceQuoting;
    public String polymorphicDiscriminator;

    public StreamingJsonEncoder(Composer composer, Json object, WriteMode writeMode, StreamingJsonEncoder[] streamingJsonEncoderArray) {
        StreamingJsonEncoder streamingJsonEncoder = this;
        Intrinsics.checkNotNullParameter(composer, "composer");
        Intrinsics.checkNotNullParameter(object, "json");
        Intrinsics.checkNotNullParameter((Object)writeMode, "mode");
        this.composer = composer;
        this.json = object;
        this.mode = writeMode;
        streamingJsonEncoder.modeReuseCache = streamingJsonEncoderArray;
        streamingJsonEncoder.serializersModule = streamingJsonEncoder.getJson().getSerializersModule();
        streamingJsonEncoder.configuration = streamingJsonEncoder.getJson().getConfiguration();
        int n = writeMode.ordinal();
        if (streamingJsonEncoderArray != null && ((object = streamingJsonEncoderArray[n]) != null || object != this)) {
            streamingJsonEncoderArray[n] = this;
        }
    }

    public final Json getJson() {
        return this.json;
    }

    @Override
    public final SerialModuleImpl getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public final boolean shouldEncodeElementDefault(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        return this.configuration.encodeDefaults;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void encodeSerializableValue(KSerializer object, Object object2) {
        Object object3 = object;
        Intrinsics.checkNotNullParameter(object3, "serializer");
        if (object3 instanceof AbstractPolymorphicSerializer && !((StreamingJsonEncoder)object4).json.configuration.useArrayPolymorphism) {
            Object object4;
            Object object5 = (AbstractPolymorphicSerializer)object;
            object = PolymorphicKt.classDiscriminator(object.getDescriptor(), ((StreamingJsonEncoder)object4).json);
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Any");
            KSerializer kSerializer = ((AbstractPolymorphicSerializer)object5).findPolymorphicSerializerOrNull((Encoder)object4, object2);
            if (kSerializer == null) {
                object4 = Reflection.getOrCreateKotlinClass(object2.getClass());
                object = ((AbstractPolymorphicSerializer)object5).getBaseClass();
                Intrinsics.checkNotNullParameter(object, "baseClass");
                object2 = ((ClassReference)object4).getSimpleName();
                if (object2 == null) {
                    object2 = String.valueOf(object4);
                }
                AbstractPolymorphicSerializerKt.throwSubtypeNotRegistered((String)object2, (KClass)object);
                throw null;
            }
            if (object5 instanceof SealedClassSerializer) {
                SerialDescriptor serialDescriptor = kSerializer.getDescriptor();
                Intrinsics.checkNotNullParameter(serialDescriptor, "<this>");
                if (Platform_commonKt.cachedSerialNames(serialDescriptor).contains(object)) {
                    object4 = object5.getDescriptor().getSerialName();
                    object2 = kSerializer.getDescriptor().getSerialName();
                    throw new IllegalStateException(("Sealed class '" + (String)object2 + "' cannot be serialized as base class '" + (String)object4 + "' because it has property name that conflicts with JSON class discriminator '" + (String)object + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
                }
            }
            object5 = kSerializer.getDescriptor().getKind();
            Intrinsics.checkNotNullParameter(object5, "kind");
            if (object5 instanceof SerialKind$ENUM) throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
            if (object5 instanceof PrimitiveKind) throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
            if (object5 instanceof PolymorphicKind) throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
            ((StreamingJsonEncoder)object4).polymorphicDiscriminator = object;
            kSerializer.serialize((Encoder)object4, object2);
            return;
        }
        object.serialize((Encoder)object4, object2);
    }

    @Override
    public final CompositeEncoder beginStructure(SerialDescriptor object) {
        Intrinsics.checkNotNullParameter(object, "descriptor");
        WriteMode writeMode = WriteModeKt.switchMode((SerialDescriptor)object, ((StreamingJsonEncoder)((Object)composer)).json);
        char c = writeMode.begin;
        if (c != '\u0000') {
            StreamingJsonEncoder streamingJsonEncoder = composer;
            streamingJsonEncoder.composer.print(c);
            streamingJsonEncoder.composer.indent();
        }
        if (((StreamingJsonEncoder)((Object)composer)).polymorphicDiscriminator != null) {
            StreamingJsonEncoder[] streamingJsonEncoderArray = object;
            StreamingJsonEncoder streamingJsonEncoder = composer;
            streamingJsonEncoder.composer.nextItem();
            object = streamingJsonEncoder.polymorphicDiscriminator;
            Intrinsics.checkNotNull(object);
            streamingJsonEncoder.composer.printQuoted((String)object);
            streamingJsonEncoder.composer.print(':');
            streamingJsonEncoder.composer.space();
            ((StreamingJsonEncoder)((Object)composer)).encodeString(streamingJsonEncoderArray.getSerialName());
            ((StreamingJsonEncoder)((Object)composer)).polymorphicDiscriminator = null;
        }
        if (((StreamingJsonEncoder)((Object)composer)).mode == writeMode) {
            return composer;
        }
        object = ((StreamingJsonEncoder)((Object)composer)).modeReuseCache;
        if (((StreamingJsonEncoder)((Object)composer)).modeReuseCache == null || (object = object[writeMode.ordinal()]) == null) {
            StreamingJsonEncoder streamingJsonEncoder;
            object = streamingJsonEncoder;
            StreamingJsonEncoder streamingJsonEncoder2 = composer;
            Composer composer = streamingJsonEncoder2.composer;
            Json json = streamingJsonEncoder2.json;
            StreamingJsonEncoder[] streamingJsonEncoderArray = streamingJsonEncoder2.modeReuseCache;
            streamingJsonEncoder = new StreamingJsonEncoder(composer, json, writeMode, streamingJsonEncoderArray);
        }
        return object;
    }

    @Override
    public final void endStructure(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        if (this.mode.end != '\u0000') {
            StreamingJsonEncoder streamingJsonEncoder = this;
            streamingJsonEncoder.composer.unIndent();
            streamingJsonEncoder.composer.nextItem();
            streamingJsonEncoder.composer.print(this.mode.end);
        }
    }

    @Override
    public final void encodeElement(SerialDescriptor object, int n) {
        Intrinsics.checkNotNullParameter(object, "descriptor");
        int n2 = this.mode.ordinal();
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    Composer composer = this.composer;
                    if (!composer.writingFirst) {
                        composer.print(',');
                    }
                    StreamingJsonEncoder streamingJsonEncoder = this;
                    StreamingJsonEncoder streamingJsonEncoder2 = this;
                    streamingJsonEncoder2.composer.nextItem();
                    Json json = streamingJsonEncoder2.json;
                    Intrinsics.checkNotNullParameter(json, "json");
                    JsonNamesMapKt.namingStrategy((SerialDescriptor)object, json);
                    streamingJsonEncoder.encodeString(object.getElementName(n));
                    streamingJsonEncoder.composer.print(':');
                    streamingJsonEncoder.composer.space();
                } else {
                    if (n == 0) {
                        this.forceQuoting = true;
                    }
                    if (n == 1) {
                        StreamingJsonEncoder streamingJsonEncoder = this;
                        streamingJsonEncoder.composer.print(',');
                        streamingJsonEncoder.composer.space();
                        streamingJsonEncoder.forceQuoting = false;
                    }
                }
            } else {
                object = this.composer;
                if (!((Composer)object).writingFirst) {
                    boolean bl;
                    if (n % 2 == 0) {
                        ((Composer)object).print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        ((Composer)object).print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                } else {
                    this.forceQuoting = true;
                    ((Composer)object).nextItem();
                }
            }
        } else {
            object = this.composer;
            if (!((Composer)object).writingFirst) {
                ((Composer)object).print(',');
            }
            this.composer.nextItem();
        }
    }

    @Override
    public final void encodeNullableSerializableElement(SerialDescriptor serialDescriptor, int n, KSerializer kSerializer, Object object) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        Intrinsics.checkNotNullParameter(kSerializer, "serializer");
        if (object != null || this.configuration.explicitNulls) {
            super.encodeNullableSerializableElement(serialDescriptor, n, kSerializer, object);
        }
    }

    @Override
    public final Encoder encodeInline(SerialDescriptor object) {
        Object object2;
        SerialDescriptor serialDescriptor = object;
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        boolean bl = serialDescriptor.isInline() && StreamingJsonEncoderKt.unsignedNumberDescriptors.contains(object);
        if (bl) {
            StreamingJsonEncoder streamingJsonEncoder;
            Object object3;
            object = ((StreamingJsonEncoder)object2).composer;
            if (!(object instanceof ComposerForUnsignedNumbers)) {
                ComposerForUnsignedNumbers composerForUnsignedNumbers;
                object = ((Composer)object).writer;
                bl = ((StreamingJsonEncoder)object2).forceQuoting;
                object3 = composerForUnsignedNumbers;
                composerForUnsignedNumbers = new ComposerForUnsignedNumbers((InternalJsonWriter)object, bl);
                object = object3;
            }
            StreamingJsonEncoder streamingJsonEncoder2 = object2;
            object2 = streamingJsonEncoder2.json;
            WriteMode writeMode = streamingJsonEncoder2.mode;
            object3 = streamingJsonEncoder;
            streamingJsonEncoder = new StreamingJsonEncoder((Composer)object, (Json)object2, writeMode, null);
            object2 = object3;
        } else if (object.isInline() && Intrinsics.areEqual(object, JsonElementKt.jsonUnquotedLiteralDescriptor)) {
            StreamingJsonEncoder streamingJsonEncoder;
            Object object4;
            object = ((StreamingJsonEncoder)object2).composer;
            if (!(object instanceof ComposerForUnquotedLiterals)) {
                ComposerForUnquotedLiterals composerForUnquotedLiterals;
                object = ((Composer)object).writer;
                bl = ((StreamingJsonEncoder)object2).forceQuoting;
                object4 = composerForUnquotedLiterals;
                composerForUnquotedLiterals = new ComposerForUnquotedLiterals((InternalJsonWriter)object, bl);
                object = object4;
            }
            Object object5 = object2;
            object2 = ((StreamingJsonEncoder)object5).json;
            WriteMode writeMode = ((StreamingJsonEncoder)object5).mode;
            object4 = streamingJsonEncoder;
            streamingJsonEncoder = new StreamingJsonEncoder((Composer)object, (Json)object2, writeMode, null);
            object2 = object4;
        }
        return object2;
    }

    @Override
    public final void encodeNull() {
        Composer composer = ((StreamingJsonEncoder)((Object)string)).composer;
        String string = "null";
        composer.getClass();
        ((JsonToStringWriter)composer.writer).write(string);
    }

    @Override
    public final void encodeBoolean(boolean bl) {
        if (((StreamingJsonEncoder)((Object)internalJsonWriter)).forceQuoting) {
            ((StreamingJsonEncoder)((Object)internalJsonWriter)).encodeString(String.valueOf(bl));
        } else {
            InternalJsonWriter internalJsonWriter = ((StreamingJsonEncoder)((Object)internalJsonWriter)).composer.writer;
            ((JsonToStringWriter)internalJsonWriter).write(String.valueOf(bl));
        }
    }

    @Override
    public final void encodeByte(byte by) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(by));
        } else {
            this.composer.print(by);
        }
    }

    @Override
    public final void encodeShort(short s) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(s));
        } else {
            this.composer.print(s);
        }
    }

    @Override
    public final void encodeInt(int n) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(n));
        } else {
            this.composer.print(n);
        }
    }

    @Override
    public final void encodeLong(long l) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(l));
        } else {
            this.composer.print(l);
        }
    }

    @Override
    public final void encodeFloat(float f) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            ((StreamingJsonEncoder)((Object)string)).encodeString(String.valueOf(f));
        } else {
            InternalJsonWriter internalJsonWriter = ((StreamingJsonEncoder)((Object)string)).composer.writer;
            ((JsonToStringWriter)internalJsonWriter).write(String.valueOf(f));
        }
        if (!((StreamingJsonEncoder)((Object)string)).configuration.allowSpecialFloatingPointValues && !(!Float.isInfinite(f) && !Float.isNaN(f))) {
            Float f2 = Float.valueOf(f);
            String string = ((StreamingJsonEncoder)((Object)string)).composer.writer.toString();
            Intrinsics.checkNotNullParameter(f2, "value");
            throw new JsonEncodingException("Unexpected special floating-point value " + f2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify(string, -1));
        }
    }

    @Override
    public final void encodeDouble(double d) {
        if (((StreamingJsonEncoder)((Object)string)).forceQuoting) {
            ((StreamingJsonEncoder)((Object)string)).encodeString(String.valueOf(d));
        } else {
            InternalJsonWriter internalJsonWriter = ((StreamingJsonEncoder)((Object)string)).composer.writer;
            ((JsonToStringWriter)internalJsonWriter).write(String.valueOf(d));
        }
        if (!((StreamingJsonEncoder)((Object)string)).configuration.allowSpecialFloatingPointValues && !(!Double.isInfinite(d) && !Double.isNaN(d))) {
            Double d2 = d;
            String string = ((StreamingJsonEncoder)((Object)string)).composer.writer.toString();
            Intrinsics.checkNotNullParameter(d2, "value");
            throw new JsonEncodingException("Unexpected special floating-point value " + d2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify(string, -1));
        }
    }

    @Override
    public final void encodeChar(char c) {
        this.encodeString(String.valueOf(c));
    }

    @Override
    public final void encodeString(String string) {
        Intrinsics.checkNotNullParameter(string, "value");
        this.composer.printQuoted(string);
    }

    @Override
    public final void encodeEnum(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "enumDescriptor");
        this.encodeString(serialDescriptor.getElementName(n));
    }
}

