/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.kotlinpoet;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt___StringsJvmKt;
import java.io.Closeable;
import java.util.ArrayList;

public final class LineWrapper
implements Closeable {
    public static final char[] SPECIAL_CHARACTERS;
    public final Appendable out;
    public final String indent;
    public final int columnLimit;
    public boolean closed;
    public final ArrayList segments;
    public int indentLevel;
    public String linePrefix;

    public LineWrapper(Appendable appendable, String string, int n) {
        LineWrapper lineWrapper = this;
        Intrinsics.checkNotNullParameter(string, "indent");
        this.out = appendable;
        this.indent = string;
        lineWrapper.columnLimit = n;
        lineWrapper.segments = CollectionsKt__IterablesKt.mutableListOf("");
        lineWrapper.indentLevel = -1;
        lineWrapper.linePrefix = "";
    }

    static {
        char[] cArray = " \n\u00b7\u2662".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        SPECIAL_CHARACTERS = cArray;
    }

    public final void append(int n, String string, String string2) {
        Intrinsics.checkNotNullParameter(string, "s");
        Intrinsics.checkNotNullParameter(string2, "linePrefix");
        if (this.closed ^ true) {
            int n2 = 0;
            while (n2 < string.length()) {
                StringBuilder stringBuilder;
                char c = string.charAt(n2);
                if (c == '\u2662') {
                    this.indentLevel = n;
                    this.linePrefix = string2;
                    this.segments.add("");
                    ++n2;
                    continue;
                }
                if (c == '\n') {
                    if (this.closed ^ true) {
                        LineWrapper lineWrapper = this;
                        lineWrapper.emitCurrentLine();
                        lineWrapper.out.append("\n");
                        lineWrapper.indentLevel = -1;
                        ++n2;
                        continue;
                    }
                    throw new IllegalStateException("closed".toString());
                }
                if (c != ' ' && c != '\u00b7') {
                    StringBuilder stringBuilder2;
                    char[] cArray = SPECIAL_CHARACTERS;
                    int n3 = StringsKt___StringsJvmKt.indexOfAny(n2, string, false, cArray);
                    if (n3 == -1) {
                        n3 = string.length();
                    }
                    ArrayList arrayList = this.segments;
                    int n4 = arrayList.size() - 1;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder3();
                    StringBuilder stringBuilder4 = stringBuilder2.append((String)arrayList.get(n4));
                    String string3 = string.substring(n2, n3);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    arrayList.set(n4, stringBuilder4.append(string3).toString());
                    n2 = n3;
                    continue;
                }
                ArrayList arrayList = this.segments;
                int n5 = arrayList.size() - 1;
                StringBuilder stringBuilder5 = stringBuilder;
                stringBuilder5();
                arrayList.set(n5, stringBuilder.append((String)arrayList.get(n5)).append(' ').toString());
                ++n2;
            }
            return;
        }
        throw new IllegalStateException("closed".toString());
    }

    @Override
    public final void close() {
        this.emitCurrentLine();
        this.closed = true;
    }

    public final void emitCurrentLine() {
        LineWrapper lineWrapper = this;
        int n = 0;
        int n2 = ((String)lineWrapper.segments.get(0)).length();
        int n3 = lineWrapper.segments.size();
        for (int i = 1; i < n3; ++i) {
            String string = (String)this.segments.get(i);
            ++n2;
            n2 = string.length() + n2;
            if (n2 <= this.columnLimit) continue;
            this.emitSegmentRange(n, i);
            n = string.length();
            n2 = n = this.indent.length() * this.indentLevel + n;
            n = i;
        }
        LineWrapper lineWrapper2 = this;
        lineWrapper2.emitSegmentRange(n, this.segments.size());
        lineWrapper2.segments.clear();
        lineWrapper2.segments.add("");
    }

    public final void emitSegmentRange(int n, int n2) {
        if (n > 0) {
            LineWrapper lineWrapper = this;
            lineWrapper.out.append("\n");
            int n3 = lineWrapper.indentLevel;
            for (int i = 0; i < n3; ++i) {
                this.out.append(this.indent);
            }
            this.out.append(this.linePrefix);
        }
        this.out.append((CharSequence)this.segments.get(n));
        ++n;
        while (n < n2) {
            LineWrapper lineWrapper = this;
            lineWrapper.out.append(" ");
            lineWrapper.out.append((CharSequence)this.segments.get(n));
            ++n;
        }
    }
}

