/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.AnnotationSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ClassName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.FieldSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.FieldSpec$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.MethodSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeSpec$Kind;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeVariableName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class TypeSpec$Builder {
    public final TypeSpec$Kind kind;
    public final String name;
    public final CodeBlock anonymousTypeArguments;
    public final CodeBlock$Builder javadoc = CodeBlock.builder();
    public TypeName superclass = ClassName.OBJECT;
    public final CodeBlock$Builder staticBlock = CodeBlock.builder();
    public final CodeBlock$Builder initializerBlock = CodeBlock.builder();
    public final LinkedHashMap enumConstants = new LinkedHashMap();
    public final ArrayList annotations = new ArrayList();
    public final ArrayList modifiers = new ArrayList();
    public final ArrayList typeVariables = new ArrayList();
    public final ArrayList superinterfaces = new ArrayList();
    public final ArrayList fieldSpecs = new ArrayList();
    public final ArrayList methodSpecs = new ArrayList();
    public final ArrayList typeSpecs = new ArrayList();
    public final ArrayList originatingElements = new ArrayList();
    public final LinkedHashSet alwaysQualifiedNames = new LinkedHashSet();

    public final TypeSpec$Builder addAnnotation(AnnotationSpec annotationSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        Util.checkNotNull(annotationSpec, "annotationSpec == null", new Object[0]);
        typeSpec$Builder.annotations.add(annotationSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addModifiers(Modifier ... modifierArray) {
        TypeSpec$Builder typeSpec$Builder = this;
        Collections.addAll(typeSpec$Builder.modifiers, modifierArray);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addTypeVariable(TypeVariableName typeVariableName) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.typeVariables.add(typeVariableName);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addSuperinterface(TypeName typeName) {
        boolean bl = typeName != null;
        TypeSpec$Builder typeSpec$Builder = this;
        Util.checkArgument(bl, "superinterface == null", new Object[0]);
        typeSpec$Builder.superinterfaces.add(typeName);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addFields(Iterable object) {
        boolean bl = object != null;
        Util.checkArgument(bl, "fieldSpecs == null", new Object[0]);
        object = object.iterator();
        while (object.hasNext()) {
            this.addField((FieldSpec)object.next());
        }
        return this;
    }

    public final TypeSpec$Builder addField(FieldSpec fieldSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.fieldSpecs.add(fieldSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addMethod(MethodSpec methodSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.methodSpecs.add(methodSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addType(TypeSpec typeSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.typeSpecs.add(typeSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec build() {
        Object[] objectArray;
        Object object = this.annotations.iterator();
        while (object.hasNext()) {
            Util.checkNotNull((AnnotationSpec)object.next(), "annotationSpec == null", new Object[0]);
        }
        if (!this.modifiers.isEmpty()) {
            Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
            object = this.modifiers.iterator();
            while (object.hasNext()) {
                Util.checkArgument((Modifier)((Object)object.next()) != null, "modifiers contain null", new Object[0]);
            }
        }
        Object[] objectArray2 = new Object[1];
        object = objectArray2;
        objectArray2[0] = this.name;
        Util.checkArgument(this.kind != TypeSpec$Kind.ENUM || !this.enumConstants.isEmpty(), "at least one enum constant is required for %s", (Object[])object);
        object = this.superinterfaces.iterator();
        while (object.hasNext()) {
            Util.checkArgument((TypeName)object.next() != null, "superinterfaces contains null", new Object[0]);
        }
        if (!this.typeVariables.isEmpty()) {
            Util.checkState(this.anonymousTypeArguments == null, "typevariables are forbidden on anonymous types.", new Object[0]);
            object = this.typeVariables.iterator();
            while (object.hasNext()) {
                Util.checkArgument((TypeVariableName)object.next() != null, "typeVariables contain null", new Object[0]);
            }
        }
        for (Map.Entry entry : this.enumConstants.entrySet()) {
            boolean bl = this.kind == TypeSpec$Kind.ENUM;
            Object[] objectArray3 = new Object[1];
            Object[] objectArray4 = objectArray3;
            objectArray3[0] = this.name;
            Util.checkState(bl, "%s is not enum", objectArray4);
            Util.checkArgument(((TypeSpec)entry.getValue()).anonymousTypeArguments != null, "enum constants must have anonymous type arguments", new Object[0]);
            Object[] objectArray5 = new Object[1];
            Object[] object2 = objectArray5;
            objectArray5[0] = this.name;
            Util.checkArgument(SourceVersion.isName(this.name), "not a valid enum constant: %s", object2);
        }
        for (FieldSpec fieldSpec : this.fieldSpecs) {
            Object object2 = this.kind;
            if (object2 != TypeSpec$Kind.INTERFACE && object2 != TypeSpec$Kind.ANNOTATION) continue;
            FieldSpec fieldSpec2 = fieldSpec;
            Util.requireExactlyOneOf(fieldSpec2.modifiers, Modifier.PUBLIC, Modifier.PRIVATE);
            object2 = EnumSet.of(Modifier.STATIC, Modifier.FINAL);
            Object[] objectArray6 = new Object[4];
            objectArray = objectArray6;
            objectArray[0] = this.kind;
            objectArray[1] = this.name;
            objectArray6[2] = fieldSpec.name;
            objectArray6[3] = object2;
            Util.checkState(fieldSpec2.modifiers.containsAll((Collection<?>)object2), "%s %s.%s requires modifiers %s", objectArray);
        }
        for (MethodSpec methodSpec : this.methodSpecs) {
            Object[] objectArray7;
            Object[] objectArray8 = this.kind;
            objectArray = TypeSpec$Kind.INTERFACE;
            if (this.kind == TypeSpec$Kind.INTERFACE) {
                MethodSpec methodSpec2 = methodSpec;
                Util.requireExactlyOneOf(methodSpec2.modifiers, Modifier.ABSTRACT, Modifier.STATIC, Modifier.DEFAULT);
                Util.requireExactlyOneOf(methodSpec2.modifiers, Modifier.PUBLIC, Modifier.PRIVATE);
            } else if (objectArray8 == TypeSpec$Kind.ANNOTATION) {
                boolean bl = methodSpec.modifiers.equals(TypeSpec$Kind.access$1000((TypeSpec$Kind)objectArray8));
                Object[] objectArray9 = new Object[4];
                objectArray8 = objectArray9;
                objectArray8[0] = objectArray7 = this.kind;
                objectArray8[1] = this.name;
                objectArray8[2] = methodSpec.name;
                objectArray9[3] = TypeSpec$Kind.access$1000((TypeSpec$Kind)this.kind);
                Util.checkState(bl, "%s %s.%s requires modifiers %s", objectArray8);
            }
            objectArray8 = this.kind;
            if (objectArray8 != TypeSpec$Kind.ANNOTATION) {
                Object[] objectArray10 = new Object[3];
                objectArray7 = objectArray10;
                objectArray7[0] = objectArray8;
                objectArray7[1] = this.name;
                objectArray10[2] = methodSpec.name;
                Util.checkState(methodSpec.defaultValue == null, "%s %s.%s cannot have a default value", objectArray7);
            }
            if (this.kind == objectArray) continue;
            Object[] objectArray11 = new Object[3];
            objectArray8 = objectArray11;
            objectArray8[0] = this.kind;
            objectArray8[1] = this.name;
            objectArray11[2] = methodSpec.name;
            Util.checkState(methodSpec.hasModifier(Modifier.DEFAULT) ^ true, "%s %s.%s cannot be default", objectArray8);
        }
        for (TypeSpec typeSpec : this.typeSpecs) {
            Object[] objectArray12 = new Object[4];
            Object[] objectArray13 = objectArray12;
            objectArray13[0] = objectArray = this.kind;
            objectArray13[1] = this.name;
            objectArray13[2] = typeSpec.name;
            objectArray12[3] = TypeSpec$Kind.access$1100((TypeSpec$Kind)objectArray);
            Util.checkArgument(typeSpec.modifiers.containsAll(TypeSpec$Kind.access$1100(this.kind)), "%s %s.%s requires modifiers %s", objectArray13);
        }
        int n = !this.modifiers.contains((Object)Modifier.ABSTRACT) && this.kind == TypeSpec$Kind.CLASS ? 0 : 1;
        for (MethodSpec methodSpec : this.methodSpecs) {
            Object[] objectArray14 = new Object[2];
            objectArray = objectArray14;
            objectArray[0] = this.name;
            objectArray14[1] = methodSpec.name;
            Util.checkArgument(n != 0 || !methodSpec.hasModifier(Modifier.ABSTRACT), "non-abstract type %s cannot declare abstract method %s", objectArray);
        }
        n = this.superinterfaces.size() + (this.superclass.equals(ClassName.OBJECT) ^ 1);
        Util.checkArgument(this.anonymousTypeArguments == null || n <= 1, "anonymous type has too many supertypes", new Object[0]);
        return new TypeSpec(this, 0);
    }

    public final TypeSpec$Builder addJavadoc(Object ... objectArray) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.javadoc.add("$L", objectArray);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder superclass(ClassName className) {
        boolean bl = this.kind == TypeSpec$Kind.CLASS;
        Util.checkState(bl, "only classes have super classes, not " + (Object)((Object)this.kind), new Object[0]);
        bl = this.superclass == ClassName.OBJECT;
        ClassName className2 = className;
        Util.checkState(bl, "superclass already set to " + this.superclass, new Object[0]);
        Util.checkArgument(className2.isPrimitive() ^ true, "superclass may not be a primitive", new Object[0]);
        this.superclass = className2;
        return this;
    }

    public final TypeSpec$Builder addSuperinterfaces(ArrayList object) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            this.addSuperinterface((TypeName)object.next());
        }
        return this;
    }

    public final TypeSpec$Builder addEnumConstant() {
        TypeSpec$Builder typeSpec$Builder = string;
        String string = "INSTANCE";
        Object object = CodeBlock.of("", new Object[0]);
        object = new TypeSpec$Builder(TypeSpec$Kind.CLASS, null, (CodeBlock)object).build();
        typeSpec$Builder.enumConstants.put(string, object);
        return typeSpec$Builder;
    }

    public final void addEnumConstant(String string, TypeSpec typeSpec) {
        this.enumConstants.put(string, typeSpec);
    }

    public final TypeSpec$Builder addField(ClassName object, Modifier ... modifierArray) {
        FieldSpec fieldSpec;
        TypeSpec$Builder typeSpec$Builder = fieldSpec$Builder;
        FieldSpec$Builder fieldSpec$Builder = FieldSpec.builder((TypeName)object, "customScalarAdapters", modifierArray);
        object = fieldSpec;
        fieldSpec = new FieldSpec(fieldSpec$Builder);
        typeSpec$Builder.fieldSpecs.add(object);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addMethods(List object) {
        boolean bl = object != null;
        Util.checkArgument(bl, "methodSpecs == null", new Object[0]);
        object = object.iterator();
        while (object.hasNext()) {
            MethodSpec methodSpec = (MethodSpec)object.next();
            this.methodSpecs.add(methodSpec);
        }
        return this;
    }

    public final TypeSpec$Builder addTypes(List object) {
        boolean bl = object != null;
        Util.checkArgument(bl, "typeSpecs == null", new Object[0]);
        object = object.iterator();
        while (object.hasNext()) {
            TypeSpec typeSpec = (TypeSpec)object.next();
            this.typeSpecs.add(typeSpec);
        }
        return this;
    }

    public TypeSpec$Builder(TypeSpec$Kind typeSpec$Kind, String string, CodeBlock codeBlock) {
        boolean bl = string == null || SourceVersion.isName(string);
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        Util.checkArgument(bl, "not a valid name: %s", objectArray3);
        objectArray.kind = typeSpec$Kind;
        objectArray.name = string;
        objectArray3.anonymousTypeArguments = codeBlock;
    }

    public static /* synthetic */ TypeSpec$Kind access$000(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.kind;
    }

    public static /* synthetic */ String access$100(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.name;
    }

    public static /* synthetic */ CodeBlock access$200(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.anonymousTypeArguments;
    }

    public static /* synthetic */ CodeBlock$Builder access$300(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.javadoc;
    }

    public static /* synthetic */ TypeName access$400(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.superclass;
    }

    public static /* synthetic */ CodeBlock$Builder access$500(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.staticBlock;
    }

    public static /* synthetic */ CodeBlock$Builder access$600(TypeSpec$Builder typeSpec$Builder) {
        return typeSpec$Builder.initializerBlock;
    }
}

