/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt;
import com.apollographql.apollo.relocated.kotlin.comparisons.NaturalOrderComparator;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.CipherSuite;
import com.apollographql.apollo.relocated.okhttp3.CipherSuite$Companion$ORDER_BY_NAME$1;
import com.apollographql.apollo.relocated.okhttp3.ConnectionSpec$Builder;
import com.apollographql.apollo.relocated.okhttp3.TlsVersion;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    public static final ConnectionSpec MODERN_TLS;
    public static final ConnectionSpec CLEARTEXT;
    public final boolean isTls;
    public final boolean supportsTlsExtensions;
    public final String[] cipherSuitesAsString;
    public final String[] tlsVersionsAsString;

    public ConnectionSpec(boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        this.isTls = bl;
        this.supportsTlsExtensions = bl2;
        this.cipherSuitesAsString = stringArray;
        this.tlsVersionsAsString = stringArray2;
    }

    public static final /* synthetic */ String[] access$getCipherSuitesAsString$p(ConnectionSpec connectionSpec) {
        return connectionSpec.cipherSuitesAsString;
    }

    public static final /* synthetic */ String[] access$getTlsVersionsAsString$p(ConnectionSpec connectionSpec) {
        return connectionSpec.tlsVersionsAsString;
    }

    static {
        CipherSuite cipherSuite;
        CipherSuite cipherSuite2;
        CipherSuite cipherSuite3;
        CipherSuite cipherSuite4;
        CipherSuite cipherSuite5;
        CipherSuite cipherSuite6;
        CipherSuite cipherSuite7;
        Object object;
        CipherSuite[] cipherSuiteArray = new CipherSuite[9];
        Object object2 = cipherSuiteArray;
        cipherSuiteArray[0] = object = CipherSuite.TLS_AES_128_GCM_SHA256;
        Object object3 = CipherSuite.TLS_AES_256_GCM_SHA384;
        cipherSuiteArray[1] = object3;
        cipherSuiteArray[2] = cipherSuite7 = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        cipherSuiteArray[3] = cipherSuite6 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray[4] = cipherSuite5 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray[5] = cipherSuite4 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray[6] = cipherSuite3 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray[7] = cipherSuite2 = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        cipherSuiteArray[8] = cipherSuite = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        int n = 16;
        CipherSuite[] cipherSuiteArray2 = new CipherSuite[16];
        CipherSuite[] cipherSuiteArray3 = cipherSuiteArray2;
        cipherSuiteArray2[0] = object;
        cipherSuiteArray2[1] = object3;
        cipherSuiteArray2[2] = cipherSuite7;
        cipherSuiteArray2[3] = cipherSuite6;
        cipherSuiteArray2[4] = cipherSuite5;
        cipherSuiteArray2[5] = cipherSuite4;
        cipherSuiteArray2[6] = cipherSuite3;
        cipherSuiteArray2[7] = cipherSuite2;
        cipherSuiteArray2[8] = cipherSuite;
        cipherSuiteArray2[9] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray2[10] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray2[11] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray2[12] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray2[13] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray2[14] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray2[15] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        ConnectionSpec$Builder connectionSpec$Builder = new ConnectionSpec$Builder().cipherSuites(Arrays.copyOf(object2, 9));
        TlsVersion[] tlsVersionArray = new TlsVersion[2];
        tlsVersionArray[0] = object2 = TlsVersion.TLS_1_3;
        object = TlsVersion.TLS_1_2;
        tlsVersionArray[1] = object;
        object3 = connectionSpec$Builder.tlsVersions(tlsVersionArray);
        boolean bl = true;
        if (object3.tls) {
            ConnectionSpec$Builder connectionSpec$Builder2;
            object3.supportsTlsExtensions = bl;
            object3 = connectionSpec$Builder2;
            object3();
            object3 = connectionSpec$Builder2.cipherSuites(Arrays.copyOf(cipherSuiteArray3, n)).tlsVersions(new TlsVersion[]{object2, object});
            bl = true;
            boolean bl2 = object3.tls;
            if (bl2) {
                ConnectionSpec$Builder connectionSpec$Builder3;
                object3.supportsTlsExtensions = bl;
                object3 = object3.cipherSuites;
                String[] stringArray = object3.tlsVersions;
                MODERN_TLS = new ConnectionSpec(bl2, bl, (String[])object3, stringArray);
                object3 = connectionSpec$Builder3;
                object3();
                object2 = connectionSpec$Builder3.cipherSuites(Arrays.copyOf(cipherSuiteArray3, n)).tlsVersions(new TlsVersion[]{object2, object, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0});
                boolean bl3 = true;
                if (object2.tls) {
                    object2.supportsTlsExtensions = bl3;
                    CLEARTEXT = new ConnectionSpec(false, false, null, null);
                    return;
                }
                throw new IllegalArgumentException("no TLS extensions for cleartext connections".toString());
            }
            throw new IllegalArgumentException("no TLS extensions for cleartext connections".toString());
        }
        throw new IllegalArgumentException("no TLS extensions for cleartext connections".toString());
    }

    public final boolean isTls() {
        return this.isTls;
    }

    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    public final List tlsVersions() {
        List list;
        block14: {
            ArrayList<String> arrayList;
            block13: {
                String[] stringArray = stringArray.tlsVersionsAsString;
                if (stringArray.tlsVersionsAsString != null) break block13;
                list = null;
                break block14;
            }
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(stringArray.length);
            for (Object object : stringArray) {
                block17: {
                    block18: {
                        block15: {
                            block16: {
                                Intrinsics.checkNotNullParameter(object, "javaName");
                                int n = object.hashCode();
                                if (n == 79201641) break block15;
                                if (n == 79923350) break block16;
                                switch (n) {
                                    default: {
                                        break block17;
                                    }
                                    case -503070501: {
                                        if (object.equals("TLSv1.3")) {
                                            object = TlsVersion.TLS_1_3;
                                            break;
                                        }
                                        break block17;
                                    }
                                    case -503070502: {
                                        if (object.equals("TLSv1.2")) {
                                            object = TlsVersion.TLS_1_2;
                                            break;
                                        }
                                        break block17;
                                    }
                                    case -503070503: {
                                        if (object.equals("TLSv1.1")) {
                                            object = TlsVersion.TLS_1_1;
                                            break;
                                        }
                                        break block17;
                                    }
                                }
                                break block18;
                            }
                            if (!object.equals("TLSv1")) break block17;
                            object = TlsVersion.TLS_1_0;
                            break block18;
                        }
                        if (!object.equals("SSLv3")) break block17;
                        object = TlsVersion.SSL_3_0;
                    }
                    arrayList2.add((String)object);
                    continue;
                }
                throw new IllegalArgumentException(Intrinsics.stringPlus(object, "Unexpected TLS version: "));
            }
            list = CollectionsKt.toList(arrayList2);
        }
        return list;
    }

    public final void apply$okhttp(SSLSocket sSLSocket, boolean bl) {
        List<CipherSuite> list;
        ConnectionSpec connectionSpec;
        ConnectionSpec$Builder connectionSpec$Builder;
        int n;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        block12: {
            if (((ConnectionSpec)((Object)connectionSpec$Builder3)).cipherSuitesAsString != null) {
                String[] stringArray4 = sSLSocket.getEnabledCipherSuites();
                Intrinsics.checkNotNullExpressionValue(stringArray4, "sslSocket.enabledCipherSuites");
                stringArray3 = Util.intersect(stringArray4, ((ConnectionSpec)((Object)connectionSpec$Builder3)).cipherSuitesAsString, CipherSuite.ORDER_BY_NAME);
            } else {
                stringArray3 = sSLSocket.getEnabledCipherSuites();
            }
            if (((ConnectionSpec)((Object)connectionSpec$Builder3)).tlsVersionsAsString != null) {
                String[] stringArray5 = sSLSocket.getEnabledProtocols();
                Intrinsics.checkNotNullExpressionValue(stringArray5, "sslSocket.enabledProtocols");
                stringArray2 = Util.intersect(stringArray5, ((ConnectionSpec)((Object)connectionSpec$Builder3)).tlsVersionsAsString, NaturalOrderComparator.INSTANCE);
            } else {
                stringArray2 = sSLSocket.getEnabledProtocols();
            }
            stringArray = sSLSocket.getSupportedCipherSuites();
            Intrinsics.checkNotNullExpressionValue(stringArray, "supportedCipherSuites");
            String string = "TLS_FALLBACK_SCSV";
            CipherSuite$Companion$ORDER_BY_NAME$1 cipherSuite$Companion$ORDER_BY_NAME$1 = CipherSuite.ORDER_BY_NAME;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                if (!(cipherSuite$Companion$ORDER_BY_NAME$1.compare(stringArray[n], string) == 0)) {
                    continue;
                }
                break block12;
            }
            n = -1;
        }
        if (bl && n != -1) {
            Intrinsics.checkNotNullExpressionValue(stringArray3, "cipherSuitesIntersection");
            String string = stringArray[n];
            Intrinsics.checkNotNullExpressionValue(string, "supportedCipherSuites[indexOfFallbackScsv]");
            String[] stringArray6 = Arrays.copyOf(stringArray3, stringArray3.length + 1);
            Intrinsics.checkNotNullExpressionValue(stringArray6, "copyOf(this, newSize)");
            stringArray3 = stringArray6;
            stringArray6[stringArray6.length - 1] = string;
        }
        Object object = connectionSpec$Builder;
        ((ConnectionSpec$Builder)object)((ConnectionSpec)((Object)connectionSpec$Builder3));
        Intrinsics.checkNotNullExpressionValue(stringArray3, "cipherSuitesIntersection");
        ConnectionSpec$Builder connectionSpec$Builder2 = connectionSpec$Builder.cipherSuites(Arrays.copyOf(stringArray3, stringArray3.length));
        Intrinsics.checkNotNullExpressionValue(stringArray2, "tlsVersionsIntersection");
        ConnectionSpec$Builder connectionSpec$Builder3 = connectionSpec$Builder2.tlsVersions(Arrays.copyOf(stringArray2, stringArray2.length));
        object = connectionSpec;
        ConnectionSpec$Builder connectionSpec$Builder4 = connectionSpec$Builder3;
        boolean bl2 = connectionSpec$Builder4.tls;
        int n3 = connectionSpec$Builder4.supportsTlsExtensions;
        stringArray2 = connectionSpec$Builder4.cipherSuites;
        stringArray = connectionSpec$Builder4.tlsVersions;
        if (new ConnectionSpec(bl2, n3 != 0, stringArray2, stringArray).tlsVersions() != null) {
            sSLSocket.setEnabledProtocols(stringArray);
        }
        if (stringArray2 == null) {
            list = null;
        } else {
            ArrayList<CipherSuite> arrayList;
            list = arrayList;
            arrayList = new ArrayList<CipherSuite>(stringArray2.length);
            int n4 = stringArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                list.add(CipherSuite.Companion.forJavaName(stringArray2[n3]));
            }
            list = CollectionsKt.toList(list);
        }
        if (list != null) {
            sSLSocket.setEnabledCipherSuites(((ConnectionSpec)object).cipherSuitesAsString);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        boolean bl = this.isTls;
        object = (ConnectionSpec)object;
        if (bl != ((ConnectionSpec)object).isTls) {
            return false;
        }
        if (bl) {
            if (!Arrays.equals(this.cipherSuitesAsString, ((ConnectionSpec)object).cipherSuitesAsString)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersionsAsString, ((ConnectionSpec)object).tlsVersionsAsString)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n = 17;
        if (this.isTls) {
            n = 527;
            Object[] objectArray = this.cipherSuitesAsString;
            int n2 = this.cipherSuitesAsString == null ? 0 : Arrays.hashCode(objectArray);
            n = (n + n2) * 31;
            Object[] objectArray2 = this.tlsVersionsAsString;
            int n3 = this.tlsVersionsAsString == null ? 0 : Arrays.hashCode(objectArray2);
            n = (n + n3) * 31 + (this.supportsTlsExtensions ^ 1);
        }
        return n;
    }

    public final String toString() {
        StringBuilder stringBuilder;
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("ConnectionSpec(cipherSuites=");
        Object object = this.cipherSuitesAsString;
        if (this.cipherSuitesAsString == null) {
            object = null;
        } else {
            ArrayList<CipherSuite> arrayList;
            ArrayList<CipherSuite> arrayList2 = arrayList;
            arrayList = new ArrayList<CipherSuite>(((String[])object).length);
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(CipherSuite.Companion.forJavaName(object[i]));
            }
            object = CollectionsKt.toList(arrayList2);
        }
        return stringBuilder2.append((Object)Objects.toString(object, "[all enabled]")).append(", tlsVersions=").append((Object)Objects.toString(this.tlsVersions(), "[all enabled]")).append(", supportsTlsExtensions=").append(this.supportsTlsExtensions).append(')').toString();
    }
}

