/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.CipherSuite;
import com.apollographql.apollo.relocated.okhttp3.ConnectionSpec;
import com.apollographql.apollo.relocated.okhttp3.TlsVersion;
import java.util.ArrayList;
import java.util.Arrays;

public final class ConnectionSpec$Builder {
    public final boolean tls;
    public String[] cipherSuites;
    public String[] tlsVersions;
    public boolean supportsTlsExtensions;

    public ConnectionSpec$Builder() {
        this.tls = true;
    }

    public ConnectionSpec$Builder(ConnectionSpec connectionSpec) {
        Intrinsics.checkNotNullParameter(connectionSpec, "connectionSpec");
        this.tls = connectionSpec.isTls();
        this.cipherSuites = ConnectionSpec.access$getCipherSuitesAsString$p(connectionSpec);
        this.tlsVersions = ConnectionSpec.access$getTlsVersionsAsString$p(connectionSpec);
        this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions();
    }

    public final ConnectionSpec$Builder cipherSuites(CipherSuite ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "cipherSuites");
        if (this.tls) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(objectArray[i].javaName);
            }
            objectArray = arrayList2.toArray(new String[0]);
            if (objectArray != null) {
                String[] stringArray = (String[])objectArray;
                return this.cipherSuites(Arrays.copyOf(stringArray, stringArray.length));
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder cipherSuites(String ... stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "cipherSuites");
        if (this.tls) {
            boolean bl = stringArray.length == 0;
            if (bl ^ true) {
                this.cipherSuites = (String[])stringArray.clone();
                return this;
            }
            throw new IllegalArgumentException("At least one cipher suite is required".toString());
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder tlsVersions(TlsVersion ... objectArray) {
        if (this.tls) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(objectArray[i].javaName);
            }
            objectArray = arrayList2.toArray(new String[0]);
            if (objectArray != null) {
                String[] stringArray = (String[])objectArray;
                return this.tlsVersions(Arrays.copyOf(stringArray, stringArray.length));
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections".toString());
    }

    public final ConnectionSpec$Builder tlsVersions(String ... stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "tlsVersions");
        if (this.tls) {
            boolean bl = stringArray.length == 0;
            if (bl ^ true) {
                this.tlsVersions = (String[])stringArray.clone();
                return this;
            }
            throw new IllegalArgumentException("At least one TLS version is required".toString());
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections".toString());
    }
}

