/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.internal;

import com.apollographql.apollo.relocated.kotlin.collections.ArraysKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.Regex;
import java.util.regex.Pattern;
import kotlin.Metadata;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\r\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"JAVA_RESERVED_WORDS", "", "", "[Ljava/lang/String;", "TYPE_REGEX", "Lkotlin/text/Regex;", "COMPANION_REGEX", "KOTLIN_ENUM_RESERVED_WORDS_REGEX", "escapeJavaReservedWord", "escapeKotlinReservedWord", "escapeTypeReservedWord", "escapeCompanionReservedWord", "escapeKotlinReservedWordInEnum", "escapeKotlinReservedWordInSealedClass", "apollo-compiler"})
public final class ReservedKeywordsKt {
    private static final String[] JAVA_RESERVED_WORDS;
    private static final Regex TYPE_REGEX;
    private static final Regex COMPANION_REGEX;
    private static final Regex KOTLIN_ENUM_RESERVED_WORDS_REGEX;

    public static final String escapeJavaReservedWord(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        if (ArraysKt.contains(JAVA_RESERVED_WORDS, string)) {
            string = string.concat("_");
        }
        return string;
    }

    public static final String escapeKotlinReservedWord(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        return string2;
    }

    public static final String escapeTypeReservedWord(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Regex regex = TYPE_REGEX;
        regex.getClass();
        return regex.nativePattern.matcher(string).matches() ? string.concat("_") : null;
    }

    private static final String escapeCompanionReservedWord(String string) {
        return COMPANION_REGEX.matches(string) ? string + '_' : null;
    }

    public static final String escapeKotlinReservedWordInEnum(String string) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "<this>");
        Regex regex = KOTLIN_ENUM_RESERVED_WORDS_REGEX;
        regex.getClass();
        string = regex.nativePattern.matcher(string).matches() ? string.concat("_") : ((string2 = ReservedKeywordsKt.escapeTypeReservedWord(string)) == null && (string2 = ReservedKeywordsKt.escapeCompanionReservedWord(string)) == null ? ReservedKeywordsKt.escapeKotlinReservedWord(string) : string2);
        return string;
    }

    public static final String escapeKotlinReservedWordInSealedClass(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        String string3 = ReservedKeywordsKt.escapeTypeReservedWord(string2);
        if (string3 == null && (string3 = ReservedKeywordsKt.escapeCompanionReservedWord(string)) == null) {
            string3 = ReservedKeywordsKt.escapeKotlinReservedWord(string);
        }
        return string3;
    }

    static {
        String[] stringArray = new String[53];
        String[] stringArray2 = stringArray;
        stringArray[0] = "abstract";
        stringArray2[1] = "assert";
        stringArray2[2] = "boolean";
        stringArray2[3] = "break";
        stringArray2[4] = "byte";
        stringArray2[5] = "case";
        stringArray2[6] = "catch";
        stringArray2[7] = "char";
        stringArray2[8] = "class";
        stringArray2[9] = "const";
        stringArray2[10] = "continue";
        stringArray2[11] = "default";
        stringArray2[12] = "do";
        stringArray2[13] = "double";
        stringArray2[14] = "else";
        stringArray2[15] = "enum";
        stringArray2[16] = "extends";
        stringArray2[17] = "false";
        stringArray2[18] = "final";
        stringArray2[19] = "finally";
        stringArray2[20] = "float";
        stringArray2[21] = "for";
        stringArray2[22] = "goto";
        stringArray2[23] = "if";
        stringArray2[24] = "implements";
        stringArray2[25] = "import";
        stringArray2[26] = "instanceof";
        stringArray2[27] = "int";
        stringArray2[28] = "interface";
        stringArray2[29] = "long";
        stringArray2[30] = "native";
        stringArray2[31] = "new";
        stringArray2[32] = "null";
        stringArray2[33] = "package";
        stringArray2[34] = "private";
        stringArray2[35] = "protected";
        stringArray2[36] = "public";
        stringArray2[37] = "return";
        stringArray2[38] = "short";
        stringArray2[39] = "static";
        stringArray2[40] = "strictfp";
        stringArray2[41] = "super";
        stringArray2[42] = "switch";
        stringArray2[43] = "synchronized";
        stringArray2[44] = "this";
        stringArray2[45] = "throw";
        stringArray2[46] = "throws";
        stringArray2[47] = "transient";
        stringArray2[48] = "try";
        stringArray2[49] = "true";
        stringArray2[50] = "void";
        stringArray2[51] = "volatile";
        stringArray2[52] = "while";
        JAVA_RESERVED_WORDS = stringArray2;
        Pattern pattern = Pattern.compile("(?:type)_*");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        TYPE_REGEX = new Regex(pattern);
        Pattern pattern2 = Pattern.compile("(?:Companion)_*");
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(...)");
        COMPANION_REGEX = new Regex(pattern2);
        Pattern pattern3 = Pattern.compile("(?:name|ordinal)_*");
        Intrinsics.checkNotNullExpressionValue(pattern3, "compile(...)");
        KOTLIN_ENUM_RESERVED_WORDS_REGEX = new Regex(pattern3);
    }
}

