/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.compiler.OperationIdGenerator;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.apollographql.apollo.gradle.api.ApolloAttributes;
import com.apollographql.apollo.gradle.api.ApolloExtension;
import com.apollographql.apollo.gradle.api.CompilerParams;
import com.apollographql.apollo.gradle.internal.AndroidTaskConfigurator;
import com.apollographql.apollo.gradle.internal.ApolloCheckDuplicatesTask;
import com.apollographql.apollo.gradle.internal.ApolloConvertSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloDownloadSchemaCliTask;
import com.apollographql.apollo.gradle.internal.ApolloDownloadSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesTask;
import com.apollographql.apollo.gradle.internal.ApolloPushSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloVariant;
import com.apollographql.apollo.gradle.internal.BuildDirLayout;
import com.apollographql.apollo.gradle.internal.DefaultApolloExtension;
import com.apollographql.apollo.gradle.internal.DefaultCompilationUnit;
import com.apollographql.apollo.gradle.internal.DefaultIntrospection;
import com.apollographql.apollo.gradle.internal.DefaultService;
import com.apollographql.apollo.gradle.internal.JvmTaskConfigurator;
import com.apollographql.apollo.gradle.internal.KotlinMultiplatformTaskConfigurator;
import com.apollographql.apollo.gradle.internal.ModelNames;
import com.apollographql.relocated.okhttp3.HttpUrl;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "apollo-gradle-plugin"})
public class ApolloPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TASK_GROUP = "apollo";
    @NotNull
    public static final String MIN_GRADLE_VERSION = "5.6";
    @NotNull
    public static final String CONFIGURATION_CONSUMER = "apollo";
    @NotNull
    public static final String USAGE_APOLLO_METADATA = "apollo-metadata";

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        boolean bl = GradleVersion.current().compareTo(GradleVersion.version((String)MIN_GRADLE_VERSION)) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "apollo-android requires Gradle version 5.6 or greater";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{project};
        Object object = project.getExtensions().create(ApolloExtension.class, "apollo", DefaultApolloExtension.class, objectArray);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.apollographql.apollo.gradle.internal.DefaultApolloExtension");
        }
        DefaultApolloExtension apolloExtension = (DefaultApolloExtension)object;
        project.getConfigurations().create(ModelNames.INSTANCE.apolloConfiguration(), arg_0 -> ApolloPlugin.apply$lambda-2(project, arg_0));
        project.afterEvaluate(arg_0 -> ApolloPlugin.apply$lambda-3(apolloExtension, arg_0));
    }

    private static final void apply$lambda-2$lambda-1(Project $project, AttributeContainer it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)$project.getObjects().named(Usage.class, USAGE_APOLLO_METADATA));
    }

    private static final void apply$lambda-2(Project $project, Configuration it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        it.setCanBeConsumed(false);
        it.setCanBeResolved(false);
        it.attributes(arg_0 -> ApolloPlugin.apply$lambda-2$lambda-1($project, arg_0));
    }

    private static final void apply$lambda-3(DefaultApolloExtension $apolloExtension, Project it) {
        Intrinsics.checkParameterIsNotNull((Object)$apolloExtension, (String)"$apolloExtension");
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        ApolloPlugin.Companion.afterEvaluate(it, $apolloExtension);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u000e\u001a\u00020\nJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0015H\u0002J&\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017H\u0002J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010&\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006("}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion;", "", "()V", "CONFIGURATION_CONSUMER", "", "MIN_GRADLE_VERSION", "TASK_GROUP", "USAGE_APOLLO_METADATA", "isKotlinMultiplatform", "", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)Z", "afterEvaluate", "", "project", "apolloExtension", "Lcom/apollographql/apollo/gradle/internal/DefaultApolloExtension;", "getDeps", "", "Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion$Dep;", "configurations", "Lorg/gradle/api/artifacts/Configuration;", "maybeRegisterCheckDuplicates", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/apollographql/apollo/gradle/internal/ApolloCheckDuplicatesTask;", "rootProject", "compilationUnit", "Lcom/apollographql/apollo/gradle/internal/DefaultCompilationUnit;", "registerCheckVersionsTask", "Lorg/gradle/api/Task;", "registerCodeGenTask", "Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesTask;", "consumerConfiguration", "registerCompilationUnits", "checkVersionsTask", "registerDownloadSchemaTasks", "toMap", "", "s", "Dep", "apollo-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isKotlinMultiplatform(@NotNull Project $this$isKotlinMultiplatform) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isKotlinMultiplatform, (String)"<this>");
            return $this$isKotlinMultiplatform.getPluginManager().hasPlugin("org.jetbrains.kotlin.multiplatform");
        }

        private final void registerCompilationUnits(Project project, DefaultApolloExtension apolloExtension, TaskProvider<Task> checkVersionsTask) {
            List list;
            Object androidExtension = project.getExtensions().findByName("android");
            Configuration apolloConfiguration = project.getConfigurations().getByName(ModelNames.INSTANCE.apolloConfiguration());
            NamedDomainObjectContainer<ApolloVariant> apolloVariants = this.isKotlinMultiplatform(project) ? KotlinMultiplatformTaskConfigurator.INSTANCE.getVariants(project) : (androidExtension != null ? AndroidTaskConfigurator.INSTANCE.getVariants(project, androidExtension) : JvmTaskConfigurator.INSTANCE.getVariants(project));
            TaskProvider rootProvider = project.getTasks().register(ModelNames.INSTANCE.generateApolloSources(), Companion::registerCompilationUnits$lambda-0);
            if (apolloExtension.getServices().isEmpty()) {
                Object[] objectArray = new Object[]{project.getObjects(), "service"};
                list = CollectionsKt.listOf((Object)project.getObjects().newInstance(DefaultService.class, objectArray));
            } else {
                list = apolloExtension.getServices();
            }
            List services = list;
            apolloVariants.all(arg_0 -> Companion.registerCompilationUnits$lambda-17(project, services, rootProvider, apolloExtension, androidExtension, apolloConfiguration, checkVersionsTask, arg_0));
        }

        private final TaskProvider<ApolloCheckDuplicatesTask> maybeRegisterCheckDuplicates(Project rootProject, DefaultCompilationUnit compilationUnit) {
            TaskProvider taskProvider;
            String taskName = ModelNames.INSTANCE.checkApolloDuplicates(compilationUnit);
            try {
                taskProvider = rootProject.getTasks().named(taskName);
                if (taskProvider == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<com.apollographql.apollo.gradle.internal.ApolloCheckDuplicatesTask>");
                }
            }
            catch (Exception e) {
                Configuration configuration = (Configuration)rootProject.getConfigurations().create(ModelNames.INSTANCE.duplicatesConsumerConfiguration(compilationUnit), arg_0 -> Companion.maybeRegisterCheckDuplicates$lambda-19(rootProject, compilationUnit, arg_0));
                TaskProvider taskProvider2 = rootProject.getTasks().register(taskName, ApolloCheckDuplicatesTask.class, arg_0 -> Companion.maybeRegisterCheckDuplicates$lambda-20(rootProject, compilationUnit, configuration, arg_0));
                Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider2, (String)"{\n        val configuration = rootProject.configurations.create(ModelNames.duplicatesConsumerConfiguration(compilationUnit)) {\n          it.isCanBeResolved = true\n          it.isCanBeConsumed = false\n\n          it.attributes {\n            it.attribute(Usage.USAGE_ATTRIBUTE, rootProject.objects.named(Usage::class.java, USAGE_APOLLO_METADATA))\n            it.attribute(ApolloAttributes.APOLLO_VARIANT_ATTRIBUTE, rootProject.objects.named(ApolloAttributes.Variant::class.java, compilationUnit.variantName))\n            it.attribute(ApolloAttributes.APOLLO_SERVICE_ATTRIBUTE, rootProject.objects.named(ApolloAttributes.Service::class.java, compilationUnit.serviceName))\n          }\n        }\n\n        rootProject.tasks.register(taskName, ApolloCheckDuplicatesTask::class.java) {\n          it.outputFile.set(BuildDirLayout.duplicatesCheck(rootProject, compilationUnit))\n          it.metadataFiles.from(configuration)\n        }\n      }");
                taskProvider = taskProvider2;
            }
            return taskProvider;
        }

        private final TaskProvider<ApolloGenerateSourcesTask> registerCodeGenTask(Project project, DefaultCompilationUnit compilationUnit, Configuration consumerConfiguration) {
            TaskProvider taskProvider = project.getTasks().register(ModelNames.INSTANCE.generateApolloSources(compilationUnit), ApolloGenerateSourcesTask.class, arg_0 -> Companion.registerCodeGenTask$lambda-27(compilationUnit, project, consumerConfiguration, arg_0));
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(ModelNames.generateApolloSources(compilationUnit), ApolloGenerateSourcesTask::class.java) { task ->\n        task.group = TASK_GROUP\n        task.description = \"Generate Apollo models for ${compilationUnit.name} GraphQL queries\"\n\n        val (compilerParams, graphqlSourceDirectorySet) = compilationUnit.resolveParams(project)\n\n        task.graphqlFiles.setFrom(graphqlSourceDirectorySet)\n        // I'm not sure if gradle is sensitive to the order of the rootFolders. Sort them just in case.\n        task.rootFolders.set(project.provider { graphqlSourceDirectorySet.srcDirs.map { it.relativeTo(project.projectDir).path }.sorted() })\n        task.schemaFile.set(compilerParams.schemaFile)\n        task.operationOutputGenerator = compilerParams.operationOutputGenerator.getOrElse(\n            OperationOutputGenerator.DefaultOperationOuputGenerator(\n                compilerParams.operationIdGenerator.orElse(OperationIdGenerator.Sha256()).get()\n            )\n        )\n\n        task.nullableValueType.set(compilerParams.nullableValueType)\n        task.useSemanticNaming.set(compilerParams.useSemanticNaming)\n        task.generateModelBuilder.set(compilerParams.generateModelBuilder)\n        task.useJavaBeansSemanticNaming.set(compilerParams.useJavaBeansSemanticNaming)\n        task.suppressRawTypesWarning.set(compilerParams.suppressRawTypesWarning)\n        task.generateKotlinModels.set(compilationUnit.generateKotlinModels())\n        task.warnOnDeprecatedUsages.set(compilerParams.warnOnDeprecatedUsages)\n        task.failOnWarnings.set(compilerParams.failOnWarnings)\n        task.generateVisitorForPolymorphicDatatypes.set(compilerParams.generateVisitorForPolymorphicDatatypes)\n        task.customTypeMapping.set(compilerParams.customTypeMapping)\n        task.outputDir.apply {\n          set(BuildDirLayout.sources(project, compilationUnit))\n          disallowChanges()\n        }\n        if (compilerParams.generateOperationOutput.getOrElse(false)) {\n          task.operationOutputFile.apply {\n            set(BuildDirLayout.operationOuput(project, compilationUnit))\n            disallowChanges()\n          }\n        }\n        // always set `metadataOutputFile` as the `metadata` task is part of `assemble` (see https://github.com/gradle/gradle/issues/14065)\n        // and we don't want it to fail if it is ever called by the user\n        task.metadataOutputFile.apply {\n          set(BuildDirLayout.metadata(project, compilationUnit))\n          disallowChanges()\n        }\n\n        task.generateMetadata.set(compilerParams.generateApolloMetadata.orElse(project.provider { !consumerConfiguration.isEmpty }))\n        task.metadataFiles.from(consumerConfiguration)\n\n        task.rootPackageName.set(compilerParams.rootPackageName)\n        task.generateAsInternal.set(compilerParams.generateAsInternal)\n        task.kotlinMultiPlatformProject.set(project.isKotlinMultiplatform)\n        task.sealedClassesForEnumsMatching.set(compilerParams.sealedClassesForEnumsMatching)\n        task.alwaysGenerateTypesMatching.set(compilerParams.alwaysGenerateTypesMatching)\n        task.packageName.set(compilerParams.packageName.orNull)\n        task.projectName.set(project.name)\n        task.projectRootDir.set(project.rootProject.rootDir)\n      }");
            return taskProvider;
        }

        private final void registerDownloadSchemaTasks(Project project, DefaultApolloExtension apolloExtension) {
            Iterable $this$forEach$iv = apolloExtension.getServices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultService service = (DefaultService)element$iv;
                boolean bl = false;
                DefaultIntrospection introspection = service.getIntrospection();
                if (introspection == null) continue;
                project.getTasks().register(ModelNames.INSTANCE.downloadApolloSchema(service), ApolloDownloadSchemaTask.class, arg_0 -> Companion.registerDownloadSchemaTasks$lambda-34$lambda-33(introspection, service, arg_0));
            }
            project.getTasks().register(ModelNames.INSTANCE.downloadApolloSchema(), ApolloDownloadSchemaCliTask.class, arg_0 -> Companion.registerDownloadSchemaTasks$lambda-35(apolloExtension, arg_0));
            project.getTasks().register(ModelNames.INSTANCE.pushApolloSchema(), ApolloPushSchemaTask.class, Companion::registerDownloadSchemaTasks$lambda-36);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, String> toMap(@NotNull String s) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            String[] stringArray = new String[]{"&"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                List keyValue = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                String key = URLDecoder.decode((String)keyValue.get(0), "UTF-8");
                String value = URLDecoder.decode((String)keyValue.get(1), "UTF-8");
                Pair pair = TuplesKt.to((Object)key, (Object)value);
                collection.add(pair);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private final void afterEvaluate(Project project, DefaultApolloExtension apolloExtension) {
            TaskProvider<Task> checkVersionsTask = this.registerCheckVersionsTask(project);
            this.registerCompilationUnits(project, apolloExtension, checkVersionsTask);
            this.registerDownloadSchemaTasks(project, apolloExtension);
            project.getTasks().register(ModelNames.INSTANCE.convertApolloSchema(), ApolloConvertSchemaTask.class, Companion::afterEvaluate$lambda-38);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Dep> getDeps(@NotNull List<? extends Configuration> configurations) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(configurations, (String)"configurations");
            Iterable $this$flatMap$iv = configurations;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Dependency it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Configuration configuration = (Configuration)element$iv$iv;
                boolean bl = false;
                Object object = configuration.getIncoming().getDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"configuration.incoming.dependencies");
                object = (Iterable)object;
                boolean $i$f$filter = false;
                void var13_13 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (Dependency)element$iv$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)"com.apollographql.apollo")) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void dependency;
                    it = (Dependency)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    String string = dependency.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.name");
                    Dep dep = new Dep(string, dependency.getVersion());
                    collection.add(dep);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final TaskProvider<Task> registerCheckVersionsTask(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            TaskProvider taskProvider = project.getTasks().register(ModelNames.INSTANCE.checkApolloVersions(), arg_0 -> Companion.registerCheckVersionsTask$lambda-42(project, arg_0));
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(ModelNames.checkApolloVersions()) {\n        val outputFile = BuildDirLayout.versionCheck(project)\n\n        it.outputs.file(outputFile)\n\n        it.inputs.property(\"versions\") {\n          val allConfigurations = project.rootProject.buildscript.configurations +\n                  project.buildscript.configurations +\n                  project.configurations\n\n          /**\n           * This includes all the configurations in the dependency resolution so it\n           * \"freezes\" them and adding dependencies after [getDeps] fails with:\n           *\n           * Cannot change dependencies of dependency configuration '$configuration'\n           * after it has been included in dependency resolution.\n           *\n           * Since this is lazy, it should hopefully be called after all other plugins\n           * have had a chance to change the dependencies\n           */\n          getDeps(allConfigurations.toList())\n                  .mapNotNull { it.version }\n                  .distinct()\n                  .sorted()\n        }\n\n        it.doLast(object: Action<Task> {\n          override fun execute(t: Task) {\n            val allVersions = it.inputs.properties[\"versions\"] as List<String>\n\n            check(allVersions.size <= 1) {\n              \"ApolloGraphQL: All apollo versions should be the same. Found:\\n$allVersions\"\n            }\n\n            val version = allVersions.firstOrNull()\n            outputFile.get().asFile.parentFile.mkdirs()\n            outputFile.get().asFile.writeText(\"All versions are consistent: $version\")\n\n          }\n        })\n      }");
            return taskProvider;
        }

        private static final void registerCompilationUnits$lambda-0(Task it) {
            it.setGroup("apollo");
            it.setDescription("Generate Apollo models for all services and variants");
        }

        private static final void registerCompilationUnits$lambda-17$lambda-1(ApolloVariant $apolloVariant, Task it) {
            it.setGroup("apollo");
            it.setDescription("Generate Apollo models for all services and variant '" + $apolloVariant.getName() + '\'');
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-4$lambda-3(Project $project, DefaultCompilationUnit $compilationUnit, AttributeContainer it) {
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.attribute(Usage.USAGE_ATTRIBUTE, (Object)$project.getObjects().named(Usage.class, ApolloPlugin.USAGE_APOLLO_METADATA));
            it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_VARIANT_ATTRIBUTE(), (Object)$project.getObjects().named(ApolloAttributes.Variant.class, $compilationUnit.getVariantName()));
            it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_SERVICE_ATTRIBUTE(), (Object)$project.getObjects().named(ApolloAttributes.Service.class, $compilationUnit.getServiceName()));
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-4(Configuration $apolloConfiguration, Project $project, DefaultCompilationUnit $compilationUnit, Configuration it) {
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.setCanBeConsumed(true);
            it.setCanBeResolved(false);
            Configuration[] configurationArray = new Configuration[]{$apolloConfiguration};
            it.extendsFrom(configurationArray);
            it.attributes(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-4$lambda-3($project, $compilationUnit, arg_0));
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-6$lambda-5(Project $project, DefaultCompilationUnit $compilationUnit, AttributeContainer it) {
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.attribute(Usage.USAGE_ATTRIBUTE, (Object)$project.getObjects().named(Usage.class, ApolloPlugin.USAGE_APOLLO_METADATA));
            it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_VARIANT_ATTRIBUTE(), (Object)$project.getObjects().named(ApolloAttributes.Variant.class, $compilationUnit.getVariantName()));
            it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_SERVICE_ATTRIBUTE(), (Object)$project.getObjects().named(ApolloAttributes.Service.class, $compilationUnit.getServiceName()));
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-6(Configuration $apolloConfiguration, Project $project, DefaultCompilationUnit $compilationUnit, Configuration it) {
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.setCanBeResolved(true);
            it.setCanBeConsumed(false);
            Configuration[] configurationArray = new Configuration[]{$apolloConfiguration};
            it.extendsFrom(configurationArray);
            it.attributes(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-6$lambda-5($project, $compilationUnit, arg_0));
        }

        private static final Provider registerCompilationUnits$lambda-17$lambda-15$lambda-8$lambda-7(ApolloGenerateSourcesTask it) {
            return (Provider)it.getMetadataOutputFile();
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-8(String $producerConfigurationName, TaskProvider $codegenProvider, ArtifactHandler it) {
            Intrinsics.checkParameterIsNotNull((Object)$producerConfigurationName, (String)"$producerConfigurationName");
            Intrinsics.checkParameterIsNotNull((Object)$codegenProvider, (String)"$codegenProvider");
            it.add($producerConfigurationName, (Object)$codegenProvider.flatMap(Companion::registerCompilationUnits$lambda-17$lambda-15$lambda-8$lambda-7));
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-9(TaskProvider $checkVersionsTask, Configuration $consumerConfiguration, ApolloGenerateSourcesTask it) {
            Intrinsics.checkParameterIsNotNull((Object)$checkVersionsTask, (String)"$checkVersionsTask");
            Object[] objectArray = new Object[]{$checkVersionsTask};
            it.dependsOn(objectArray);
            objectArray = new Object[]{$consumerConfiguration};
            it.dependsOn(objectArray);
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-10(TaskProvider $codegenProvider, Task it) {
            Intrinsics.checkParameterIsNotNull((Object)$codegenProvider, (String)"$codegenProvider");
            Object[] objectArray = new Object[]{$codegenProvider};
            it.dependsOn(objectArray);
        }

        private static final void registerCompilationUnits$lambda-17$lambda-15$lambda-12(TaskProvider $checkApolloDuplicates, ApolloGenerateSourcesTask it) {
            Intrinsics.checkParameterIsNotNull((Object)$checkApolloDuplicates, (String)"$checkApolloDuplicates");
            Object[] objectArray = new Object[]{$checkApolloDuplicates};
            it.finalizedBy(objectArray);
        }

        private static final Directory registerCompilationUnits$lambda-17$lambda-15$lambda-13(ApolloGenerateSourcesTask it) {
            return (Directory)it.getOutputDir().get();
        }

        private static final Provider registerCompilationUnits$lambda-17$lambda-15$lambda-14(ApolloGenerateSourcesTask it) {
            return (Provider)it.getOperationOutputFile();
        }

        private static final void registerCompilationUnits$lambda-17$lambda-16(TaskProvider $variantProvider, Task it) {
            Object[] objectArray = new Object[]{$variantProvider};
            it.dependsOn(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private static final void registerCompilationUnits$lambda-17(Project $project, List $services, TaskProvider $rootProvider, DefaultApolloExtension $apolloExtension, Object $androidExtension, Configuration $apolloConfiguration, TaskProvider $checkVersionsTask, ApolloVariant apolloVariant) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Intrinsics.checkParameterIsNotNull((Object)$services, (String)"$services");
            Intrinsics.checkParameterIsNotNull((Object)$apolloExtension, (String)"$apolloExtension");
            Intrinsics.checkParameterIsNotNull((Object)$checkVersionsTask, (String)"$checkVersionsTask");
            TaskContainer taskContainer = $project.getTasks();
            Intrinsics.checkExpressionValueIsNotNull((Object)apolloVariant, (String)"apolloVariant");
            TaskProvider variantProvider = taskContainer.register(ModelNames.INSTANCE.generateApolloSources(apolloVariant), arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-1(apolloVariant, arg_0));
            Iterable $this$map$iv = $services;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DefaultService defaultService = (DefaultService)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                DefaultCompilationUnit defaultCompilationUnit = DefaultCompilationUnit.Companion.createDefaultCompilationUnit($project, $apolloExtension, apolloVariant, (DefaultService)it);
                collection.add(defaultCompilationUnit);
            }
            List compilationUnits = (List)destination$iv$iv;
            Iterable $this$forEach$iv = compilationUnits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultCompilationUnit compilationUnit = (DefaultCompilationUnit)element$iv;
                boolean bl = false;
                String producerConfigurationName = ModelNames.INSTANCE.producerConfiguration(compilationUnit);
                $project.getConfigurations().create(producerConfigurationName, arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-4($apolloConfiguration, $project, compilationUnit, arg_0));
                Configuration consumerConfiguration = (Configuration)$project.getConfigurations().create(ModelNames.INSTANCE.consumerConfiguration(compilationUnit), arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-6($apolloConfiguration, $project, compilationUnit, arg_0));
                Intrinsics.checkExpressionValueIsNotNull((Object)consumerConfiguration, (String)"consumerConfiguration");
                TaskProvider<ApolloGenerateSourcesTask> codegenProvider = Companion.registerCodeGenTask($project, compilationUnit, consumerConfiguration);
                $project.artifacts(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-8(producerConfigurationName, codegenProvider, arg_0));
                codegenProvider.configure(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-9($checkVersionsTask, consumerConfiguration, arg_0));
                variantProvider.configure(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-10(codegenProvider, arg_0));
                Project project = $project.getRootProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.rootProject");
                TaskProvider<ApolloCheckDuplicatesTask> checkApolloDuplicates = Companion.maybeRegisterCheckDuplicates(project, compilationUnit);
                project = $project.getRootProject().getDependencies();
                boolean bl2 = false;
                boolean bl3 = false;
                Project $this$registerCompilationUnits_u24lambda_u2d17_u24lambda_u2d15_u24lambda_u2d11 = project;
                boolean bl4 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)$project.getPath()), TuplesKt.to((Object)"configuration", (Object)producerConfigurationName)};
                $this$registerCompilationUnits_u24lambda_u2d17_u24lambda_u2d15_u24lambda_u2d11.add(ModelNames.INSTANCE.duplicatesConsumerConfiguration(compilationUnit), (Object)$this$registerCompilationUnits_u24lambda_u2d17_u24lambda_u2d15_u24lambda_u2d11.project(MapsKt.mapOf((Pair[])pairArray)));
                codegenProvider.configure(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-15$lambda-12(checkApolloDuplicates, arg_0));
                compilationUnit.getOutputDir().set(codegenProvider.map(Companion::registerCompilationUnits$lambda-17$lambda-15$lambda-13));
                compilationUnit.getOperationOutputFile().set(codegenProvider.flatMap(Companion::registerCompilationUnits$lambda-17$lambda-15$lambda-14));
                $apolloExtension.getCompilationUnits$apollo_gradle_plugin().add((Object)compilationUnit);
                if (Companion.isKotlinMultiplatform($project)) {
                    KotlinMultiplatformTaskConfigurator.INSTANCE.registerGeneratedDirectory($project, compilationUnit, codegenProvider);
                    continue;
                }
                if ($androidExtension != null) {
                    AndroidTaskConfigurator.INSTANCE.registerGeneratedDirectory($project, compilationUnit, codegenProvider);
                    continue;
                }
                JvmTaskConfigurator.INSTANCE.registerGeneratedDirectory($project, compilationUnit, codegenProvider);
            }
            $rootProvider.configure(arg_0 -> Companion.registerCompilationUnits$lambda-17$lambda-16(variantProvider, arg_0));
        }

        private static final void maybeRegisterCheckDuplicates$lambda-19$lambda-18(Project $rootProject, DefaultCompilationUnit $compilationUnit, AttributeContainer it) {
            Intrinsics.checkParameterIsNotNull((Object)$rootProject, (String)"$rootProject");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.attribute(Usage.USAGE_ATTRIBUTE, (Object)$rootProject.getObjects().named(Usage.class, ApolloPlugin.USAGE_APOLLO_METADATA));
            it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_VARIANT_ATTRIBUTE(), (Object)$rootProject.getObjects().named(ApolloAttributes.Variant.class, $compilationUnit.getVariantName()));
            it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_SERVICE_ATTRIBUTE(), (Object)$rootProject.getObjects().named(ApolloAttributes.Service.class, $compilationUnit.getServiceName()));
        }

        private static final void maybeRegisterCheckDuplicates$lambda-19(Project $rootProject, DefaultCompilationUnit $compilationUnit, Configuration it) {
            Intrinsics.checkParameterIsNotNull((Object)$rootProject, (String)"$rootProject");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.setCanBeResolved(true);
            it.setCanBeConsumed(false);
            it.attributes(arg_0 -> Companion.maybeRegisterCheckDuplicates$lambda-19$lambda-18($rootProject, $compilationUnit, arg_0));
        }

        private static final void maybeRegisterCheckDuplicates$lambda-20(Project $rootProject, DefaultCompilationUnit $compilationUnit, Configuration $configuration, ApolloCheckDuplicatesTask it) {
            Intrinsics.checkParameterIsNotNull((Object)$rootProject, (String)"$rootProject");
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            it.getOutputFile().set(BuildDirLayout.INSTANCE.duplicatesCheck$apollo_gradle_plugin($rootProject, $compilationUnit));
            Object[] objectArray = new Object[]{$configuration};
            it.getMetadataFiles().from(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private static final List registerCodeGenTask$lambda-27$lambda-22(SourceDirectorySet $graphqlSourceDirectorySet, Project $project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$graphqlSourceDirectorySet, (String)"$graphqlSourceDirectorySet");
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Set set = $graphqlSourceDirectorySet.getSrcDirs();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"graphqlSourceDirectorySet.srcDirs");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                File file2 = $project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.projectDir");
                String string = FilesKt.relativeTo((File)it, (File)file2).getPath();
                collection.add(string);
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        private static final Boolean registerCodeGenTask$lambda-27$lambda-26(Configuration $consumerConfiguration) {
            Intrinsics.checkParameterIsNotNull((Object)$consumerConfiguration, (String)"$consumerConfiguration");
            return !$consumerConfiguration.isEmpty();
        }

        private static final void registerCodeGenTask$lambda-27(DefaultCompilationUnit $compilationUnit, Project $project, Configuration $consumerConfiguration, ApolloGenerateSourcesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)$compilationUnit, (String)"$compilationUnit");
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Intrinsics.checkParameterIsNotNull((Object)$consumerConfiguration, (String)"$consumerConfiguration");
            task.setGroup("apollo");
            task.setDescription("Generate Apollo models for " + $compilationUnit.getName() + " GraphQL queries");
            Pair<CompilerParams, SourceDirectorySet> pair = $compilationUnit.resolveParams($project);
            CompilerParams compilerParams = (CompilerParams)pair.component1();
            SourceDirectorySet graphqlSourceDirectorySet = (SourceDirectorySet)pair.component2();
            task.getGraphqlFiles().setFrom((Iterable)graphqlSourceDirectorySet);
            task.getRootFolders().set($project.provider(() -> Companion.registerCodeGenTask$lambda-27$lambda-22(graphqlSourceDirectorySet, $project)));
            task.getSchemaFile().set((Provider)compilerParams.getSchemaFile());
            Property<OperationOutputGenerator> property = compilerParams.getOperationOutputGenerator();
            Object object = compilerParams.getOperationIdGenerator().orElse((Object)new OperationIdGenerator.Sha256()).get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compilerParams.operationIdGenerator.orElse(OperationIdGenerator.Sha256()).get()");
            Object[] objectArray = property.getOrElse((Object)new OperationOutputGenerator.DefaultOperationOuputGenerator((OperationIdGenerator)object));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"compilerParams.operationOutputGenerator.getOrElse(\n            OperationOutputGenerator.DefaultOperationOuputGenerator(\n                compilerParams.operationIdGenerator.orElse(OperationIdGenerator.Sha256()).get()\n            )\n        )");
            task.setOperationOutputGenerator((OperationOutputGenerator)objectArray);
            task.getNullableValueType().set((Provider)compilerParams.getNullableValueType());
            task.getUseSemanticNaming().set((Provider)compilerParams.getUseSemanticNaming());
            task.getGenerateModelBuilder().set((Provider)compilerParams.getGenerateModelBuilder());
            task.getUseJavaBeansSemanticNaming().set((Provider)compilerParams.getUseJavaBeansSemanticNaming());
            task.getSuppressRawTypesWarning().set((Provider)compilerParams.getSuppressRawTypesWarning());
            task.getGenerateKotlinModels().set((Object)$compilationUnit.generateKotlinModels());
            task.getWarnOnDeprecatedUsages().set((Provider)compilerParams.getWarnOnDeprecatedUsages());
            task.getFailOnWarnings().set((Provider)compilerParams.getFailOnWarnings());
            task.getGenerateVisitorForPolymorphicDatatypes().set((Provider)compilerParams.getGenerateVisitorForPolymorphicDatatypes());
            task.getCustomTypeMapping().set((Provider)compilerParams.getCustomTypeMapping());
            objectArray = task.getOutputDir();
            boolean bl = false;
            boolean bl2 = false;
            Object[] $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d23 = objectArray;
            boolean bl3 = false;
            $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d23.set(BuildDirLayout.INSTANCE.sources$apollo_gradle_plugin($project, $compilationUnit));
            $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d23.disallowChanges();
            objectArray = compilerParams.getGenerateOperationOutput().getOrElse((Object)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"compilerParams.generateOperationOutput.getOrElse(false)");
            if (((Boolean)objectArray).booleanValue()) {
                objectArray = task.getOperationOutputFile();
                bl = false;
                bl2 = false;
                Object[] $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d24 = objectArray;
                boolean bl4 = false;
                $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d24.set(BuildDirLayout.INSTANCE.operationOuput$apollo_gradle_plugin($project, $compilationUnit));
                $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d24.disallowChanges();
            }
            objectArray = task.getMetadataOutputFile();
            bl = false;
            bl2 = false;
            Object[] $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d25 = objectArray;
            boolean bl5 = false;
            $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d25.set(BuildDirLayout.INSTANCE.metadata$apollo_gradle_plugin($project, $compilationUnit));
            $this$registerCodeGenTask_u24lambda_u2d27_u24lambda_u2d25.disallowChanges();
            task.getGenerateMetadata().set(compilerParams.getGenerateApolloMetadata().orElse($project.provider(() -> Companion.registerCodeGenTask$lambda-27$lambda-26($consumerConfiguration))));
            objectArray = new Object[]{$consumerConfiguration};
            task.getMetadataFiles().from(objectArray);
            task.getRootPackageName().set((Provider)compilerParams.getRootPackageName());
            task.getGenerateAsInternal().set((Provider)compilerParams.getGenerateAsInternal());
            task.getKotlinMultiPlatformProject().set((Object)Companion.isKotlinMultiplatform($project));
            task.getSealedClassesForEnumsMatching().set((Provider)compilerParams.getSealedClassesForEnumsMatching());
            task.getAlwaysGenerateTypesMatching().set((Provider)compilerParams.getAlwaysGenerateTypesMatching());
            task.getPackageName().set(compilerParams.getPackageName().getOrNull());
            task.getProjectName().set((Object)$project.getName());
            task.getProjectRootDir().set($project.getRootProject().getRootDir());
        }

        private static final String registerDownloadSchemaTasks$lambda-34$lambda-33$lambda-28(Provider $sourceSetName, String it) {
            return "src/" + $sourceSetName.get() + "/graphql/" + it;
        }

        private static final String registerDownloadSchemaTasks$lambda-34$lambda-33$lambda-31(DefaultIntrospection $introspection, String it) {
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            HttpUrl.Builder builder = HttpUrl.Companion.get(it).newBuilder();
            boolean bl = false;
            boolean bl2 = false;
            HttpUrl.Builder $this$registerDownloadSchemaTasks_u24lambda_u2d34_u24lambda_u2d33_u24lambda_u2d31_u24lambda_u2d30 = builder;
            boolean bl3 = false;
            Iterable $this$forEach$iv = ((Map)$introspection.getQueryParameters().get()).entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it2 = (Map.Entry)element$iv;
                boolean bl4 = false;
                Object k = it2.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                $this$registerDownloadSchemaTasks_u24lambda_u2d34_u24lambda_u2d33_u24lambda_u2d31_u24lambda_u2d30.addQueryParameter((String)k, (String)it2.getValue());
            }
            return builder.build().toString();
        }

        /*
         * WARNING - void declaration
         */
        private static final void registerDownloadSchemaTasks$lambda-34$lambda-33(DefaultIntrospection $introspection, DefaultService $service, ApolloDownloadSchemaTask task) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)$service, (String)"$service");
            Provider sourceSetName = $introspection.getSourceSetName().orElse((Object)"main");
            task.setGroup("apollo");
            task.getSchemaRelativeToProject().set($service.getSchemaPath().map(arg_0 -> Companion.registerDownloadSchemaTasks$lambda-34$lambda-33$lambda-28(sourceSetName, arg_0)));
            task.getEndpoint().set($introspection.getEndpointUrl().map(arg_0 -> Companion.registerDownloadSchemaTasks$lambda-34$lambda-33$lambda-31($introspection, arg_0)));
            Object object = $introspection.getHeaders().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"introspection.headers.get()");
            object = (Map)object;
            ApolloDownloadSchemaTask apolloDownloadSchemaTask = task;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var9_10 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var9_10.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getKey() + ": " + it.getValue();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            apolloDownloadSchemaTask.setHeader((List<String>)collection);
        }

        private static final void registerDownloadSchemaTasks$lambda-35(DefaultApolloExtension $apolloExtension, ApolloDownloadSchemaCliTask task) {
            Intrinsics.checkParameterIsNotNull((Object)$apolloExtension, (String)"$apolloExtension");
            task.setGroup("apollo");
            NamedDomainObjectContainer<DefaultCompilationUnit> namedDomainObjectContainer = $apolloExtension.getCompilationUnits$apollo_gradle_plugin();
            Intrinsics.checkExpressionValueIsNotNull(namedDomainObjectContainer, (String)"apolloExtension.compilationUnits");
            task.setCompilationUnits(namedDomainObjectContainer);
        }

        private static final void registerDownloadSchemaTasks$lambda-36(ApolloPushSchemaTask task) {
            task.setGroup("apollo");
        }

        private static final void afterEvaluate$lambda-38(ApolloConvertSchemaTask task) {
            task.setGroup("apollo");
        }

        private static final void registerCheckVersionsTask$lambda-42(Project $project, Task it) {
            Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
            Provider<RegularFile> outputFile = BuildDirLayout.INSTANCE.versionCheck$apollo_gradle_plugin($project);
            it.getOutputs().file(outputFile);
            it.getInputs().property("versions", (Object)new Function0<List<? extends String>>($project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke() {
                    void $this$mapNotNullTo$iv$iv;
                    ConfigurationContainer configurationContainer = this.$project.getRootProject().getBuildscript().getConfigurations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.rootProject.buildscript.configurations");
                    Set set = (Set)configurationContainer;
                    configurationContainer = this.$project.getBuildscript().getConfigurations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.buildscript.configurations");
                    Set set2 = SetsKt.plus((Set)set, (Iterable)((Iterable)configurationContainer));
                    configurationContainer = this.$project.getConfigurations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
                    Set allConfigurations = SetsKt.plus((Set)set2, (Iterable)((Iterable)configurationContainer));
                    Iterable $this$mapNotNull$iv = ApolloPlugin.Companion.getDeps(CollectionsKt.toList((Iterable)allConfigurations));
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Dep it = (Dep)element$iv$iv;
                        boolean bl2 = false;
                        if (it.getVersion() == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        String it$iv$iv = string;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                }
            });
            it.doLast((Action)new Action<Task>(it, outputFile){
                final /* synthetic */ Task $it;
                final /* synthetic */ Provider<RegularFile> $outputFile;
                {
                    this.$it = $it;
                    this.$outputFile = $outputFile;
                }

                public void execute(@NotNull Task t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    V v = this.$it.getInputs().getProperties().get("versions");
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                    }
                    List allVersions = (List)v;
                    boolean bl = allVersions.size() <= 1;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = Intrinsics.stringPlus((String)"ApolloGraphQL: All apollo versions should be the same. Found:\n", (Object)allVersions);
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    String version = (String)CollectionsKt.firstOrNull((List)allVersions);
                    ((RegularFile)this.$outputFile.get()).getAsFile().getParentFile().mkdirs();
                    File file = ((RegularFile)this.$outputFile.get()).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile.get().asFile");
                    FilesKt.writeText$default((File)file, (String)Intrinsics.stringPlus((String)"All versions are consistent: ", (Object)version), null, (int)2, null);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion$Dep;", "", "name", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-gradle-plugin"})
        public static final class Dep {
            @NotNull
            private final String name;
            @Nullable
            private final String version;

            public Dep(@NotNull String name, @Nullable String version) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                this.name = name;
                this.version = version;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @Nullable
            public final String component2() {
                return this.version;
            }

            @NotNull
            public final Dep copy(@NotNull String name, @Nullable String version) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return new Dep(name, version);
            }

            public static /* synthetic */ Dep copy$default(Dep dep, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = dep.name;
                }
                if ((n & 2) != 0) {
                    string2 = dep.version;
                }
                return dep.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Dep(name=" + this.name + ", version=" + this.version + ')';
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Dep)) {
                    return false;
                }
                Dep dep = (Dep)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)dep.name)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.version, (Object)dep.version);
            }
        }
    }
}

