/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.com.squareup.javapoet;

import com.apollographql.relocated.com.squareup.javapoet.Util;
import java.io.IOException;

final class LineWrapper {
    private final Appendable out;
    private final String indent;
    private final int columnLimit;
    private boolean closed;
    private final StringBuilder buffer = new StringBuilder();
    private int column = 0;
    private int indentLevel = -1;

    LineWrapper(Appendable out, String indent, int columnLimit) {
        Util.checkNotNull(out, "out == null", new Object[0]);
        this.out = out;
        this.indent = indent;
        this.columnLimit = columnLimit;
    }

    void append(String s) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.indentLevel != -1) {
            int nextNewline = s.indexOf(10);
            if (nextNewline == -1 && this.column + s.length() <= this.columnLimit) {
                this.buffer.append(s);
                this.column += s.length();
                return;
            }
            boolean wrap = nextNewline == -1 || this.column + nextNewline > this.columnLimit;
            this.flush(wrap);
        }
        this.out.append(s);
        int lastNewline = s.lastIndexOf(10);
        this.column = lastNewline != -1 ? s.length() - lastNewline - 1 : this.column + s.length();
    }

    void wrappingSpace(int indentLevel) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.indentLevel != -1) {
            this.flush(false);
        }
        ++this.column;
        this.indentLevel = indentLevel;
    }

    void close() throws IOException {
        if (this.indentLevel != -1) {
            this.flush(false);
        }
        this.closed = true;
    }

    private void flush(boolean wrap) throws IOException {
        if (wrap) {
            this.out.append('\n');
            for (int i = 0; i < this.indentLevel; ++i) {
                this.out.append(this.indent);
            }
            this.column = this.indentLevel * this.indent.length();
            this.column += this.buffer.length();
        } else {
            this.out.append(' ');
        }
        this.out.append(this.buffer);
        this.buffer.delete(0, this.buffer.length());
        this.indentLevel = -1;
    }
}

