/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import com.apollographql.relocated.org.antlr.runtime.ANTLRStringStream;
import com.apollographql.relocated.org.antlr.runtime.CommonTokenStream;
import com.apollographql.relocated.org.antlr.runtime.NoViableAltException;
import com.apollographql.relocated.org.antlr.runtime.Parser;
import com.apollographql.relocated.org.antlr.runtime.RecognitionException;
import com.apollographql.relocated.org.antlr.runtime.Token;
import com.apollographql.relocated.org.antlr.runtime.TokenStream;
import com.apollographql.relocated.org.antlr.runtime.tree.CommonTreeNodeStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CodeGenerator;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.compiler.STLexer;
import org.stringtemplate.v4.compiler.STParser;
import org.stringtemplate.v4.misc.ErrorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    public static final String SUBTEMPLATE_PREFIX = "_sub";
    public static final int TEMPLATE_INITIAL_CODE_SIZE = 15;
    public static final Map<String, Interpreter.Option> supportedOptions = new HashMap<String, Interpreter.Option>(){
        {
            this.put("anchor", Interpreter.Option.ANCHOR);
            this.put("format", Interpreter.Option.FORMAT);
            this.put("null", Interpreter.Option.NULL);
            this.put("separator", Interpreter.Option.SEPARATOR);
            this.put("wrap", Interpreter.Option.WRAP);
        }
    };
    public static final int NUM_OPTIONS = supportedOptions.size();
    public static final Map<String, String> defaultOptionValues = new HashMap<String, String>(){
        {
            this.put("anchor", "true");
            this.put("wrap", "\n");
        }
    };
    public static Map<String, Short> funcs = new HashMap<String, Short>(){
        {
            this.put("first", (short)27);
            this.put("last", (short)28);
            this.put("rest", (short)29);
            this.put("trunc", (short)30);
            this.put("strip", (short)31);
            this.put("trim", (short)32);
            this.put("length", (short)33);
            this.put("strlen", (short)34);
            this.put("reverse", (short)35);
        }
    };
    public static int subtemplateCount = 0;
    public STGroup group;

    public Compiler() {
        this(STGroup.defaultGroup);
    }

    public Compiler(STGroup group) {
        this.group = group;
    }

    public CompiledST compile(String template) {
        CompiledST code = this.compile(null, null, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String name, String template) {
        CompiledST code = this.compile(null, name, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String srcName, String name, List<FormalArgument> args, String template, Token templateToken) {
        ANTLRStringStream is = new ANTLRStringStream(template);
        is.name = srcName != null ? srcName : name;
        STLexer lexer = null;
        lexer = templateToken != null && templateToken.getType() == 6 ? new STLexer(this.group.errMgr, is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar){

            public Token nextToken() {
                Token t = super.nextToken();
                while (t.getType() == 32 || t.getType() == 31) {
                    t = super.nextToken();
                }
                return t;
            }
        } : new STLexer(this.group.errMgr, is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        STParser p = new STParser(tokens, this.group.errMgr, templateToken);
        STParser.templateAndEOF_return r = null;
        try {
            r = p.templateAndEOF();
        }
        catch (RecognitionException re) {
            this.reportMessageAndThrowSTException(tokens, templateToken, p, re);
            return null;
        }
        if (p.getNumberOfSyntaxErrors() > 0 || r.getTree() == null) {
            CompiledST impl = new CompiledST();
            impl.defineFormalArgs(args);
            return impl;
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(r.getTree());
        nodes.setTokenStream(tokens);
        CodeGenerator gen = new CodeGenerator(nodes, this.group.errMgr, name, template, templateToken);
        CompiledST impl = null;
        try {
            impl = gen.template(name, args);
            impl.nativeGroup = this.group;
            impl.template = template;
            impl.ast = r.getTree();
            impl.ast.setUnknownTokenBoundaries();
            impl.tokens = tokens;
        }
        catch (RecognitionException re) {
            this.group.errMgr.internalError(null, "bad tree structure", re);
        }
        return impl;
    }

    public static CompiledST defineBlankRegion(CompiledST outermostImpl, Token nameToken) {
        String outermostTemplateName = outermostImpl.name;
        String mangled = STGroup.getMangledRegionName(outermostTemplateName, nameToken.getText());
        CompiledST blank = new CompiledST();
        blank.isRegion = true;
        blank.templateDefStartToken = nameToken;
        blank.regionDefType = ST.RegionType.IMPLICIT;
        blank.name = mangled;
        outermostImpl.addImplicitlyDefinedTemplate(blank);
        return blank;
    }

    public static String getNewSubtemplateName() {
        return SUBTEMPLATE_PREFIX + ++subtemplateCount;
    }

    protected void reportMessageAndThrowSTException(TokenStream tokens, Token templateToken, Parser parser2, RecognitionException re) {
        if (re.token.getType() == -1) {
            String msg = "premature EOF";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (re instanceof NoViableAltException) {
            String msg = "'" + re.token.getText() + "' came as a complete surprise to me";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.index() == 0) {
            String msg = "this doesn't look like a template: \"" + tokens + "\"";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.LA(1) == 23) {
            String msg = "doesn't look like an expression";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else {
            String msg = parser2.getErrorMessage(re, parser2.getTokenNames());
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        }
        throw new STException();
    }
}

