/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.gradle.Utils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.gradle.api.GradleException;
import org.gradle.api.internal.AbstractTask;
import org.jetbrains.annotations.Nullable;

class CodegenGenerationTaskCommandArgsBuilder {
    private final AbstractTask task;
    private final String schemaFilePath;
    private final String outputPackageName;
    private final File outputFolder;
    private final String variant;
    private final List<String> sourceSets;

    CodegenGenerationTaskCommandArgsBuilder(AbstractTask task, String schemaFilePath, String outputPackageName, File outputFolder, String variant, List<String> sourceSets) {
        this.task = task;
        this.schemaFilePath = schemaFilePath;
        this.outputPackageName = outputPackageName;
        this.outputFolder = outputFolder;
        this.variant = variant;
        this.sourceSets = sourceSets;
    }

    public List<CommandArgs> build() {
        List<ApolloCodegenIRArgs> codegenArgs = this.buildCodegenArgs();
        ArrayList<CommandArgs> taskExecutionArgs = new ArrayList<CommandArgs>();
        for (ApolloCodegenIRArgs codegenArg : codegenArgs) {
            codegenArg.irOutputFolder.mkdirs();
            ArrayList<String> args = new ArrayList<String>();
            args.add("generate");
            args.addAll(codegenArg.queryFilePaths);
            args.addAll(Arrays.asList("--add-typename", "--schema", codegenArg.schemaFile.getAbsolutePath(), "--output", codegenArg.irOutputFolder.getAbsolutePath() + File.separator + Utils.capitalize(this.variant) + "API.json", "--operation-ids-path", codegenArg.irOutputFolder.getAbsolutePath() + File.separator + Utils.capitalize(this.variant) + "OperationIdMap.json", "--merge-in-fields-from-fragment-spreads", "false", "--target", "json"));
            taskExecutionArgs.add(new CommandArgs(args));
        }
        return taskExecutionArgs;
    }

    public List<ApolloCodegenIRArgs> buildCodegenArgs() {
        List<ApolloCodegenIRArgs> codegenArgs;
        File schemaFile = null;
        if (this.schemaFilePath != null && !this.schemaFilePath.trim().isEmpty()) {
            schemaFile = Paths.get(this.schemaFilePath, new String[0]).toFile();
            if (!schemaFile.exists()) {
                schemaFile = Paths.get(this.task.getProject().getProjectDir().getAbsolutePath(), this.schemaFilePath).toFile();
            }
            if (!schemaFile.exists()) {
                throw new GradleException("Provided schema file path doesn't exists: " + this.schemaFilePath + ". Please ensure a valid schema file exists");
            }
        }
        File targetPackageFolder = null;
        if (schemaFile != null) {
            if (this.outputPackageName == null || this.outputPackageName.trim().isEmpty()) {
                throw new GradleException("Missing explicit outputPackageName option. Please ensure a valid package name is provided");
            }
            targetPackageFolder = new File(this.outputFolder.getAbsolutePath() + File.separator + "src" + File.separator + "main" + File.separator + "graphql" + File.separator + this.outputPackageName.replace(".", File.separator));
        }
        if (schemaFile == null) {
            codegenArgs = this.codeGenArgs(this.task.getInputs().getSourceFiles().getFiles());
        } else {
            HashSet<String> queryFilePaths = new HashSet<String>();
            for (File queryFile : this.queryFilesFrom(this.task.getInputs().getSourceFiles().getFiles())) {
                queryFilePaths.add(queryFile.getAbsolutePath());
            }
            codegenArgs = Collections.singletonList(new ApolloCodegenIRArgs(schemaFile, queryFilePaths, targetPackageFolder));
        }
        return codegenArgs;
    }

    private List<ApolloCodegenIRArgs> codeGenArgs(Set<File> files) {
        final List<File> schemaFiles = this.getSchemaFilesFrom(files);
        if (schemaFiles.isEmpty()) {
            throw new GradleException("Couldn't find schema files for the variant " + Utils.capitalize(this.variant) + ". Please" + " ensure a valid schema.json exists under the varian't source sets");
        }
        if (CodegenGenerationTaskCommandArgsBuilder.illegalSchemasFound(schemaFiles)) {
            throw new GradleException("Found an ancestor directory to a schema file that contains another schema file. Please ensure no schema files exist on the path to another one");
        }
        ImmutableMap.Builder schemaQueryMap = ImmutableMap.builder();
        for (final File f : schemaFiles) {
            String normalizedSchemaFileName = this.getPathRelativeToSourceSet(f);
            if (schemaQueryMap.build().containsKey((Object)normalizedSchemaFileName)) continue;
            schemaQueryMap.put((Object)normalizedSchemaFileName, (Object)new ApolloCodegenIRArgs(f, (Set<String>)FluentIterable.from(files).filter((Predicate)new Predicate<File>(){

                public boolean apply(@Nullable File file) {
                    return file != null && !schemaFiles.contains(file) && file.getParent().contains(CodegenGenerationTaskCommandArgsBuilder.this.getPathRelativeToSourceSet(f.getParentFile()));
                }
            }).transform((Function)new Function<File, String>(){

                @Nullable
                public String apply(@Nullable File file) {
                    return file.getAbsolutePath();
                }
            }).toSet(), new File(this.outputFolder.getAbsolutePath() + File.separator + this.task.getProject().relativePath((Object)f.getParent()))));
        }
        return schemaQueryMap.build().values().asList();
    }

    private List<File> getSchemaFilesFrom(Set<File> files) {
        return FluentIterable.from(files).filter((Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File file) {
                return file != null && file.getName().equals("schema.json");
            }
        }).toSortedList((Comparator)new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String sourceSet1 = CodegenGenerationTaskCommandArgsBuilder.this.getSourceSetNameFromFile(o1);
                String sourceSet2 = CodegenGenerationTaskCommandArgsBuilder.this.getSourceSetNameFromFile(o2);
                return -(CodegenGenerationTaskCommandArgsBuilder.this.sourceSets.indexOf(sourceSet1) - CodegenGenerationTaskCommandArgsBuilder.this.sourceSets.indexOf(sourceSet2));
            }
        });
    }

    private List<File> queryFilesFrom(Set<File> files) {
        return FluentIterable.from(files).filter((Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File file) {
                return file != null && !file.getName().equals("schema.json");
            }
        }).toList();
    }

    private static boolean illegalSchemasFound(Collection<File> schemaFiles) {
        for (final File f : schemaFiles) {
            final Path parent = Paths.get(f.getParent(), new String[0]).toAbsolutePath();
            ImmutableList matches = FluentIterable.from(schemaFiles).filter((Predicate)new Predicate<File>(){

                public boolean apply(@Nullable File file) {
                    return file != null && file != f && Paths.get(file.getParent(), new String[0]).startsWith(parent);
                }
            }).toList();
            if (matches.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private String getSourceSetNameFromFile(File file) {
        Path absolutePath = Paths.get(file.getAbsolutePath(), new String[0]);
        Path basePath = Paths.get(this.task.getProject().file((Object)"src").getAbsolutePath(), new String[0]);
        return basePath.relativize(absolutePath).toString().split(Matcher.quoteReplacement(File.separator))[0];
    }

    private String getPathRelativeToSourceSet(File file) {
        Path absolutePath = Paths.get(file.getAbsolutePath(), new String[0]);
        Path basePath = Paths.get(this.task.getProject().file((Object)"src").getAbsolutePath() + File.separator + this.getSourceSetNameFromFile(file), new String[0]);
        return basePath.relativize(absolutePath).toString();
    }

    class CommandArgs {
        final List<String> taskArguments;

        CommandArgs(List<String> taskArguments) {
            this.taskArguments = taskArguments;
        }
    }

    static final class ApolloCodegenIRArgs {
        final File schemaFile;
        final Set<String> queryFilePaths;
        final File irOutputFolder;

        ApolloCodegenIRArgs(File schemaFile, Set<String> queryFilePaths, File irOutputFolder) {
            this.schemaFile = schemaFile;
            this.queryFilePaths = queryFilePaths;
            this.irOutputFolder = irOutputFolder;
        }
    }
}

