/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.compiler.NullableValueType;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.jetbrains.annotations.NotNull;

public class ApolloClassGenerationTask
extends SourceTask {
    static final String NAME = "generate%sApolloClasses";
    Map<String, String> customTypeMapping;
    String nullableValueType;
    boolean useSemanticNaming;
    boolean generateModelBuilder;
    boolean useJavaBeansSemanticNaming;
    boolean suppressRawTypesWarning;
    String outputPackageName;
    final File outputDir = new File(this.getProject().getBuildDir() + File.separator + Joiner.on((String)File.separator).join((Iterable)GraphQLCompiler.OUTPUT_DIRECTORY));

    @TaskAction
    void generateClasses(IncrementalTaskInputs inputs) {
        final NullableValueType nullableValueType = this.nullableValueType == null ? NullableValueType.ANNOTATED : NullableValueType.Companion.findByValue(this.nullableValueType);
        inputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(@NotNull InputFileDetails inputFileDetails) {
                GraphQLCompiler.Arguments args = new GraphQLCompiler.Arguments(inputFileDetails.getFile(), ApolloClassGenerationTask.this.outputDir, ApolloClassGenerationTask.this.customTypeMapping, nullableValueType, ApolloClassGenerationTask.this.useSemanticNaming, ApolloClassGenerationTask.this.generateModelBuilder, ApolloClassGenerationTask.this.useJavaBeansSemanticNaming, ApolloClassGenerationTask.this.outputPackageName, ApolloClassGenerationTask.this.suppressRawTypesWarning);
                new GraphQLCompiler().write(args);
            }
        });
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    @Input
    public Map<String, String> getCustomTypeMapping() {
        return this.customTypeMapping;
    }

    @Input
    @Optional
    public String getNullableValueType() {
        return this.nullableValueType;
    }

    @Input
    public boolean isUseSemanticNaming() {
        return this.useSemanticNaming;
    }

    @Input
    public boolean isGenerateModelBuilder() {
        return this.generateModelBuilder;
    }

    @Input
    public boolean isUseJavaBeansSemanticNaming() {
        return this.useJavaBeansSemanticNaming;
    }

    @Input
    public boolean isSuppressRawTypesWarning() {
        return this.suppressRawTypesWarning;
    }

    @Input
    @Optional
    public String getOutputPackageName() {
        return this.outputPackageName;
    }
}

