/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.compiler.FileUtils;
import com.apollographql.apollo.compiler.pqm.PqmOperation;
import com.apollographql.apollo.tooling.CannotModifyOperationBody;
import com.apollographql.apollo.tooling.GraphNotFound;
import com.apollographql.apollo.tooling.PermissionError;
import com.apollographql.apollo.tooling.PersistedQueriesUploaderKt;
import com.apollographql.apollo.tooling.PersistedQuery;
import com.apollographql.apollo.tooling.PublishOperationsResult;
import com.apollographql.apollo.tooling.PublishOperationsSuccess;
import com.apollographql.apollo.tooling.RegisterOperations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloRegisterOperationsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graph", "Lorg/gradle/api/provider/Property;", "", "getGraph", "()Lorg/gradle/api/provider/Property;", "graphVariant", "getGraphVariant", "key", "getKey", "listId", "getListId", "operationManifestFormat", "getOperationManifestFormat", "operationOutput", "Lorg/gradle/api/file/RegularFileProperty;", "getOperationOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "taskAction", "", "apollo-gradle-plugin-external"})
@SourceDebugExtension(value={"SMAP\nApolloRegisterOperationsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApolloRegisterOperationsTask.kt\ncom/apollographql/apollo/gradle/internal/ApolloRegisterOperationsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1557#2:102\n1628#2,3:103\n*S KotlinDebug\n*F\n+ 1 ApolloRegisterOperationsTask.kt\ncom/apollographql/apollo/gradle/internal/ApolloRegisterOperationsTask\n*L\n59#1:102\n59#1:103,3\n*E\n"})
public abstract class ApolloRegisterOperationsTask
extends DefaultTask {
    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getOperationOutput();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getOperationManifestFormat();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getListId();

    @Input
    @NotNull
    public abstract Property<String> getKey();

    @Input
    @NotNull
    public abstract Property<String> getGraph();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getGraphVariant();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void taskAction() {
        if (this.getListId().isPresent()) {
            PublishOperationsResult result;
            void $this$mapTo$iv$iv;
            PublishOperationsResult $this$map$iv;
            if (!Intrinsics.areEqual((Object)this.getOperationManifestFormat().get(), (Object)"persistedQueryManifest")) {
                boolean $i$a$-check-ApolloRegisterOperationsTask$taskAction$32 = false;
                String $i$a$-check-ApolloRegisterOperationsTask$taskAction$32 = "Apollo: registering operations to a persisted query list requires operationManifestFormat = \"persistedQueryManifest\":\napollo {\n  service(\"service\") {\n    operationManifestFormat.set(\"persistedQueryManifest\")\n  }\n}";
                throw new IllegalStateException($i$a$-check-ApolloRegisterOperationsTask$taskAction$32.toString());
            }
            Object object = this.getListId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String string = (String)object;
            File file = ((RegularFile)this.getOperationOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            Iterable $i$a$-check-ApolloRegisterOperationsTask$taskAction$32 = FileUtils.readPersistedQueryManifest((File)file).getOperations();
            String string2 = string;
            boolean $i$f$map = false;
            void var4_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PqmOperation pqmOperation = (PqmOperation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PersistedQuery(it.getName(), it.getId(), it.getBody(), it.getType()));
            }
            Object object2 = this.getKey().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            $this$map$iv = result = PersistedQueriesUploaderKt.publishOperations((String)string2, (List)((List)destination$iv$iv), (String)((String)object2), (String)((String)this.getGraph().get()));
            if ($this$map$iv instanceof PublishOperationsSuccess) {
                this.getLogger().info("Apollo: persisted query list uploaded successfully");
            } else {
                if ($this$map$iv instanceof CannotModifyOperationBody) {
                    throw new IllegalStateException(("Cannot upload persisted query list: cannot modify operation body ('" + ((CannotModifyOperationBody)result).getMessage() + "')").toString());
                }
                if (Intrinsics.areEqual((Object)$this$map$iv, (Object)GraphNotFound.INSTANCE)) {
                    throw new IllegalStateException(("Cannot upload persisted query list: graph '" + this.getGraph() + "' not found").toString());
                }
                if ($this$map$iv instanceof PermissionError) {
                    throw new IllegalStateException(("Cannot upload persisted query list: permission error ('" + ((PermissionError)result).getMessage() + "')").toString());
                }
            }
        } else {
            this.getLogger().warn("Apollo: registering operations without a listId is deprecated");
            if (!Intrinsics.areEqual((Object)this.getOperationManifestFormat().get(), (Object)"operationOutput")) {
                boolean bl = false;
                String string = "Apollo: registering legacy operations requires operationManifestFormat = \"operationOutput\":\napollo {\n  service(\"service\") {\n    operationManifestFormat.set(\"operationOutput\")\n  }\n}";
                throw new IllegalStateException(string.toString());
            }
            String string = (String)this.getKey().get();
            if (string == null) {
                throw new IllegalStateException("key is required to register operations".toString());
            }
            String string3 = (String)this.getGraph().get();
            if (string3 == null) {
                throw new IllegalStateException("graphID is required to register operations".toString());
            }
            String string4 = (String)this.getGraphVariant().get();
            if (string4 == null) {
                throw new IllegalStateException("graphVariant is required to register operations".toString());
            }
            File file = ((RegularFile)this.getOperationOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            RegisterOperations.INSTANCE.registerOperations(string, string3, string4, FileUtils.readOperationOutput((File)file));
        }
    }
}

