/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.ast.ApolloParser;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.GQLNode;
import com.apollographql.apollo.ast.GqldocumentKt;
import com.apollographql.apollo.ast.GqlnodeKt;
import com.apollographql.apollo.ast.introspection.ApolloIntrospectionSchema;
import com.apollographql.apollo.ast.introspection.Introspection;
import com.apollographql.apollo.ast.introspection.IntrospectionSchema;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0012J\b\u0010\u0015\u001a\u00020\u0014H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\u00068gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloConvertSchemaTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "from", "Lorg/gradle/api/provider/Property;", "", "getFrom", "()Lorg/gradle/api/provider/Property;", "to", "getTo", "projectRootDir", "getProjectRootDir", "()Ljava/lang/String;", "setProjectRootDir", "(Ljava/lang/String;)V", "isIntrospection", "", "Ljava/io/File;", "convert", "", "taskAction", "apollo-gradle-plugin-external"})
public abstract class ApolloConvertSchemaTask
extends DefaultTask {
    public ApolloConvertSchemaTask() {
        this.getOutputs().upToDateWhen(arg_0 -> ApolloConvertSchemaTask._init_$lambda$1(ApolloConvertSchemaTask::_init_$lambda$0, arg_0));
        this.getOutputs().cacheIf(arg_0 -> ApolloConvertSchemaTask._init_$lambda$3(ApolloConvertSchemaTask::_init_$lambda$2, arg_0));
    }

    @Input
    @Option(option="from", description="schema to convert from")
    @NotNull
    public abstract Property<String> getFrom();

    @Input
    @Option(option="to", description="schema to convert to")
    @NotNull
    public abstract Property<String> getTo();

    @Internal
    @NotNull
    public abstract String getProjectRootDir();

    public abstract void setProjectRootDir(@NotNull String var1);

    private final boolean isIntrospection(File $this$isIntrospection) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$isIntrospection), (Object)"json");
    }

    public final void convert(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (!(this.isIntrospection(from) && !this.isIntrospection(to) || !this.isIntrospection(from) && this.isIntrospection(to))) {
            boolean bl = false;
            String string = "Cannot convert from " + from.getName() + " to " + to.getName() + ", they are already the same format";
            throw new IllegalStateException(string.toString());
        }
        if (this.isIntrospection(from)) {
            GqlnodeKt.toUtf8$default((GQLNode)((GQLNode)Introspection.toGQLDocument((IntrospectionSchema)Introspection.toIntrospectionSchema((File)from))), (File)to, null, (int)2, null);
        } else {
            Introspection.writeTo((ApolloIntrospectionSchema)Introspection.toIntrospectionSchema((GQLDocument)GqldocumentKt.toFullSchemaGQLDocument((GQLDocument)ApolloParser.toGQLDocument$default((File)from, null, (boolean)false, (int)3, null))), (File)to);
        }
    }

    @TaskAction
    public final void taskAction() {
        File file = new File(this.getProjectRootDir());
        Object object = this.getFrom().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        File file2 = FilesKt.resolve((File)file, (String)((String)object));
        File file3 = new File(this.getProjectRootDir());
        Object object2 = this.getTo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.convert(file2, FilesKt.resolve((File)file3, (String)((String)object2)));
    }

    private static final boolean _init_$lambda$0(Task it) {
        return false;
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$2(Task it) {
        return false;
    }

    private static final boolean _init_$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

