/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.execution;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.ast.ApolloParser;
import com.apollographql.apollo.ast.GQLDefinition;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo.ast.GqldocumentKt;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.execution.Coercing;
import com.apollographql.apollo.execution.GraphQLRequest;
import com.apollographql.apollo.execution.GraphQLResponse;
import com.apollographql.apollo.execution.Instrumentation;
import com.apollographql.apollo.execution.PersistedDocumentCache;
import com.apollographql.apollo.execution.Resolver;
import com.apollographql.apollo.execution.RootResolver;
import com.apollographql.apollo.execution.SubscriptionEvent;
import com.apollographql.apollo.execution.SubscriptionResponse;
import com.apollographql.apollo.execution.ThrowingResolver;
import com.apollographql.apollo.execution.ThrowingTypeResolver;
import com.apollographql.apollo.execution.TypeResolver;
import com.apollographql.apollo.execution.internal.Either;
import com.apollographql.apollo.execution.internal.IntrospectionKt;
import com.apollographql.apollo.execution.internal.OperationContext;
import com.apollographql.apollo.execution.internal.PrepareKt;
import com.apollographql.apollo.execution.internal.PreparedRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/apollographql/apollo/execution/ExecutableSchema;", "", "schema", "Lcom/apollographql/apollo/ast/Schema;", "coercings", "", "", "Lcom/apollographql/apollo/execution/Coercing;", "queryRoot", "Lcom/apollographql/apollo/execution/RootResolver;", "mutationRoot", "subscriptionRoot", "resolver", "Lcom/apollographql/apollo/execution/Resolver;", "typeResolver", "Lcom/apollographql/apollo/execution/TypeResolver;", "instrumentations", "", "Lcom/apollographql/apollo/execution/Instrumentation;", "persistedDocumentCache", "Lcom/apollographql/apollo/execution/PersistedDocumentCache;", "<init>", "(Lcom/apollographql/apollo/ast/Schema;Ljava/util/Map;Lcom/apollographql/apollo/execution/RootResolver;Lcom/apollographql/apollo/execution/RootResolver;Lcom/apollographql/apollo/execution/RootResolver;Lcom/apollographql/apollo/execution/Resolver;Lcom/apollographql/apollo/execution/TypeResolver;Ljava/util/List;Lcom/apollographql/apollo/execution/PersistedDocumentCache;)V", "introspectionResolver", "execute", "Lcom/apollographql/apollo/execution/GraphQLResponse;", "request", "Lcom/apollographql/apollo/execution/GraphQLRequest;", "executionContext", "Lcom/apollographql/apollo/api/ExecutionContext;", "(Lcom/apollographql/apollo/execution/GraphQLRequest;Lcom/apollographql/apollo/api/ExecutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribe", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo/execution/SubscriptionEvent;", "operationContext", "Lcom/apollographql/apollo/execution/internal/OperationContext;", "preparedRequest", "Lcom/apollographql/apollo/execution/internal/PreparedRequest;", "Builder", "apollo-execution"})
@SourceDebugExtension(value={"SMAP\nExecutableSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutableSchema.kt\ncom/apollographql/apollo/execution/ExecutableSchema\n+ 2 arrow.kt\ncom/apollographql/apollo/execution/internal/Either\n*L\n1#1,153:1\n63#2,3:154\n63#2,3:157\n*S KotlinDebug\n*F\n+ 1 ExecutableSchema.kt\ncom/apollographql/apollo/execution/ExecutableSchema\n*L\n38#1:154,3\n52#1:157,3\n*E\n"})
public final class ExecutableSchema {
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, Coercing<?>> coercings;
    @Nullable
    private final RootResolver queryRoot;
    @Nullable
    private final RootResolver mutationRoot;
    @Nullable
    private final RootResolver subscriptionRoot;
    @NotNull
    private final Resolver resolver;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final List<Instrumentation> instrumentations;
    @Nullable
    private final PersistedDocumentCache persistedDocumentCache;
    @NotNull
    private final Resolver introspectionResolver;

    public ExecutableSchema(@NotNull Schema schema, @NotNull Map<String, ? extends Coercing<?>> coercings, @Nullable RootResolver queryRoot, @Nullable RootResolver mutationRoot, @Nullable RootResolver subscriptionRoot, @NotNull Resolver resolver, @NotNull TypeResolver typeResolver, @NotNull List<? extends Instrumentation> instrumentations, @Nullable PersistedDocumentCache persistedDocumentCache) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(coercings, (String)"coercings");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        this.schema = schema;
        this.coercings = coercings;
        this.queryRoot = queryRoot;
        this.mutationRoot = mutationRoot;
        this.subscriptionRoot = subscriptionRoot;
        this.resolver = resolver;
        this.typeResolver = typeResolver;
        this.instrumentations = instrumentations;
        this.persistedDocumentCache = persistedDocumentCache;
        this.introspectionResolver = IntrospectionKt.introspectionResolver(this.schema);
    }

    @Nullable
    public final Object execute(@NotNull GraphQLRequest request, @NotNull ExecutionContext executionContext, @NotNull Continuation<? super GraphQLResponse> $completion) {
        GraphQLResponse graphQLResponse;
        Either<List<Error>, PreparedRequest> this_$iv = PrepareKt.prepareRequest(this.schema, this.coercings, this.persistedDocumentCache, request);
        boolean $i$f$fold$apollo_execution = false;
        Either<List<Error>, PreparedRequest> either = this_$iv;
        if (either instanceof Either.Right) {
            PreparedRequest it = (PreparedRequest)((Either.Right)this_$iv).getValue();
            boolean bl = false;
            Object object = this.operationContext(it, executionContext).execute($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            graphQLResponse = (GraphQLResponse)object;
        } else if (either instanceof Either.Left) {
            List it = (List)((Either.Left)this_$iv).getValue();
            boolean bl = false;
            graphQLResponse = new GraphQLResponse.Builder().errors(it).build();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return graphQLResponse;
    }

    public static /* synthetic */ Object execute$default(ExecutableSchema executableSchema, GraphQLRequest graphQLRequest, ExecutionContext executionContext, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            executionContext = ExecutionContext.Empty;
        }
        return executableSchema.execute(graphQLRequest, executionContext, (Continuation<? super GraphQLResponse>)continuation);
    }

    @NotNull
    public final Flow<SubscriptionEvent> subscribe(@NotNull GraphQLRequest request, @NotNull ExecutionContext executionContext) {
        Flow flow;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Either<List<Error>, PreparedRequest> this_$iv = PrepareKt.prepareRequest(this.schema, this.coercings, this.persistedDocumentCache, request);
        boolean $i$f$fold$apollo_execution = false;
        Either<List<Error>, PreparedRequest> either = this_$iv;
        if (either instanceof Either.Right) {
            PreparedRequest it = (PreparedRequest)((Either.Right)this_$iv).getValue();
            boolean bl = false;
            flow = this.operationContext(it, executionContext).subscribe();
        } else if (either instanceof Either.Left) {
            List it = (List)((Either.Left)this_$iv).getValue();
            boolean bl = false;
            flow = FlowKt.flowOf((Object)new SubscriptionResponse(new GraphQLResponse.Builder().errors(it).build()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return flow;
    }

    public static /* synthetic */ Flow subscribe$default(ExecutableSchema executableSchema, GraphQLRequest graphQLRequest, ExecutionContext executionContext, int n, Object object) {
        if ((n & 2) != 0) {
            executionContext = ExecutionContext.Empty;
        }
        return executableSchema.subscribe(graphQLRequest, executionContext);
    }

    private final OperationContext operationContext(PreparedRequest preparedRequest, ExecutionContext executionContext) {
        return new OperationContext(this.schema, MapsKt.plus(this.coercings, IntrospectionKt.getIntrospectionCoercings()), this.introspectionResolver, this.queryRoot, this.mutationRoot, this.subscriptionRoot, this.resolver, this.typeResolver, this.instrumentations, preparedRequest.getOperation(), preparedRequest.getFragments(), preparedRequest.getVariables(), executionContext);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\bJ\u001a\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\b2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0006\u0010\u001c\u001a\u00020\u001dR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo/execution/ExecutableSchema$Builder;", "", "<init>", "()V", "schema", "Lcom/apollographql/apollo/ast/GQLDocument;", "coercings", "", "", "Lcom/apollographql/apollo/execution/Coercing;", "resolver", "Lcom/apollographql/apollo/execution/Resolver;", "queryRoot", "Lcom/apollographql/apollo/execution/RootResolver;", "mutationRoot", "subscriptionRoot", "typeResolver", "Lcom/apollographql/apollo/execution/TypeResolver;", "instrumentations", "", "Lcom/apollographql/apollo/execution/Instrumentation;", "persistedDocumentCache", "Lcom/apollographql/apollo/execution/PersistedDocumentCache;", "addCoercing", "type", "coercing", "addInstrumentation", "instrumentation", "build", "Lcom/apollographql/apollo/execution/ExecutableSchema;", "apollo-execution"})
    @SourceDebugExtension(value={"SMAP\nExecutableSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutableSchema.kt\ncom/apollographql/apollo/execution/ExecutableSchema$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n774#2:154\n865#2,2:155\n*S KotlinDebug\n*F\n+ 1 ExecutableSchema.kt\ncom/apollographql/apollo/execution/ExecutableSchema$Builder\n*L\n135#1:154\n135#1:155,2\n*E\n"})
    public static final class Builder {
        @Nullable
        private GQLDocument schema;
        @NotNull
        private final Map<String, Coercing<?>> coercings = new LinkedHashMap();
        @Nullable
        private Resolver resolver;
        @Nullable
        private RootResolver queryRoot;
        @Nullable
        private RootResolver mutationRoot;
        @Nullable
        private RootResolver subscriptionRoot;
        @Nullable
        private TypeResolver typeResolver;
        @NotNull
        private final List<Instrumentation> instrumentations = new ArrayList();
        @Nullable
        private PersistedDocumentCache persistedDocumentCache;

        @NotNull
        public final Builder schema(@NotNull GQLDocument schema) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Builder $this$schema_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$schema_u24lambda_u240.schema = schema;
            return builder;
        }

        @NotNull
        public final Builder schema(@NotNull String schema) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Builder $this$schema_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$schema_u24lambda_u241.schema(ApolloParser.toGQLDocument$default((String)schema, null, (int)1, null));
            return builder;
        }

        @NotNull
        public final Builder addCoercing(@NotNull String type, @NotNull Coercing<?> coercing) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(coercing, (String)"coercing");
            Builder $this$addCoercing_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addCoercing_u24lambda_u240.coercings.put(type, coercing);
            return builder;
        }

        @NotNull
        public final Builder queryRoot(@NotNull RootResolver queryRoot) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)queryRoot, (String)"queryRoot");
            Builder $this$queryRoot_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$queryRoot_u24lambda_u240.queryRoot = queryRoot;
            return builder;
        }

        @NotNull
        public final Builder mutationRoot(@NotNull RootResolver mutationRoot) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)mutationRoot, (String)"mutationRoot");
            Builder $this$mutationRoot_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$mutationRoot_u24lambda_u240.mutationRoot = mutationRoot;
            return builder;
        }

        @NotNull
        public final Builder subscriptionRoot(@NotNull RootResolver subscriptionRoot) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)subscriptionRoot, (String)"subscriptionRoot");
            Builder $this$subscriptionRoot_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$subscriptionRoot_u24lambda_u240.subscriptionRoot = subscriptionRoot;
            return builder;
        }

        @NotNull
        public final Builder resolver(@NotNull Resolver resolver) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Builder $this$resolver_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$resolver_u24lambda_u240.resolver = resolver;
            return builder;
        }

        @NotNull
        public final Builder typeResolver(@NotNull TypeResolver typeResolver) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
            Builder $this$typeResolver_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$typeResolver_u24lambda_u240.typeResolver = typeResolver;
            return builder;
        }

        @NotNull
        public final Builder addInstrumentation(@NotNull Instrumentation instrumentation) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
            Builder $this$addInstrumentation_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addInstrumentation_u24lambda_u240.instrumentations.add(instrumentation);
            return builder;
        }

        @NotNull
        public final Builder persistedDocumentCache(@Nullable PersistedDocumentCache persistedDocumentCache) {
            Builder builder;
            Builder $this$persistedDocumentCache_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$persistedDocumentCache_u24lambda_u240.persistedDocumentCache = persistedDocumentCache;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ExecutableSchema build() {
            TypeResolver typeResolver;
            void $this$filterTo$iv$iv;
            if (!(this.schema != null)) {
                boolean $i$a$-check-ExecutableSchema$Builder$build$22 = false;
                String $i$a$-check-ExecutableSchema$Builder$build$22 = "A schema is required to build an ExecutableSchema";
                throw new IllegalStateException($i$a$-check-ExecutableSchema$Builder$build$22.toString());
            }
            Iterable $this$filter$iv = GqldocumentKt.builtinDefinitions();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GQLDefinition it = (GQLDefinition)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof GQLScalarTypeDefinition))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            GQLDocument gQLDocument = this.schema;
            Intrinsics.checkNotNull((Object)gQLDocument);
            List definitions = CollectionsKt.plus((Collection)collection, (Iterable)gQLDocument.getDefinitions());
            Schema schema = GqldocumentKt.toSchema((GQLDocument)new GQLDocument(definitions, null));
            Resolver resolver = this.resolver;
            if (resolver == null) {
                resolver = ThrowingResolver.INSTANCE;
            }
            if ((typeResolver = this.typeResolver) == null) {
                typeResolver = ThrowingTypeResolver.INSTANCE;
            }
            return new ExecutableSchema(schema, this.coercings, this.queryRoot, this.mutationRoot, this.subscriptionRoot, resolver, typeResolver, this.instrumentations, this.persistedDocumentCache);
        }
    }
}

