/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.execution.internal;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.ast.ApolloParser;
import com.apollographql.apollo.ast.ExecutableValidationResult;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.GQLFragmentDefinition;
import com.apollographql.apollo.ast.GQLOperationDefinition;
import com.apollographql.apollo.ast.GQLResult;
import com.apollographql.apollo.ast.GraphQLIssue;
import com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.execution.Coercing;
import com.apollographql.apollo.execution.ErrorPersistedDocument;
import com.apollographql.apollo.execution.GraphQLRequest;
import com.apollographql.apollo.execution.PersistedDocument;
import com.apollographql.apollo.execution.PersistedDocumentCache;
import com.apollographql.apollo.execution.ValidPersistedDocument;
import com.apollographql.apollo.execution.internal.ArrowKt;
import com.apollographql.apollo.execution.internal.CoerceVariablesValuesKt;
import com.apollographql.apollo.execution.internal.DefaultRaise;
import com.apollographql.apollo.execution.internal.Either;
import com.apollographql.apollo.execution.internal.ErrorsKt;
import com.apollographql.apollo.execution.internal.PreparedRequest;
import com.apollographql.apollo.execution.internal.Raise;
import com.apollographql.apollo.execution.internal.RaiseCancellationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a^\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0018\u00010\u0011j\u0002`\u00120\rH\u0000\u001a,\u0010\u0013\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u001e\u0010\u0019\u001a\u00020\u0014*\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001H\u0002\u001aJ\u0010\t\u001a\u00020\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001aL\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0002\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a8\u0006\u001b"}, d2={"validateDocument", "Lcom/apollographql/apollo/execution/internal/Either;", "", "Lcom/apollographql/apollo/ast/Issue;", "Lcom/apollographql/apollo/ast/GQLDocument;", "schema", "Lcom/apollographql/apollo/ast/Schema;", "document", "", "prepareRequest", "Lcom/apollographql/apollo/execution/internal/PreparedRequest;", "Lcom/apollographql/apollo/execution/internal/Raise;", "coercings", "", "Lcom/apollographql/apollo/execution/Coercing;", "operationName", "variables", "", "Lcom/apollographql/apollo/execution/ExternalValue;", "getPersistedDocument", "Lcom/apollographql/apollo/execution/PersistedDocument;", "persistedDocumentCache", "Lcom/apollographql/apollo/execution/PersistedDocumentCache;", "request", "Lcom/apollographql/apollo/execution/GraphQLRequest;", "toPersistedDocument", "Lcom/apollographql/apollo/api/Error;", "apollo-execution"})
@SourceDebugExtension(value={"SMAP\nprepare.kt\nKotlin\n*S Kotlin\n*F\n+ 1 prepare.kt\ncom/apollographql/apollo/execution/internal/PrepareKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 arrow.kt\ncom/apollographql/apollo/execution/internal/Either\n+ 4 arrow.kt\ncom/apollographql/apollo/execution/internal/ArrowKt\n*L\n1#1,180:1\n774#2:181\n865#2,2:182\n774#2:184\n865#2,2:185\n808#2,11:187\n295#2,2:198\n808#2,11:200\n1208#2,2:211\n1236#2,4:213\n63#3,3:217\n263#4:220\n275#4:221\n201#4,11:222\n263#4:233\n275#4:234\n201#4,11:235\n171#4:246\n185#4:247\n201#4,11:248\n*S KotlinDebug\n*F\n+ 1 prepare.kt\ncom/apollographql/apollo/execution/internal/PrepareKt\n*L\n30#1:181\n30#1:182,2\n37#1:184\n37#1:185,2\n61#1:187,11\n75#1:198,2\n82#1:200,11\n82#1:211,2\n82#1:213,4\n139#1:217,3\n154#1:220\n154#1:221\n154#1:222,11\n166#1:233\n166#1:234\n166#1:235,11\n178#1:246\n178#1:247\n178#1:248,11\n*E\n"})
public final class PrepareKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Either<List<Issue>, GQLDocument> validateDocument(@NotNull Schema schema, @NotNull String document) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        GQLResult parseResult = ApolloParser.parseAsGQLDocument$default((String)document, null, (int)1, null);
        Iterable $this$filter$iv = parseResult.getIssues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Issue it = (Issue)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof GraphQLIssue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List issues = (List)destination$iv$iv;
        if (!((Collection)issues).isEmpty()) {
            return ArrowKt.left(issues);
        }
        GQLDocument gqlDocument = (GQLDocument)parseResult.getOrThrow();
        ExecutableValidationResult validationResult = ApolloParser.validateAsExecutable((GQLDocument)gqlDocument, (Schema)schema);
        Iterable $this$filter$iv2 = validationResult.getIssues();
        boolean $i$f$filter2 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Issue it = (Issue)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof GraphQLIssue)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        issues = (List)destination$iv$iv2;
        if (!((Collection)issues).isEmpty()) {
            return ArrowKt.left(issues);
        }
        return ArrowKt.right(gqlDocument);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PreparedRequest prepareRequest(@NotNull Raise<? super String> $this$prepareRequest, @NotNull Schema schema, @NotNull Map<String, ? extends Coercing<?>> coercings, @NotNull GQLDocument document, @Nullable String operationName, @NotNull Map<String, ? extends Object> variables) {
        Map<String, Object> map2;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        GQLOperationDefinition gQLOperationDefinition;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$prepareRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(coercings, (String)"coercings");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Iterable $this$filterIsInstance$iv = document.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List operations = (List)destination$iv$iv;
        if (operations.isEmpty()) {
            $this$prepareRequest.raise("The document does not contain any operation.");
            throw new KotlinNothingValueException();
        }
        if (operations.size() == 1) {
            gQLOperationDefinition = (GQLOperationDefinition)CollectionsKt.first((List)operations);
        } else {
            Object v1;
            block11: {
                if (operationName == null) {
                    $this$prepareRequest.raise("The document contains multiple operations. Use 'operationName' to indicate which one to execute.");
                    throw new KotlinNothingValueException();
                }
                Iterable $this$firstOrNull$iv = operations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GQLOperationDefinition it = (GQLOperationDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)operationName)) continue;
                    v1 = element$iv;
                    break block11;
                }
                v1 = null;
            }
            GQLOperationDefinition ret = v1;
            if (ret == null) {
                $this$prepareRequest.raise("No operation named '" + operationName + "' found. Double check operationName.");
                throw new KotlinNothingValueException();
            }
            gQLOperationDefinition = ret;
        }
        GQLOperationDefinition operation = gQLOperationDefinition;
        Iterable $this$filterIsInstance$iv2 = document.getDefinitions();
        boolean $i$f$filterIsInstance2 = false;
        Iterable $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)element$iv$iv;
            Map map3 = destination$iv$iv3;
            boolean bl = false;
            map3.put(it.getName(), element$iv$iv);
        }
        Map fragments = destination$iv$iv3;
        try {
            map2 = CoerceVariablesValuesKt.coerceVariableValues(schema, operation.getVariableDefinitions(), variables, coercings);
        }
        catch (Exception e) {
            $this$prepareRequest.raise("Cannot coerce variable values: '" + e.getMessage() + '\'');
            throw new KotlinNothingValueException();
        }
        Map<String, Object> variableValues = map2;
        return new PreparedRequest(operation, fragments, variableValues);
    }

    @NotNull
    public static final PersistedDocument getPersistedDocument(@NotNull Raise<? super String> $this$getPersistedDocument, @NotNull Schema schema, @Nullable PersistedDocumentCache persistedDocumentCache, @NotNull GraphQLRequest request) {
        Intrinsics.checkNotNullParameter($this$getPersistedDocument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object persistedQuery = request.getExtensions().get("persistedQuery");
        PersistedDocument persistedDocument = null;
        if (persistedQuery != null) {
            String id;
            if (persistedDocumentCache == null) {
                $this$getPersistedDocument.raise("PersistedQueryNotSupported");
                throw new KotlinNothingValueException();
            }
            if (!(persistedQuery instanceof Map)) {
                $this$getPersistedDocument.raise("Expected 'persistedQuery' to be an object.");
                throw new KotlinNothingValueException();
            }
            Map cfr_ignored_0 = (Map)persistedQuery;
            Object v = ((Map)persistedQuery).get("sha256Hash");
            String string = id = v instanceof String ? (String)v : null;
            if (id == null) {
                $this$getPersistedDocument.raise("'persistedQuery.sha256Hash' not found or not a string.");
                throw new KotlinNothingValueException();
            }
            persistedDocument = persistedDocumentCache.get(id);
            if (persistedDocument == null) {
                if (request.getDocument() == null) {
                    $this$getPersistedDocument.raise("PersistedQueryNotFound");
                    throw new KotlinNothingValueException();
                }
                persistedDocument = PrepareKt.toPersistedDocument(PrepareKt.validateDocument(schema, request.getDocument()));
                persistedDocumentCache.put(id, persistedDocument);
            }
        } else {
            if (request.getDocument() == null) {
                $this$getPersistedDocument.raise("no GraphQL document found");
                throw new KotlinNothingValueException();
            }
            persistedDocument = PrepareKt.toPersistedDocument(PrepareKt.validateDocument(schema, request.getDocument()));
        }
        return persistedDocument;
    }

    private static final PersistedDocument toPersistedDocument(Either<? extends List<? extends Issue>, GQLDocument> $this$toPersistedDocument) {
        PersistedDocument persistedDocument;
        Either<? extends List<? extends Issue>, GQLDocument> this_$iv = $this$toPersistedDocument;
        boolean $i$f$fold$apollo_execution = false;
        Either<? extends List<? extends Issue>, GQLDocument> either = this_$iv;
        if (either instanceof Either.Right) {
            GQLDocument it = (GQLDocument)((Either.Right)this_$iv).getValue();
            boolean bl = false;
            persistedDocument = new ValidPersistedDocument(it);
        } else if (either instanceof Either.Left) {
            List it = (List)((Either.Left)this_$iv).getValue();
            boolean bl = false;
            persistedDocument = new ErrorPersistedDocument(it);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return persistedDocument;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PreparedRequest prepareRequest(@NotNull Raise<? super List<Error>> $this$prepareRequest, @NotNull Schema schema, @NotNull Map<String, ? extends Coercing<?>> coercings, @Nullable PersistedDocumentCache persistedDocumentCache, @NotNull GraphQLRequest request) {
        PreparedRequest preparedRequest;
        Object $this$prepareRequest_u24lambda_u245;
        PersistedDocument persistedDocument;
        boolean bl;
        Raise $this$withError_u24lambda_u240$iv;
        Intrinsics.checkNotNullParameter($this$prepareRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(coercings, (String)"coercings");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Raise<? super List<Error>> $this$withError$iv = $this$prepareRequest;
        boolean $i$f$withError = false;
        boolean $i$f$recover = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            $this$withError_u24lambda_u240$iv = raise$iv$iv$iv;
            bl = false;
            Raise $this$prepareRequest_u24lambda_u243 = $this$withError_u24lambda_u240$iv;
            boolean bl2 = false;
            persistedDocument = PrepareKt.getPersistedDocument($this$prepareRequest_u24lambda_u243, schema, persistedDocumentCache, request);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            void it;
            raise$iv$iv$iv.complete$apollo_execution();
            Object it$iv = ArrowKt.raisedOrRethrow(e$iv$iv$iv, raise$iv$iv$iv);
            boolean bl3 = false;
            String $this$prepareRequest_u24lambda_u243 = (String)it$iv;
            Raise<? super List<Error>> raise = $this$withError$iv;
            boolean bl4 = false;
            raise.raise(ErrorsKt.singleGraphQLError((String)it));
            throw new KotlinNothingValueException();
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete$apollo_execution();
            Throwable it$iv$iv = ArrowKt.nonFatalOrThrow(e$iv$iv$iv);
            boolean bl5 = false;
            throw it$iv$iv;
        }
        PersistedDocument persistedDocument2 = persistedDocument;
        if (persistedDocument2 instanceof ErrorPersistedDocument) {
            $this$prepareRequest.raise(ErrorsKt.toErrors(((ErrorPersistedDocument)persistedDocument2).getIssues()));
            throw new KotlinNothingValueException();
        }
        if (!(persistedDocument2 instanceof ValidPersistedDocument)) {
            throw new IllegalStateException("Check failed.");
        }
        $this$withError$iv = $this$prepareRequest;
        $i$f$withError = false;
        $i$f$recover = false;
        $i$f$_fold = false;
        raise$iv$iv$iv = new DefaultRaise(false);
        try {
            $this$withError_u24lambda_u240$iv = raise$iv$iv$iv;
            bl = false;
            $this$prepareRequest_u24lambda_u245 = $this$withError_u24lambda_u240$iv;
            boolean bl6 = false;
            preparedRequest = PrepareKt.prepareRequest((Raise<? super String>)$this$prepareRequest_u24lambda_u245, schema, coercings, ((ValidPersistedDocument)persistedDocument2).getDocument(), request.getOperationName(), request.getVariables());
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            void it;
            raise$iv$iv$iv.complete$apollo_execution();
            Object it$iv = ArrowKt.raisedOrRethrow(e$iv$iv$iv, raise$iv$iv$iv);
            boolean bl7 = false;
            $this$prepareRequest_u24lambda_u245 = (String)it$iv;
            Raise<? super List<Error>> raise = $this$withError$iv;
            boolean bl8 = false;
            raise.raise(ErrorsKt.singleGraphQLError((String)it));
            throw new KotlinNothingValueException();
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete$apollo_execution();
            Throwable it$iv$iv = ArrowKt.nonFatalOrThrow(e$iv$iv$iv);
            boolean bl9 = false;
            throw it$iv$iv;
        }
        return preparedRequest;
    }

    @NotNull
    public static final Either<List<Error>, PreparedRequest> prepareRequest(@NotNull Schema schema, @NotNull Map<String, ? extends Coercing<?>> coercings, @Nullable PersistedDocumentCache persistedDocumentCache, @NotNull GraphQLRequest request) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(coercings, (String)"coercings");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            Raise $this$prepareRequest_u24lambda_u246 = raise$iv$iv$iv;
            boolean bl = false;
            PreparedRequest res$iv$iv$iv = PrepareKt.prepareRequest($this$prepareRequest_u24lambda_u246, schema, coercings, persistedDocumentCache, request);
            raise$iv$iv$iv.complete$apollo_execution();
            PreparedRequest it$iv = res$iv$iv$iv;
            boolean bl2 = false;
            either = new Either.Right<PreparedRequest>(it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete$apollo_execution();
            Object it$iv = ArrowKt.raisedOrRethrow(e$iv$iv$iv, raise$iv$iv$iv);
            boolean bl = false;
            either = new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete$apollo_execution();
            Throwable it$iv$iv = ArrowKt.nonFatalOrThrow(e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }
}

