/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.execution.internal;

import com.apollographql.apollo.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo.ast.GQLEnumValueDefinition;
import com.apollographql.apollo.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLInputValueDefinition;
import com.apollographql.apollo.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo.ast.GQLListType;
import com.apollographql.apollo.ast.GQLNamedType;
import com.apollographql.apollo.ast.GQLNonNullType;
import com.apollographql.apollo.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo.ast.GQLType;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo.ast.GQLValue;
import com.apollographql.apollo.ast.GQLVariableDefinition;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.execution.Coercing;
import com.apollographql.apollo.execution.CoercingKt;
import com.apollographql.apollo.execution.internal.CoerceArgumentValuesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001ab\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0018\u00010\u0003j\u0002`\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0018\u00010\u0003j\u0002`\u000b0\u00012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0001H\u0000\u001aD\u0010\u000e\u001a\b\u0018\u00010\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0018\u00010\u0003j\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0001H\u0002\u001a<\u0010\u0012\u001a\b\u0018\u00010\u0003j\u0002`\u00042\f\u0010\u000f\u001a\b\u0018\u00010\u0003j\u0002`\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001aD\u0010\u0015\u001a\b\u0018\u00010\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0018\u00010\u0003j\u0002`\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0001H\u0002\u00a8\u0006\u0018"}, d2={"coerceVariableValues", "", "", "", "Lcom/apollographql/apollo/execution/InternalValue;", "schema", "Lcom/apollographql/apollo/ast/Schema;", "variableDefinitions", "", "Lcom/apollographql/apollo/ast/GQLVariableDefinition;", "variables", "Lcom/apollographql/apollo/execution/ExternalValue;", "coercings", "Lcom/apollographql/apollo/execution/Coercing;", "coerceExternalToInternal", "value", "type", "Lcom/apollographql/apollo/ast/GQLType;", "coerceEnumExternalToInternal", "definition", "Lcom/apollographql/apollo/ast/GQLEnumTypeDefinition;", "coerceInputObject", "Lcom/apollographql/apollo/ast/GQLInputObjectTypeDefinition;", "externalValue", "apollo-execution"})
@SourceDebugExtension(value={"SMAP\ncoerceVariablesValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coerceVariablesValues.kt\ncom/apollographql/apollo/execution/internal/CoerceVariablesValuesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1863#2,2:151\n1557#2:153\n1628#2,3:154\n1755#2,3:157\n1557#2:160\n1628#2,3:161\n1611#2,9:164\n1863#2:173\n1864#2:175\n1620#2:176\n1#3:174\n*S KotlinDebug\n*F\n+ 1 coerceVariablesValues.kt\ncom/apollographql/apollo/execution/internal/CoerceVariablesValuesKt\n*L\n28#1:151,2\n69#1:153\n69#1:154,3\n110#1:157,3\n111#1:160\n111#1:161,3\n125#1:164,9\n125#1:173\n125#1:175\n125#1:176\n125#1:174\n*E\n"})
public final class CoerceVariablesValuesKt {
    @NotNull
    public static final Map<String, Object> coerceVariableValues(@NotNull Schema schema, @NotNull List<GQLVariableDefinition> variableDefinitions, @NotNull Map<String, ? extends Object> variables, @NotNull Map<String, ? extends Coercing<?>> coercings) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(variableDefinitions, (String)"variableDefinitions");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(coercings, (String)"coercings");
        Map coercedValues = new LinkedHashMap();
        Iterable $this$forEach$iv = variableDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLVariableDefinition variableDefinition = (GQLVariableDefinition)element$iv;
            boolean bl = false;
            boolean hasValue = variables.containsKey(variableDefinition.getName());
            if (hasValue) {
                GQLValue defaultValue = variableDefinition.getDefaultValue();
                if (defaultValue != null) {
                    coercedValues.put(variableDefinition.getName(), CoerceArgumentValuesKt.coerceInputLiteralToInternal(schema, defaultValue, variableDefinition.getType(), coercings, null));
                    continue;
                }
                if (!(variableDefinition.getType() instanceof GQLNonNullType)) continue;
                throw new IllegalStateException(("No variable found for variable of non-null type '" + variableDefinition.getName() + '\'').toString());
            }
            Object value = variables.get(variableDefinition.getName());
            coercedValues.put(variableDefinition.getName(), CoerceVariablesValuesKt.coerceExternalToInternal(schema, value, variableDefinition.getType(), coercings));
        }
        return coercedValues;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object coerceExternalToInternal(Schema schema, Object value, GQLType type, Map<String, ? extends Coercing<?>> coercings) {
        Object object;
        if (value == null) {
            if (!(type instanceof GQLNonNullType)) {
                return null;
            }
            boolean bl = false;
            if (bl) return null;
            boolean bl2 = false;
            throw new IllegalStateException("'null' found in non-null position".toString());
        }
        GQLType gQLType = type;
        if (gQLType instanceof GQLNonNullType) {
            object = CoerceVariablesValuesKt.coerceExternalToInternal(schema, value, ((GQLNonNullType)type).getType(), coercings);
            return object;
        } else if (gQLType instanceof GQLListType) {
            if (value instanceof List) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CoerceVariablesValuesKt.coerceExternalToInternal(schema, it, ((GQLListType)type).getType(), coercings));
                }
                object = (List)destination$iv$iv;
                return object;
            } else {
                object = CollectionsKt.listOf((Object)CoerceVariablesValuesKt.coerceExternalToInternal(schema, value, ((GQLListType)type).getType(), coercings));
            }
            return object;
        } else {
            if (!(gQLType instanceof GQLNamedType)) throw new NoWhenBranchMatchedException();
            GQLTypeDefinition definition = schema.typeDefinition(((GQLNamedType)type).getName());
            GQLTypeDefinition gQLTypeDefinition = definition;
            if (gQLTypeDefinition instanceof GQLEnumTypeDefinition) {
                object = CoerceVariablesValuesKt.coerceEnumExternalToInternal(value, coercings, (GQLEnumTypeDefinition)definition);
                return object;
            } else if (gQLTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                object = CoerceVariablesValuesKt.coerceInputObject(schema, (GQLInputObjectTypeDefinition)definition, value, coercings);
                return object;
            } else {
                if (gQLTypeDefinition instanceof GQLInterfaceTypeDefinition) throw new IllegalStateException(("Output type '" + definition.getName() + "' cannot be used in input position").toString());
                if (gQLTypeDefinition instanceof GQLObjectTypeDefinition) throw new IllegalStateException(("Output type '" + definition.getName() + "' cannot be used in input position").toString());
                if (gQLTypeDefinition instanceof GQLUnionTypeDefinition) {
                    throw new IllegalStateException(("Output type '" + definition.getName() + "' cannot be used in input position").toString());
                }
                if (!(gQLTypeDefinition instanceof GQLScalarTypeDefinition)) throw new NoWhenBranchMatchedException();
                object = CoercingKt.scalarCoercingDeserialize(value, coercings, ((GQLScalarTypeDefinition)definition).getName());
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object coerceEnumExternalToInternal(@Nullable Object value, @NotNull Map<String, ? extends Coercing<?>> coercings, @NotNull GQLEnumTypeDefinition definition) {
        Object object;
        Intrinsics.checkNotNullParameter(coercings, (String)"coercings");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        if (!(value instanceof String)) {
            boolean bl = false;
            throw new IllegalStateException(("Don't know how to coerce '" + value + "' to a '" + definition.getName() + "' enum value").toString());
        }
        Coercing<?> coercing = coercings.get(definition.getName());
        if (coercing == null) {
            Object it;
            boolean bl;
            block8: {
                Iterable $this$any$iv = definition.getEnumValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (GQLEnumValueDefinition)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)value)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                Iterable $this$map$iv = definition.getEnumValues();
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    GQLEnumValueDefinition gQLEnumValueDefinition = (GQLEnumValueDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it2.getName());
                }
                Set possibleValues = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                String string = '\'' + (String)value + "' cannot be coerced to a '" + definition.getName() + "' enum value. Possible values are: '" + possibleValues + '\'';
                throw new IllegalStateException(string.toString());
            }
            object = value;
        } else {
            object = coercing.deserialize(value);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object coerceInputObject(Schema schema, GQLInputObjectTypeDefinition definition, Object externalValue, Map<String, ? extends Coercing<?>> coercings) {
        void $this$mapNotNullTo$iv$iv;
        if (!(externalValue instanceof Map)) {
            throw new IllegalStateException(("Don't know how to coerce '" + externalValue + "' to a '" + definition.getName() + "' input object").toString());
        }
        Iterable $this$mapNotNull$iv = definition.getInputFields();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GQLInputValueDefinition inputValueDefinition = (GQLInputValueDefinition)element$iv$iv;
            boolean bl2 = false;
            GQLType inputFieldType = inputValueDefinition.getType();
            if (!((Map)externalValue).containsKey(inputValueDefinition.getName())) {
                if (inputValueDefinition.getDefaultValue() != null) {
                    String string = inputValueDefinition.getName();
                    GQLValue gQLValue = inputValueDefinition.getDefaultValue();
                    Intrinsics.checkNotNull((Object)gQLValue);
                    pair = TuplesKt.to((Object)string, (Object)CoerceArgumentValuesKt.coerceInputLiteralToInternal(schema, gQLValue, inputFieldType, coercings, null));
                } else {
                    if (inputFieldType instanceof GQLNonNullType) {
                        throw new IllegalStateException(("Missing input field '" + inputValueDefinition.getName()).toString());
                    }
                    pair = null;
                }
            } else {
                Object inputFieldValue = ((Map)externalValue).get(inputValueDefinition.getName());
                pair = TuplesKt.to((Object)inputValueDefinition.getName(), (Object)CoerceVariablesValuesKt.coerceExternalToInternal(schema, inputFieldValue, inputFieldType, coercings));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Coercing<?> coercing = coercings.get(definition.getName());
        return coercing != null ? coercing.deserialize(map2) : map2;
    }
}

