/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.codegen.kotlin.schema;

import com.apollographql.apollo.compiler.codegen.LayoutImplKt;
import com.apollographql.apollo.compiler.codegen.SchemaLayout;
import com.apollographql.apollo.compiler.codegen.kotlin.CgFile;
import com.apollographql.apollo.compiler.codegen.kotlin.CgFileBuilder;
import com.apollographql.apollo.compiler.codegen.kotlin.KotlinSchemaContext;
import com.apollographql.apollo.compiler.codegen.kotlin.KotlinSymbols;
import com.apollographql.apollo.compiler.codegen.kotlin.helpers.KDocKt;
import com.apollographql.apollo.compiler.codegen.kotlin.schema.ScalarBuilderKt;
import com.apollographql.apollo.compiler.codegen.kotlin.schema.util.TypesBuilderKt;
import com.apollographql.apollo.compiler.ir.BuiltInType;
import com.apollographql.apollo.compiler.ir.IrScalar;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0005H\u0002J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo/compiler/codegen/kotlin/schema/ScalarBuilder;", "Lcom/apollographql/apollo/compiler/codegen/kotlin/CgFileBuilder;", "context", "Lcom/apollographql/apollo/compiler/codegen/kotlin/KotlinSchemaContext;", "scalar", "Lcom/apollographql/apollo/compiler/ir/IrScalar;", "inlineClassName", "Lcom/squareup/kotlinpoet/ClassName;", "(Lcom/apollographql/apollo/compiler/codegen/kotlin/KotlinSchemaContext;Lcom/apollographql/apollo/compiler/ir/IrScalar;Lcom/squareup/kotlinpoet/ClassName;)V", "layout", "Lcom/apollographql/apollo/compiler/codegen/SchemaLayout;", "packageName", "", "simpleName", "build", "Lcom/apollographql/apollo/compiler/codegen/kotlin/CgFile;", "prefixBuiltinScalarNames", "name", "prepare", "", "companionTypeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "typeSpec", "apollo-compiler"})
public final class ScalarBuilder
implements CgFileBuilder {
    @NotNull
    private final KotlinSchemaContext context;
    @NotNull
    private final IrScalar scalar;
    @Nullable
    private final ClassName inlineClassName;
    @NotNull
    private final SchemaLayout layout;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleName;

    public ScalarBuilder(@NotNull KotlinSchemaContext context, @NotNull IrScalar scalar, @Nullable ClassName inlineClassName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
        this.context = context;
        this.scalar = scalar;
        this.inlineClassName = inlineClassName;
        this.layout = this.context.getLayout();
        this.packageName = LayoutImplKt.typePackageName(this.layout);
        this.simpleName = this.prefixBuiltinScalarNames(this.layout.schemaTypeName(this.scalar.getName()));
    }

    private final String prefixBuiltinScalarNames(String name) {
        Object[] objectArray = new String[]{"String", "Boolean", "Int", "Float", "ID"};
        if (ArraysKt.contains((Object[])objectArray, (Object)name)) {
            return "GraphQL" + name;
        }
        return name;
    }

    @Override
    public void prepare() {
        block49: {
            MemberName memberName;
            ClassName className;
            block50: {
                MemberName memberName2;
                block48: {
                    String[] stringArray = new String[]{this.simpleName};
                    this.context.getResolver().registerSchemaType(this.scalar.getName(), new ClassName(this.packageName, stringArray));
                    if (this.scalar.getMapTo() == null) break block48;
                    this.context.getResolver().registerScalarTarget(this.scalar.getName(), this.scalar.getMapTo().getName());
                    if (this.scalar.getMapTo().getAdapter() != null) {
                        this.context.getResolver().registerScalarAdapter(this.scalar.getName(), this.scalar.getMapTo().getAdapter());
                    }
                    if (this.scalar.getMapTo().getInlineProperty() != null) {
                        this.context.getResolver().registerScalarInlineProperty(this.scalar.getName(), this.scalar.getMapTo().getInlineProperty());
                    }
                    this.context.getResolver().registerScalarIsUserDefined(this.scalar.getName());
                    break block49;
                }
                if (this.scalar.getMapToBuiltIn() == null) break block50;
                if (this.inlineClassName != null) {
                    this.context.getResolver().registerScalarTarget(this.scalar.getName(), this.inlineClassName.getCanonicalName());
                } else {
                    this.context.getResolver().registerScalarTarget(this.scalar.getName(), ScalarBuilderKt.asTargetClassName(this.scalar.getMapToBuiltIn().getBuiltIn()).getCanonicalName());
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.scalar.getMapToBuiltIn().getBuiltIn().ordinal()]) {
                    case 1: {
                        memberName2 = KotlinSymbols.INSTANCE.getStringAdapter();
                        break;
                    }
                    case 2: {
                        memberName2 = KotlinSymbols.INSTANCE.getBooleanAdapter();
                        break;
                    }
                    case 3: {
                        memberName2 = KotlinSymbols.INSTANCE.getIntAdapter();
                        break;
                    }
                    case 4: {
                        memberName2 = KotlinSymbols.INSTANCE.getLongAdapter();
                        break;
                    }
                    case 5: {
                        memberName2 = KotlinSymbols.INSTANCE.getFloatAdapter();
                        break;
                    }
                    case 6: {
                        memberName2 = KotlinSymbols.INSTANCE.getDoubleAdapter();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String adapter = memberName2.getCanonicalName();
                this.context.getResolver().registerScalarAdapter(this.scalar.getName(), adapter);
                this.context.getResolver().registerScalarIsUserDefined(this.scalar.getName());
                break block49;
            }
            switch (this.scalar.getName()) {
                case "String": 
                case "ID": {
                    className = KotlinSymbols.INSTANCE.getString();
                    break;
                }
                case "Int": {
                    className = KotlinSymbols.INSTANCE.getInt();
                    break;
                }
                case "Boolean": {
                    className = KotlinSymbols.INSTANCE.getBoolean();
                    break;
                }
                case "Float": {
                    className = KotlinSymbols.INSTANCE.getDouble();
                    break;
                }
                default: {
                    className = KotlinSymbols.INSTANCE.getAny();
                }
            }
            String target = className.getCanonicalName();
            this.context.getResolver().registerScalarTarget(this.scalar.getName(), target);
            switch (this.scalar.getName()) {
                case "String": 
                case "ID": {
                    memberName = KotlinSymbols.INSTANCE.getStringAdapter();
                    break;
                }
                case "Int": {
                    memberName = KotlinSymbols.INSTANCE.getIntAdapter();
                    break;
                }
                case "Boolean": {
                    memberName = KotlinSymbols.INSTANCE.getBooleanAdapter();
                    break;
                }
                case "Float": {
                    memberName = KotlinSymbols.INSTANCE.getDoubleAdapter();
                    break;
                }
                default: {
                    memberName = KotlinSymbols.INSTANCE.getAnyAdapter();
                }
            }
            String adapter = memberName.getCanonicalName();
            this.context.getResolver().registerScalarAdapter(this.scalar.getName(), adapter);
        }
    }

    @Override
    @NotNull
    public CgFile build() {
        String string = this.packageName;
        String string2 = this.simpleName;
        List list = CollectionsKt.listOf((Object)this.typeSpec(this.scalar));
        return new CgFile(string, list, null, null, string2, null, 44, null);
    }

    private final TypeSpec typeSpec(IrScalar $this$typeSpec) {
        return KDocKt.maybeAddDeprecation(KDocKt.maybeAddDescription(TypeSpec.Companion.classBuilder(this.simpleName), $this$typeSpec.getDescription()), $this$typeSpec.getDeprecationReason()).addType(this.companionTypeSpec($this$typeSpec)).build();
    }

    private final TypeSpec companionTypeSpec(IrScalar $this$companionTypeSpec) {
        return TypeSpec.Companion.companionObjectBuilder$default((TypeSpec.Companion)TypeSpec.Companion, null, (int)1, null).addProperty(TypesBuilderKt.typePropertySpec($this$companionTypeSpec, this.context.getResolver().resolveScalarTarget($this$companionTypeSpec.getName()))).build();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuiltInType.values().length];
            try {
                nArray[BuiltInType.String.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInType.Boolean.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInType.Int.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInType.Long.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInType.Float.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInType.Double.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

