/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.internal;

import com.apollographql.apollo.ast.GQLDefinition;
import com.apollographql.apollo.ast.GQLField;
import com.apollographql.apollo.ast.GQLFragmentDefinition;
import com.apollographql.apollo.ast.GQLFragmentSpread;
import com.apollographql.apollo.ast.GQLInlineFragment;
import com.apollographql.apollo.ast.GQLOperationDefinition;
import com.apollographql.apollo.ast.GQLSelection;
import com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.ast.UpperCaseField;
import com.apollographql.apollo.compiler.internal.-checkCapitalizedFields;
import com.apollographql.apollo.compiler.internal.ValidationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u001a(\u0010\u0000\u001a\u00020\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0001H\u0002\u00a8\u0006\u0010"}, d2={"checkCapitalizedFields", "", "Lcom/apollographql/apollo/ast/Issue;", "definitions", "Lcom/apollographql/apollo/ast/GQLDefinition;", "checkFragmentsOnly", "", "decapitalizeFirstLetter", "", "name", "isFirstLetterUpperCase", "", "Lcom/apollographql/apollo/compiler/internal/ValidationScope;", "selections", "Lcom/apollographql/apollo/ast/GQLSelection;", "checkedFragments", "apollo-compiler"})
@JvmName(name="-checkCapitalizedFields")
@SourceDebugExtension(value={"SMAP\ncheckCapitalizedFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 checkCapitalizedFields.kt\ncom/apollographql/apollo/compiler/internal/-checkCapitalizedFields\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,101:1\n1869#2,2:102\n1869#2:104\n1870#2:106\n1#3:105\n130#4,2:107\n1179#4,2:109\n*S KotlinDebug\n*F\n+ 1 checkCapitalizedFields.kt\ncom/apollographql/apollo/compiler/internal/-checkCapitalizedFields\n*L\n21#1:102,2\n35#1:104\n35#1:106\n83#1:107,2\n89#1:109,2\n*E\n"})
public final class -checkCapitalizedFields {
    @NotNull
    public static final List<Issue> checkCapitalizedFields(@NotNull List<? extends GQLDefinition> definitions, boolean checkFragmentsOnly) {
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        ValidationScope scope2 = new ValidationScope(definitions){
            private final List<Issue> issues;
            private final Map<String, GQLFragmentDefinition> fragmentsByName;
            {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                this.issues = new ArrayList<E>();
                Iterable iterable = $definitions;
                checkCapitalizedFields.scope.1 var12_3 = this;
                boolean $i$f$filterIsInstance = false;
                void var4_5 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)element$iv$iv;
                    Map map = destination$iv$iv2;
                    boolean bl = false;
                    map.put(it.getName(), element$iv$iv);
                }
                var12_3.fragmentsByName = destination$iv$iv2;
            }

            public List<Issue> getIssues() {
                return this.issues;
            }

            public Map<String, GQLFragmentDefinition> getFragmentsByName() {
                return this.fragmentsByName;
            }
        };
        Iterable $this$forEach$iv = definitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDefinition definition = (GQLDefinition)element$iv;
            boolean bl = false;
            if (definition instanceof GQLOperationDefinition && !checkFragmentsOnly) {
                -checkCapitalizedFields.checkCapitalizedFields(scope2, ((GQLOperationDefinition)definition).getSelections(), CollectionsKt.emptyList());
                continue;
            }
            if (!(definition instanceof GQLFragmentDefinition)) continue;
            -checkCapitalizedFields.checkCapitalizedFields(scope2, ((GQLFragmentDefinition)definition).getSelections(), CollectionsKt.emptyList());
        }
        return scope2.getIssues();
    }

    private static final void checkCapitalizedFields(ValidationScope $this$checkCapitalizedFields, List<? extends GQLSelection> selections, List<String> checkedFragments) {
        Iterable $this$forEach$iv = selections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLFragmentDefinition fragment;
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                if (((GQLField)it).getSelections().isEmpty()) continue;
                String alias = ((GQLField)it).getAlias();
                if (alias != null) {
                    if (-checkCapitalizedFields.isFirstLetterUpperCase(alias)) {
                        $this$checkCapitalizedFields.getIssues().add((Issue)new UpperCaseField(StringsKt.trimIndent((String)("\n                      Capitalized alias '" + alias + "' is not supported as it causes name clashes with the generated models. Use '" + -checkCapitalizedFields.decapitalizeFirstLetter(alias) + "' instead.\n                    ")), it.getSourceLocation()));
                    }
                } else if (-checkCapitalizedFields.isFirstLetterUpperCase(((GQLField)it).getName())) {
                    $this$checkCapitalizedFields.getIssues().add((Issue)new UpperCaseField(StringsKt.trimIndent((String)("\n                    Capitalized field '" + ((GQLField)it).getName() + "' is not supported as it causes name clashes with the generated models. Use an alias instead or the 'flattenModels' or 'decapitalizeFields' compiler option.\n                  ")), it.getSourceLocation()));
                }
                -checkCapitalizedFields.checkCapitalizedFields($this$checkCapitalizedFields, ((GQLField)it).getSelections(), checkedFragments);
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                -checkCapitalizedFields.checkCapitalizedFields($this$checkCapitalizedFields, ((GQLInlineFragment)it).getSelections(), checkedFragments);
                continue;
            }
            if (!(gQLSelection instanceof GQLFragmentSpread) || checkedFragments.contains(((GQLFragmentSpread)it).getName())) continue;
            if ($this$checkCapitalizedFields.getFragmentsByName().get(((GQLFragmentSpread)it).getName()) == null) continue;
            boolean bl2 = false;
            -checkCapitalizedFields.checkCapitalizedFields($this$checkCapitalizedFields, fragment.getSelections(), CollectionsKt.plus((Collection)checkedFragments, (Object)((GQLFragmentSpread)it).getName()));
        }
    }

    private static final boolean isFirstLetterUpperCase(String name) {
        Character c;
        block1: {
            CharSequence $this$firstOrNull$iv = name;
            boolean $i$f$firstOrNull = false;
            for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$firstOrNull$iv.charAt(i);
                boolean bl = false;
                if (!Character.isLetter(it)) continue;
                c = Character.valueOf(element$iv);
                break block1;
            }
            c = null;
        }
        return c != null ? Character.isUpperCase(c.charValue()) : true;
    }

    private static final String decapitalizeFirstLetter(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        boolean isDecapitalized = false;
        CharSequence $this$forEach$iv = name;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            String string;
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (!isDecapitalized && Character.isLetter(it)) {
                isDecapitalized = true;
                String string2 = String.valueOf(it).toLowerCase(Locale.ROOT);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            } else {
                string = String.valueOf(it);
            }
            builder.append(string);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

