/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.ResponseFieldSpec;
import com.apollographql.apollo.compiler.ResponseFieldSpec$WhenMappings;
import com.apollographql.apollo.compiler.UtilKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.Condition;
import com.apollographql.apollo.compiler.ir.Field;
import com.apollographql.apollo.compiler.ir.TypeDeclaration;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 A2\u00020\u0001:\u0001AB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nH\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0006\u0010 \u001a\u00020\u001bJ&\u0010!\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0016\u0010/\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bJ\u0018\u00100\u001a\n 2*\u0004\u0018\u000101012\u0006\u00103\u001a\u00020,H\u0002J\u0018\u00104\u001a\n 2*\u0004\u0018\u000101012\u0006\u00103\u001a\u00020,H\u0002J\u0018\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u00107\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u00108\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010:\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J \u0010;\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020,2\u0006\u00109\u001a\u00020\u001bH\u0002J \u0010>\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010?\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u001e\u0010@\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006B"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec;", "", "irField", "Lcom/apollographql/apollo/compiler/ir/Field;", "fieldSpec", "Lcom/squareup/javapoet/FieldSpec;", "normalizedFieldSpec", "responseFieldType", "Lcom/apollographql/apollo/api/ResponseField$Type;", "typeConditions", "", "", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "(Lcom/apollographql/apollo/compiler/ir/Field;Lcom/squareup/javapoet/FieldSpec;Lcom/squareup/javapoet/FieldSpec;Lcom/apollographql/apollo/api/ResponseField$Type;Ljava/util/List;Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;)V", "getContext", "()Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "getFieldSpec", "()Lcom/squareup/javapoet/FieldSpec;", "getIrField", "()Lcom/apollographql/apollo/compiler/ir/Field;", "getNormalizedFieldSpec", "getResponseFieldType", "()Lcom/apollographql/apollo/api/ResponseField$Type;", "getTypeConditions", "()Ljava/util/List;", "booleanConditionsCode", "Lcom/squareup/javapoet/CodeBlock;", "conditions", "Lcom/apollographql/apollo/compiler/ir/Condition;", "customTypeFactoryCode", "factoryMethod", "factoryCode", "fragmentFactoryCode", "possibleTypes", "genericFactoryCode", "readCustomCode", "readerParam", "fieldParam", "readEnumCode", "readFragmentsCode", "readListCode", "readListItemStatement", "rawFieldType", "Lcom/squareup/javapoet/TypeName;", "readObjectCode", "readScalarCode", "readValueCode", "responseFieldListItemReaderType", "Lcom/squareup/javapoet/ParameterizedTypeName;", "kotlin.jvm.PlatformType", "type", "responseFieldObjectReaderType", "writeCustomCode", "writerParam", "writeEnumCode", "writeFragmentCode", "marshaller", "writeFragmentsCode", "writeListCode", "writeListItemStatement", "listItemType", "writeObjectCode", "writeScalarCode", "writeValueCode", "Companion", "apollo-compiler"})
public final class ResponseFieldSpec {
    @NotNull
    private final Field irField;
    @NotNull
    private final FieldSpec fieldSpec;
    @NotNull
    private final FieldSpec normalizedFieldSpec;
    @NotNull
    private final ResponseField.Type responseFieldType;
    @NotNull
    private final List<String> typeConditions;
    @NotNull
    private final CodeGenerationContext context;
    private static final Map<ResponseField.Type, String> FACTORY_METHODS;
    private static final Map<ResponseField.Type, String> READ_METHODS;
    private static final Map<ResponseField.Type, String> WRITE_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_READ_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_WRITE_METHODS;
    private static final ParameterSpec RESPONSE_READER_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_READER_PARAM;
    private static final ParameterSpec ITEMS_VALUE_PARAM;
    private static final ParameterSpec ITEM_VALUE_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_WRITER_PARAM;
    public static final Companion Companion;

    @NotNull
    public final CodeBlock factoryCode() {
        CodeBlock codeBlock;
        String string = FACTORY_METHODS.get(this.responseFieldType);
        if (string == null) {
            String string2 = "Unrecognized responseFieldType: " + this.responseFieldType;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String factoryMethod = string;
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$0[this.responseFieldType.ordinal()]) {
            case 1: {
                codeBlock = this.customTypeFactoryCode(this.irField, factoryMethod);
                break;
            }
            case 2: {
                codeBlock = this.fragmentFactoryCode(this.irField, factoryMethod, this.typeConditions);
                break;
            }
            default: {
                codeBlock = this.genericFactoryCode(this.irField, factoryMethod);
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock readValueCode(@NotNull CodeBlock readerParam, @NotNull CodeBlock fieldParam) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull((Object)readerParam, (String)"readerParam");
        Intrinsics.checkParameterIsNotNull((Object)fieldParam, (String)"fieldParam");
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$1[this.responseFieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.readScalarCode(readerParam, fieldParam);
                break;
            }
            case 6: {
                codeBlock = this.readCustomCode(readerParam, fieldParam);
                break;
            }
            case 7: {
                codeBlock = this.readEnumCode(readerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.readObjectCode(readerParam, fieldParam);
                break;
            }
            case 9: {
                codeBlock = this.readListCode(readerParam, fieldParam);
                break;
            }
            case 10: {
                codeBlock = this.readObjectCode(readerParam, fieldParam);
                break;
            }
            case 11: {
                codeBlock = this.readFragmentsCode();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock writeValueCode(@NotNull CodeBlock writerParam, @NotNull CodeBlock fieldParam, @NotNull CodeBlock marshaller) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull((Object)writerParam, (String)"writerParam");
        Intrinsics.checkParameterIsNotNull((Object)fieldParam, (String)"fieldParam");
        Intrinsics.checkParameterIsNotNull((Object)marshaller, (String)"marshaller");
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$2[this.responseFieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.writeScalarCode(writerParam, fieldParam);
                break;
            }
            case 6: {
                codeBlock = this.writeEnumCode(writerParam, fieldParam);
                break;
            }
            case 7: {
                codeBlock = this.writeCustomCode(writerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.writeObjectCode(writerParam, fieldParam, marshaller);
                break;
            }
            case 9: {
                codeBlock = this.writeListCode(writerParam, fieldParam, marshaller);
                break;
            }
            case 10: {
                codeBlock = this.writeFragmentCode(writerParam, marshaller);
                break;
            }
            case 11: {
                codeBlock = this.writeFragmentsCode(writerParam, marshaller);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    private final CodeBlock customTypeFactoryCode(Field irField, String factoryMethod) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String string = UtilKt.normalizeGraphQlType$default(irField.getType(), false, 2, null);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string3;
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $T.$L, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), customScalarEnum, customScalarEnumConst, this.booleanConditionsCode(irField.getConditions())});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026Code(irField.conditions))");
        return codeBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock fragmentFactoryCode(Field irField, String factoryMethod, List<String> possibleTypes) {
        void $this$foldIndexed$iv;
        boolean bl;
        CodeBlock builder;
        int n;
        int n2;
        CodeBlock $this$foldIndexed$iv2;
        int n3;
        void $this$mapTo$iv$iv;
        Condition it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irField.getConditions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Condition)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)Condition.Kind.BOOLEAN.getRawValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void condition;
            it = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            n3 = 0;
            CodeBlock codeBlock = CodeBlock.of((String)"$T.booleanCondition($S, $L)", (Object[])new Object[]{ResponseField.Condition.class, condition.getVariableName(), condition.getInverted()});
            collection.add(codeBlock);
        }
        List booleanConditions = (List)destination$iv$iv;
        Iterable $i$f$map22 = possibleTypes;
        CodeBlock.Builder initial$iv322 = CodeBlock.builder();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv322;
        for (Object element$iv : $this$foldIndexed$iv2) {
            void type;
            void v0;
            void $this$applyIf$iv;
            n3 = index$iv++;
            n2 = 0;
            if (n3 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            n = n3;
            String string = (String)element$iv;
            CodeBlock.Builder builder2 = accumulator$iv;
            int index = n;
            boolean bl3 = false;
            void var20_36 = builder;
            boolean condition$iv = index > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void var23_41 = $this$applyIf$iv;
                boolean bl4 = false;
                bl = false;
                void $this$applyIf = var23_41;
                boolean bl5 = false;
                $this$applyIf.add(", ", new Object[0]);
                v0 = var23_41;
            } else {
                v0 = $this$applyIf$iv;
            }
            accumulator$iv = v0.add(CodeBlock.of((String)"$S", (Object[])new Object[]{type}));
        }
        $this$foldIndexed$iv2 = accumulator$iv.build();
        boolean initial$iv322 = false;
        $i$f$foldIndexed = false;
        CodeBlock code = $this$foldIndexed$iv2;
        boolean bl6 = false;
        CodeBlock codeBlock = code;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"code");
        CodeBlock typeCondition = codeBlock.isEmpty() ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.builder().add("$T.typeCondition(new $T[] {", new Object[]{ResponseField.Condition.class, ClassNames.INSTANCE.getSTRING()}).add(code).add("})", new Object[0]).build();
        Iterable initial$iv322 = CollectionsKt.plus((Collection)booleanConditions, (Object)typeCondition);
        CodeBlock.Builder initial$iv = CodeBlock.builder();
        boolean $i$f$foldIndexed2 = false;
        int index$iv2 = 0;
        CodeBlock.Builder accumulator$iv2 = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void code2;
            void v2;
            void $this$applyIf$iv;
            void builder3;
            n2 = index$iv2++;
            n = 0;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n4 = n2;
            builder = (CodeBlock)element$iv;
            CodeBlock.Builder index = accumulator$iv2;
            int index2 = n4;
            boolean bl7 = false;
            void condition$iv = builder3;
            boolean condition$iv2 = index2 > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv2) {
                void var24_44 = $this$applyIf$iv;
                bl = false;
                boolean bl8 = false;
                void $this$applyIf = var24_44;
                boolean bl9 = false;
                $this$applyIf.add(",\n", new Object[0]);
                v2 = var24_44;
            } else {
                v2 = $this$applyIf$iv;
            }
            accumulator$iv2 = v2.add((CodeBlock)code2);
        }
        CodeBlock codeBlock2 = accumulator$iv2.build();
        boolean bl10 = false;
        boolean bl11 = false;
        CodeBlock code3 = codeBlock2;
        boolean bl12 = false;
        CodeBlock codeBlock3 = code3;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock3, (String)"code");
        CodeBlock conditions = codeBlock3.isEmpty() ? CodeBlock.of((String)"$T.<$T>emptyList()", (Object[])new Object[]{Collections.class, ResponseField.Condition.class}) : CodeBlock.builder().add("$T.<$T>asList(\n", new Object[]{Arrays.class, ResponseField.Condition.class}).indent().add(code3).unindent().add("\n)", new Object[0]).build();
        CodeBlock codeBlock4 = CodeBlock.of((String)"$T.$L($S, $S, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), conditions});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock4, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026Name,\n        conditions)");
        return codeBlock4;
    }

    private final CodeBlock genericFactoryCode(Field irField, String factoryMethod) {
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), this.booleanConditionsCode(irField.getConditions())});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026Code(irField.conditions))");
        return codeBlock;
    }

    private final CodeBlock readEnumCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock readValueCode = CodeBlock.builder().addStatement("final $T $L", new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name}).beginControlFlow("if ($LStr != null)", new Object[]{this.fieldSpec.name}).addStatement("$L = $T.$L($LStr)", new Object[]{this.fieldSpec.name, this.normalizedFieldSpec.type, TypeDeclaration.Companion.getENUM_SAFE_VALUE_OF(), this.fieldSpec.name}).nextControlFlow("else", new Object[0]).addStatement("$L = null", new Object[]{this.fieldSpec.name}).endControlFlow().build();
        CodeBlock codeBlock = CodeBlock.builder().addStatement("final $T $LStr = $L.$L($L)", new Object[]{ClassNames.INSTANCE.getSTRING(), this.fieldSpec.name, readerParam, READ_METHODS.get(ResponseField.Type.STRING), fieldParam}).add(readValueCode).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock\n        .build\u2026lueCode)\n        .build()");
        return codeBlock;
    }

    private final CodeBlock readScalarCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get(this.responseFieldType), fieldParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026seFieldType], fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readCustomCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L(($T) $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get(this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026::class.java, fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readObjectCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        Object[] objectArray = new Object[2];
        TypeName typeName2 = this.normalizedFieldSpec.type;
        if (typeName2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName2);
        objectArray[1] = ResponseFieldSpec.RESPONSE_READER_PARAM.name;
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.responseFieldObjectReaderType(typeName)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.normalizedFieldSpec.type).addParameter(RESPONSE_READER_PARAM).addStatement("return $L.map($L)", objectArray).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readListItemStatement(TypeName rawFieldType) {
        Function0<CodeBlock> $fun$readScalar$1 = new Function0<CodeBlock>(this, rawFieldType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $rawFieldType;

            @NotNull
            public final CodeBlock invoke() {
                CodeBlock codeBlock;
                String readMethod;
                String string = (String)ResponseFieldSpec.access$getSCALAR_LIST_ITEM_READ_METHODS$cp().get(this.$rawFieldType);
                if (string == null) {
                    string = readMethod = "readString";
                }
                if (UtilKt.isEnum(this.$rawFieldType, this.this$0.getContext())) {
                    CodeBlock codeBlock2 = CodeBlock.of((String)"return $T.$L($L.$L());\n", (Object[])new Object[]{this.$rawFieldType, TypeDeclaration.Companion.getENUM_SAFE_VALUE_OF(), ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_READER_PARAM$cp().name, readMethod});
                    codeBlock = codeBlock2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"CodeBlock.of(\"return \\$T\u2026R_PARAM.name, readMethod)");
                } else {
                    CodeBlock codeBlock3 = CodeBlock.of((String)"return $L.$L();\n", (Object[])new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_READER_PARAM$cp().name, readMethod});
                    codeBlock = codeBlock3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock3, (String)"CodeBlock.of(\"return \\$L\u2026R_PARAM.name, readMethod)");
                }
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$rawFieldType = typeName;
                super(0);
            }
        };
        Function0<CodeBlock> $fun$readCustom$2 = new Function0<CodeBlock>(this){
            final /* synthetic */ ResponseFieldSpec this$0;

            @NotNull
            public final CodeBlock invoke() {
                ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.this$0.getContext());
                String string = UtilKt.normalizeGraphQlType(this.this$0.getIrField().getType(), true);
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
                String customScalarEnumConst = string3;
                CodeBlock codeBlock = CodeBlock.of((String)"return $L.readCustomType($T.$L);\n", (Object[])new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_READER_PARAM$cp().name, customScalarEnum, customScalarEnumConst});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"return \\$L\u2026m, customScalarEnumConst)");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                super(0);
            }
        };
        Function0<CodeBlock> $fun$readObject$3 = new Function0<CodeBlock>(this, rawFieldType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $rawFieldType;

            @NotNull
            public final CodeBlock invoke() {
                Object[] objectArray = new Object[2];
                TypeName typeName = this.$rawFieldType;
                if (typeName == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
                }
                objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName);
                objectArray[1] = ResponseFieldSpec.access$getRESPONSE_READER_PARAM$cp().name;
                TypeSpec objectReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ResponseFieldSpec.access$responseFieldObjectReaderType(this.this$0, this.$rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.$rawFieldType).addParameter(ResponseFieldSpec.access$getRESPONSE_READER_PARAM$cp()).addStatement("return $L.map($L)", objectArray).build()).build();
                CodeBlock codeBlock = CodeBlock.of((String)"return $L.readObject($L);\n", (Object[])new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_READER_PARAM$cp().name, objectReaderTypeSpec});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"return \\$L\u2026me, objectReaderTypeSpec)");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$rawFieldType = typeName;
                super(0);
            }
        };
        Function0<CodeBlock> $fun$readList$4 = new Function0<CodeBlock>(this, rawFieldType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $rawFieldType;

            @NotNull
            public final CodeBlock invoke() {
                TypeName listItemType = UtilKt.listParamType(this.$rawFieldType);
                CodeBlock readItemCode = ResponseFieldSpec.access$readListItemStatement(this.this$0, listItemType);
                TypeSpec listItemReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ResponseFieldSpec.access$responseFieldListItemReaderType(this.this$0, listItemType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(listItemType).addParameter(ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_READER_PARAM$cp()).addCode(readItemCode).build()).build();
                CodeBlock codeBlock = CodeBlock.of((String)"return $L.readList($L);\n", (Object[])new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_READER_PARAM$cp().name, listItemReaderTypeSpec});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"return \\$L\u2026, listItemReaderTypeSpec)");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$rawFieldType = typeName;
                super(0);
            }
        };
        if (!UtilKt.isList(rawFieldType)) {
            if (UtilKt.isCustomScalarType(this.irField.getType(), this.context)) {
                return $fun$readCustom$2.invoke();
            }
            if (UtilKt.isScalar(rawFieldType, this.context)) {
                return $fun$readScalar$1.invoke();
            }
            return $fun$readObject$3.invoke();
        }
        return $fun$readList$4.invoke();
    }

    private final CodeBlock readListCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        TypeName rawFieldType = UtilKt.listParamType(typeName);
        TypeSpec readerTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)this.responseFieldListItemReaderType(rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(RESPONSE_LIST_ITEM_READER_PARAM).addCode(this.readListItemStatement(rawFieldType)).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readFragmentsCode() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.normalizedFieldSpec.type;
        objectArray[1] = this.fieldSpec.name;
        TypeName typeName = this.normalizedFieldSpec.type;
        if (typeName == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[2] = UtilKt.mapperFieldName((ClassName)typeName);
        objectArray[3] = ResponseFieldSpec.RESPONSE_READER_PARAM.name;
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.map($L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026SPONSE_READER_PARAM.name)");
        return codeBlock;
    }

    private final CodeBlock writeScalarCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldSpec.type");
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026   fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeEnumCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldSpec.type");
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, writeEnumCode.valueCode.1.INSTANCE, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026   fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldSpec.type");
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L(($T) $L, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get(this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L((\\\u2026a, fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeObjectCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller) {
        TypeName typeName = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"fieldSpec.type");
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, (Function1)new Function1<CodeBlock, CodeBlock>(marshaller){
            final /* synthetic */ CodeBlock $marshaller;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L.$L", (Object[])new Object[]{it, this.$marshaller});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L\", it, marshaller)");
                return codeBlock;
            }
            {
                this.$marshaller = codeBlock;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026], fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeListItemStatement(TypeName listItemType, CodeBlock marshaller) {
        Function0<CodeBlock> $fun$writeScalar$1 = new Function0<CodeBlock>(this, listItemType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $listItemType;

            @NotNull
            public final CodeBlock invoke() {
                String string = (String)ResponseFieldSpec.access$getSCALAR_LIST_ITEM_WRITE_METHODS$cp().get(this.$listItemType);
                if (string == null) {
                    string = "writeString";
                }
                String writeMethod = string;
                CodeBlock.Builder builder = CodeBlock.builder();
                boolean bl = false;
                boolean bl2 = false;
                CodeBlock.Builder it = builder;
                boolean bl3 = false;
                CodeBlock codeBlock = (UtilKt.isEnum(this.$listItemType, this.this$0.getContext()) ? it.addStatement("$L.$L((($T) $L).rawValue())", new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp().name, writeMethod, this.$listItemType, ResponseFieldSpec.access$getITEM_VALUE_PARAM$cp().name}) : it.addStatement("$L.$L(($T) $L)", new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp().name, writeMethod, this.$listItemType, ResponseFieldSpec.access$getITEM_VALUE_PARAM$cp().name})).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder().let \u2026        }\n      }.build()");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$listItemType = typeName;
                super(0);
            }
        };
        Function0<CodeBlock> $fun$writeCustom$2 = new Function0<CodeBlock>(this){
            final /* synthetic */ ResponseFieldSpec this$0;

            @NotNull
            public final CodeBlock invoke() {
                ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.this$0.getContext());
                String string = UtilKt.normalizeGraphQlType(this.this$0.getIrField().getType(), true);
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
                String customScalarEnumConst = string3;
                CodeBlock codeBlock = CodeBlock.builder().addStatement("$L.writeCustom($T.$L, $L)", new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp().name, customScalarEnum, customScalarEnumConst, ResponseFieldSpec.access$getITEM_VALUE_PARAM$cp().name}).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026.name)\n          .build()");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                super(0);
            }
        };
        Function0<CodeBlock> $fun$writeObject$3 = new Function0<CodeBlock>(listItemType, marshaller){
            final /* synthetic */ TypeName $listItemType;
            final /* synthetic */ CodeBlock $marshaller;

            @NotNull
            public final CodeBlock invoke() {
                CodeBlock codeBlock = CodeBlock.builder().addStatement("$L.writeObject((($T) $L).$L)", new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp().name, this.$listItemType, ResponseFieldSpec.access$getITEM_VALUE_PARAM$cp().name, this.$marshaller}).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026aller)\n          .build()");
                return codeBlock;
            }
            {
                this.$listItemType = typeName;
                this.$marshaller = codeBlock;
                super(0);
            }
        };
        Function0<CodeBlock> $fun$writeList$4 = new Function0<CodeBlock>(this, listItemType, marshaller){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $listItemType;
            final /* synthetic */ CodeBlock $marshaller;

            @NotNull
            public final CodeBlock invoke() {
                TypeName rawFieldType = UtilKt.listParamType(this.$listItemType);
                CodeBlock readItemCode = ResponseFieldSpec.access$writeListItemStatement(this.this$0, rawFieldType, this.$marshaller);
                TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ResponseFieldSpec.access$getITEMS_VALUE_PARAM$cp()).addParameter(ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp()).addCode(readItemCode).build()).build();
                CodeBlock codeBlock = CodeBlock.builder().addStatement("$L.writeList(($T) $L, $L)", new Object[]{ResponseFieldSpec.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp().name, ClassNames.INSTANCE.getLIST(), ResponseFieldSpec.access$getITEM_VALUE_PARAM$cp().name, listWriterType}).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026rType)\n          .build()");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$listItemType = typeName;
                this.$marshaller = codeBlock;
                super(0);
            }
        };
        CodeBlock codeBlock = UtilKt.isList(listItemType) ? $fun$writeList$4.invoke() : (UtilKt.isCustomScalarType(this.irField.getType(), this.context) ? $fun$writeCustom$2.invoke() : (UtilKt.isScalar(listItemType, this.context) ? $fun$writeScalar$1.invoke() : $fun$writeObject$3.invoke()));
        boolean bl = false;
        boolean bl2 = false;
        CodeBlock it = codeBlock;
        boolean bl3 = false;
        CodeBlock codeBlock2 = CodeBlock.builder().beginControlFlow("for (Object $L : $L)", new Object[]{ResponseFieldSpec.ITEM_VALUE_PARAM.name, ResponseFieldSpec.ITEMS_VALUE_PARAM.name}).add(it).endControlFlow().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"CodeBlock.builder()\n    \u2026Flow()\n          .build()");
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"when {\n      listItemTyp\u2026\n          .build()\n    }");
        return codeBlock2;
    }

    private final CodeBlock writeListCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller) {
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        TypeName listItemType = UtilKt.listParamType(typeName);
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ITEMS_VALUE_PARAM).addParameter(RESPONSE_LIST_ITEM_WRITER_PARAM).addCode(this.writeListItemStatement(listItemType, marshaller)).build()).build();
        Object[] objectArray = new Object[5];
        objectArray[0] = writerParam;
        objectArray[1] = WRITE_METHODS.get(this.responseFieldType);
        objectArray[2] = fieldParam;
        TypeName typeName2 = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"fieldSpec.type");
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        objectArray[3] = UtilKt.unwrapOptionalValue$default(typeName2, string, false, null, 6, null);
        objectArray[4] = listWriterType;
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026ec.name), listWriterType)");
        return codeBlock;
    }

    private final CodeBlock writeFragmentCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L.marshal($L);\n", (Object[])new Object[]{this.fieldSpec.name, marshaller, writerParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L.ma\u2026 marshaller, writerParam)");
        return codeBlock;
    }

    private final CodeBlock writeFragmentsCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L.marshal($L);\n", (Object[])new Object[]{this.fieldSpec.name, marshaller, writerParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L.ma\u2026 marshaller, writerParam)");
        return codeBlock;
    }

    private final ParameterizedTypeName responseFieldObjectReaderType(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ObjectReader.class), (TypeName[])new TypeName[]{type});
    }

    private final ParameterizedTypeName responseFieldListItemReaderType(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ListReader.class), (TypeName[])new TypeName[]{type});
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock booleanConditionsCode(List<Condition> conditions) {
        CodeBlock codeBlock;
        void $this$foldIndexed$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = conditions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Condition it = (Condition)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)Condition.Kind.BOOLEAN.getRawValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        CodeBlock.Builder initial$iv = CodeBlock.builder();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void condition;
            void v0;
            void $this$applyIf$iv;
            void builder;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Condition condition2 = (Condition)element$iv;
            CodeBlock.Builder builder2 = accumulator$iv;
            int index = n2;
            boolean bl2 = false;
            void var16_24 = builder;
            boolean condition$iv = index > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void var19_27 = $this$applyIf$iv;
                boolean bl3 = false;
                boolean bl4 = false;
                void $this$applyIf = var19_27;
                boolean bl5 = false;
                $this$applyIf.add(",\n", new Object[0]);
                v0 = var19_27;
            } else {
                v0 = $this$applyIf$iv;
            }
            accumulator$iv = v0.add("$T.booleanCondition($S, $L)", new Object[]{ResponseField.Condition.class, condition.getVariableName(), condition.getInverted()});
        }
        CodeBlock codeBlock2 = accumulator$iv.build();
        boolean bl = false;
        boolean bl6 = false;
        CodeBlock code = codeBlock2;
        boolean bl7 = false;
        CodeBlock codeBlock3 = code;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock3, (String)"code");
        if (codeBlock3.isEmpty()) {
            CodeBlock codeBlock4 = CodeBlock.of((String)"$T.<$T>emptyList()", (Object[])new Object[]{Collections.class, ResponseField.Condition.class});
            codeBlock = codeBlock4;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock4, (String)"CodeBlock.of(\"\\$T.<\\$T>e\u2026ld.Condition::class.java)");
        } else {
            CodeBlock codeBlock5 = CodeBlock.builder().add("$T.<$T>asList(\n", new Object[]{Arrays.class, ResponseField.Condition.class}).indent().add(code).unindent().add("\n)", new Object[0]).build();
            codeBlock = codeBlock5;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock5, (String)"CodeBlock.builder()\n    \u2026\n                .build()");
        }
        return codeBlock;
    }

    @NotNull
    public final Field getIrField() {
        return this.irField;
    }

    @NotNull
    public final FieldSpec getFieldSpec() {
        return this.fieldSpec;
    }

    @NotNull
    public final FieldSpec getNormalizedFieldSpec() {
        return this.normalizedFieldSpec;
    }

    @NotNull
    public final ResponseField.Type getResponseFieldType() {
        return this.responseFieldType;
    }

    @NotNull
    public final List<String> getTypeConditions() {
        return this.typeConditions;
    }

    @NotNull
    public final CodeGenerationContext getContext() {
        return this.context;
    }

    public ResponseFieldSpec(@NotNull Field irField, @NotNull FieldSpec fieldSpec, @NotNull FieldSpec normalizedFieldSpec, @NotNull ResponseField.Type responseFieldType, @NotNull List<String> typeConditions, @NotNull CodeGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)irField, (String)"irField");
        Intrinsics.checkParameterIsNotNull((Object)fieldSpec, (String)"fieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)normalizedFieldSpec, (String)"normalizedFieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)responseFieldType, (String)"responseFieldType");
        Intrinsics.checkParameterIsNotNull(typeConditions, (String)"typeConditions");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.irField = irField;
        this.fieldSpec = fieldSpec;
        this.normalizedFieldSpec = normalizedFieldSpec;
        this.responseFieldType = responseFieldType;
        this.typeConditions = typeConditions;
        this.context = context;
    }

    public /* synthetic */ ResponseFieldSpec(Field field, FieldSpec fieldSpec, FieldSpec fieldSpec2, ResponseField.Type type, List list, CodeGenerationContext codeGenerationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(field, fieldSpec, fieldSpec2, type, list, codeGenerationContext);
    }

    static {
        Companion = new Companion(null);
        FACTORY_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"forString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"forInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"forLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"forDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"forBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"forString"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"forObject"), TuplesKt.to((Object)ResponseField.Type.LIST, (Object)"forList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"forCustomType"), TuplesKt.to((Object)ResponseField.Type.FRAGMENT, (Object)"forFragment")});
        READ_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"readString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"readInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"readLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"readDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"readBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"readString"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"readObject"), TuplesKt.to((Object)ResponseField.Type.LIST, (Object)"readList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"readCustomType"), TuplesKt.to((Object)ResponseField.Type.FRAGMENT, (Object)"readFragment")});
        WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"writeString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"writeInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"writeLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"writeString"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"writeCustom"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"writeObject"), TuplesKt.to((Object)ResponseField.Type.LIST, (Object)"writeList")});
        SCALAR_LIST_ITEM_READ_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"readString"), TuplesKt.to((Object)TypeName.INT, (Object)"readInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"readInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"readLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"readLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"readDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"readDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"readBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"readBoolean")});
        SCALAR_LIST_ITEM_WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"writeString"), TuplesKt.to((Object)TypeName.INT, (Object)"writeInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"writeInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"writeLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"writeLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"writeDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"writeBoolean")});
        RESPONSE_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.class)), (String)"reader", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.ListItemReader.class)), (String)"listItemReader", (Modifier[])new Modifier[0]).build();
        ITEMS_VALUE_PARAM = ParameterSpec.builder((Type)((Type)((Object)List.class)), (String)"items", (Modifier[])new Modifier[0]).build();
        ITEM_VALUE_PARAM = ParameterSpec.builder((TypeName)((TypeName)TypeName.OBJECT), (String)"item", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_WRITER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseWriter.ListItemWriter.class)), (String)"listItemWriter", (Modifier[])new Modifier[0]).build();
    }

    public static final /* synthetic */ Map access$getSCALAR_LIST_ITEM_READ_METHODS$cp() {
        return SCALAR_LIST_ITEM_READ_METHODS;
    }

    public static final /* synthetic */ ParameterSpec access$getRESPONSE_LIST_ITEM_READER_PARAM$cp() {
        return RESPONSE_LIST_ITEM_READER_PARAM;
    }

    public static final /* synthetic */ ParameterizedTypeName access$responseFieldObjectReaderType(ResponseFieldSpec $this, TypeName type) {
        return $this.responseFieldObjectReaderType(type);
    }

    public static final /* synthetic */ ParameterSpec access$getRESPONSE_READER_PARAM$cp() {
        return RESPONSE_READER_PARAM;
    }

    public static final /* synthetic */ CodeBlock access$readListItemStatement(ResponseFieldSpec $this, TypeName rawFieldType) {
        return $this.readListItemStatement(rawFieldType);
    }

    public static final /* synthetic */ ParameterizedTypeName access$responseFieldListItemReaderType(ResponseFieldSpec $this, TypeName type) {
        return $this.responseFieldListItemReaderType(type);
    }

    public static final /* synthetic */ Map access$getSCALAR_LIST_ITEM_WRITE_METHODS$cp() {
        return SCALAR_LIST_ITEM_WRITE_METHODS;
    }

    public static final /* synthetic */ ParameterSpec access$getRESPONSE_LIST_ITEM_WRITER_PARAM$cp() {
        return RESPONSE_LIST_ITEM_WRITER_PARAM;
    }

    public static final /* synthetic */ ParameterSpec access$getITEM_VALUE_PARAM$cp() {
        return ITEM_VALUE_PARAM;
    }

    public static final /* synthetic */ CodeBlock access$writeListItemStatement(ResponseFieldSpec $this, TypeName listItemType, CodeBlock marshaller) {
        return $this.writeListItemStatement(listItemType, marshaller);
    }

    public static final /* synthetic */ ParameterSpec access$getITEMS_VALUE_PARAM$cp() {
        return ITEMS_VALUE_PARAM;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec$Companion;", "", "()V", "FACTORY_METHODS", "", "Lcom/apollographql/apollo/api/ResponseField$Type;", "", "ITEMS_VALUE_PARAM", "Lcom/squareup/javapoet/ParameterSpec;", "kotlin.jvm.PlatformType", "ITEM_VALUE_PARAM", "READ_METHODS", "RESPONSE_LIST_ITEM_READER_PARAM", "RESPONSE_LIST_ITEM_WRITER_PARAM", "RESPONSE_READER_PARAM", "SCALAR_LIST_ITEM_READ_METHODS", "Lcom/squareup/javapoet/TypeName;", "SCALAR_LIST_ITEM_WRITE_METHODS", "WRITE_METHODS", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

