/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import org.jetbrains.annotations.Nullable;

public final class Input<V> {
    @Nullable
    public final V value;
    public final boolean defined;

    private Input(@Nullable V value, boolean defined) {
        this.value = value;
        this.defined = defined;
    }

    public static <V> Input<V> optional(@Nullable V value) {
        if (value == null) {
            return Input.absent();
        }
        return Input.fromNullable(value);
    }

    public static <V> Input<V> fromNullable(@Nullable V value) {
        return new Input<V>(value, true);
    }

    public static <V> Input<V> absent() {
        return new Input<Object>(null, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Input)) {
            return false;
        }
        Input input = (Input)o;
        return this.defined == input.defined && (this.value != null && this.value.equals(input.value) || this.value == null && input.value == null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.defined ? 1 : 0);
        return result;
    }
}

