/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.SimpleResponseReader;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.internal.json.ResponseJsonStreamReader;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public final class SimpleOperationResponseParser {
    private SimpleOperationResponseParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D extends Operation.Data, W> Response<W> parse(@NotNull BufferedSource source, @NotNull Operation<D, W, ?> operation, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        Utils.checkNotNull(source, "source == null");
        Utils.checkNotNull(operation, "operation == null");
        Utils.checkNotNull(scalarTypeAdapters, "scalarTypeAdapters == null");
        try (BufferedSourceJsonReader jsonReader = null;){
            jsonReader = new BufferedSourceJsonReader(source);
            jsonReader.beginObject();
            Map<String, Object> response = new ResponseJsonStreamReader(jsonReader).toMap();
            Response<W> response2 = SimpleOperationResponseParser.parse(response, operation, scalarTypeAdapters);
            return response2;
        }
    }

    private static <D extends Operation.Data, W> Response<W> parse(@NotNull Map<String, Object> response, @NotNull Operation<D, W, ?> operation, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        ArrayList<Error> errors;
        Operation.Data data;
        Utils.checkNotNull(response, "response == null");
        Utils.checkNotNull(operation, "operation == null");
        Utils.checkNotNull(scalarTypeAdapters, "scalarTypeAdapters == null");
        Map responseData = (Map)response.get("data");
        if (responseData != null) {
            SimpleResponseReader responseReader = new SimpleResponseReader((Map<String, Object>)responseData, (Operation.Variables)operation.variables(), scalarTypeAdapters);
            data = (Operation.Data)operation.responseFieldMapper().map(responseReader);
        } else {
            data = null;
        }
        List responseErrors = (List)response.get("errors");
        if (responseErrors != null) {
            errors = new ArrayList<Error>();
            for (Map errorPayload : responseErrors) {
                errors.add(SimpleOperationResponseParser.readError(errorPayload));
            }
        } else {
            errors = null;
        }
        return Response.builder(operation).data(operation.wrapData(data)).errors(errors).extensions((Map)response.get("extensions")).build();
    }

    private static Error readError(Map<String, Object> payload) {
        String message = null;
        ArrayList<Error.Location> locations = new ArrayList<Error.Location>();
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            if ("message".equals(entry.getKey())) {
                Object value = entry.getValue();
                message = value != null ? value.toString() : null;
                continue;
            }
            if ("locations".equals(entry.getKey())) {
                List locationItems = (List)entry.getValue();
                if (locationItems == null) continue;
                for (Map item : locationItems) {
                    locations.add(SimpleOperationResponseParser.readErrorLocation(item));
                }
                continue;
            }
            if (entry.getValue() == null) continue;
            customAttributes.put(entry.getKey(), entry.getValue());
        }
        return new Error(message, locations, customAttributes);
    }

    private static Error.Location readErrorLocation(Map<String, Object> data) {
        long line = -1L;
        long column = -1L;
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if ("line".equals(entry.getKey())) {
                    line = ((Number)entry.getValue()).longValue();
                    continue;
                }
                if (!"column".equals(entry.getKey())) continue;
                column = ((Number)entry.getValue()).longValue();
            }
        }
        return new Error.Location(line, column);
    }
}

