/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Response<T> {
    private final Operation operation;
    private final T data;
    private final List<Error> errors;
    private Set<String> dependentKeys;

    public Response(Operation operation) {
        this(operation, null, null, null);
    }

    public Response(Operation operation, T data, List<Error> errors, Set<String> dependentKeys) {
        this.operation = operation;
        this.data = data;
        this.errors = errors != null ? errors : Collections.emptyList();
        this.dependentKeys = dependentKeys != null ? dependentKeys : Collections.emptySet();
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty();
    }

    public Operation operation() {
        return this.operation;
    }

    public T data() {
        return this.data;
    }

    public List<Error> errors() {
        return this.errors;
    }

    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }
}

