/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal.json;

import com.apollographql.apollo.api.internal.json.JsonDataException;
import com.apollographql.apollo.api.internal.json.JsonEncodingException;
import com.apollographql.apollo.api.internal.json.JsonReader;
import com.apollographql.apollo.api.internal.json.JsonScope;
import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 L2\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\u0001H\u0016J\b\u0010%\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\t\u0010'\u001a\u00020\bH\u0096\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\u0019H\u0016J\b\u00100\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\bH\u0002J\u0015\u00103\u001a\u0004\u0018\u0001H4\"\u0004\b\u0000\u00104H\u0016\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u000208H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010:\u001a\u00020\u0014H\u0002J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0017H\u0002J\b\u0010>\u001a\u00020\u0017H\u0002J\b\u0010?\u001a\u00020!H\u0016J\u0010\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020\u0017H\u0002J\b\u0010B\u001a\u00020*H\u0002J\u0010\u0010C\u001a\u00020!2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\u0014H\u0002J\b\u0010F\u001a\u00020!H\u0002J\b\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020!H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/apollographql/apollo/api/internal/json/BufferedSourceJsonReader;", "Lcom/apollographql/apollo/api/internal/json/JsonReader;", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "buffer", "Lokio/Buffer;", "failOnUnknown", "", "getFailOnUnknown", "()Z", "setFailOnUnknown", "(Z)V", "lenient", "getLenient", "setLenient", "pathIndices", "", "pathNames", "", "", "[Ljava/lang/String;", "peeked", "", "peekedLong", "", "peekedNumberLength", "peekedString", "stack", "stackSize", "beginArray", "beginObject", "checkLenient", "", "close", "doPeek", "endArray", "endObject", "getPath", "hasNext", "isLiteral", "c", "", "nextBoolean", "nextDouble", "", "nextInt", "nextLong", "nextName", "nextNonWhitespace", "throwOnEof", "nextNull", "T", "()Ljava/lang/Object;", "nextQuotedValue", "runTerminator", "Lokio/ByteString;", "nextString", "nextUnquotedValue", "peek", "Lcom/apollographql/apollo/api/internal/json/JsonReader$Token;", "peekKeyword", "peekNumber", "promoteNameToValue", "push", "newTop", "readEscapeCharacter", "skipQuotedValue", "skipTo", "toFind", "skipToEndOfLine", "skipUnquotedValue", "skipValue", "syntaxError", "Lcom/apollographql/apollo/api/internal/json/JsonEncodingException;", "message", "Companion", "apollo-api"})
public final class BufferedSourceJsonReader
implements JsonReader {
    private final Buffer buffer;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private final int[] stack;
    private int stackSize;
    private final String[] pathNames;
    private final int[] pathIndices;
    private boolean lenient;
    private boolean failOnUnknown;
    private final BufferedSource source;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final ByteString SINGLE_QUOTE_OR_SLASH;
    private static final ByteString DOUBLE_QUOTE_OR_SLASH;
    private static final ByteString UNQUOTED_STRING_TERMINALS;
    private static final ByteString LINEFEED_OR_CARRIAGE_RETURN;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    public static final Companion Companion;

    @Override
    public boolean getLenient() {
        return this.lenient;
    }

    @Override
    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    @Override
    public boolean getFailOnUnknown() {
        return this.failOnUnknown;
    }

    @Override
    public void setFailOnUnknown(boolean bl) {
        this.failOnUnknown = bl;
    }

    @Override
    @NotNull
    public JsonReader beginArray() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$apply = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$apply.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$apply.doPeek();
        if (p != 3) {
            throw (Throwable)new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$apply.peek()) + " at path " + $this$apply.getPath());
        }
        $this$apply.push(1);
        $this$apply.pathIndices[$this$apply.stackSize - 1] = 0;
        $this$apply.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endArray() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$apply = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$apply.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$apply.doPeek();
        if (p != 4) {
            throw (Throwable)new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$apply.peek()) + " at path " + $this$apply.getPath());
        }
        int n4 = $this$apply.stackSize;
        $this$apply.stackSize = n4 + -1;
        int n5 = $this$apply.stackSize - 1;
        n4 = $this$apply.pathIndices[n5];
        $this$apply.pathIndices[n5] = n4 + 1;
        $this$apply.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader beginObject() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$apply = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$apply.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$apply.doPeek();
        if (p != 1) {
            throw (Throwable)new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$apply.peek()) + " at path " + $this$apply.getPath());
        }
        $this$apply.push(3);
        $this$apply.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endObject() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$apply = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$apply.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$apply.doPeek();
        if (p != 2) {
            throw (Throwable)new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)$this$apply.peek()) + " at path " + $this$apply.getPath());
        }
        int n4 = $this$apply.stackSize;
        $this$apply.stackSize = n4 + -1;
        $this$apply.pathNames[$this$apply.stackSize] = null;
        int n5 = $this$apply.stackSize - 1;
        n4 = $this$apply.pathIndices[n5];
        $this$apply.pathIndices[n5] = n4 + 1;
        $this$apply.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    public boolean hasNext() throws IOException {
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        return p != 2 && p != 4;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() throws IOException {
        JsonReader.Token token;
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 1: {
                token = JsonReader.Token.BEGIN_OBJECT;
                break;
            }
            case 2: {
                token = JsonReader.Token.END_OBJECT;
                break;
            }
            case 3: {
                token = JsonReader.Token.BEGIN_ARRAY;
                break;
            }
            case 4: {
                token = JsonReader.Token.END_ARRAY;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                token = JsonReader.Token.NAME;
                break;
            }
            case 5: 
            case 6: {
                token = JsonReader.Token.BOOLEAN;
                break;
            }
            case 7: {
                token = JsonReader.Token.NULL;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                token = JsonReader.Token.STRING;
                break;
            }
            case 15: {
                token = JsonReader.Token.LONG;
                break;
            }
            case 16: {
                token = JsonReader.Token.NUMBER;
                break;
            }
            case 17: {
                token = JsonReader.Token.END_DOCUMENT;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        return token;
    }

    private final int doPeek() throws IOException {
        int n;
        int n2;
        int c;
        int peekStack = this.stack[this.stackSize - 1];
        block0 : switch (peekStack) {
            case 1: {
                this.stack[this.stackSize - 1] = 2;
                break;
            }
            case 2: {
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                switch ((char)c) {
                    case ']': {
                        int n3 = 4;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = n3;
                        boolean bl3 = false;
                        this.peeked = it;
                        return n3;
                    }
                    case ';': {
                        this.checkLenient();
                        break block0;
                    }
                    case ',': {
                        break block0;
                    }
                }
                throw (Throwable)this.syntaxError("Unterminated array");
            }
            case 3: 
            case 5: {
                int n4;
                int c2;
                this.stack[this.stackSize - 1] = 4;
                if (peekStack == 5) {
                    c2 = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    switch ((char)c2) {
                        case '}': {
                            int n5 = 2;
                            boolean bl = false;
                            boolean bl4 = false;
                            int it = n5;
                            boolean bl5 = false;
                            this.peeked = it;
                            return n5;
                        }
                        case ';': {
                            this.checkLenient();
                            break;
                        }
                        case ',': {
                            break;
                        }
                        default: {
                            throw (Throwable)this.syntaxError("Unterminated object");
                        }
                    }
                }
                c2 = this.nextNonWhitespace(true);
                switch ((char)c2) {
                    case '\"': {
                        this.buffer.readByte();
                        int n6 = 13;
                        boolean bl = false;
                        boolean bl6 = false;
                        int it = n6;
                        boolean bl7 = false;
                        this.peeked = it;
                        n4 = n6;
                        break;
                    }
                    case '\'': {
                        this.buffer.readByte();
                        this.checkLenient();
                        int n7 = 12;
                        boolean bl = false;
                        boolean bl8 = false;
                        int it = n7;
                        boolean bl9 = false;
                        this.peeked = it;
                        n4 = n7;
                        break;
                    }
                    case '}': {
                        if (peekStack != 5) {
                            this.buffer.readByte();
                            int n8 = 2;
                            boolean bl = false;
                            boolean bl10 = false;
                            int it = n8;
                            boolean bl11 = false;
                            this.peeked = it;
                            n4 = n8;
                            break;
                        }
                        throw (Throwable)this.syntaxError("Expected name");
                    }
                    default: {
                        this.checkLenient();
                        if (this.isLiteral((char)c2)) {
                            int n9 = 14;
                            boolean bl = false;
                            boolean bl12 = false;
                            int it = n9;
                            boolean bl13 = false;
                            this.peeked = it;
                            n4 = n9;
                            break;
                        }
                        throw (Throwable)this.syntaxError("Expected name");
                    }
                }
                return n4;
            }
            case 4: {
                this.stack[this.stackSize - 1] = 5;
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                switch ((char)c) {
                    case ':': {
                        break block0;
                    }
                    case '=': {
                        this.checkLenient();
                        if (!this.source.request(1L) || this.buffer.getByte(0L) != (byte)62) break block0;
                        this.buffer.readByte();
                        break block0;
                    }
                    default: {
                        throw (Throwable)this.syntaxError("Expected ':'");
                    }
                }
            }
            case 6: {
                this.stack[this.stackSize - 1] = 7;
                break;
            }
            case 7: {
                c = this.nextNonWhitespace(false);
                if (c == -1) {
                    int n10 = 17;
                    boolean bl = false;
                    boolean bl14 = false;
                    int it = n10;
                    boolean bl15 = false;
                    this.peeked = it;
                    return n10;
                }
                this.checkLenient();
                break;
            }
            default: {
                c = peekStack != 8 ? 1 : 0;
                n2 = 0;
                n = 0;
                if (c != 0) break;
                boolean bl = false;
                String string = "JsonReader is closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        c = this.nextNonWhitespace(true);
        switch ((char)c) {
            case ']': {
                if (peekStack == 1) {
                    this.buffer.readByte();
                    n2 = 4;
                    n = 0;
                    boolean bl = false;
                    int it = n2;
                    boolean bl16 = false;
                    this.peeked = it;
                    return n2;
                }
                if (peekStack != 1 && peekStack != 2) {
                    throw (Throwable)this.syntaxError("Unexpected value");
                }
                this.checkLenient();
                n2 = 7;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl17 = false;
                this.peeked = it;
                return n2;
            }
            case ',': 
            case ';': {
                if (peekStack != 1 && peekStack != 2) {
                    throw (Throwable)this.syntaxError("Unexpected value");
                }
                this.checkLenient();
                n2 = 7;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl18 = false;
                this.peeked = it;
                return n2;
            }
            case '\'': {
                this.checkLenient();
                this.buffer.readByte();
                n2 = 8;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl19 = false;
                this.peeked = it;
                return n2;
            }
            case '\"': {
                this.buffer.readByte();
                n2 = 9;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl20 = false;
                this.peeked = it;
                return n2;
            }
            case '[': {
                this.buffer.readByte();
                n2 = 3;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl21 = false;
                this.peeked = it;
                return n2;
            }
            case '{': {
                this.buffer.readByte();
                n2 = 1;
                n = 0;
                boolean bl = false;
                int it = n2;
                boolean bl22 = false;
                this.peeked = it;
                return n2;
            }
        }
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral((char)this.buffer.getByte(0L))) {
            throw (Throwable)this.syntaxError("Expected value");
        }
        this.checkLenient();
        n = 10;
        boolean bl = false;
        boolean bl23 = false;
        int it = n;
        boolean bl24 = false;
        this.peeked = it;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int peekKeyword() throws IOException {
        String keyword = null;
        String keywordUpper = null;
        int peeking = 0;
        switch (this.buffer.getByte(0L)) {
            case 84: 
            case 116: {
                keyword = "true";
                keywordUpper = "TRUE";
                peeking = 5;
                break;
            }
            case 70: 
            case 102: {
                keyword = "false";
                keywordUpper = "FALSE";
                peeking = 6;
                break;
            }
            case 78: 
            case 110: {
                keyword = "null";
                keywordUpper = "NULL";
                peeking = 7;
                break;
            }
            default: {
                return 0;
            }
        }
        int length = keyword.length();
        int n = 1;
        int n2 = length;
        while (n < n2) {
            void i;
            if (!this.source.request((long)i + 1L)) {
                return 0;
            }
            byte c = this.buffer.getByte((long)i);
            if (c != (byte)keyword.charAt((int)i) && c != (byte)keywordUpper.charAt((int)i)) {
                return 0;
            }
            ++i;
        }
        if (this.source.request((long)length + 1L) && this.isLiteral((char)this.buffer.getByte((long)length))) {
            return 0;
        }
        this.buffer.skip((long)length);
        n = peeking;
        n2 = 0;
        boolean bl = false;
        int it = n;
        boolean bl2 = false;
        this.peeked = it;
        return n;
    }

    private final int peekNumber() throws IOException {
        int n;
        int n2;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        block16: while (this.source.request((long)i + 1L)) {
            byte c = this.buffer.getByte((long)i);
            block0 : switch ((char)c) {
                case '-': {
                    switch (last) {
                        case 0: {
                            negative = true;
                            last = 1;
                            break block0;
                        }
                        case 5: {
                            last = 6;
                            break block0;
                        }
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < (byte)48 || c > (byte)57) {
                        if (!this.isLiteral((char)c)) break block16;
                        return 0;
                    }
                    switch (last) {
                        case 0: 
                        case 1: {
                            value = -((long)(c - (byte)48));
                            last = 2;
                            break block0;
                        }
                        case 2: {
                            if (value == 0L) {
                                return 0;
                            }
                            long newValue = value * (long)10 - (long)(c - (byte)48);
                            fitsInLong = fitsInLong & value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                            value = newValue;
                            break block0;
                        }
                        case 3: {
                            last = 4;
                            break block0;
                        }
                        case 5: 
                        case 6: {
                            last = 7;
                            break block0;
                        }
                    }
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip((long)i);
            n2 = 15;
            boolean bl = false;
            boolean bl2 = false;
            int it = n2;
            boolean bl3 = false;
            this.peeked = it;
            n = n2;
        } else if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            n2 = 16;
            boolean bl = false;
            boolean bl4 = false;
            int it = n2;
            boolean bl5 = false;
            this.peeked = it;
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isLiteral(char c) throws IOException {
        boolean bl;
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
                bl = false;
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String nextName() throws IOException {
        String string;
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 14: {
                string = this.nextUnquotedValue();
                break;
            }
            case 13: {
                string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 12: {
                string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            default: {
                throw (Throwable)new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        String result = string;
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    @Override
    @Nullable
    public String nextString() throws IOException {
        Object object;
        Object object2 = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)object2).intValue();
        boolean bl3 = false;
        Object object3 = !(it == 0) ? object2 : null;
        switch (object3 != null ? ((Integer)object3).intValue() : this.doPeek()) {
            case 10: {
                object = this.nextUnquotedValue();
                break;
            }
            case 9: {
                object = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 8: {
                object = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            case 11: {
                String string = this.peekedString;
                if (string != null) {
                    object2 = string;
                    bl = false;
                    bl2 = false;
                    Object it2 = object2;
                    boolean bl4 = false;
                    this.peekedString = null;
                    object = object2;
                    break;
                }
                object = null;
                break;
            }
            case 15: {
                object = String.valueOf(this.peekedLong);
                break;
            }
            case 16: {
                object = this.buffer.readUtf8((long)this.peekedNumberLength);
                break;
            }
            default: {
                throw (Throwable)new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        String result = object;
        this.peeked = 0;
        int n = this.stackSize - 1;
        int n2 = this.pathIndices[n];
        this.pathIndices[n] = n2 + 1;
        return result;
    }

    @Override
    public boolean nextBoolean() throws IOException {
        boolean bl;
        Integer n = this.peeked;
        boolean bl2 = false;
        boolean bl3 = false;
        int it = ((Number)n).intValue();
        boolean bl4 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 5: {
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                int n4 = this.pathIndices[n3];
                this.pathIndices[n3] = n4 + 1;
                bl = true;
                break;
            }
            case 6: {
                this.peeked = 0;
                int n5 = this.stackSize - 1;
                int n6 = this.pathIndices[n5];
                this.pathIndices[n5] = n6 + 1;
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public <T> T nextNull() throws IOException {
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 7: {
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                int n4 = this.pathIndices[n3];
                this.pathIndices[n3] = n4 + 1;
                break;
            }
            default: {
                throw (Throwable)new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        return null;
    }

    @Override
    public double nextDouble() throws IOException {
        double result;
        block16: {
            block17: {
                double d;
                Integer n = this.peeked;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                Integer n2 = !(it == 0) ? n : null;
                int p = n2 != null ? n2.intValue() : this.doPeek();
                if (p == 15) {
                    this.peeked = 0;
                    int n3 = this.stackSize - 1;
                    int n4 = this.pathIndices[n3];
                    this.pathIndices[n3] = n4 + 1;
                    return this.peekedLong;
                }
                if (p == 16) {
                    this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
                } else if (p == 9) {
                    this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                } else if (p == 8) {
                    this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                } else if (p == 10) {
                    this.peekedString = this.nextUnquotedValue();
                } else if (p != 11) {
                    throw (Throwable)new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
                }
                this.peeked = 11;
                try {
                    String string = this.peekedString;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = string;
                    boolean bl4 = false;
                    d = Double.parseDouble(string2);
                }
                catch (NumberFormatException e) {
                    throw (Throwable)new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPath());
                }
                result = d;
                if (this.getLenient()) break block16;
                d = result;
                boolean bl5 = false;
                if (Double.isNaN(d)) break block17;
                d = result;
                bl5 = false;
                if (!Double.isInfinite(d)) break block16;
            }
            throw (Throwable)new JsonEncodingException("JSON forbids NaN and infinities: " + result + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        int n5 = this.pathIndices[n];
        this.pathIndices[n] = n5 + 1;
        return result;
    }

    @Override
    public long nextLong() throws IOException {
        double d;
        boolean bl;
        Integer n = this.peeked;
        boolean bl2 = false;
        boolean bl3 = false;
        int it = ((Number)n).intValue();
        boolean bl4 = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            int n4 = this.pathIndices[n3];
            this.pathIndices[n3] = n4 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                bl = false;
                long result = Long.parseLong(string2);
                this.peeked = 0;
                int n5 = this.stackSize - 1;
                int n6 = this.pathIndices[n5];
                this.pathIndices[n5] = n6 + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw (Throwable)new JsonDataException("Expected a long but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string;
            bl = false;
            d = Double.parseDouble(string3);
        }
        catch (NumberFormatException e) {
            throw (Throwable)new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPath());
        }
        double asDouble = d;
        long result = (long)asDouble;
        if ((double)result != asDouble) {
            throw (Throwable)new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n7 = this.stackSize - 1;
        int n8 = this.pathIndices[n7];
        this.pathIndices[n7] = n8 + 1;
        return result;
    }

    private final String nextQuotedValue(ByteString runTerminator) throws IOException {
        String string;
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw (Throwable)this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != (byte)92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            string = result;
        } else {
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            String string2 = builder.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        }
        return string;
    }

    private final String nextUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private final void skipQuotedValue(ByteString runTerminator) throws IOException {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw (Throwable)this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != (byte)92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private final void skipUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() throws IOException {
        double d;
        int n;
        Integer n2 = this.peeked;
        int n3 = 0;
        boolean bl = false;
        int it = ((Number)n2).intValue();
        boolean bl2 = false;
        Integer n4 = !(it == 0) ? n2 : null;
        int p = n4 != null ? n4.intValue() : this.doPeek();
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw (Throwable)new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            int n5 = this.stackSize - 1;
            n3 = this.pathIndices[n5];
            this.pathIndices[n5] = n3 + 1;
            return result;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                bl = false;
                int result = Integer.parseInt(string2);
                this.peeked = 0;
                int n6 = this.stackSize - 1;
                int n7 = this.pathIndices[n6];
                this.pathIndices[n6] = n7 + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw (Throwable)new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string;
            n = 0;
            d = Double.parseDouble(string3);
        }
        catch (NumberFormatException e) {
            throw (Throwable)new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        double asDouble = d;
        int result = (int)asDouble;
        if ((double)result != asDouble) {
            throw (Throwable)new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n8 = this.stackSize - 1;
        n = this.pathIndices[n8];
        this.pathIndices[n8] = n + 1;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() throws IOException {
        if (this.getFailOnUnknown()) {
            throw (Throwable)new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        int count = 0;
        do {
            Integer n = this.peeked;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            Integer n2 = !(it == 0) ? n : null;
            switch (n2 != null ? n2.intValue() : this.doPeek()) {
                case 3: {
                    this.push(1);
                    ++count;
                    break;
                }
                case 1: {
                    this.push(3);
                    ++count;
                    break;
                }
                case 4: {
                    int n3 = this.stackSize;
                    this.stackSize = n3 + -1;
                    --count;
                    break;
                }
                case 2: {
                    int n4 = this.stackSize;
                    this.stackSize = n4 + -1;
                    --count;
                    break;
                }
                case 10: 
                case 14: {
                    this.skipUnquotedValue();
                    break;
                }
                case 9: 
                case 13: {
                    this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                    break;
                }
                case 8: 
                case 12: {
                    this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
                    break;
                }
                case 16: {
                    this.buffer.skip((long)this.peekedNumberLength);
                    break;
                }
            }
            this.peeked = 0;
        } while (count != 0);
        int n = this.stackSize - 1;
        int n5 = this.pathIndices[n];
        this.pathIndices[n] = n5 + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            throw (Throwable)new JsonDataException("Nesting too deep at " + this.getPath());
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int nextNonWhitespace(boolean throwOnEof) throws IOException {
        int p = 0;
        block4: while (this.source.request((long)p + 1L)) {
            byte c;
            if ((c = this.buffer.getByte((long)p++)) == 10 || c == 32 || c == 13 || c == 9) continue;
            this.buffer.skip((long)p - 1L);
            if (c == 47) {
                if (!this.source.request(2L)) {
                    return c;
                }
                this.checkLenient();
                byte peek = this.buffer.getByte(1L);
                switch ((char)peek) {
                    case '*': {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        if (!this.skipTo("*/")) {
                            throw (Throwable)this.syntaxError("Unterminated comment");
                        }
                        this.buffer.readByte();
                        this.buffer.readByte();
                        p = 0;
                        continue block4;
                    }
                    case '/': {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        this.skipToEndOfLine();
                        p = 0;
                        continue block4;
                    }
                }
                return c;
            }
            if (c == 35) {
                this.checkLenient();
                this.skipToEndOfLine();
                p = 0;
                continue;
            }
            return c;
        }
        if (throwOnEof) {
            throw (Throwable)new EOFException("End of input");
        }
        return -1;
    }

    private final void checkLenient() throws IOException {
        if (!this.getLenient()) {
            throw (Throwable)this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private final void skipToEndOfLine() throws IOException {
        long index = this.source.indexOfElement(LINEFEED_OR_CARRIAGE_RETURN);
        this.buffer.skip(index != -1L ? index + 1L : this.buffer.size());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean skipTo(String toFind) throws IOException {
        block0: while (this.source.request((long)toFind.length())) {
            int n = 0;
            int n2 = ((CharSequence)toFind).length();
            while (n < n2) {
                void c;
                if (this.buffer.getByte((long)c) != (byte)toFind.charAt((int)c)) {
                    this.buffer.readByte();
                    continue block0;
                }
                ++c;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getPath() {
        return JsonScope.INSTANCE.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    /*
     * WARNING - void declaration
     */
    private final char readEscapeCharacter() throws IOException {
        char c;
        if (!this.source.request(1L)) {
            throw (Throwable)this.syntaxError("Unterminated escape sequence");
        }
        char escaped = (char)this.buffer.readByte();
        switch (escaped) {
            case 'u': {
                void var2_2;
                int i;
                if (!this.source.request(4L)) {
                    throw (Throwable)new EOFException("Unterminated escape sequence at path " + this.getPath());
                }
                char result = (char)0;
                int end = i + 4;
                for (i = 0; i < end; ++i) {
                    int n;
                    byte c2 = this.buffer.getByte((long)i);
                    result = (char)(result << 4);
                    if (c2 >= (byte)48 && c2 <= (byte)57) {
                        n = c2 - (byte)48;
                    } else if (c2 >= (byte)97 && c2 <= (byte)102) {
                        n = c2 - (byte)97 + 10;
                    } else if (c2 >= (byte)65 && c2 <= (byte)70) {
                        n = c2 - (byte)65 + 10;
                    } else {
                        throw (Throwable)this.syntaxError("\\u" + this.buffer.readUtf8(4L));
                    }
                    result = (char)(result + n);
                }
                this.buffer.skip(4L);
                c = var2_2;
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case '\n': 
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                c = escaped;
                break;
            }
            default: {
                void var1_1;
                if (!this.getLenient()) {
                    throw (Throwable)this.syntaxError("Invalid escape sequence: \\" + escaped);
                }
                c = var1_1;
            }
        }
        return c;
    }

    private final JsonEncodingException syntaxError(String message) {
        return new JsonEncodingException(message + " at path " + this.getPath());
    }

    @Override
    public void promoteNameToValue() throws IOException {
        if (this.hasNext()) {
            this.peekedString = this.nextName();
            this.peeked = 11;
        }
    }

    public BufferedSourceJsonReader(@NotNull BufferedSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        this.buffer = this.source.getBuffer();
        int[] nArray = new int[32];
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = nArray;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl3 = false;
        $this$apply[0] = 6;
        Unit unit = Unit.INSTANCE;
        bufferedSourceJsonReader.stack = nArray;
        this.stackSize = 1;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
    }

    static {
        Companion = new Companion(null);
        SINGLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("'\\");
        DOUBLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("\"\\");
        UNQUOTED_STRING_TERMINALS = ByteString.Companion.encodeUtf8("{}[]:, \n\t\r/\\;#=");
        LINEFEED_OR_CARRIAGE_RETURN = ByteString.Companion.encodeUtf8("\n\r");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u001c\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/apollographql/apollo/api/internal/json/BufferedSourceJsonReader$Companion;", "", "()V", "DOUBLE_QUOTE_OR_SLASH", "Lokio/ByteString;", "LINEFEED_OR_CARRIAGE_RETURN", "MIN_INCOMPLETE_INTEGER", "", "NUMBER_CHAR_DECIMAL", "", "NUMBER_CHAR_DIGIT", "NUMBER_CHAR_EXP_DIGIT", "NUMBER_CHAR_EXP_E", "NUMBER_CHAR_EXP_SIGN", "NUMBER_CHAR_FRACTION_DIGIT", "NUMBER_CHAR_NONE", "NUMBER_CHAR_SIGN", "PEEKED_BEGIN_ARRAY", "PEEKED_BEGIN_OBJECT", "PEEKED_BUFFERED", "PEEKED_DOUBLE_QUOTED", "PEEKED_DOUBLE_QUOTED_NAME", "PEEKED_END_ARRAY", "PEEKED_END_OBJECT", "PEEKED_EOF", "PEEKED_FALSE", "PEEKED_LONG", "PEEKED_NONE", "PEEKED_NULL", "PEEKED_NUMBER", "PEEKED_SINGLE_QUOTED", "PEEKED_SINGLE_QUOTED_NAME", "PEEKED_TRUE", "PEEKED_UNQUOTED", "PEEKED_UNQUOTED_NAME", "SINGLE_QUOTE_OR_SLASH", "UNQUOTED_STRING_TERMINALS", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

